/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import com.tridium.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Binder
extends Subscriber {
    public static long checkItemsDelay = new Long(System.getProperty("bajaui.binder.checkItemsDelay", "500"));
    public static final Log log = Log.getLog((String)"binder");
    static final BOrd[] noOrds = new BOrd[0];
    static final BBinding[] noBindings = new BBinding[0];
    BWidget owner;
    HashMap byBinding;
    HashMap byOrd;
    HashMap byTargetComponent;
    protected boolean isAlive;
    OrdTarget base;
    Worker worker;
    Context context;
    static /* synthetic */ Class class$javax$baja$ui$BBinding;
    static /* synthetic */ Class class$com$tridium$ui$Binder$Item;

    public synchronized void bind(BBinding binding) {
        if (log.isTraceOn()) {
            log.trace("bind(" + (Object)((Object)binding) + ')');
        }
        BOrd ord = binding.getOrd();
        try {
            if (ord.hasVariables()) {
                return;
            }
        }
        catch (Exception item) {
            return;
        }
        Item item = (Item)this.byOrd.get(ord);
        if (item == null) {
            item = new Item(ord);
            this.byOrd.put(ord, item);
        }
        item.bindings.add(binding);
        this.byBinding.put(binding, item);
        item.resolved = false;
        this.checkWorker();
    }

    public synchronized void unbind(BBinding binding) {
        Item item;
        if (log.isTraceOn()) {
            log.trace("unbind(" + (Object)((Object)binding) + ')');
        }
        if ((item = (Item)this.byBinding.get((Object)binding)) != null) {
            this.byBinding.remove((Object)binding);
            item.bindings.remove((Object)binding);
        }
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public BOrd[] getAllOrds() {
        if (this.byOrd.size() == 0) {
            return noOrds;
        }
        return this.byOrd.keySet().toArray(new BOrd[this.byOrd.size()]);
    }

    public BBinding[] getAllBindings() {
        if (this.byBinding.size() == 0) {
            return noBindings;
        }
        return this.byBinding.keySet().toArray(new BBinding[this.byBinding.size()]);
    }

    public BBinding[] getBindingsForOrd(BOrd ord) {
        Item item = (Item)this.byOrd.get(ord);
        if (item == null) {
            return noBindings;
        }
        ArrayList b = item.bindings;
        return b.toArray(new BBinding[b.size()]);
    }

    public boolean getAllResolved() {
        boolean resolved = true;
        BBinding[] binds = this.getAllBindings();
        int i = 0;
        while (i < binds.length) {
            if (!binds[i].isBound()) {
                resolved = false;
            }
            ++i;
        }
        return resolved;
    }

    public synchronized void start(OrdTarget base, Context context) {
        if (log.isTraceOn()) {
            log.trace("start(" + base.getOrd() + ')');
        }
        this.base = base;
        this.context = context;
        this.isAlive = true;
        this.checkWorker();
    }

    public void stop() {
        if (log.isTraceOn()) {
            log.trace("stop()");
        }
        this.unsubscribeAll();
        this.isAlive = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = null;
        this.byOrd = null;
        this.byBinding = null;
    }

    public void save(Context cx) throws Exception {
        Class clazz = class$javax$baja$ui$BBinding;
        if (clazz == null) {
            clazz = class$javax$baja$ui$BBinding = Binder.class("[Ljavax.baja.ui.BBinding;", false);
        }
        Array noSpace = new Array(clazz, 16);
        HashMap<BSpace, Array> spaceMap = new HashMap<BSpace, Array>();
        BBinding[] bindings = this.getAllBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].isBound()) {
                BSpace space = bindings[i].getTarget().getSpace();
                if (space == null) {
                    noSpace.add((Object)bindings[i]);
                } else {
                    Array spaceBindings = (Array)spaceMap.get(space);
                    if (spaceBindings == null) {
                        Class clazz2 = class$javax$baja$ui$BBinding;
                        if (clazz2 == null) {
                            clazz2 = Binder.class("[Ljavax.baja.ui.BBinding;", false);
                        }
                        spaceBindings = new Array(clazz2);
                        spaceMap.put(space, spaceBindings);
                    }
                    spaceBindings.add((Object)bindings[i]);
                }
            }
            ++i;
        }
        Iterator entries = spaceMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            BSpace space = (BSpace)entry.getKey();
            Array spaceBindings = (Array)entry.getValue();
            if (space instanceof BComponentSpace) {
                Transaction tx = ((BComponentSpace)space).newTransaction(cx);
                ListIterator i2 = spaceBindings.iterator();
                while (i2.hasNext()) {
                    ((BBinding)((Object)i2.next())).save((Context)tx);
                }
                tx.commit();
                continue;
            }
            ListIterator i3 = spaceBindings.iterator();
            while (i3.hasNext()) {
                ((BBinding)((Object)i3.next())).save(cx);
            }
        }
    }

    public void event(BComponentEvent event) {
        Item[] items = (Item[])this.byTargetComponent.get(event.getSourceComponent());
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                items[i].resolved = false;
                ++i;
            }
        }
    }

    protected synchronized void checkWorker() {
        if (this.byBinding.size() > 0 && this.isAlive && this.worker == null) {
            this.worker = new Worker("Ui:Binder:" + this.base.getOrd().toString());
            if (log.isTraceOn()) {
                log.trace("spawn worker");
            }
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void checkItems() {
        Item[] items = null;
        Binder binder = this;
        // MONITORENTER : binder
        Class clazz = class$com$tridium$ui$Binder$Item;
        if (clazz == null) {
            clazz = class$com$tridium$ui$Binder$Item = Binder.class("[Lcom.tridium.ui.Binder$Item;", false);
        }
        Array acc = new Array(clazz);
        Iterator it = this.byOrd.values().iterator();
        while (true) {
            if (!it.hasNext()) {
                if (acc.size() != 0) break;
                // MONITOREXIT : binder
                return;
            }
            Item item = (Item)it.next();
            BOrd ord = item.ord;
            if (item.resolved || ord == null || ord.isNull()) continue;
            acc.add((Object)item);
        }
        items = (Item[])acc.trim();
        // MONITOREXIT : binder
        if (log.isTraceOn()) {
            log.trace("resolve #" + items.length);
        }
        BOrd[] ords = new BOrd[items.length];
        int i = 0;
        while (i < items.length) {
            ords[i] = items[i].ord;
            ++i;
        }
        BatchResolve batch = new BatchResolve(ords).resolve(this.base.get(), this.context);
        int len = items.length;
        HashMap toSubscribe = new HashMap(len * 2);
        int i2 = 0;
        while (i2 < len) {
            Item item = items[i2];
            if (batch.isResolved(i2)) {
                item.target = batch.getTarget(i2);
                this.postResolve(item, toSubscribe);
            } else {
                log.warning("unresolved: " + item.ord);
            }
            item.resolved = true;
            ++i2;
        }
        int subscribeSize = toSubscribe.size();
        if (subscribeSize > 0) {
            if (log.isTraceOn()) {
                log.trace("  subscribe #" + subscribeSize);
            }
            try {
                this.subscribe(toSubscribe.values().toArray(new BComponent[subscribeSize]), 0, null);
            }
            catch (Throwable e) {
                log.error("subscribe", e);
            }
        }
        try {
            int i3 = 0;
            while (i3 < items.length) {
                Item item = items[i3];
                if (item.target != null && item.targetComponent != null && item.targetComponent != item.target.get()) {
                    try {
                        item.target = item.ord.resolve(this.base.get(), this.context);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ++i3;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i4 = 0;
        while (i4 < items.length) {
            try {
                this.updateBindings(items[i4].bindings, items[i4].target);
            }
            catch (Throwable e) {
                log.error("update", e);
            }
            ++i4;
        }
    }

    void postResolve(Item item, HashMap toSubscribe) {
        BComponent comp;
        if (item.target == null) {
            return;
        }
        if (log.isTraceOn()) {
            log.trace("resolved " + item.ord + " -> " + item.target.get());
        }
        if ((comp = item.target.getComponent()) != null && !item.subscribed) {
            item.subscribed = true;
            item.targetComponent = comp;
            toSubscribe.put(comp, comp);
            Object[] itemsByComp = (Item[])this.byTargetComponent.get(comp);
            itemsByComp = itemsByComp == null ? new Item[]{item} : (Item[])ArrayUtil.addOne((Object[])itemsByComp, (Object)item);
            this.byTargetComponent.put(comp, itemsByComp);
        }
    }

    protected void unresolve() {
        Item[] items = this.byBinding.values().toArray(new Item[this.byBinding.size()]);
        int i = 0;
        while (i < items.length) {
            items[i].resolved = false;
            ++i;
        }
    }

    protected void updateBindings(ArrayList bindings, OrdTarget target) {
        int i = 0;
        while (i < bindings.size()) {
            Binder.updateBinding((BBinding)((Object)bindings.get(i)), target);
            ++i;
        }
    }

    protected static void updateBinding(BBinding binding, OrdTarget target) {
        try {
            if (log.isTraceOn()) {
                log.trace("  updateBinding " + (Object)((Object)binding));
            }
            binding.fw(303, target, null, null, null);
            binding.targetChanged();
            binding.fireTargetChanged(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            binding.getWidget().bindingsChanged();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.byBinding = new HashMap();
        this.byOrd = new HashMap();
        this.byTargetComponent = new HashMap();
        this.isAlive = false;
        this.worker = null;
    }

    public Binder(BWidget owner) {
        this.this();
        this.owner = owner;
    }

    static class Item {
        BOrd ord;
        ArrayList bindings;
        boolean resolved;
        OrdTarget target;
        boolean subscribed;
        BComponent targetComponent;

        public String toString() {
            return this.ord.toString();
        }

        Item(BOrd ord) {
            this.ord = ord;
            this.bindings = new ArrayList(4);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Worker
    extends Thread {
        public void run() {
            while (Binder.this.isAlive) {
                try {
                    Binder.this.checkItems();
                    Thread.sleep(checkItemsDelay);
                }
                catch (Throwable e) {
                    if (!Binder.this.isAlive) continue;
                    e.printStackTrace();
                }
            }
        }

        Worker(String name) {
            super(name);
        }
    }
}

