/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ui;

import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BOptionDialog
extends BDialog {
    public static final Property yesButton = BOptionDialog.newProperty((int)0, (BValue)new BButton("_yes"), null);
    public static final Property noButton = BOptionDialog.newProperty((int)0, (BValue)new BButton("_no"), null);
    public static final Property okButton = BOptionDialog.newProperty((int)0, (BValue)new BButton("_ok"), null);
    public static final Property cancelButton = BOptionDialog.newProperty((int)0, (BValue)new BButton("_cancel"), null);
    public static final Property detailsButton = BOptionDialog.newProperty((int)0, (BValue)new BToggleButton("_details"), null);
    public static final Action buttonPressed = BOptionDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE;
    private int buttons;
    private BImage icon;
    private String details;
    private RectGeom iconRect;
    private RectGeom contentRect;
    private RectGeom detailsRect;
    private RectGeom buttonsRect;
    private Size buttonDim;
    private BTextEditorPane detailsDisplay;
    private int result;
    static /* synthetic */ Class class$com$tridium$ui$BOptionDialog;

    public BButton getYesButton() {
        return (BButton)this.get(yesButton);
    }

    public void setYesButton(BButton v) {
        this.set(yesButton, (BValue)v, null);
    }

    public BButton getNoButton() {
        return (BButton)this.get(noButton);
    }

    public void setNoButton(BButton v) {
        this.set(noButton, (BValue)v, null);
    }

    public BButton getOkButton() {
        return (BButton)this.get(okButton);
    }

    public void setOkButton(BButton v) {
        this.set(okButton, (BValue)v, null);
    }

    public BButton getCancelButton() {
        return (BButton)this.get(cancelButton);
    }

    public void setCancelButton(BButton v) {
        this.set(cancelButton, (BValue)v, null);
    }

    public BToggleButton getDetailsButton() {
        return (BToggleButton)this.get(detailsButton);
    }

    public void setDetailsButton(BToggleButton v) {
        this.set(detailsButton, (BValue)v, null);
    }

    public void buttonPressed(BWidgetEvent event) {
        this.invoke(buttonPressed, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        this.computeIconPrefSize();
        this.computeContentPrefSize();
        this.computeDetailsPrefSize();
        this.computeButtonsPrefSize();
        double iw = this.iconRect.width;
        double ih = this.iconRect.height;
        double cw = this.contentRect.width;
        double ch = this.contentRect.height;
        double bw = this.buttonsRect.width;
        double bh = this.buttonsRect.height;
        double dw = this.detailsRect.width;
        double dh = this.detailsRect.height;
        double w = Math.max(Math.max(iw + cw, dw), bw);
        double h = Math.max(ih, ch) + bh + dh;
        this.setPreferredSize(w, h);
    }

    public void doLayout(BWidget[] kids) {
        this.computePreferredSize();
        double w = this.getWidth();
        double h = this.getHeight();
        this.layoutDetails(w, h);
        this.layoutButtons(w, h);
        this.layoutContentAndIcon(w, h);
    }

    private final void computeIconPrefSize() {
        if (this.icon == null) {
            this.iconRect.height = 0.0;
            this.iconRect.width = 0.0;
        } else {
            this.iconRect.width = this.icon.getWidth() + 8.0;
            this.iconRect.height = this.icon.getHeight() + 8.0;
        }
    }

    private final void computeContentPrefSize() {
        BWidget c = this.getContent();
        c.computePreferredSize();
        this.contentRect.width = c.getPreferredWidth() + 12.0;
        this.contentRect.height = c.getPreferredHeight() + 8.0;
        if (!(c instanceof BTextEditorPane) && (c instanceof BScrollPane || c instanceof BTabbedPane)) {
            this.contentRect.width = 400.0;
            this.contentRect.height = 300.0;
        }
    }

    private final void computeButtonsPrefSize() {
        BAbstractButton b;
        double bh = 0.0;
        double bw = 0.0;
        int count = 0;
        if ((this.buttons & 4) != 0) {
            b = this.getYesButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 8) != 0) {
            b = this.getNoButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 1) != 0) {
            b = this.getOkButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if ((this.buttons & 2) != 0) {
            b = this.getCancelButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        if (this.details != null) {
            b = this.getDetailsButton();
            b.computePreferredSize();
            bw = Math.max(bw, b.getPreferredWidth());
            bh = Math.max(bh, b.getPreferredHeight());
            ++count;
        }
        this.buttonDim.width = bw;
        this.buttonDim.height = bh;
        this.buttonsRect.width = bw * (double)count + (double)(4 * (count - 1)) + 8.0;
        this.buttonsRect.height = bh + 8.0;
    }

    private final void computeDetailsPrefSize() {
        if (this.details == null) {
            this.detailsRect.height = 0.0;
            this.detailsRect.width = 0.0;
        } else {
            BTextEditorPane e = this.detailsDisplay;
            e.computePreferredSize();
            this.detailsRect.width = e.getPreferredWidth() + 8.0;
            this.detailsRect.height = this.getDetailsButton().getSelected() ? e.getPreferredHeight() + 8.0 : 0.0;
        }
    }

    private final void layoutDetails(double w, double h) {
        BTextEditorPane d = this.detailsDisplay;
        if (this.details == null || !this.getDetailsButton().getSelected()) {
            this.detailsRect.x = 0.0;
            this.detailsRect.y = h;
            d.setBounds(0.0, this.detailsRect.y, 0.0, 0.0);
        } else {
            double above = Math.max(this.iconRect.height, this.contentRect.height) + this.buttonsRect.height + (double)4;
            double dw = this.detailsRect.width = w - 8.0;
            double dh = this.detailsRect.height = h - above;
            double dx = this.detailsRect.x = (double)4;
            double dy = this.detailsRect.y = h - this.detailsRect.height - (double)4;
            d.setBounds(dx, dy, dw, dh);
        }
    }

    private final void layoutButtons(double w, double h) {
        double bx = this.buttonsRect.x = (w - this.buttonsRect.width) / (double)2 + (double)4;
        double by = this.buttonsRect.y = this.detailsRect.y - this.buttonDim.height - (double)4;
        double bw = this.buttonDim.width;
        double bh = this.buttonDim.height;
        if ((this.buttons & 4) != 0) {
            this.getYesButton().setBounds(bx, by, bw, bh);
            bx += bw + (double)4;
        } else {
            this.getYesButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 8) != 0) {
            this.getNoButton().setBounds(bx, by, bw, bh);
            bx += bw + (double)4;
        } else {
            this.getNoButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 1) != 0) {
            this.getOkButton().setBounds(bx, by, bw, bh);
            bx += bw + (double)4;
        } else {
            this.getOkButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if ((this.buttons & 2) != 0) {
            this.getCancelButton().setBounds(bx, by, bw, bh);
            bx += bw + (double)4;
        } else {
            this.getCancelButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
        if (this.details != null) {
            this.getDetailsButton().setBounds(bx, by, bw, bh);
            bx += bw + (double)4;
        } else {
            this.getDetailsButton().setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void layoutContentAndIcon(double w, double h) {
        double aw;
        BWidget top;
        double ah = this.buttonsRect.y - 8.0;
        if (this.icon == null) {
            this.iconRect.y = 0.0;
            this.iconRect.x = 0.0;
        } else {
            this.iconRect.x = 4;
            this.iconRect.y = (ah - this.iconRect.height) / (double)2 + (double)4;
        }
        double contentMargin = 4;
        BWidget content = this.getContent();
        if (content instanceof BEdgePane && (top = ((BEdgePane)content).getTop()) instanceof BWizardHeader) {
            contentMargin = 0.0;
        }
        double cx = this.iconRect.x + this.iconRect.width + contentMargin;
        double cy = contentMargin;
        double cw = aw = w - cx - contentMargin;
        double ch = ah;
        this.contentRect.x = cx;
        this.contentRect.y = cy;
        this.contentRect.width = cw;
        this.contentRect.height = ch;
        this.getContent().setBounds(cx, cy, cw, ch);
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
        if (this.icon != null) {
            g.drawImage(this.icon, this.iconRect.x, this.iconRect.y);
        }
    }

    public int getResult() {
        return this.result;
    }

    public void close(int result) {
        this.result = result;
        this.close();
    }

    public void toggleDetails() {
        this.detailsDisplay.setVisible(this.getDetailsButton().getSelected());
        this.setScreenSizeToPreferredSize();
    }

    public void doButtonPressed(BWidgetEvent event) {
        BWidget src = event.getWidget();
        if (src == this.getOkButton()) {
            this.close(1);
        }
        if (src == this.getCancelButton()) {
            this.close(2);
        }
        if (src == this.getYesButton()) {
            this.close(4);
        }
        if (src == this.getNoButton()) {
            this.close(8);
        }
        if (src == this.getDetailsButton()) {
            this.toggleDetails();
        }
    }

    public void windowClosing(BWindowEvent event) {
        this.result = (this.buttons & 2) != 0 ? 2 : ((this.buttons & 1) != 0 ? 1 : ((this.buttons & 8) != 0 ? 8 : ((this.buttons & 4) != 0 ? 4 : 2)));
        this.close();
    }

    public static String promptFileName(BWidget owner, String title, String value) {
        BTextField field = new BTextField(value, 40);
        field.setController(new FileNameController());
        int result = BOptionDialog.open(owner, title, field, 3, QUESTION_ICON);
        if (result == 2) {
            return null;
        }
        return field.getText();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.iconRect = new RectGeom();
        this.contentRect = new RectGeom();
        this.detailsRect = new RectGeom();
        this.buttonsRect = new RectGeom();
        this.buttonDim = new Size();
    }

    public BOptionDialog(BWidget owner, String title, BWidget content, int buttons, BImage icon, String details) {
        super(owner, title, true, content);
        this.this();
        this.detailsDisplay = new BTextEditorPane("", 15, 45, false);
        this.add("detailsDisplay", (BValue)this.detailsDisplay);
        this.buttons = buttons;
        this.icon = icon;
        this.details = details;
        this.linkTo("linkA", this.getOkButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkB", this.getCancelButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkC", this.getYesButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkD", this.getNoButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("linkE", this.getDetailsButton(), (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.detailsDisplay.setVisible(false);
        if (details != null) {
            this.detailsDisplay.setText(details);
        }
        UiLexicon lex = UiLexicon.bajaui();
        if ((buttons & 4) != 0) {
            this.getYesButton().setText(lex.getText("dialog.yes"));
        } else {
            this.getYesButton().setVisible(false);
        }
        if ((buttons & 8) != 0) {
            this.getNoButton().setText(lex.getText("dialog.no"));
        } else {
            this.getNoButton().setVisible(false);
        }
        if ((buttons & 1) != 0) {
            this.getOkButton().setText(lex.getText("dialog.ok"));
        } else {
            this.getOkButton().setVisible(false);
        }
        if ((buttons & 2) != 0) {
            this.getCancelButton().setText(lex.getText("dialog.cancel"));
        } else {
            this.getCancelButton().setVisible(false);
        }
        if (details != null) {
            this.getDetailsButton().setText(lex.getText("dialog.details"));
        } else {
            this.getDetailsButton().setVisible(false);
        }
        if ((buttons & 1) != 0) {
            this.setDefaultButton(this.getOkButton());
        } else if ((buttons & 4) != 0) {
            this.setDefaultButton(this.getYesButton());
        }
    }

    public BOptionDialog() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$ui$BOptionDialog;
        if (clazz == null) {
            clazz = class$com$tridium$ui$BOptionDialog = BOptionDialog.class("[Lcom.tridium.ui.BOptionDialog;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class FileNameController
    extends TextController {
        public void focusGained(BFocusEvent event) {
            super.focusGained(event);
            int dot = this.getEditor().getText().lastIndexOf(46);
            if (dot > 0) {
                this.getEditor().getSelection().select(new Position(0, dot), new Position(0, 0));
            }
        }
    }
}

