/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonInteger
extends BLonPrimitive
implements BINumeric {
    public static final BLonInteger DEFAULT = new BLonInteger(0);
    public static final Type TYPE;
    private int value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonInteger;

    public static final BLonInteger make(int n) {
        return new BLonInteger(n);
    }

    public final int getInt() {
        return this.value;
    }

    public final float getFloat() {
        return this.value;
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonInteger) {
            boolean bl = false;
            if (((BLonInteger)((Object)object)).value == this.value) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final int compareTo(Object object) {
        int n = this.value;
        int n2 = ((BNumber)object).getInt();
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return String.valueOf(this.value);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return BLonInteger.make(dataInput.readInt());
    }

    public final String encodeToString() throws IOException {
        return String.valueOf(this.value);
    }

    public static final String encodeToString(int n) {
        return String.valueOf(n);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BLonInteger.make(Integer.parseInt(string));
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid integer: " + string);
        }
    }

    public static final int intFromString(String string) throws IOException {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid integer: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                lonOutputStream.writeUnsigned8(this.value);
                break;
            }
            case 1: {
                lonOutputStream.writeSigned8(this.value);
                break;
            }
            case 2: {
                lonOutputStream.writeUnsigned8(this.value);
                break;
            }
            case 3: {
                lonOutputStream.writeSigned16(this.value);
                break;
            }
            case 4: {
                lonOutputStream.writeUnsigned16(this.value);
                break;
            }
            case 5: {
                lonOutputStream.writeSigned32(this.value);
                break;
            }
            case 12: {
                lonOutputStream.writeBit(this.value, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                lonOutputStream.writeSignedBit(this.value, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalueid datatype for LonInteger.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        int n;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                n = lonInputStream.readUnsigned8();
                break;
            }
            case 1: {
                n = lonInputStream.readSigned8();
                break;
            }
            case 2: {
                n = lonInputStream.readUnsigned8();
                break;
            }
            case 3: {
                n = lonInputStream.readSigned16();
                break;
            }
            case 4: {
                n = lonInputStream.readUnsigned16();
                break;
            }
            case 5: {
                n = lonInputStream.readSigned32();
                break;
            }
            case 12: {
                n = lonInputStream.readBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                n = lonInputStream.readSignedBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonInteger.");
            }
        }
        if (this.value == n) {
            return this;
        }
        return BLonInteger.make(n);
    }

    public final double getDataAsDouble() {
        return this.value;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        return BLonInteger.make((int)d);
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean getDataAsBoolean() {
        boolean bl = false;
        if (this.value != 0) {
            bl = true;
        }
        return bl;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonInteger.make(bl ? 1 : 0);
    }

    public final String getDataAsString() {
        return Integer.toString(this.value);
    }

    public final BLonPrimitive makeFromString(String string) {
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return BLonInteger.make(n);
    }

    public final double getNumeric() {
        return this.getDataAsDouble();
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonInteger(int n) {
        this.value = n;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonInteger;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonInteger = BLonInteger.class("[Ljavax.baja.lonworks.londata.BLonInteger;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

