/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonFloat
extends BLonPrimitive
implements BINumeric {
    public static final BLonFloat POSITIVE_INFINITY = new BLonFloat(Float.POSITIVE_INFINITY);
    public static final BLonFloat NEGATIVE_INFINITY = new BLonFloat(Float.NEGATIVE_INFINITY);
    public static final BLonFloat NaN = new BLonFloat(Float.NaN);
    public static final BLonFloat DEFAULT = new BLonFloat(0.0f);
    public static final Type TYPE;
    private float value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonFloat;

    public static final BLonFloat make(float f) {
        if (f == 0.0f) {
            return DEFAULT;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (f == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Float.isNaN(f)) {
            return NaN;
        }
        return new BLonFloat(f);
    }

    public final float getFloat() {
        return this.value;
    }

    public final int getInt() {
        return (int)this.value;
    }

    public static final String toString(float f, Context context) {
        BUnit bUnit = null;
        if (context != null && (bUnit = (BUnit)context.getFacet("units")) != null && bUnit.isNull()) {
            bUnit = null;
        }
        String string = f == Float.POSITIVE_INFINITY ? "+inf" : (f == Float.NEGATIVE_INFINITY ? "-inf" : (Float.isNaN(f) ? "nan" : Float.toString(f)));
        if (bUnit != null) {
            string = string + ' ' + bUnit.getSymbol();
        }
        return string;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonFloat) {
            float f = ((BLonFloat)((Object)object)).value;
            if (f == this.value) {
                return true;
            }
            if (Float.isNaN(f) && Float.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean equals(float f, float f2) {
        if (f == f2) {
            return true;
        }
        return Float.isNaN(f) && Float.isNaN(f2);
    }

    public final int compareTo(Object object) {
        float f = this.value;
        float f2 = ((BLonFloat)((Object)object)).value;
        if (BLonFloat.equals(f, f2)) {
            return 0;
        }
        if (f < f2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BLonFloat.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        float f = dataInput.readFloat();
        if (BLonFloat.equals(this.value, f)) {
            return this;
        }
        return new BLonFloat(f);
    }

    public final String encodeToString() throws IOException {
        return BLonFloat.encodeToString(this.value);
    }

    public static final String encodeToString(float f) throws IOException {
        if (f == Float.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Float.isNaN(f)) {
            return "nan";
        }
        return String.valueOf((double)f);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            if (string.equals("+inf")) {
                return POSITIVE_INFINITY;
            }
            if (string.equals("-inf")) {
                return NEGATIVE_INFINITY;
            }
            if (string.equals("nan")) {
                return NaN;
            }
            return new BLonFloat((float)Double.parseDouble(string));
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid float: " + string);
        }
    }

    public static final float floatFromString(String string) throws IOException {
        try {
            if (string.equalsIgnoreCase("+inf")) {
                return Float.POSITIVE_INFINITY;
            }
            if (string.equalsIgnoreCase("-inf")) {
                return Float.NEGATIVE_INFINITY;
            }
            if (string.equalsIgnoreCase("nan")) {
                return Float.NaN;
            }
            return (float)Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid float: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        float f = this.value;
        if (bLonElementQualifiers.hasInvalidValue() && Float.isNaN(f)) {
            f = bLonElementQualifiers.getInvalidValue();
        } else {
            if (bLonElementQualifiers.getOffset() != 0.0f) {
                f += bLonElementQualifiers.getOffset();
            }
            if (bLonElementQualifiers.getResolution() != 1.0f) {
                f /= bLonElementQualifiers.getResolution();
            }
        }
        int n = (int)f;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                lonOutputStream.writeUnsigned8(n);
                break;
            }
            case 1: {
                lonOutputStream.writeSigned8(n);
                break;
            }
            case 2: {
                lonOutputStream.writeUnsigned8(n);
                break;
            }
            case 3: {
                lonOutputStream.writeSigned16(n);
                break;
            }
            case 4: {
                lonOutputStream.writeUnsigned16(n);
                break;
            }
            case 5: {
                lonOutputStream.writeSigned32(n);
                break;
            }
            case 12: {
                lonOutputStream.writeBit(n, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                lonOutputStream.writeSignedBit(n, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 8: {
                lonOutputStream.writeFloat(f);
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonFloat " + (Object)((Object)bLonElementQualifiers.getElemtype()));
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        double d;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                d = lonInputStream.readUnsigned8();
                break;
            }
            case 1: {
                d = lonInputStream.readSigned8();
                break;
            }
            case 2: {
                d = lonInputStream.readUnsigned8();
                break;
            }
            case 3: {
                d = lonInputStream.readSigned16();
                break;
            }
            case 4: {
                d = lonInputStream.readUnsigned16();
                break;
            }
            case 5: {
                d = lonInputStream.readSigned32();
                break;
            }
            case 12: {
                d = lonInputStream.readBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                d = lonInputStream.readSignedBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 8: {
                d = lonInputStream.readFloat();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonFloat.");
            }
        }
        if (bLonElementQualifiers.hasInvalidValue() && d == (double)bLonElementQualifiers.getInvalidValueL()) {
            return BLonFloat.make(Float.NaN);
        }
        if (bLonElementQualifiers.getResolution() != 1.0f) {
            d *= (double)bLonElementQualifiers.getResolution();
        }
        if (bLonElementQualifiers.getOffset() != 0.0f) {
            d -= (double)bLonElementQualifiers.getOffset();
        }
        if (d == (double)this.value) {
            return this;
        }
        return BLonFloat.make((float)d);
    }

    public final double getDataAsDouble() {
        return this.value;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        return BLonFloat.make((float)d);
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean getDataAsBoolean() {
        boolean bl = false;
        if ((double)this.value > 0.0) {
            bl = true;
        }
        return bl;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonFloat.make(bl ? 1.0f : 0.0f);
    }

    public final String getDataAsString() {
        return String.valueOf((double)this.value);
    }

    public final BLonPrimitive makeFromString(String string) {
        float f = Float.NaN;
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (Throwable throwable) {}
        return BLonFloat.make(f);
    }

    public final BEnum getDataAsEnum(BEnum bEnum) {
        try {
            BEnumRange bEnumRange = bEnum.getRange();
            return bEnumRange.get((int)this.value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final BLonPrimitive makeFromEnum(BEnum bEnum) {
        return new BLonFloat(bEnum.getOrdinal());
    }

    public final int getIntValue() {
        return (int)this.value;
    }

    public final double getNumeric() {
        return this.getDataAsDouble();
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonFloat(float f) {
        this.value = f;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonFloat;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonFloat = BLonFloat.class("[Ljavax.baja.lonworks.londata.BLonFloat;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

