/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.enums.BLonNilEnum;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonEnum
extends BLonPrimitive
implements BIEnum,
BINumeric,
BIBoolean {
    public static final BLonEnum DEFAULT = new BLonEnum((BEnum)BLonNilEnum.nil);
    public static final Type TYPE;
    private BEnum value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonEnum;

    public static final BLonEnum make(BEnum bEnum) {
        return new BLonEnum(bEnum);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BLonEnum)) {
            return false;
        }
        BEnum bEnum = ((BLonEnum)((Object)object)).value;
        return this.compare(bEnum);
    }

    public final boolean compare(BEnum bEnum) {
        boolean bl = false;
        if (this.value.getClass() == bEnum.getClass() && this.value.getOrdinal() == bEnum.getOrdinal()) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return this.value.getDisplayTag(context);
    }

    public final String encodeToString() throws IOException {
        return this.encodeClass((BSimple)this.value) + ' ' + this.value.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf(32);
        BEnum bEnum = (BEnum)this.decodeClass(string.substring(0, n));
        return BLonEnum.make((BEnum)bEnum.decodeFromString(string.substring(n + 1)));
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeClass((BSimple)this.value));
        dataOutput.writeInt(this.value.getOrdinal());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        BEnum bEnum = (BEnum)this.decodeClass(dataInput.readUTF());
        return BLonEnum.make(bEnum.getRange().get(dataInput.readInt()));
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        int n = this.value.getOrdinal();
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 7: {
                lonOutputStream.writeSigned8(n);
                break;
            }
            case 9: {
                lonOutputStream.writeBit(n, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 10: {
                lonOutputStream.writeSignedBit(n, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonEnum.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        int n = 0;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 7: {
                n = lonInputStream.readSigned8();
                break;
            }
            case 9: {
                n = lonInputStream.readBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 10: {
                n = lonInputStream.readSignedBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonEnum.");
            }
        }
        if (this.value.getOrdinal() == n) {
            return this;
        }
        return BLonEnum.make(this.value.getRange().get(n));
    }

    public final double getDataAsDouble() {
        return this.value.getOrdinal();
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        int n = (int)d;
        BEnum bEnum = this.value;
        if (!bEnum.getRange().isOrdinal(n)) {
            return null;
        }
        return BLonEnum.make(bEnum.getRange().get(n));
    }

    public final boolean getDataAsBoolean() {
        return this.value.isActive();
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        int n = bl;
        BEnum bEnum = this.value;
        if (!bEnum.getRange().isOrdinal(n)) {
            return null;
        }
        return BLonEnum.make(bEnum.getRange().get(n));
    }

    public final String getDataAsString() {
        return this.value.getTag();
    }

    public final BLonPrimitive makeFromString(String string) {
        BEnum bEnum = this.value;
        if (!bEnum.getRange().isTag(string)) {
            return null;
        }
        return BLonEnum.make(bEnum.getRange().get(string));
    }

    public final BEnum getDataAsEnum(BEnum bEnum) {
        return this.value;
    }

    public final BLonPrimitive makeFromEnum(BEnum bEnum) {
        BLonPrimitive bLonPrimitive = this.makeFromOrdinal(bEnum.getOrdinal());
        return bLonPrimitive != null ? bLonPrimitive : new BLonEnum(bEnum);
    }

    public final BLonPrimitive makeFromOrdinal(int n) {
        BEnum bEnum = this.value;
        if (!bEnum.getRange().isOrdinal(n)) {
            return null;
        }
        return BLonEnum.make(bEnum.getRange().get(n));
    }

    public final BEnum getEnum() {
        return this.value;
    }

    public final BFacets getEnumFacets() {
        return BFacets.makeEnum((BEnumRange)this.value.getRange());
    }

    public final double getNumeric() {
        return this.getDataAsDouble();
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    public final boolean getBoolean() {
        return this.getDataAsBoolean();
    }

    public final BFacets getBooleanFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonEnum(BEnum bEnum) {
        this.value = bEnum;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonEnum;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonEnum = BLonEnum.class("[Ljavax.baja.lonworks.londata.BLonEnum;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

