/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonDouble
extends BLonPrimitive
implements BINumeric {
    public static final BLonDouble POSITIVE_INFINITY = new BLonDouble(Double.POSITIVE_INFINITY);
    public static final BLonDouble NEGATIVE_INFINITY = new BLonDouble(Double.NEGATIVE_INFINITY);
    public static final BLonDouble NaN = new BLonDouble(Double.NaN);
    public static final BLonDouble DEFAULT = new BLonDouble(0.0);
    public static final Type TYPE;
    private double value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonDouble;

    public static final BLonDouble make(double d) {
        if (d == 0.0) {
            return DEFAULT;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        if (Double.isNaN(d)) {
            return NaN;
        }
        return new BLonDouble(d);
    }

    public final double getDouble() {
        return this.value;
    }

    public final int getInt() {
        return (int)this.value;
    }

    public static final String toString(double d, Context context) {
        BUnit bUnit = null;
        if (context != null && (bUnit = (BUnit)context.getFacet("units")) != null && bUnit.isNull()) {
            bUnit = null;
        }
        String string = d == Double.POSITIVE_INFINITY ? "+inf" : (d == Double.NEGATIVE_INFINITY ? "-inf" : (Double.isNaN(d) ? "nan" : Double.toString(d)));
        if (bUnit != null) {
            string = string + ' ' + bUnit.getSymbol();
        }
        return string;
    }

    public final int hashCode() {
        return (int)(Double.doubleToLongBits(this.value) & (long)-1);
    }

    public final boolean equals(Object object) {
        if (object instanceof BLonDouble) {
            double d = ((BLonDouble)((Object)object)).value;
            if (d == this.value) {
                return true;
            }
            if (Double.isNaN(d) && Double.isNaN(this.value)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean equals(double d, double d2) {
        if (d == d2) {
            return true;
        }
        return Double.isNaN(d) && Double.isNaN(d2);
    }

    public final int compareTo(Object object) {
        double d = this.value;
        double d2 = ((BLonDouble)((Object)object)).value;
        if (BLonDouble.equals(d, d2)) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public final String toString(Context context) {
        return BLonDouble.toString(this.value, context);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.value);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        double d = dataInput.readDouble();
        if (BLonDouble.equals(this.value, d)) {
            return this;
        }
        return new BLonDouble(d);
    }

    public final String encodeToString() throws IOException {
        return BLonDouble.encodeToString(this.value);
    }

    public static final String encodeToString(double d) throws IOException {
        if (d == Double.POSITIVE_INFINITY) {
            return "+inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-inf";
        }
        if (Double.isNaN(d)) {
            return "nan";
        }
        return String.valueOf(d);
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            if (string.equals("+inf")) {
                return POSITIVE_INFINITY;
            }
            if (string.equals("-inf")) {
                return NEGATIVE_INFINITY;
            }
            if (string.equals("nan")) {
                return NaN;
            }
            return new BLonDouble(Double.parseDouble(string));
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid double: " + string);
        }
    }

    public static final double doubleFromString(String string) throws IOException {
        try {
            if (string.equalsIgnoreCase("+inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (string.equalsIgnoreCase("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (string.equalsIgnoreCase("nan")) {
                return Double.NaN;
            }
            return Double.parseDouble(string);
        }
        catch (Throwable throwable) {
            throw new IOException("Invalid double: " + string);
        }
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        double d = this.value;
        boolean bl = false;
        if (bLonElementQualifiers.hasInvalidValue() && Double.isNaN(d)) {
            d = bLonElementQualifiers.getInvalidValue();
            bl = true;
        } else {
            if (bLonElementQualifiers.getOffset() != 0.0f) {
                d += (double)bLonElementQualifiers.getOffset();
            }
            if (bLonElementQualifiers.getResolution() != 1.0f) {
                d /= (double)bLonElementQualifiers.getResolution();
            }
        }
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                lonOutputStream.writeUnsigned8((int)d);
                break;
            }
            case 1: {
                lonOutputStream.writeSigned8((int)d);
                break;
            }
            case 2: {
                lonOutputStream.writeUnsigned8((int)d);
                break;
            }
            case 3: {
                lonOutputStream.writeSigned16((int)d);
                break;
            }
            case 4: {
                lonOutputStream.writeUnsigned16((int)d);
                break;
            }
            case 5: {
                lonOutputStream.writeSigned32((int)d);
                break;
            }
            case 16: {
                if (bl) {
                    lonOutputStream.writeUnsigned32(bLonElementQualifiers.getInvalidValueL());
                    break;
                }
                lonOutputStream.writeUnsigned32((long)d);
                break;
            }
            case 12: {
                lonOutputStream.writeBit((int)d, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                lonOutputStream.writeSignedBit((int)d, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 8: {
                lonOutputStream.writeFloat((float)d);
                break;
            }
            case 17: {
                lonOutputStream.writeDouble(d);
                break;
            }
            case 18: {
                if (bl) {
                    lonOutputStream.writeSigned64(bLonElementQualifiers.getInvalidValueL());
                    break;
                }
                lonOutputStream.writeSigned64((long)d);
                break;
            }
            case 19: {
                if (bl) {
                    lonOutputStream.writeUnsigned64(new BigInteger(Long.toString(bLonElementQualifiers.getInvalidValueL())));
                    break;
                }
                lonOutputStream.writeUnsigned64(new BigInteger(Long.toString((long)d)));
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonDouble " + (Object)((Object)bLonElementQualifiers.getElemtype()));
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        double d;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 0: {
                d = lonInputStream.readUnsigned8();
                break;
            }
            case 1: {
                d = lonInputStream.readSigned8();
                break;
            }
            case 2: {
                d = lonInputStream.readUnsigned8();
                break;
            }
            case 3: {
                d = lonInputStream.readSigned16();
                break;
            }
            case 4: {
                d = lonInputStream.readUnsigned16();
                break;
            }
            case 5: {
                d = lonInputStream.readSigned32();
                break;
            }
            case 16: {
                long l = lonInputStream.readUnsigned32();
                if (bLonElementQualifiers.isInvalid(l)) {
                    return BLonDouble.make(Double.NaN);
                }
                d = l;
                break;
            }
            case 12: {
                d = lonInputStream.readBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 13: {
                d = lonInputStream.readSignedBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            case 8: {
                d = lonInputStream.readFloat();
                break;
            }
            case 17: {
                d = lonInputStream.readDouble();
                break;
            }
            case 18: {
                long l = lonInputStream.readSigned64();
                if (bLonElementQualifiers.isInvalid(l)) {
                    return BLonDouble.make(Double.NaN);
                }
                d = l;
                break;
            }
            case 19: {
                d = lonInputStream.readUnsigned64().doubleValue();
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for LonDouble.");
            }
        }
        if (bLonElementQualifiers.isInvalid(d)) {
            return BLonDouble.make(Double.NaN);
        }
        if (bLonElementQualifiers.getResolution() != 1.0f) {
            d *= (double)bLonElementQualifiers.getResolution();
        }
        if (bLonElementQualifiers.getOffset() != 0.0f) {
            d -= (double)bLonElementQualifiers.getOffset();
        }
        if (d == this.value) {
            return this;
        }
        return BLonDouble.make(d);
    }

    public final double getDataAsDouble() {
        return this.value;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        return BLonDouble.make(d);
    }

    public final boolean isNumeric() {
        return true;
    }

    public final boolean getDataAsBoolean() {
        boolean bl = false;
        if (this.value > 0.0) {
            bl = true;
        }
        return bl;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonDouble.make(bl ? 1.0f : 0.0f);
    }

    public final String getDataAsString() {
        return Double.toString(this.value);
    }

    public final BLonPrimitive makeFromString(String string) {
        double d = Double.NaN;
        try {
            d = Double.valueOf(string);
        }
        catch (Throwable throwable) {}
        return BLonDouble.make(d);
    }

    public final BEnum getDataAsEnum(BEnum bEnum) {
        try {
            BEnumRange bEnumRange = bEnum.getRange();
            return bEnumRange.get((int)this.value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final BLonPrimitive makeFromEnum(BEnum bEnum) {
        return new BLonDouble(bEnum.getOrdinal());
    }

    public final int getIntValue() {
        return (int)this.value;
    }

    public final double getNumeric() {
        return this.value;
    }

    public final BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonDouble(double d) {
        this.value = d;
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonDouble;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonDouble = BLonDouble.class("[Ljavax.baja.lonworks.londata.BLonDouble;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

