/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonData
extends BVector {
    public static final Type TYPE;
    private Vector proxyExt;
    private int byteLength;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonData;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonPrimitive;

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (BLonData.isDataProp(property)) {
            this.dataChanged(context);
        }
    }

    public static boolean isDataProp(Property property) {
        boolean bl = false;
        if (property.getType().is(BLonPrimitive.TYPE) || property.getType().is(TYPE)) {
            bl = true;
        }
        return bl;
    }

    protected void dataChanged(Context context) {
        BComponent bComponent = (BComponent)this.getParent();
        if (bComponent == null) {
            return;
        }
        if (bComponent.getType().is(TYPE)) {
            ((BLonData)bComponent).dataChanged(context);
        }
    }

    public void writeOk() {
        if (this.proxyExt == null) {
            return;
        }
        int n = 0;
        while (n < this.proxyExt.size()) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
            BStatusValue bStatusValue = bLonProxyExt.getStatusValue();
            if (bStatusValue != null) {
                bLonProxyExt.writeOk(bStatusValue);
            }
            ++n;
        }
    }

    public void writeFail(String string) {
        if (this.proxyExt == null) {
            return;
        }
        int n = 0;
        while (n < this.proxyExt.size()) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
            bLonProxyExt.writeFail(string);
            ++n;
        }
    }

    public void readFail(String string) {
        if (this.proxyExt == null) {
            return;
        }
        int n = 0;
        while (n < this.proxyExt.size()) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
            bLonProxyExt.readFail(string);
            ++n;
        }
    }

    public void readOk() {
        if (this.proxyExt == null) {
            return;
        }
        int n = 0;
        while (n < this.proxyExt.size()) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
            BStatusValue bStatusValue = bLonProxyExt.getStatusValue();
            if (bStatusValue != null) {
                bLonProxyExt.readOk(bStatusValue);
            }
            ++n;
        }
    }

    public void markStale(boolean bl, Context context) {
        if (this.proxyExt == null) {
            return;
        }
        int n = 0;
        while (n < this.proxyExt.size()) {
            ((BLonProxyExt)((Object)this.proxyExt.elementAt(n))).setStale(true, context);
            ++n;
        }
    }

    public void registerProxyExt(BLonProxyExt bLonProxyExt) {
        this.getLC().getData().doRegisterProxyExt(bLonProxyExt);
    }

    private final void doRegisterProxyExt(BLonProxyExt bLonProxyExt) {
        if (this.proxyExt == null) {
            this.proxyExt = new Vector();
        }
        if (this.proxyExt.contains((Object)bLonProxyExt)) {
            return;
        }
        this.proxyExt.addElement(bLonProxyExt);
    }

    public void unregisterProxyExt(BLonProxyExt bLonProxyExt) {
        this.getLC().getData().doUnregisterProxyExt(bLonProxyExt);
    }

    private final BLonComponent getLC() {
        BLonData bLonData = this;
        while (!bLonData.getType().is(BLonComponent.TYPE)) {
            bLonData = bLonData.getParent();
        }
        return (BLonComponent)bLonData;
    }

    private final void doUnregisterProxyExt(BLonProxyExt bLonProxyExt) {
        if (this.proxyExt == null) {
            return;
        }
        this.proxyExt.removeElement((Object)bLonProxyExt);
    }

    /*
     * Unable to fully structure code
     */
    public void removeProxies(Context var1_1) {
        if (this.proxyExt != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (BLonProxyExt)this.proxyExt.firstElement();
            this.proxyExt.removeElementAt(0);
            var3_3 = (BComponent)var2_2.getParent();
            ((BComponent)var3_3.getParent()).remove(var3_3.getPropertyInParent(), var1_1);
lbl7:
            // 2 sources

            ** while (!this.proxyExt.isEmpty())
        }
lbl8:
        // 1 sources

    }

    public boolean hasProxies() {
        boolean bl = false;
        if (this.proxyExt != null && this.proxyExt.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean hasWriteProxies() {
        if (this.proxyExt != null) {
            int n = 0;
            while (n < this.proxyExt.size()) {
                BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
                BControlPoint bControlPoint = (BControlPoint)bLonProxyExt.getParent();
                if (bControlPoint.isWritablePoint()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public BControlPoint[] getProxies(boolean bl) {
        if (this.proxyExt == null) {
            return null;
        }
        Class clazz = class$javax$baja$control$BControlPoint;
        if (clazz == null) {
            clazz = class$javax$baja$control$BControlPoint = BLonData.class("[Ljavax.baja.control.BControlPoint;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < this.proxyExt.size()) {
            BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
            BControlPoint bControlPoint = (BControlPoint)bLonProxyExt.getParent();
            if (bControlPoint.isWritablePoint() || bl) {
                array.add((Object)bControlPoint);
            }
            ++n;
        }
        return (BControlPoint[])array.trim();
    }

    public final boolean forceProxyUpdates() {
        boolean bl = false;
        if (this.proxyExt != null) {
            int n = 0;
            while (n < this.proxyExt.size()) {
                BLonProxyExt bLonProxyExt = (BLonProxyExt)((Object)this.proxyExt.elementAt(n));
                BControlPoint bControlPoint = (BControlPoint)bLonProxyExt.getParent();
                if (bControlPoint.isWritablePoint()) {
                    bLonProxyExt.forceUpdate();
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean canCopyFrom(BLonData bLonData) {
        return this.hasEquivalentElements(bLonData);
    }

    public boolean hasEquivalentElements(BLonData bLonData) {
        if (this.isUnion() != bLonData.isUnion()) {
            return false;
        }
        SlotCursor slotCursor = this.getProperties();
        SlotCursor slotCursor2 = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BLonElementQualifiers bLonElementQualifiers;
            if (!slotCursor2.nextObject()) {
                return false;
            }
            Property property = slotCursor.property();
            Property property2 = slotCursor2.property();
            if (property.getType() != property2.getType()) {
                return false;
            }
            if (property.getType().is(TYPE)) {
                if (((BLonData)slotCursor.get()).hasEquivalentElements((BLonData)slotCursor2.get())) continue;
                return false;
            }
            if (!property.getType().is(BLonPrimitive.TYPE)) continue;
            if (!property.getName().equals(property2.getName())) {
                return false;
            }
            BLonElementQualifiers bLonElementQualifiers2 = LonFacetsUtil.getQualifiers(property.getFacets());
            if (!bLonElementQualifiers2.canCopyFrom((Object)(bLonElementQualifiers = LonFacetsUtil.getQualifiers(property2.getFacets())))) {
                return false;
            }
            if (!property.getType().is(BLonEnum.TYPE)) continue;
            BEnum bEnum = ((BLonEnum)slotCursor.get()).getEnum();
            BEnum bEnum2 = ((BLonEnum)slotCursor2.get()).getEnum();
            if (bEnum.getRange().equals((Object)bEnum2.getRange())) continue;
            return false;
        }
        return !slotCursor2.nextObject();
    }

    public void subscribed() {
        this.readSubscribed();
    }

    public void unsubscribed() {
        this.readUnsubscribed();
    }

    public void readSubscribed() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BLonComponent) {
            ((BLonComponent)bComplex).readSubscribed();
        } else {
            ((BLonData)bComplex).readSubscribed();
        }
    }

    public void readUnsubscribed() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BLonComponent) {
            ((BLonComponent)bComplex).readUnsubscribed();
        } else {
            ((BLonData)bComplex).readUnsubscribed();
        }
    }

    public BLonComponent getLonComponent() {
        BLonData bLonData = this;
        while (!(bLonData instanceof BLonComponent)) {
            bLonData = bLonData.getParent();
        }
        return (BLonComponent)bLonData;
    }

    public void initDataElements(float[] fArray) {
        this.initDataElements(fArray, 0);
    }

    private final int initDataElements(float[] fArray, int n) {
        int n2 = n;
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                if (n2 >= fArray.length) {
                    throw new BajaRuntimeException("Not enough init elements for " + this.getLonComponent().getDisplayName(null));
                }
                BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(slotCursor.property().getFacets());
                BLonPrimitive bLonPrimitive = ((BLonPrimitive)bObject).makeFromDouble(fArray[n2++], bLonElementQualifiers);
                this.set(slotCursor.property(), (BValue)bLonPrimitive, BLonNetwork.lonNoWrite);
                continue;
            }
            if (!type.is(TYPE)) continue;
            n2 = this.initDataElements(fArray, n2);
        }
        return n2;
    }

    public BLonPrimitive[] getPrimitives() {
        Class clazz = class$javax$baja$lonworks$londata$BLonPrimitive;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonPrimitive = BLonData.class("[Ljavax.baja.lonworks.londata.BLonPrimitive;", false);
        }
        Array array = new Array(clazz);
        this.getPrimitives(this, array);
        return (BLonPrimitive[])array.trim();
    }

    void getPrimitives(BLonData bLonData, Array array) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                array.add((Object)bObject);
                continue;
            }
            if (!type.is(TYPE)) continue;
            this.getPrimitives((BLonData)bObject, array);
        }
    }

    public int getByteLength() {
        if (this.byteLength == -1) {
            this.byteLength = this.toNetBytes().length;
        }
        return this.byteLength;
    }

    public byte[] toNetBytes() {
        LonOutputStream lonOutputStream = new LonOutputStream();
        this.toOutputStream(lonOutputStream);
        return lonOutputStream.toByteArray();
    }

    protected void toOutputStream(LonOutputStream lonOutputStream) {
        Property[] propertyArray = this.getActiveProps();
        int n = 0;
        while (n < propertyArray.length) {
            BValue bValue = this.get(propertyArray[n]);
            Type type = bValue.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                this.primitiveToOutputStream(propertyArray[n], lonOutputStream);
            } else if (type.is(TYPE)) {
                int n2 = lonOutputStream.setBitFieldMark();
                ((BLonData)bValue).toOutputStream(lonOutputStream);
                lonOutputStream.resetBitFieldMark(n2);
            }
            ++n;
        }
    }

    protected void primitiveToOutputStream(Property property, LonOutputStream lonOutputStream) {
        BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
        int n = bLonElementQualifiers.getByteOffset();
        if (n > 0) {
            lonOutputStream.setPosition(n);
        }
        ((BLonPrimitive)this.get(property)).toOutputStream(lonOutputStream, bLonElementQualifiers);
    }

    public void fromNetBytes(byte[] byArray) {
        this.fromInputStream(new LonInputStream(byArray));
    }

    protected void fromInputStream(LonInputStream lonInputStream) {
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                this.primitiveFromInputStream(slotCursor.property(), lonInputStream);
                continue;
            }
            if (!type.is(TYPE)) continue;
            int n = lonInputStream.setBitFieldMark();
            ((BLonData)bObject).fromInputStream(lonInputStream);
            lonInputStream.resetBitFieldMark(n);
        }
    }

    Property[] getActiveProps() {
        return this.getPropertiesArray();
    }

    protected void primitiveFromInputStream(Property property, LonInputStream lonInputStream) {
        BLonPrimitive bLonPrimitive;
        BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
        try {
            int n = bLonElementQualifiers.getByteOffset();
            if (n > 0) {
                lonInputStream.reset(n);
            }
            bLonPrimitive = ((BLonPrimitive)this.get(property)).fromInputStream(lonInputStream, bLonElementQualifiers);
        }
        catch (Throwable throwable) {
            Log.getLog((String)"lonworks").error("Unable to decode netBytes for " + property.getName() + ": " + throwable.getMessage());
            return;
        }
        this.set(property, (BValue)bLonPrimitive, BLonNetwork.lonNoWrite);
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Property[] propertyArray = this.getActiveProps();
        int n2 = 0;
        while (n2 < propertyArray.length) {
            BValue bValue = this.get(propertyArray[n2]);
            Type type = bValue.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                BLonPrimitive bLonPrimitive;
                if (n > 3) {
                    stringBuffer.append(", ...");
                    break;
                }
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if ((bLonPrimitive = (BLonPrimitive)bValue).isNumeric()) {
                    double d = bLonPrimitive.getDataAsDouble();
                    BasicContext basicContext = new BasicContext(context, propertyArray[n2].getFacets());
                    stringBuffer.append(BDouble.make((double)d).toString((Context)basicContext));
                } else {
                    stringBuffer.append(bLonPrimitive.toString(context));
                }
                ++n;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextObject()) {
            stringBuffer.append(slotCursor.property().getName()).append(":").append(slotCursor.get().toDebugString()).append("\n");
            BFacets bFacets = slotCursor.property().getFacets();
            try {
                if (bFacets != null) {
                    stringBuffer.append(bFacets.encodeToString()).append("\n");
                }
            }
            catch (Throwable throwable) {}
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void setLonInt(String string, int n, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
        if (bLonPrimitive.getType().is(BLonInteger.TYPE)) {
            this.set(property, (BValue)BLonInteger.make(n), context);
        } else {
            this.set(property, (BValue)bLonPrimitive.makeFromDouble(n, bLonElementQualifiers), context);
        }
    }

    public void setLonBoolean(String string, boolean bl, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        if (bLonPrimitive.getType().is(BLonBoolean.TYPE)) {
            this.set(property, (BValue)BLonBoolean.make(bl), context);
        } else {
            this.set(property, (BValue)bLonPrimitive.makeFromBoolean(bl), context);
        }
    }

    public void setLonFloat(String string, float f, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(property.getFacets());
        if (bLonPrimitive.getType().is(BLonFloat.TYPE)) {
            this.set(property, (BValue)BLonFloat.make(f), context);
        } else {
            this.set(property, (BValue)bLonPrimitive.makeFromDouble(f, bLonElementQualifiers), context);
        }
    }

    public void setLonString(String string, String string2, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        if (bLonPrimitive.getType().is(BLonString.TYPE)) {
            this.set(property, (BValue)BLonString.make(string2), context);
        } else {
            this.set(property, (BValue)bLonPrimitive.makeFromString(string2), context);
        }
    }

    public void setLonEnum(String string, String string2, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        this.set(property, (BValue)bLonPrimitive.makeFromString(string2), context);
    }

    public void setLonEnum(String string, BEnum bEnum, Context context) {
        Property property = this.getProperty(string);
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(property);
        this.set(property, (BValue)bLonPrimitive.makeFromEnum(bEnum), context);
    }

    public int getLonInt(String string) {
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(this.getProperty(string));
        if (bLonPrimitive.getType().is(BLonInteger.TYPE)) {
            return ((BLonInteger)bLonPrimitive).getInt();
        }
        return (int)bLonPrimitive.getDataAsDouble();
    }

    public boolean getLonBoolean(String string) {
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(this.getProperty(string));
        if (bLonPrimitive.getType().is(BLonBoolean.TYPE)) {
            return ((BLonBoolean)bLonPrimitive).getBoolean();
        }
        return bLonPrimitive.getDataAsBoolean();
    }

    public float getLonFloat(String string) {
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(this.getProperty(string));
        if (bLonPrimitive.getType().is(BLonFloat.TYPE)) {
            return ((BLonFloat)bLonPrimitive).getFloat();
        }
        return (float)bLonPrimitive.getDataAsDouble();
    }

    public String getLonString(String string) {
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(this.getProperty(string));
        if (bLonPrimitive.getType().is(BLonString.TYPE)) {
            return ((BLonString)bLonPrimitive).getString();
        }
        return bLonPrimitive.getDataAsString();
    }

    public BEnum getLonEnum(String string, BEnum bEnum) {
        BLonPrimitive bLonPrimitive = (BLonPrimitive)this.get(this.getProperty(string));
        return bLonPrimitive.getDataAsEnum(bEnum);
    }

    public boolean isUnion() {
        return false;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.proxyExt = null;
        this.byteLength = -1;
    }

    public BLonData() {
        this.this();
    }

    public BLonData(BLonPrimitive bLonPrimitive, BLonElementQualifiers bLonElementQualifiers, BUnit bUnit) {
        this.this();
        BFacets bFacets = LonFacetsUtil.makeFacets(bLonElementQualifiers, bUnit);
        this.add("value", (BValue)bLonPrimitive, 0, bFacets, null);
    }

    static {
        Class clazz = class$javax$baja$lonworks$londata$BLonData;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonData = BLonData.class("[Ljavax.baja.lonworks.londata.BLonData;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

