/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.londata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.InvalidTypeException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BLonBoolean
extends BLonPrimitive
implements BIBoolean,
BIEnum {
    public static final BLonBoolean TRUE = new BLonBoolean(true);
    public static final BLonBoolean FALSE;
    public static final BLonBoolean DEFAULT;
    public static final Type TYPE;
    boolean value;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonBoolean;

    public static final BLonBoolean make(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BLonBoolean)) {
            return false;
        }
        return this.value ^ ((BLonBoolean)((Object)object)).value ^ true;
    }

    public final String toString(Context context) {
        return this.value ? "true" : "false";
    }

    public final String encodeToString() {
        return this.value ? "true" : "false";
    }

    public final BObject decodeFromString(String string) throws IOException {
        if (string.equals("true")) {
            return TRUE;
        }
        if (string.equals("false")) {
            return FALSE;
        }
        throw new IOException("Invalid boolean: " + string);
    }

    public static final boolean booleanFromString(String string) throws IOException {
        if (string.equals("true")) {
            return true;
        }
        if (string.equals("false")) {
            return false;
        }
        throw new IOException("Invalid boolean: " + string);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final Type getType() {
        return TYPE;
    }

    public final void toOutputStream(LonOutputStream lonOutputStream, BLonElementQualifiers bLonElementQualifiers) {
        boolean bl = this.value;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 6: {
                lonOutputStream.writeBoolean(bl);
                break;
            }
            case 11: {
                lonOutputStream.writeBooleanBit(bl, bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for BLonBoolean.");
            }
        }
    }

    public final BLonPrimitive fromInputStream(LonInputStream lonInputStream, BLonElementQualifiers bLonElementQualifiers) {
        boolean bl;
        switch (bLonElementQualifiers.getElemtype().getOrdinal()) {
            case 6: {
                bl = lonInputStream.readBoolean();
                break;
            }
            case 11: {
                bl = lonInputStream.readBooleanBit(bLonElementQualifiers.getByteOffset(), bLonElementQualifiers.getBitOffset(), bLonElementQualifiers.getSize());
                break;
            }
            default: {
                throw new InvalidTypeException("Invalid datatype for BLonBoolean.");
            }
        }
        return BLonBoolean.make(bl);
    }

    public final double getDataAsDouble() {
        return this.value ? 1.0 : 0.0;
    }

    public final BLonPrimitive makeFromDouble(double d, BLonElementQualifiers bLonElementQualifiers) {
        boolean bl = false;
        if (d > 0.0) {
            bl = true;
        }
        return BLonBoolean.make(bl);
    }

    public final boolean getDataAsBoolean() {
        return this.value;
    }

    public final BLonPrimitive makeFromBoolean(boolean bl) {
        return BLonBoolean.make(bl);
    }

    public final String getDataAsString() {
        return this.value ? "true" : "false";
    }

    public final BLonPrimitive makeFromString(String string) {
        boolean bl = false;
        try {
            bl = Boolean.valueOf(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return BLonBoolean.make(bl);
    }

    public final boolean getBoolean() {
        return this.getDataAsBoolean();
    }

    public final BFacets getBooleanFacets() {
        return BFacets.NULL;
    }

    public final BEnum getEnum() {
        return this.value ? BBoolean.TRUE : BBoolean.FALSE;
    }

    public final BFacets getEnumFacets() {
        return BFacets.makeBoolean();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BLonBoolean(boolean bl) {
        this.value = bl;
    }

    static {
        DEFAULT = FALSE = new BLonBoolean(false);
        Class clazz = class$javax$baja$lonworks$londata$BLonBoolean;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonBoolean = BLonBoolean.class("[Ljavax.baja.lonworks.londata.BLonBoolean;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

