/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BSubnetNode
extends BSimple
implements LonAddress {
    static IntHashMap cache = new IntHashMap();
    public static final BSubnetNode DEFAULT = new BSubnetNode(0, 0);
    public static final Type TYPE;
    private int subnetId;
    private int nodeId;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BSubnetNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final BSubnetNode make(int n, int n2) {
        IntHashMap intHashMap = cache;
        synchronized (intHashMap) {
            int n3 = n << 8 | n2;
            BSubnetNode bSubnetNode = (BSubnetNode)cache.get(n3);
            if (bSubnetNode == null) {
                bSubnetNode = new BSubnetNode(n, n2);
                cache.put(n3, (Object)bSubnetNode);
            }
            return bSubnetNode;
        }
    }

    public final BSubnetNode makeFrom(int n, int n2) {
        return BSubnetNode.make(n, n2);
    }

    public final int getSubnetId() {
        return this.subnetId;
    }

    public final int getNodeId() {
        return this.nodeId;
    }

    public final int hashCode() {
        return 0x1000000 | this.subnetId << 8 | this.nodeId;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BSubnetNode)) {
            return false;
        }
        BSubnetNode bSubnetNode = (BSubnetNode)object;
        return this.compare(bSubnetNode.subnetId, bSubnetNode.nodeId);
    }

    private final boolean compare(int n, int n2) {
        boolean bl = false;
        if (this.subnetId == n && this.nodeId == n2) {
            bl = true;
        }
        return bl;
    }

    public final String toString(Context context) {
        return "" + this.subnetId + '/' + this.nodeId;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.subnetId);
        dataOutput.writeInt(this.nodeId);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.makeFrom(dataInput.readInt(), dataInput.readInt());
    }

    public final String encodeToString() throws IOException {
        return "" + this.subnetId + '/' + this.nodeId;
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf("/");
        int n2 = Integer.parseInt(string.substring(0, n));
        int n3 = Integer.parseInt(string.substring(n + 1));
        return this.makeFrom(n2, n3);
    }

    public final Type getType() {
        return TYPE;
    }

    public final int getAddressType() {
        return 1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BSubnetNode(int n, int n2) {
        if (n < 0 || n > 255 || n2 < 0 || n2 > 127) {
            throw new BajaRuntimeException("Invalid subnet/node " + n + '/' + n2 + ". Valid values are subnet 1-255 node 1-127.");
        }
        this.subnetId = n;
        this.nodeId = n2;
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BSubnetNode;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BSubnetNode = BSubnetNode.class("[Ljavax.baja.lonworks.datatypes.BSubnetNode;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

