/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.data.BIDataValue;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNvConfigData
extends BStruct {
    public static final int DEFAULT_ADDR_INDEX = -1;
    public static final Property priority = BNvConfigData.newProperty((int)65, (boolean)false, null);
    public static final Property direction = BNvConfigData.newProperty((int)1, (BValue)BLonNvDirection.input, null);
    public static final Property selector = BNvConfigData.newProperty((int)65, (int)-1, (BFacets)BFacets.make((String)"radix", (BIDataValue)BInteger.make((int)16)));
    public static final Property turnAround = BNvConfigData.newProperty((int)65, (boolean)false, null);
    public static final Property serviceType = BNvConfigData.newProperty((int)1, (BValue)BLonServiceType.unacked, null);
    public static final Property authenticated = BNvConfigData.newProperty((int)65, (boolean)false, null);
    public static final Property addrIndex = BNvConfigData.newProperty((int)65, (int)-1, null);
    public static final Type TYPE;
    private static final int PRIORITY_NET_IMAGE = 128;
    private static final int DIRECTION_NET_IMAGE = 64;
    private static final int TURNAROUND_NET_IMAGE = 128;
    private static final int SERVICE_TYPE_NET_IMAGE = 96;
    private static final int AUTH_NET_IMAGE = 16;
    private static final int ADDR_INDEX_NET_IMAGE = 15;
    private static final int UPPER_SEL_MASK = 63;
    private static final int LOWER_SEL_MASK = 255;
    public static final int UNBOUND_NV_BASE_SELECTOR = 16383;
    public static final int MAX_BOUND_SELECTOR = 12287;
    public static final int UNUSED_ADDR_INDEX = 15;
    public static final int UNUSED_EXT_ADDR_INDEX = 65535;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BNvConfigData;

    public boolean getPriority() {
        return this.getBoolean(priority);
    }

    public void setPriority(boolean bl) {
        this.setBoolean(priority, bl, null);
    }

    public BLonNvDirection getDirection() {
        return (BLonNvDirection)this.get(direction);
    }

    public void setDirection(BLonNvDirection bLonNvDirection) {
        this.set(direction, (BValue)bLonNvDirection, null);
    }

    public int getSelector() {
        return this.getInt(selector);
    }

    public void setSelector(int n) {
        this.setInt(selector, n, null);
    }

    public boolean getTurnAround() {
        return this.getBoolean(turnAround);
    }

    public void setTurnAround(boolean bl) {
        this.setBoolean(turnAround, bl, null);
    }

    public BLonServiceType getServiceType() {
        return (BLonServiceType)this.get(serviceType);
    }

    public void setServiceType(BLonServiceType bLonServiceType) {
        this.set(serviceType, (BValue)bLonServiceType, null);
    }

    public boolean getAuthenticated() {
        return this.getBoolean(authenticated);
    }

    public void setAuthenticated(boolean bl) {
        this.setBoolean(authenticated, bl, null);
    }

    public int getAddrIndex() {
        return this.getInt(addrIndex);
    }

    public void setAddrIndex(int n) {
        this.setInt(addrIndex, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isAlias() {
        return false;
    }

    public void writeNetworkBytes(LonOutputStream lonOutputStream) {
        int n = lonOutputStream.setBitFieldMark();
        lonOutputStream.writeBooleanBit(this.getPriority(), 0, 7, 1);
        lonOutputStream.writeBooleanBit(this.isOutput(), 0, 6, 1);
        int n2 = this.getSelector();
        lonOutputStream.writeBit(n2 >> 8, 0, 0, 6);
        lonOutputStream.writeUnsigned8(n2);
        lonOutputStream.writeBooleanBit(this.getTurnAround(), 2, 7, 1);
        lonOutputStream.writeBit(this.getServiceType().getOrdinal(), 2, 5, 2);
        lonOutputStream.writeBooleanBit(this.getAuthenticated(), 2, 4, 1);
        int n3 = this.getAddrIndex() == -1 ? 15 : this.getAddrIndex();
        lonOutputStream.writeBit(n3, 2, 0, 4);
        lonOutputStream.resetBitFieldMark(n);
    }

    public void fromInputStream(LonInputStream lonInputStream) {
        int n = lonInputStream.setBitFieldMark();
        this.setPriority(lonInputStream.readBooleanBit(0, 7, 1));
        BLonNvDirection bLonNvDirection = lonInputStream.readBooleanBit(0, 6, 1) ? BLonNvDirection.output : BLonNvDirection.input;
        this.setDirection(bLonNvDirection);
        int n2 = lonInputStream.readBit(0, 0, 6) << 8 | lonInputStream.readUnsigned8();
        this.setSelector(n2);
        this.setTurnAround(lonInputStream.readBooleanBit(2, 7, 1));
        this.setServiceType(BLonServiceType.make(lonInputStream.readBit(2, 5, 2)));
        this.setAuthenticated(lonInputStream.readBooleanBit(2, 4, 1));
        int n3 = lonInputStream.readBit(2, 0, 4);
        this.setAddrIndex(n3 == 15 ? -1 : n3);
        lonInputStream.resetBitFieldMark(n);
    }

    public boolean isInput() {
        boolean bl = false;
        if (this.getDirection() == BLonNvDirection.input) {
            bl = true;
        }
        return bl;
    }

    public boolean isOutput() {
        boolean bl = false;
        if (this.getDirection() == BLonNvDirection.output) {
            bl = true;
        }
        return bl;
    }

    public boolean isBoundNv() {
        boolean bl = false;
        if (this.getSelector() >= 0 && this.getSelector() < 12287) {
            bl = true;
        }
        return bl;
    }

    public void setUnbound(int n) {
        this.setSelector(16383 - n);
        this.setTurnAround(false);
        this.setAddrIndex(-1);
    }

    public String toString(Context context) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sel:0x").append(Integer.toString(this.getSelector(), 16));
        stringBuffer.append(",").append((Object)this.getServiceType());
        stringBuffer.append(",adr:").append(this.getAddrIndex());
        if (this.getDirection() == BLonNvDirection.input) {
            stringBuffer.append(",in");
        } else {
            stringBuffer.append(",out");
        }
        if (this.getTurnAround()) {
            stringBuffer.append(",turn");
        }
        if (this.getPriority()) {
            stringBuffer.append(",pri");
        }
        if (this.getAuthenticated()) {
            stringBuffer.append(",auth");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BNvConfigData;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BNvConfigData = BNvConfigData.class("[Ljavax.baja.lonworks.datatypes.BNvConfigData;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

