/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks.datatypes;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressTable;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BExtAddressTable;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDeviceData
extends BComponent {
    public static final Property neuronId = BDeviceData.newProperty((int)64, (BValue)BNeuronId.DEFAULT, null);
    public static final Property programId = BDeviceData.newProperty((int)8, (BValue)BProgramId.DEFAULT, null);
    public static final Property nodeState = BDeviceData.newProperty((int)64, (BValue)BLonNodeState.unknown, null);
    public static final Property subnetNodeId = BDeviceData.newProperty((int)65, (BValue)BSubnetNode.DEFAULT, null);
    public static final Property location = BDeviceData.newProperty((int)0, (String)"", null);
    public static final Property authenticate = BDeviceData.newProperty((int)0, (boolean)false, null);
    public static final Property channelId = BDeviceData.newProperty((int)1, (int)0, null);
    public static final Property workingDomain = BDeviceData.newProperty((int)1, (int)0, null);
    public static final Property bindingII = BDeviceData.newProperty((int)1, (boolean)false, null);
    public static final Property hosted = BDeviceData.newProperty((int)1, (boolean)false, null);
    public static final Property twoDomains = BDeviceData.newProperty((int)1, (boolean)false, null);
    public static final Property msgTagCount = BDeviceData.newProperty((int)1, (int)0, null);
    public static final Property addressCount = BDeviceData.newProperty((int)1, (int)0, null);
    public static final Property addressTable = BDeviceData.newProperty((int)65, (BValue)new BAddressTable(), null);
    public static final Property extAddressTable = BDeviceData.newProperty((int)4, (BValue)new BExtAddressTable(), null);
    public static final Property prioritySlot = BDeviceData.newProperty((int)1, (int)0, null);
    public static final Property aliasTable = BDeviceData.newProperty((int)1, (BValue)new BAliasTable(), null);
    public static final Property selfDoc = BDeviceData.newProperty((int)0, (String)"", null);
    public static final Property hasNodeObject = BDeviceData.newProperty((int)0, (boolean)false, null);
    public static final Property freezeChannelPriorities = BDeviceData.newProperty((int)0, (boolean)false, null);
    public static final Property lastHash = BDeviceData.newProperty((int)71, (int)-1, null);
    public static final Property facets = BDeviceData.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public static final Context importChanges;
    private Object pickle;
    static /* synthetic */ Class class$javax$baja$lonworks$datatypes$BDeviceData;

    public BNeuronId getNeuronId() {
        return (BNeuronId)this.get(neuronId);
    }

    public void setNeuronId(BNeuronId bNeuronId) {
        this.set(neuronId, (BValue)bNeuronId, null);
    }

    public BProgramId getProgramId() {
        return (BProgramId)this.get(programId);
    }

    public void setProgramId(BProgramId bProgramId) {
        this.set(programId, (BValue)bProgramId, null);
    }

    public BLonNodeState getNodeState() {
        return (BLonNodeState)this.get(nodeState);
    }

    public void setNodeState(BLonNodeState bLonNodeState) {
        this.set(nodeState, (BValue)bLonNodeState, null);
    }

    public BSubnetNode getSubnetNodeId() {
        return (BSubnetNode)this.get(subnetNodeId);
    }

    public void setSubnetNodeId(BSubnetNode bSubnetNode) {
        this.set(subnetNodeId, (BValue)bSubnetNode, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String string) {
        this.setString(location, string, null);
    }

    public boolean getAuthenticate() {
        return this.getBoolean(authenticate);
    }

    public void setAuthenticate(boolean bl) {
        this.setBoolean(authenticate, bl, null);
    }

    public int getChannelId() {
        return this.getInt(channelId);
    }

    public void setChannelId(int n) {
        this.setInt(channelId, n, null);
    }

    public int getWorkingDomain() {
        return this.getInt(workingDomain);
    }

    public void setWorkingDomain(int n) {
        this.setInt(workingDomain, n, null);
    }

    public boolean getBindingII() {
        return this.getBoolean(bindingII);
    }

    public void setBindingII(boolean bl) {
        this.setBoolean(bindingII, bl, null);
    }

    public boolean getHosted() {
        return this.getBoolean(hosted);
    }

    public void setHosted(boolean bl) {
        this.setBoolean(hosted, bl, null);
    }

    public boolean getTwoDomains() {
        return this.getBoolean(twoDomains);
    }

    public void setTwoDomains(boolean bl) {
        this.setBoolean(twoDomains, bl, null);
    }

    public int getMsgTagCount() {
        return this.getInt(msgTagCount);
    }

    public void setMsgTagCount(int n) {
        this.setInt(msgTagCount, n, null);
    }

    public int getAddressCount() {
        return this.getInt(addressCount);
    }

    public void setAddressCount(int n) {
        this.setInt(addressCount, n, null);
    }

    public BAddressTable getAddressTable() {
        return (BAddressTable)this.get(addressTable);
    }

    public void setAddressTable(BAddressTable bAddressTable) {
        this.set(addressTable, (BValue)bAddressTable, null);
    }

    public BExtAddressTable getExtAddressTable() {
        return (BExtAddressTable)this.get(extAddressTable);
    }

    public void setExtAddressTable(BExtAddressTable bExtAddressTable) {
        this.set(extAddressTable, (BValue)bExtAddressTable, null);
    }

    public int getPrioritySlot() {
        return this.getInt(prioritySlot);
    }

    public void setPrioritySlot(int n) {
        this.setInt(prioritySlot, n, null);
    }

    public BAliasTable getAliasTable() {
        return (BAliasTable)this.get(aliasTable);
    }

    public void setAliasTable(BAliasTable bAliasTable) {
        this.set(aliasTable, (BValue)bAliasTable, null);
    }

    public String getSelfDoc() {
        return this.getString(selfDoc);
    }

    public void setSelfDoc(String string) {
        this.setString(selfDoc, string, null);
    }

    public boolean getHasNodeObject() {
        return this.getBoolean(hasNodeObject);
    }

    public void setHasNodeObject(boolean bl) {
        this.setBoolean(hasNodeObject, bl, null);
    }

    public boolean getFreezeChannelPriorities() {
        return this.getBoolean(freezeChannelPriorities);
    }

    public void setFreezeChannelPriorities(boolean bl) {
        this.setBoolean(freezeChannelPriorities, bl, null);
    }

    public int getLastHash() {
        return this.getInt(lastHash);
    }

    public void setLastHash(int n) {
        this.setInt(lastHash, n, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        BComplex bComplex;
        super.changed(property, context);
        if (!this.isRunning() || context == importChanges) {
            return;
        }
        if (property == facets) {
            this.pickle = null;
        }
        if ((bComplex = this.getParent()) instanceof BLonDevice) {
            ((BLonDevice)bComplex).deviceDataChanged(property, context);
        }
        if (property == neuronId || property == programId || property == nodeState || property == subnetNodeId || property == channelId) {
            NmUtil.getLonNetwork(this).addressManager().deviceDataChanged(this, context);
        }
        if (context == AddressManager.noDeviceChange || context == NAddressManager.localChange) {
            return;
        }
        if (this.getNeuronId().isZero()) {
            return;
        }
        Runnable runnable = null;
        if (property == nodeState) {
            runnable = new Runnable(){

                public final void run() {
                    BDeviceData.this.updateNodeState();
                }
            };
        } else if (property == subnetNodeId || property == workingDomain) {
            runnable = new Runnable(){

                public final void run() {
                    BDeviceData.this.updateSubnetNodeId();
                }
            };
        }
        if (runnable != null) {
            NmUtil.getLonNetwork(this).postAsync(runnable);
        }
    }

    private final void updateSubnetNodeId() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BLonDevice) {
            BLonDevice bLonDevice = (BLonDevice)bComplex;
            bLonDevice.updateDomainTable();
        }
    }

    private final void updateNodeState() {
        boolean bl = false;
        BComplex bComplex = this.getParent();
        BLonNodeState bLonNodeState = this.getNodeState();
        LonException lonException = null;
        if (bComplex instanceof BLonDevice) {
            BLonDevice bLonDevice = (BLonDevice)bComplex;
            bLonDevice.updateNodeState();
        } else if (bComplex instanceof BLonRouter) {
            BLonRouter bLonRouter = (BLonRouter)bComplex;
            try {
                NmUtil.setDeviceState(bLonRouter, bLonNodeState, true);
                NmUtil.setDeviceState(bLonRouter, bLonNodeState, false);
            }
            catch (LonException lonException2) {
                bl = true;
                lonException = lonException2;
            }
            bLonRouter.getNearDeviceData().set(nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
            bLonRouter.getFarDeviceData().set(nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
        }
        if (bl) {
            throw new BajaRuntimeException("Unable to update state change in " + bComplex.getDisplayName(null), (Throwable)((Object)lonException));
        }
    }

    public void setPickle(Object object) {
        if (object instanceof DeviceFacets) {
            this.pickle = object;
        }
    }

    public Object getPickle() {
        return this.pickle;
    }

    public boolean isExtended() {
        return false;
    }

    public void clearAddressTable() {
        this.getAddressTable().clearTable();
    }

    public BIAddressEntry getAddressEntry(int n) {
        return this.getAddressTable().getAddressEntry(n);
    }

    public void setAddressEntry(int n, BIAddressEntry bIAddressEntry) {
        this.getAddressTable().setAddressEntry(n, bIAddressEntry);
    }

    public void setAddressEntry(int n, BIAddressEntry bIAddressEntry, Context context) {
        this.getAddressTable().setAddressEntry(n, bIAddressEntry, context);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pickle = null;
    }

    public BDeviceData() {
        this.this();
    }

    public BDeviceData(BProgramId bProgramId) {
        this.this();
        this.setProgramId(bProgramId);
    }

    public BDeviceData(BProgramId bProgramId, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, boolean bl4) {
        this.this();
        this.setProgramId(bProgramId);
        this.setBindingII(bl);
        this.setHosted(bl2);
        this.setTwoDomains(bl3);
        this.setMsgTagCount(n);
        this.setAddressCount(n2);
        if (n3 > 0) {
            this.setAliasTable(new BAliasTable(n3));
        }
        this.setHasNodeObject(bl4);
    }

    static {
        Class clazz = class$javax$baja$lonworks$datatypes$BDeviceData;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$datatypes$BDeviceData = BDeviceData.class("[Ljavax.baja.lonworks.datatypes.BDeviceData;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"deviceData.png");
        importChanges = new BasicContext();
    }
}

