/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.driver.point.BITunable;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.Tuning;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonLink;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.tuning.BLonTuningPolicy;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNetworkVariable
extends BLonComponent
implements BINetworkVariable,
BITunable,
BIPollable {
    public static final Property nvProps = BNetworkVariable.newProperty((int)0, (BValue)new BNvProps(), null);
    public static final Property nvConfigData = BNetworkVariable.newProperty((int)0, (BValue)new BNvConfigData(), null);
    public static final Property tuningPolicyName = BNetworkVariable.newProperty((int)0, (String)"defaultPolicy", (BFacets)BITunable.TUNING_POLICY_NAME_FACETS);
    public static final Action nvUpdate = BNetworkVariable.newAction((int)4, null);
    public static final Topic receivedUpdate = BNetworkVariable.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private boolean registered;
    private boolean pollSubscribe;
    private int knobCount;
    boolean linked;
    boolean pseudoLink;
    Tuning tuning;
    Object wipSync;
    Array linksToPropagate;
    boolean writeInProgress;
    static /* synthetic */ Class class$javax$baja$lonworks$BNetworkVariable;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonLink;

    public BNvProps getNvProps() {
        return (BNvProps)this.get(nvProps);
    }

    public void setNvProps(BNvProps bNvProps) {
        this.set(nvProps, (BValue)bNvProps, null);
    }

    public BNvConfigData getNvConfigData() {
        return (BNvConfigData)this.get(nvConfigData);
    }

    public void setNvConfigData(BNvConfigData bNvConfigData) {
        this.set(nvConfigData, (BValue)bNvConfigData, null);
    }

    public String getTuningPolicyName() {
        return this.getString(tuningPolicyName);
    }

    public void setTuningPolicyName(String string) {
        this.setString(tuningPolicyName, string, null);
    }

    public void nvUpdate() {
        this.invoke(nvUpdate, null, null);
    }

    public void fireReceivedUpdate(BValue bValue) {
        this.fire(receivedUpdate, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static void setFlags(BNvProps bNvProps, BNvConfigData bNvConfigData, int n) {
        if ((n & 1) > 0) {
            bNvProps.setPolled(true);
        }
        if ((n & 2) > 0) {
            bNvProps.setAuthConf(false);
        }
        if ((n & 4) > 0) {
            bNvProps.setServiceConf(false);
        }
        if ((n & 8) > 0) {
            bNvProps.setPriorityConf(true);
        }
        if ((n & 0x10) > 0) {
            bNvConfigData.setAuthenticated(true);
        }
        if ((n & 0x20) > 0) {
            bNvConfigData.setPriority(true);
        }
        if ((n & 0x40) > 0) {
            bNvConfigData.setServiceType(BLonServiceType.acked);
        }
        if ((n & 0x80) > 0) {
            bNvConfigData.setServiceType(BLonServiceType.unackedRpt);
        }
    }

    public boolean isNetworkVariable() {
        return true;
    }

    public int getNvIndex() {
        return this.getNvProps().getNvIndex();
    }

    public void setNvIndex(int n) {
        this.getNvProps().setNvIndex(n);
    }

    public int getSnvtType() {
        return this.getNvProps().getSnvtType();
    }

    public void setUnbound() {
        int n = this.getNvConfigData().getSelector();
        this.getNvConfigData().setUnbound(this.getNvProps().getNvIndex());
        this.getNvProps().setUnbound();
        this.unbound(n);
    }

    public void unbound(int n) {
        if (this.getNvConfigData().isOutput()) {
            this.unregisterSelector(n);
        }
        this.evaluatePollSubscribe();
        try {
            this.getDevice().unbound(this.getNvProps().getNvIndex());
        }
        catch (Throwable throwable) {}
    }

    public void bound() {
        this.evaluatePollSubscribe();
        if (this.getNvConfigData().isOutput() && this.getNvProps().getBoundToLocal()) {
            this.registerSelector();
        }
        try {
            this.getDevice().bound(this.getNvProps().getNvIndex());
        }
        catch (Throwable throwable) {}
    }

    public void lonComponentStarted() {
        if (this.getNvConfigData().getSelector() == -1) {
            this.getNvConfigData().setUnbound(this.getNvProps().getNvIndex());
        }
        this.getTuning().transition();
        if (this.getNvConfigData().isOutput() && this.getNvProps().getBoundToLocal()) {
            this.registerSelector();
        }
        this.evaluateLinkedState();
        if (Sys.atSteadyState()) {
            this.evaluatePollSubscribe();
        }
    }

    public void lonComponentStopped() {
        this.getTuning().transition();
        if (this.getNvConfigData().isOutput() && this.getNvProps().getBoundToLocal()) {
            this.unregisterSelector(this.getNvConfigData().getSelector());
        }
        this.lonNetwork().getPollService().unsubscribe(this);
        this.linksToPropagate = null;
    }

    public void atSteadyState() throws Exception {
        super.atSteadyState();
        if (this.getNvConfigData().isInput()) {
            this.getNvProps().setBoundToLocal(false);
        }
        if (this.getNvConfigData().isOutput()) {
            this.propagateLinks();
        }
        this.getTuning().transition();
        this.evaluatePollSubscribe();
    }

    public boolean requiresPrioritySlot() {
        BNvConfigData bNvConfigData = this.getNvConfigData();
        return bNvConfigData.getPriority() && !bNvConfigData.isInput() && bNvConfigData.isBoundNv();
    }

    private final void registerSelector() {
        if (this.registered) {
            return;
        }
        this.lonNetwork().nvManager().registerSelector(this.getNvConfigData().getSelector(), this, this.getDevice());
        this.registered = true;
    }

    private final void unregisterSelector(int n) {
        if (!this.registered) {
            return;
        }
        this.lonNetwork().nvManager().unregisterSelector(n, this, this.getDevice());
        this.registered = false;
    }

    void reregisterSelector() {
        if (this.registered) {
            int n = this.getNvConfigData().getSelector();
            this.lonNetwork().nvManager().unregisterSelector(n, this, this.getDevice());
            this.lonNetwork().nvManager().registerSelector(n, this, this.getDevice());
        }
    }

    public BPollFrequency getPollFrequency() {
        return ((BLonTuningPolicy)this.getTuning().getPolicy()).getPollFrequency();
    }

    public int getWriteDelay() {
        return ((BLonTuningPolicy)this.getTuning().getPolicy()).getWriteDelay();
    }

    public void pollNv() {
        if (this.getDevice().isReadyForNvUpdates()) {
            if (this.writeInProgress()) {
                return;
            }
            this.doForceRead();
        }
    }

    private final void evaluatePollSubscribe() {
        boolean bl;
        if (!this.isRunning()) {
            return;
        }
        boolean bl2 = this.evaluateBound();
        boolean bl3 = this.getNvProps().getBoundToLocal();
        boolean bl4 = false;
        if (!bl3 && this.knobCount > 0 && !bl2 || bl3 && this.getNvProps().getPolled()) {
            bl4 = true;
        }
        boolean bl5 = bl4;
        boolean bl6 = false;
        if ((bl5 || !bl3 && this.subscribeCount > 0) && this.getNvProps().getPollEnable()) {
            bl6 = true;
        }
        if ((bl = bl6) && !this.pollSubscribe) {
            this.lonNetwork().getPollService().subscribe(this);
        } else if (!bl && this.pollSubscribe) {
            this.lonNetwork().getPollService().unsubscribe(this);
        }
        this.pollSubscribe = bl;
    }

    protected void lonComponentSubscribed() {
        if (this.isRunning() && this.getDevice().isReadyForNvUpdates()) {
            this.forceRead();
        }
        this.evaluatePollSubscribe();
    }

    protected void lonComponentUnsubscribed() {
        this.evaluatePollSubscribe();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == nvProps) {
            this.evaluatePollSubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void dataChanged(Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (context == null || !BLonNetwork.lonNoPropagate.equals(context)) {
            this.propagateLinks();
        }
        if (context != null && BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (this.wipSync == null) {
            this.wipSync = new Object();
        }
        Object object = this.wipSync;
        synchronized (object) {
            this.writeInProgress = true;
        }
        this.getTuning().writeDesired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean writeInProgress() {
        if (this.wipSync == null) {
            return false;
        }
        Object object = this.wipSync;
        synchronized (object) {
            return this.writeInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void propagateLinks() {
        Array array = this.getLinksToPropagate(false);
        if (array == null) {
            return;
        }
        Array array2 = array;
        synchronized (array2) {
            BLonLink[] bLonLinkArray = (BLonLink[])array.trim();
            int n = 0;
            while (n < bLonLinkArray.length) {
                bLonLinkArray[n].propagateNv(this);
                ++n;
            }
            return;
        }
    }

    public void doForceRead() {
        this.lonDevice().checkState();
        if (this.illegalLength) {
            throw new BajaRuntimeException(this.getDisplayName(null) + " data length > maxNvLength of " + Lon.maxNvLength() + " bytes");
        }
        try {
            if (Lon.d()) {
                byte[] byArray = NmUtil.fetchNv(this.lonDevice(), this.getNvIndex());
                this.getData().fromNetBytes(byArray);
            }
            this.getData().readOk();
            this.getTuning().readOk();
        }
        catch (Throwable throwable) {
            this.getData().readFail(throwable.toString());
            this.getTuning().readFail();
            String string = "Unable to read " + this.debugName();
            this.lonNetwork().log().error(string, throwable);
            throw new BajaRuntimeException(string, throwable);
        }
    }

    public void doNvUpdate() {
        try {
            BNvConfigData bNvConfigData = this.getNvConfigData();
            if (bNvConfigData.isOutput() && bNvConfigData.isBoundNv()) {
                byte[] byArray = NmUtil.pollNv(this.lonDevice(), bNvConfigData);
                this.receiveUpdate(byArray);
            }
        }
        catch (Exception exception) {}
    }

    /*
     * Exception decompiling
     */
    public void doForceWrite() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 210->217)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isWriteable() {
        return this.getNvConfigData().isInput();
    }

    public void receiveUpdate(byte[] byArray) {
        try {
            this.getData().fromNetBytes(byArray);
            this.getData().readOk();
            this.getTuning().readOk();
            this.fireReceivedUpdate(null);
        }
        catch (Throwable throwable) {
            String string = throwable.toString();
            this.getData().readFail(string);
            this.getTuning().readFail();
            this.lonNetwork().log().error("Could not decode nv update data " + this.debugName(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lonKnobAdded(Knob knob) {
        ++this.knobCount;
        Array array = this.getLinksToPropagate(true);
        Array array2 = array;
        synchronized (array2) {
            array.add((Object)((BLonLink)knob.getLink()));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
            this.evaluatePollSubscribe();
        }
        if (this.getDevice().isRunning()) {
            this.pollNv();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lonKnobRemove(Knob knob) {
        --this.knobCount;
        Array array = this.getLinksToPropagate(false);
        if (array != null) {
            Array array2 = array;
            synchronized (array2) {
                array.remove((Object)((BLonLink)knob.getLink()));
            }
        }
        this.evaluatePollSubscribe();
    }

    public void lonLinkAdded() {
        this.evaluateLinkedState();
    }

    public void lonLinkRemoved() {
        this.evaluateLinkedState();
    }

    private final boolean evaluateBound() {
        BNvConfigData bNvConfigData = this.getNvConfigData();
        if (bNvConfigData.isInput()) {
            return bNvConfigData.isBoundNv();
        }
        BComponent bComponent = (BComponent)this.getParent();
        Array array = this.getLinksToPropagate(false);
        if (bComponent != null && array != null) {
            BLonLink[] bLonLinkArray = (BLonLink[])array.trim();
            int n = 0;
            while (n < bLonLinkArray.length) {
                if (!bLonLinkArray[n].isBound(this)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    protected void evaluateLinkedState() {
        this.linked = false;
        this.pseudoLink = false;
        BComponent bComponent = (BComponent)this.getParent();
        if (bComponent == null) {
            return;
        }
        BLink[] bLinkArray = bComponent.getLinks((Slot)this.getPropertyInParent());
        int n = 0;
        while (n < bLinkArray.length) {
            if (bLinkArray[n] instanceof BLonLink) {
                this.linked = true;
                if (((BLonLink)bLinkArray[n]).getPseudoLink()) {
                    this.pseudoLink = true;
                    return;
                }
            }
            ++n;
        }
    }

    protected boolean isLinked() {
        return this.linked;
    }

    public Tuning getTuning() {
        return this.tuning;
    }

    public boolean isFatalFault() {
        return this.getDevice().isFatalFault();
    }

    public BStatus getStatus() {
        return this.getDevice().getStatus();
    }

    public boolean isSubscribedDesired() {
        return false;
    }

    public BReadWriteMode getMode() {
        return this.isWriteable() ? BReadWriteMode.writeonly : BReadWriteMode.readonly;
    }

    public void readSubscribed(Context context) {
        super.readSubscribed();
    }

    public void readUnsubscribed(Context context) {
        super.readUnsubscribed();
    }

    public boolean write(Context context) {
        boolean bl;
        boolean bl2 = false;
        if (context == BTuningPolicy.maxWriteTimeContext || context == BTuningPolicy.writeOnStartContext || context == BTuningPolicy.writeOnUpContext || context == BTuningPolicy.writeOnEnabledContext) {
            bl2 = true;
        }
        if (!(!(bl = bl2) || this.linked && !this.getNvConfigData().isBoundNv() || this.getData().hasWriteProxies() || this.pseudoLink)) {
            this.getTuning().writeOk();
            return false;
        }
        if (context == BTuningPolicy.maxWriteTimeContext && this.getData().hasWriteProxies()) {
            this.getData().forceProxyUpdates();
        }
        if (DeviceFacets.delayNvUpdate(this.lonDevice(), this)) {
            return false;
        }
        this.forceWrite();
        return false;
    }

    public void setStale(boolean bl, Context context) {
        if (this.getData().hasProxies()) {
            this.getData().markStale(bl, context);
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"BNetworkVariable", 2);
        spyWriter.prop((Object)"linked", this.linked);
        spyWriter.prop((Object)"knobCount(nvo)", this.knobCount);
        spyWriter.prop((Object)"allLinksBound", this.evaluateBound());
        spyWriter.prop((Object)"isBoundToLocal", this.getNvProps().getBoundToLocal());
        spyWriter.prop((Object)"hasProxies", this.getData().hasProxies());
        spyWriter.prop((Object)"hasWriteProxies", this.getData().hasWriteProxies());
        spyWriter.prop((Object)"pseudoLink", this.pseudoLink);
        spyWriter.prop((Object)"getMode", (Object)this.getMode());
        spyWriter.prop((Object)"subscribeCount", this.subscribeCount);
        spyWriter.prop((Object)"selector registered", this.registered);
        spyWriter.prop((Object)"pollSubscribe", this.pollSubscribe);
        spyWriter.prop((Object)"writeInProgress", this.writeInProgress);
        spyWriter.prop((Object)"illegalLength", this.illegalLength);
        spyWriter.endProps();
    }

    protected Array getLinksToPropagate(boolean bl) {
        if (bl && this.linksToPropagate == null) {
            Class clazz = class$javax$baja$lonworks$BLonLink;
            if (clazz == null) {
                clazz = class$javax$baja$lonworks$BLonLink = BNetworkVariable.class("[Ljavax.baja.lonworks.BLonLink;", false);
            }
            this.linksToPropagate = new Array(clazz);
        }
        return this.linksToPropagate;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.registered = false;
        this.pollSubscribe = false;
        this.knobCount = 0;
        this.linked = false;
        this.pseudoLink = false;
        this.tuning = new Tuning((BITunable)this);
        this.wipSync = null;
        this.linksToPropagate = null;
        this.writeInProgress = false;
    }

    public BNetworkVariable() {
        this.this();
    }

    public BNetworkVariable(int n, int n2, int n3, int n4, int n5, BLonNvDirection bLonNvDirection) {
        this.this();
        BNvProps bNvProps = this.getNvProps();
        bNvProps.setNvIndex(n);
        bNvProps.setSnvtType(n2);
        bNvProps.setObjectIndex(n3);
        bNvProps.setMemberIndex(n4);
        BNvConfigData bNvConfigData = this.getNvConfigData();
        bNvConfigData.setDirection(bLonNvDirection);
        BNetworkVariable.setFlags(bNvProps, bNvConfigData, n5);
        this.setData(SnvtUtil.getLonData(n2));
    }

    public BNetworkVariable(int n, BLonData bLonData, int n2, int n3, int n4, BLonNvDirection bLonNvDirection) {
        this.this();
        BNvProps bNvProps = this.getNvProps();
        bNvProps.setNvIndex(n);
        bNvProps.setSnvtType(-1);
        bNvProps.setObjectIndex(n2);
        bNvProps.setMemberIndex(n3);
        BNvConfigData bNvConfigData = this.getNvConfigData();
        bNvConfigData.setDirection(bLonNvDirection);
        BNetworkVariable.setFlags(bNvProps, bNvConfigData, n4);
        this.setData(bLonData);
    }

    static {
        Class clazz = class$javax$baja$lonworks$BNetworkVariable;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BNetworkVariable = BNetworkVariable.class("[Ljavax.baja.lonworks.BNetworkVariable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nv.png");
    }
}

