/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.lonworks;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BModifyFlags;
import javax.baja.lonworks.datatypes.BNcProps;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNetworkConfig
extends BLonComponent
implements BINetworkVariable {
    public static final Property ncProps = BNetworkConfig.newProperty((int)0, (BValue)new BNcProps(), null);
    public static final Property nvConfigData = BNetworkConfig.newProperty((int)0, (BValue)new BNvConfigData(), null);
    public static final Topic receivedUpdate = BNetworkConfig.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static /* synthetic */ Class class$javax$baja$lonworks$BNetworkConfig;

    public BNcProps getNcProps() {
        return (BNcProps)this.get(ncProps);
    }

    public void setNcProps(BNcProps bNcProps) {
        this.set(ncProps, (BValue)bNcProps, null);
    }

    public BNvConfigData getNvConfigData() {
        return (BNvConfigData)this.get(nvConfigData);
    }

    public void setNvConfigData(BNvConfigData bNvConfigData) {
        this.set(nvConfigData, (BValue)bNvConfigData, null);
    }

    public void fireReceivedUpdate(BValue bValue) {
        this.fire(receivedUpdate, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean isNetworkConfig() {
        return true;
    }

    public int getNvIndex() {
        return this.getNcProps().getNvIndex();
    }

    public void setNvIndex(int n) {
        this.getNcProps().setNvIndex(n);
    }

    public int getSnvtType() {
        return this.getNcProps().getSnvtType();
    }

    public void setUnbound() {
        this.getNcProps().setUnbound();
        this.getNvConfigData().setUnbound(this.getNvIndex());
    }

    public void receiveUpdate(byte[] byArray) {
        try {
            this.getData().fromNetBytes(byArray);
            this.getData().readOk();
            this.fireReceivedUpdate(null);
        }
        catch (Throwable throwable) {
            this.getData().readFail(throwable.toString());
            this.lonNetwork().log().error("Could not decode nv update data " + this.getParent().getDisplayName(null) + ':' + this.getDisplayName(null), throwable);
        }
    }

    public final void lonComponentStarted() {
        if (this.getNvConfigData().getSelector() == -1) {
            this.getNvConfigData().setUnbound(this.getNcProps().getNvIndex());
        }
    }

    public boolean isForeignPersistent() {
        return true;
    }

    public boolean isWriteable() {
        return this.getNcProps().getModifyFlag().isMfgOnly() ^ true;
    }

    protected void dataChanged(Context context) {
        if (BLonNetwork.lonNoWrite.equals(context)) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        this.forceWrite();
    }

    public void doForceRead() {
        this.lonDevice().checkState();
        if (this.illegalLength) {
            throw new BajaRuntimeException(this.getDisplayName(null) + " data length > maxNvLength of " + Lon.maxNvLength() + " bytes");
        }
        BNcProps bNcProps = this.getNcProps();
        try {
            if (Lon.d()) {
                byte[] byArray = NmUtil.fetchNv(this.lonDevice(), bNcProps.getNvIndex());
                this.getData().fromNetBytes(byArray);
            }
            this.getData().readOk();
        }
        catch (Throwable throwable) {
            this.getData().readFail(throwable.toString());
            String string = "Unable to read " + this.debugName();
            this.lonNetwork().log().error(string, throwable);
            throw new BajaRuntimeException(string + ' ' + throwable.getMessage(), throwable);
        }
    }

    public void doForceWrite() {
        if (!Lon.d()) {
            return;
        }
        BNvConfigData bNvConfigData = this.getNvConfigData();
        if (!bNvConfigData.isInput()) {
            return;
        }
        BNcProps bNcProps = this.getNcProps();
        if (bNcProps.getModifyFlag().isMfgOnly()) {
            throw new BajaRuntimeException("Can not write mfgOnly nci " + this.getDisplayName(null));
        }
        BLonDevice bLonDevice = this.lonDevice();
        bLonDevice.checkState();
        if (this.illegalLength) {
            throw new BajaRuntimeException(this.getDisplayName(null) + " data length > maxNvLength of " + Lon.maxNvLength() + " bytes");
        }
        boolean bl = bLonDevice.isDownLoadInProgress();
        try {
            int[] nArray = null;
            boolean[] blArray = null;
            boolean bl2 = false;
            if (!bl) {
                bLonDevice.beginConfigWrite();
                if (bNcProps.getModifyFlag().isOffline()) {
                    try {
                        NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOffline);
                    }
                    catch (LonException lonException) {
                        System.out.println((Object)lonException);
                    }
                    bl2 = true;
                }
                if (bNcProps.getModifyFlag().isDisabled() && bNcProps.getScope() == BLonConfigScope.object) {
                    nArray = SelfDocUtil.selectToIntArray(bNcProps.getSelect());
                    blArray = new boolean[nArray.length];
                    bLonDevice.disableObjectsForWrite(nArray, blArray);
                }
            }
            NmUtil.setNvValue(this.lonDevice(), bNvConfigData, this.getData().toNetBytes());
            if (!bl) {
                if (bl2) {
                    try {
                        NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOnline);
                    }
                    catch (LonException lonException) {
                        System.out.println((Object)lonException);
                    }
                }
                if (nArray != null) {
                    bLonDevice.enableObjectsAfterWrite(nArray, blArray);
                }
                if (bNcProps.getModifyFlag().isReset()) {
                    bLonDevice.doReset();
                }
                bLonDevice.endConfigWrite();
            }
            this.getData().writeOk();
        }
        catch (Throwable throwable) {
            this.getData().writeFail(throwable.toString());
            String string = "Unable to write " + this.debugName();
            this.lonNetwork().log().error(string, throwable);
            throw new BajaRuntimeException(string + ' ' + throwable.getMessage(), throwable);
        }
    }

    protected void lonComponentSubscribed() {
        BBoolean bBoolean = (BBoolean)this.getPropertyInParent().getFacets().get("deviceSpecific");
        if (bBoolean != null && bBoolean.getBoolean()) {
            this.forceRead();
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BNetworkConfig() {
    }

    public BNetworkConfig(int n, int n2, int n3, BModifyFlags bModifyFlags, BLonConfigScope bLonConfigScope, String string, float[] fArray) {
        this(n, n2, n3, bModifyFlags, bLonConfigScope, string);
        this.initDataElements(fArray);
    }

    public BNetworkConfig(int n, int n2, int n3, BModifyFlags bModifyFlags, BLonConfigScope bLonConfigScope, String string) {
        BNcProps bNcProps = this.getNcProps();
        bNcProps.setNvIndex(n);
        bNcProps.setSnvtType(n2);
        bNcProps.setConfigIndex(n3);
        bNcProps.setModifyFlag(bModifyFlags);
        bNcProps.setScope(bLonConfigScope);
        bNcProps.setSelect(string);
        this.setData(SnvtUtil.getLonData(n2));
    }

    public BNetworkConfig(int n, BLonData bLonData, int n2, BModifyFlags bModifyFlags, BLonConfigScope bLonConfigScope, String string) {
        BNcProps bNcProps = this.getNcProps();
        bNcProps.setNvIndex(n);
        bNcProps.setConfigIndex(n2);
        bNcProps.setModifyFlag(bModifyFlags);
        bNcProps.setScope(bLonConfigScope);
        bNcProps.setSelect(string);
        this.setData(bLonData);
    }

    static {
        Class clazz = class$javax$baja$lonworks$BNetworkConfig;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BNetworkConfig = BNetworkConfig.class("[Ljavax.baja.lonworks.BNetworkConfig;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nci.png");
    }
}

