/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.xml;

import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import com.tridium.lonworks.xml.LonXMLReader;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XCpTypeDef;
import com.tridium.lonworks.xml.XElementQualifier;
import com.tridium.lonworks.xml.XEnumDef;
import com.tridium.lonworks.xml.XIConfig;
import com.tridium.lonworks.xml.XLonData;
import com.tridium.lonworks.xml.XLonDataUtil;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XLonTyped;
import com.tridium.lonworks.xml.XNetVariable;
import com.tridium.lonworks.xml.XNetworkConfig;
import com.tridium.lonworks.xml.XNetworkVariable;
import com.tridium.lonworks.xml.XTypeDef;
import com.tridium.lonworks.xml.XUnion;
import com.tridium.lonworks.xml.XUnionBranch;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BUnionQualifier;
import javax.baja.lonworks.datatypes.BUnionQualifiers;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDataUnion;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XUtil {
    private static BUnit CELSIUS = UnitDatabase.getUnit((String)"celsius");
    private static XLonInterfaceFile st = null;
    static /* synthetic */ Class class$java$lang$String;

    public static BLonData getLonDataNv(XNetVariable xNetVariable, XLonInterfaceFile xLonInterfaceFile) {
        BLonData bLonData = XUtil.getLonDataClass(xNetVariable, xLonInterfaceFile);
        if (bLonData != null) {
            return bLonData;
        }
        int n = XLonDataUtil.snvtTypeFromString(xNetVariable.snvtType);
        if (n > 0) {
            return SnvtUtil.getLonData(n, XLonDataUtil.isDiffQualifier(xNetVariable.snvtType));
        }
        XElementQualifier[] xElementQualifierArray = xNetVariable.getElementQualifiers(xLonInterfaceFile);
        bLonData = XUtil.makeLonData(xElementQualifierArray, xNetVariable.getUnion(), xLonInterfaceFile);
        return bLonData;
    }

    public static BLonData getLonDataNc(XNetworkConfig xNetworkConfig, XLonInterfaceFile xLonInterfaceFile) {
        BLonData bLonData = XUtil.getLonDataNv(xNetworkConfig, xLonInterfaceFile);
        if (bLonData == null) {
            return null;
        }
        byte[] byArray = xNetworkConfig.getInitBytes(xLonInterfaceFile);
        if (byArray != null) {
            bLonData.fromNetBytes(byArray);
        }
        XUtil.addMinMax(xNetworkConfig, bLonData);
        return bLonData;
    }

    public static BLonData getLonDataCp(XConfigProperty xConfigProperty, XLonInterfaceFile xLonInterfaceFile, XLonDevice xLonDevice, BLonConfigScope bLonConfigScope, String string, BLonDevice bLonDevice, int n) {
        Object object;
        BLonData bLonData = XUtil.getLonDataClass(xConfigProperty, xLonInterfaceFile);
        try {
            if (bLonData == null) {
                bLonData = XUtil.getCpLonData(xConfigProperty, bLonConfigScope, string, xLonInterfaceFile, xLonDevice);
            }
        }
        catch (Throwable throwable) {
            bLonDevice.log().warning(bLonDevice.getName() + '.' + xConfigProperty.getName() + ": " + throwable.getMessage());
        }
        if (bLonData == null) {
            object = (Object)BLonElementQualifiers.make(BLonElementType.na, xConfigProperty.length);
            bLonData = new BLonData(BLonByteArray.make(xConfigProperty.length), (BLonElementQualifiers)((Object)object), null);
        }
        if ((object = xConfigProperty.getInitBytes(xLonInterfaceFile)) != null) {
            Object object2 = object;
            if (n > 0 && ((byte[])object).length >= xConfigProperty.length * (n + 1)) {
                object2 = new byte[xConfigProperty.length];
                System.arraycopy(object, xConfigProperty.length * n, object2, 0, xConfigProperty.length);
            }
            bLonData.fromNetBytes((byte[])object2);
        }
        XUtil.addMinMax(xConfigProperty, bLonData);
        return bLonData;
    }

    private static final BLonData getLonDataClass(XLonTyped xLonTyped, XLonInterfaceFile xLonInterfaceFile) {
        String string = xLonTyped.getTypeSpec(xLonInterfaceFile);
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return (BLonData)Sys.getType((String)string).getInstance();
        }
        catch (Throwable throwable) {
            throw new BajaRuntimeException("Unable to create class " + string, throwable);
        }
    }

    public static BLonData makeLonData(XElementQualifier[] xElementQualifierArray, XLonInterfaceFile xLonInterfaceFile) {
        return XUtil.makeLonData(xElementQualifierArray, null, xLonInterfaceFile);
    }

    public static BLonData makeLonData(XElementQualifier[] xElementQualifierArray, XUnion xUnion, XLonInterfaceFile xLonInterfaceFile) {
        XUnionBranch[] xUnionBranchArray;
        boolean bl;
        if (xElementQualifierArray.length == 0) {
            return null;
        }
        boolean bl2 = false;
        if (xUnion != null && XUtil.isValid(xUnion)) {
            bl2 = true;
        }
        BLonData bLonData = (bl = bl2) ? new BLonDataUnion() : new BLonData();
        int n = 0;
        while (n < xElementQualifierArray.length) {
            xUnionBranchArray = xElementQualifierArray[n];
            BFacets bFacets = LonFacetsUtil.makeFacets(XUtil.getQuals((XElementQualifier)xUnionBranchArray), XUtil.getUnits(xUnionBranchArray.getEngUnit()));
            bLonData.add(xUnionBranchArray.getName(), (BValue)XUtil.getLonPrimitive((XElementQualifier)xUnionBranchArray, xLonInterfaceFile), 0, bFacets, null);
            ++n;
        }
        if (bl) {
            BUnionQualifiers bUnionQualifiers = ((BLonDataUnion)bLonData).getUnionQuals();
            bUnionQualifiers.setConditionProp(xUnion.branchElem);
            xUnionBranchArray = xUnion.getUnionBranches();
            int n2 = 0;
            while (n2 < xUnionBranchArray.length) {
                XUnionBranch xUnionBranch = xUnionBranchArray[n2];
                BUnionQualifier bUnionQualifier = new BUnionQualifier();
                bUnionQualifier.setBranch(xUnionBranch.branchName);
                bUnionQualifier.setBranchProps(XUtil.getBranchPropsString(xUnionBranch.branchName, xElementQualifierArray));
                bUnionQualifier.setConditions(xUnionBranch.condition);
                bUnionQualifiers.add(xUnionBranch.branchName, (BValue)bUnionQualifier);
                ++n2;
            }
        }
        return bLonData;
    }

    private static final boolean isValid(XUnion xUnion) {
        if (xUnion.branchElem.indexOf(63) >= 0) {
            return false;
        }
        Vector vector = xUnion.branch;
        int n = 0;
        while (n < vector.size()) {
            XUnionBranch xUnionBranch = (XUnionBranch)vector.elementAt(n);
            if (xUnionBranch.branchName.length() == 0 || xUnionBranch.branchName.indexOf(63) >= 0) {
                return false;
            }
            if (xUnionBranch.condition.length() == 0 || xUnionBranch.condition.indexOf(63) >= 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final String getBranchPropsString(String string, XElementQualifier[] xElementQualifierArray) {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = XUtil.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < xElementQualifierArray.length) {
            String string2 = xElementQualifierArray[n].getUnionBranch();
            if (string2 != null && string2.equals(string)) {
                array.add((Object)xElementQualifierArray[n].getName());
            }
            ++n;
        }
        return LonStringUtil.toString((String[])array.trim());
    }

    private static final BLonElementQualifiers getQuals(XElementQualifier xElementQualifier) {
        try {
            return BLonElementQualifiers.make(BLonElementType.make(xElementQualifier.getElementType()), xElementQualifier.hasMinimum(), xElementQualifier.getMinimum(), xElementQualifier.hasMaximum(), xElementQualifier.getMaximum(), xElementQualifier.getResolution(), xElementQualifier.getOffset(), xElementQualifier.hasByteOffset(), xElementQualifier.getByteOffset(), xElementQualifier.getBitOffset(), xElementQualifier.hasInvalid(), xElementQualifier.getInvalid(), xElementQualifier.getLength());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create element qualifier " + xElementQualifier.name + "\nencodes to:" + xElementQualifier.encodeToString());
        }
    }

    private static final BUnit getUnits(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return BUnit.getUnit((String)string);
        }
        catch (RuntimeException runtimeException) {
            String string2 = "Could not find units " + string + "  " + runtimeException;
            System.out.println(string2);
            return null;
        }
    }

    private static final BLonPrimitive getLonPrimitive(XElementQualifier xElementQualifier, XLonInterfaceFile xLonInterfaceFile) {
        BLonPrimitive bLonPrimitive;
        switch (XElementQualifier.qualTypeFromString(xElementQualifier.getElementType())) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: {
                bLonPrimitive = BLonFloat.DEFAULT;
                break;
            }
            case 16: {
                bLonPrimitive = BLonDouble.DEFAULT;
                break;
            }
            case 5: 
            case 17: 
            case 18: {
                if (xElementQualifier.getResolution() < 1.0f) {
                    bLonPrimitive = BLonDouble.DEFAULT;
                    break;
                }
                bLonPrimitive = BLonLong.DEFAULT;
                break;
            }
            case 19: {
                if (xElementQualifier.getResolution() < 1.0f) {
                    bLonPrimitive = BLonDouble.DEFAULT;
                    break;
                }
                bLonPrimitive = BLonBigInteger.DEFAULT;
                break;
            }
            case 6: 
            case 10: {
                bLonPrimitive = BLonBoolean.FALSE;
                break;
            }
            case 7: 
            case 9: {
                bLonPrimitive = XUtil.getEnum(xElementQualifier.getEnumDef(), xLonInterfaceFile);
                break;
            }
            case 13: {
                bLonPrimitive = BLonString.DEFAULT;
                break;
            }
            default: {
                bLonPrimitive = BLonByteArray.make(xElementQualifier.getLength());
            }
        }
        return bLonPrimitive;
    }

    private static final BLonPrimitive getEnum(String string, XLonInterfaceFile xLonInterfaceFile) {
        XEnumDef xEnumDef = xLonInterfaceFile.resolveEnumDef(string);
        if (xEnumDef == null) {
            throw new RuntimeException("No enumType " + string);
        }
        return xEnumDef.getEnum();
    }

    private static final BLonData getCpLonData(XConfigProperty xConfigProperty, BLonConfigScope bLonConfigScope, String string, XLonInterfaceFile xLonInterfaceFile, XLonDevice xLonDevice) {
        XLonData xLonData;
        XCpTypeDef xCpTypeDef = null;
        if (xConfigProperty.scptType.length() > 0) {
            xCpTypeDef = XUtil.findStandardCpType(xConfigProperty.scptType);
        } else if (xConfigProperty.typeDef.length() > 0) {
            xLonData = xLonInterfaceFile.resolveTypeDef(xConfigProperty.typeDef);
            if (xLonData == null) {
                System.out.println("WARNING:typeDef not found " + xConfigProperty.getName() + ':' + xConfigProperty.typeDef);
                return null;
            }
            if (!(xLonData instanceof XCpTypeDef)) {
                return XUtil.makeLonData(xLonData.getElementQualifiers(xLonInterfaceFile), xLonData.union, xLonInterfaceFile);
            }
            xCpTypeDef = (XCpTypeDef)xLonData;
        } else {
            return null;
        }
        if (xCpTypeDef == null) {
            throw new RuntimeException("Could not find type {" + xConfigProperty.getName() + '}');
        }
        xConfigProperty.setXTypeDef(xCpTypeDef);
        if (!xCpTypeDef.inherited) {
            xLonData = xConfigProperty.scptType.length() > 0 ? XUtil.getStandard() : xLonInterfaceFile;
            return xCpTypeDef.getLonData((XLonInterfaceFile)xLonData);
        }
        int n = -1;
        XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
        if (bLonConfigScope.equals((Object)BLonConfigScope.nv)) {
            n = SelfDocUtil.getFirstIndex(string);
        } else if (bLonConfigScope.equals((Object)BLonConfigScope.object)) {
            n = XUtil.getInheritanceSourceNv(xConfigProperty, xLonDevice, string);
        } else {
            throw new RuntimeException("Scpt inherits data type from nv but scope is " + (Object)((Object)bLonConfigScope) + " {" + xConfigProperty.getName() + '}');
        }
        XNetworkVariable xNetworkVariable = null;
        int n2 = 0;
        while (n2 < xNetworkVariableArray.length) {
            if (xNetworkVariableArray[n2].index <= n && xNetworkVariableArray[n2].index + xNetworkVariableArray[n2].arraySize > n) {
                xNetworkVariable = xNetworkVariableArray[n2];
                break;
            }
            ++n2;
        }
        if (xNetworkVariable == null) {
            throw new RuntimeException("Scpt inherits data type from nv " + n + ".  Unable to find nv. {" + xConfigProperty.getName() + '}');
        }
        BLonData bLonData = XUtil.getLonDataNv(xNetworkVariable, xLonInterfaceFile);
        if (xConfigProperty.scptType.equals("CpSndDelta") || xConfigProperty.scptType.equals("CpOffset")) {
            XUtil.tempToDeltaTemp(bLonData);
        }
        return bLonData;
    }

    public static int getInheritanceSourceNv(XConfigProperty xConfigProperty, XLonDevice xLonDevice, String string) {
        int n = -1;
        XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
        if (xConfigProperty.principalNv.length() <= 0) {
            throw new RuntimeException("Inherited type with object scope but no principalNv {" + xConfigProperty.getName() + '}');
        }
        int n2 = SelfDocUtil.getFirstIndex(string);
        int n3 = Integer.parseInt(xConfigProperty.principalNv.substring(1));
        boolean bl = xConfigProperty.principalNv.startsWith("#");
        int n4 = 0;
        while (n4 < xNetworkVariableArray.length) {
            XNetworkVariable xNetworkVariable = xNetworkVariableArray[n4];
            if (xNetworkVariable != null && xNetworkVariable.objectIndex.length() > 0) {
                int n5 = SelfDocUtil.getFirstIndex(xNetworkVariable.objectIndex);
                int n6 = SelfDocUtil.getLastIndex(xNetworkVariable.objectIndex);
                if (n2 >= n5 && n2 <= n6 && n3 >= xNetworkVariable.memberIndex && n3 < xNetworkVariable.memberIndex + xNetworkVariable.memberArraySize && xNetworkVariable.mfgMember == bl) {
                    n = xNetworkVariable.index;
                    break;
                }
            }
            ++n4;
        }
        if (n == -1) {
            throw new RuntimeException("Can't find object " + n2 + " with member " + xConfigProperty.principalNv + " {" + xConfigProperty.getName() + '}');
        }
        return n;
    }

    private static final void tempToDeltaTemp(BLonData bLonData) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                BUnit bUnit;
                BFacets bFacets = slotCursor.property().getFacets();
                if (bFacets == null || (bUnit = (BUnit)bFacets.get("units")) == null || !bUnit.getDimension().equals((Object)CELSIUS.getDimension())) continue;
                bUnit = BUnit.getUnit((String)(bUnit.getUnitName() + " degrees"));
                bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)bUnit);
                bLonData.setFacets((Slot)slotCursor.property(), bFacets);
                continue;
            }
            if (!type.is(BLonData.TYPE)) continue;
            XUtil.tempToDeltaTemp((BLonData)bObject);
        }
    }

    private static final XCpTypeDef findStandardCpType(String string) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        Vector vector = xLonInterfaceFile.types;
        int n = 0;
        while (n < vector.size()) {
            XTypeDef xTypeDef = (XTypeDef)vector.elementAt(n);
            if (xTypeDef.isCpType() && string.equals(xTypeDef.getName())) {
                return (XCpTypeDef)xTypeDef;
            }
            ++n;
        }
        return null;
    }

    public static XCpTypeDef findCpType(String string) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        Vector vector = xLonInterfaceFile.types;
        int n = 0;
        while (n < vector.size()) {
            XTypeDef xTypeDef = (XTypeDef)vector.elementAt(n);
            if (xTypeDef.isCpType() && string.equals(xTypeDef.getName())) {
                return (XCpTypeDef)xTypeDef;
            }
            ++n;
        }
        return null;
    }

    public static XCpTypeDef findCpType(int n, int n2) {
        XLonInterfaceFile xLonInterfaceFile = XUtil.getStandard();
        Vector vector = xLonInterfaceFile.types;
        String string = Integer.toString(n) + ',' + Integer.toString(n2);
        int n3 = 0;
        while (n3 < vector.size()) {
            XTypeDef xTypeDef = (XTypeDef)vector.elementAt(n3);
            if (xTypeDef.isCpType() && xTypeDef.getTypeScope().equals(string)) {
                return (XCpTypeDef)xTypeDef;
            }
            ++n3;
        }
        return null;
    }

    public static void addMinMax(XIConfig xIConfig, BLonData bLonData) {
        Object object;
        XTypeDef xTypeDef = xIConfig.getXTypeDef();
        if (xTypeDef != null && xTypeDef.isCpType() && ((XCpTypeDef)(object = (XCpTypeDef)xTypeDef)).getMax() == null) {
            ((XCpTypeDef)object).getMin();
        }
        object = null;
        float[] fArray = null;
        if (xIConfig.getMin().length() > 0) {
            object = XUtil.getFloats(xIConfig.getMin());
        }
        if (xIConfig.getMax().length() > 0) {
            fArray = XUtil.getFloats(xIConfig.getMax());
        }
        if (object == null && fArray == null) {
            return;
        }
        XUtil.setFacets(bLonData, (float[])object, fArray, 0);
    }

    private static final int setFacets(BLonData bLonData, float[] fArray, float[] fArray2, int n) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                if (type.is(BLonFloat.TYPE)) {
                    Property property = slotCursor.property();
                    BFacets bFacets = property.getFacets();
                    if (fArray != null) {
                        bFacets = BFacets.make((BFacets)bFacets, (String)"min", (BIDataValue)BFloat.make((float)fArray[n]));
                    }
                    if (fArray2 != null) {
                        bFacets = BFacets.make((BFacets)bFacets, (String)"max", (BIDataValue)BFloat.make((float)fArray2[n]));
                    }
                    bLonData.setFacets((Slot)property, bFacets);
                }
                ++n;
                continue;
            }
            if (!type.is(BLonData.TYPE)) continue;
            n = XUtil.setFacets(bLonData, fArray, fArray2, n);
        }
        return n;
    }

    private static final float[] getFloats(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,|");
        int n = stringTokenizer.countTokens();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.valueOf(stringTokenizer.nextToken()).floatValue();
            ++n2;
        }
        return fArray;
    }

    public static XLonInterfaceFile getStandard() {
        if (st == null) {
            try {
                BOrd bOrd = BOrd.make((String)"module://lonworks/javax/baja/lonworks/standard.lnml");
                st = LonXMLReader.decode(bOrd);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new RuntimeException("Cannot access standard.lnml " + throwable);
            }
        }
        return st;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

