/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.local.BLocalNci;
import com.tridium.lonworks.local.BLocalNv;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.selfdoc.DocToXDevice;
import com.tridium.lonworks.xml.XDeviceData;
import java.io.IOException;
import java.util.Date;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.BLocalExtractXifParameter;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LocalToXif {
    private BLocalLonDevice bdev;
    private StringBuffer out;
    static /* synthetic */ Class class$javax$baja$lonworks$londata$BLonElementQualifiers;

    public static String extractXif(BLocalLonDevice bLocalLonDevice, BLocalExtractXifParameter bLocalExtractXifParameter) throws IOException {
        LocalToXif localToXif = new LocalToXif();
        return localToXif.extract(bLocalLonDevice, bLocalExtractXifParameter);
    }

    private final String extract(BLocalLonDevice bLocalLonDevice, BLocalExtractXifParameter bLocalExtractXifParameter) throws IOException {
        this.bdev = bLocalLonDevice;
        this.out = new StringBuffer();
        this.out.append("File: " + bLocalExtractXifParameter.getFileName() + " generated by Niagra, XIF Version 4.0\n");
        this.out.append("Copyright (c) ").append(BAbsTime.now().getYear()).append(" Tridium \n");
        this.out.append("All Rights Reserved. Run on " + new Date() + '\n');
        this.out.append("\n");
        this.writeHeader();
        this.writeNetworkVariableDefinition();
        return this.out.toString();
    }

    private final void writeHeader() {
        XDeviceData xDeviceData = null;
        try {
            xDeviceData = DocToXDevice.getDeviceData(BLocal.local, this.bdev.lonComm(), this.bdev.authenticate(), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.out.append(LonByteArrayUtil.toString(LonByteArrayUtil.getBytes(xDeviceData.getProgramID()), ':')).append("\n");
        int n = this.bdev.getNetworkVariables().length;
        this.out.append(xDeviceData.domains).append(" ");
        this.out.append(xDeviceData.addressTableEntries).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.handlesIncomingExplicitMessages)).append(" ");
        this.out.append(n).append(" ");
        this.out.append(xDeviceData.numExplicitMessageTags).append(" ");
        this.out.append(xDeviceData.networkInputBuffers).append(" ");
        this.out.append(xDeviceData.networkOutputBuffers).append(" ");
        this.out.append(xDeviceData.priorityNetworkOutputBuffers).append(" ");
        this.out.append(xDeviceData.priorityApplicationOutputBuffers).append(" ");
        this.out.append(xDeviceData.applicationOutputBuffers).append(" ");
        this.out.append(xDeviceData.applicationInputBuffers).append(" ");
        this.out.append(xDeviceData.sizeNetworkInputBuffer).append(" ");
        this.out.append(xDeviceData.sizeNetworkOutputBuffer).append(" ");
        this.out.append(xDeviceData.sizeAppOutputBuffer).append(" ");
        this.out.append(xDeviceData.sizeAppInputBuffer).append(" ");
        this.out.append(this.appTypeToInt("hostSelect")).append(" ");
        this.out.append(xDeviceData.numNetworkVariablesNISelect).append(" ");
        this.out.append(xDeviceData.rcvTransactionBuffers).append(" ");
        this.out.append(xDeviceData.aliasCount).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.bindingII)).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.allowStatRelativeAddressing)).append(" ");
        this.out.append(xDeviceData.maxSizeWrite).append(" ");
        this.out.append(n).append("\n");
        this.out.append(xDeviceData.neuronChipType).append(" ");
        this.out.append(xDeviceData.clockRate).append(" ");
        this.out.append(xDeviceData.firmwareRevision).append(" ");
        this.out.append(xDeviceData.rcvTransactionBlockSize).append(" ");
        this.out.append(xDeviceData.transControlBlockSize).append(" ");
        this.out.append(xDeviceData.neuronFreeRam).append(" ");
        this.out.append(xDeviceData.offChipFreeRam).append(" ");
        this.out.append(xDeviceData.domainTableEntrySize).append(" ");
        this.out.append(xDeviceData.addressTableEntrySize).append(" ");
        this.out.append(xDeviceData.nvConfigTableEntrySize).append(" ");
        this.out.append(xDeviceData.domainToUserSize).append(" ");
        this.out.append(xDeviceData.nvAliasTableEntrySize).append("\n");
        this.out.append(this.booleanToInt(xDeviceData.standardTransceiverTypeUsed)).append(" ");
        this.out.append(xDeviceData.standardTransceiverTypeId).append(" ");
        this.out.append("1 ");
        this.out.append(xDeviceData.transceiverType).append(" ");
        this.out.append(xDeviceData.transceiverInterfaceRate).append(" ");
        this.out.append(xDeviceData.numPrioritySlots).append(" ");
        this.out.append(xDeviceData.minimumClockRate).append(" ");
        this.out.append(xDeviceData.averagePacketSize).append(" ");
        this.out.append(xDeviceData.oscillatorAccuracy).append(" ");
        this.out.append(xDeviceData.oscillatorWakeupTime).append("\n");
        this.out.append(xDeviceData.channelBitRate).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.specialBitRate)).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.specialPreambleControl)).append(" ");
        int n2 = xDeviceData.specialWakeupDirection.equals("output");
        this.out.append(n2).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.overridesGenPurposeData)).append(" ");
        this.out.append(xDeviceData.generalPurposeData1).append(" ");
        this.out.append(xDeviceData.generalPurposeData2).append(" ");
        this.out.append(xDeviceData.generalPurposeData3).append(" ");
        this.out.append(xDeviceData.generalPurposeData4).append(" ");
        this.out.append(xDeviceData.generalPurposeData5).append(" ");
        this.out.append(xDeviceData.generalPurposeData6).append(" ");
        this.out.append(xDeviceData.generalPurposeData7).append("\n");
        this.out.append(xDeviceData.rcvStartDelay).append(" ");
        this.out.append(xDeviceData.rcvEndDelay).append(" ");
        this.out.append(xDeviceData.indeterminateTime).append(" ");
        this.out.append(xDeviceData.minInterpacketTime).append(" ");
        this.out.append(xDeviceData.preambleLength).append(" ");
        this.out.append(xDeviceData.turnaroundTime).append(" ");
        this.out.append(xDeviceData.missedPreambleTime).append(" ");
        this.out.append(xDeviceData.packetQualificationTime).append(" ");
        this.out.append(this.booleanToInt(xDeviceData.rawDataOverrides)).append(" ");
        this.out.append(xDeviceData.rawDataClockRate).append(" ");
        this.out.append(xDeviceData.rawData1).append(" ");
        this.out.append(xDeviceData.rawData2).append(" ");
        this.out.append(xDeviceData.rawData3).append(" ");
        this.out.append(xDeviceData.rawData4).append(" ");
        this.out.append(xDeviceData.rawData5).append("\n");
        this.out.append("*\n");
        String string = this.bdev.getSelfDoc();
        while (string.length() > 60) {
            String string2 = string.substring(0, 60);
            this.out.append("\"" + string2 + '\n');
            string = string.substring(60);
        }
        this.out.append("\"" + string + '\n');
        this.out.append("\n");
    }

    private final void writeNetworkVariableDefinition() {
        BINetworkVariable[] bINetworkVariableArray = this.bdev.getNetworkVariables();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            BStruct bStruct;
            BNvConfigData bNvConfigData;
            BLonComponent bLonComponent;
            if (bINetworkVariableArray[n].isLocalNv()) {
                bLonComponent = (BLocalNv)bINetworkVariableArray[n];
                bNvConfigData = ((BLocalNv)bLonComponent).getNvConfigData();
                bStruct = ((BLocalNv)bLonComponent).getNvProps();
                this.out.append("VAR ").append(bLonComponent.getName()).append(" ");
                this.out.append(((BLocalNv)bLonComponent).getNvIndex()).append(" ");
                this.out.append("0 0 0\n");
                this.out.append("0").append(" ");
                this.out.append("1").append(" ");
                this.out.append("63").append(" ");
                this.out.append(this.booleanToInt(bNvConfigData.isOutput())).append(" ");
                this.out.append(this.srvTypeToInt(bNvConfigData.getServiceType())).append(" ");
                this.out.append(this.booleanToInt(bStruct.getServiceConf())).append(" ");
                this.out.append(this.booleanToInt(bNvConfigData.getAuthenticated())).append(" ");
                this.out.append(this.booleanToInt(bStruct.getAuthConf())).append(" ");
                this.out.append(this.booleanToInt(bNvConfigData.getPriority())).append(" ");
                this.out.append(this.booleanToInt(bStruct.getPriorityConf())).append(" ");
                this.out.append(this.booleanToInt(bStruct.getPolled())).append(" ");
                this.out.append(this.booleanToInt(bStruct.getSync())).append(" ");
                this.out.append("0\n");
                this.appendSelfDoc(((BLocalNv)bLonComponent).getSelfDoc());
                this.addNvSchema(((BLocalNv)bLonComponent).getSnvtType(), bLonComponent);
            } else if (bINetworkVariableArray[n].isLocalNci()) {
                bLonComponent = (BLocalNci)bINetworkVariableArray[n];
                bNvConfigData = ((BLocalNci)bLonComponent).getNvConfigData();
                bStruct = ((BLocalNci)bLonComponent).getNcProps();
                this.out.append("VAR ").append(bLonComponent.getName()).append(" ");
                this.out.append(((BLocalNci)bLonComponent).getNvIndex()).append(" ");
                this.out.append("0 0 0\n");
                this.out.append(this.booleanToInt(bStruct.getModifyFlag().isOffline())).append(" ");
                this.out.append("1 ");
                this.out.append("63 ");
                this.out.append(this.booleanToInt(bNvConfigData.isOutput())).append(" ");
                this.out.append(this.srvTypeToInt(bNvConfigData.getServiceType())).append(" ");
                this.out.append("1 ");
                this.out.append(this.booleanToInt(bNvConfigData.getAuthenticated())).append(" ");
                this.out.append("1 ");
                this.out.append(this.booleanToInt(bNvConfigData.getPriority())).append(" ");
                this.out.append("1 ");
                this.out.append("0 ");
                this.out.append("0 ");
                this.out.append("1\n");
                this.appendSelfDoc(((BLocalNci)bLonComponent).getSelfDoc());
                this.addNvSchema(((BLocalNci)bLonComponent).getSnvtType(), bLonComponent);
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void appendSelfDoc(String var1_1) {
        block1: {
            if (var1_1.length() != 0 && !var1_1.equals("*")) ** GOTO lbl8
            this.out.append("*\n");
            break block1;
lbl-1000:
            // 1 sources

            {
                this.out.append("\"" + var1_1.substring(0, 60) + '\n');
                var1_1 = var1_1.substring(60);
lbl8:
                // 2 sources

                ** while (var1_1.length() > 60)
            }
lbl9:
            // 1 sources

            this.out.append("\"" + var1_1 + '\n');
        }
    }

    private final void addNvSchema(int n, BLonData bLonData) {
        BLonElementQualifiers[] bLonElementQualifiersArray = this.getElementQualifiers(bLonData);
        this.out.append(n).append(" * ");
        int n2 = this.out.length();
        int n3 = bLonElementQualifiersArray.length;
        this.out.append("\n");
        int n4 = 0;
        while (n4 < bLonElementQualifiersArray.length) {
            BLonElementQualifiers bLonElementQualifiers = bLonElementQualifiersArray[n4];
            BLonElementType bLonElementType = bLonElementQualifiers.getElemtype();
            switch (bLonElementType.getOrdinal()) {
                case 5: {
                    this.out.append("1 0 0 1 4\n");
                    break;
                }
                case 16: {
                    this.out.append("1 0 0 0 4\n");
                    break;
                }
                case 8: {
                    this.out.append("3 0 1 0 0\n");
                    this.out.append("3 1 7 0 0\n");
                    this.out.append("3 0 1 0 0\n");
                    this.out.append("3 1 7 0 0\n");
                    this.out.append("2 0 0 0 0\n");
                    n3 += 4;
                    break;
                }
                default: {
                    int n5 = this.typeToInt(bLonElementType);
                    boolean bl = false;
                    if (n5 == 3) {
                        bl = true;
                    }
                    boolean bl2 = bl;
                    boolean bl3 = false;
                    if (n5 == 0 || n5 == 1) {
                        bl3 = true;
                    }
                    boolean bl4 = bl3;
                    this.out.append(n5).append(" ");
                    int n6 = 0;
                    if (bl2) {
                        n6 = Math.abs(bLonElementQualifiers.getBitOffset() + bLonElementQualifiers.getLength() - 8);
                    }
                    this.out.append(n6).append(" ");
                    int n7 = 0;
                    if (bl2) {
                        n7 = bLonElementQualifiers.getLength();
                    }
                    this.out.append(n7).append(" ");
                    this.out.append(this.signed(bLonElementType)).append(" ");
                    int n8 = 0;
                    if (bl4) {
                        n8 = bLonElementQualifiers.getLength();
                    }
                    this.out.append(n8).append("\n");
                }
            }
            ++n4;
        }
        this.out.insert(n2, n3);
    }

    private final BLonElementQualifiers[] getElementQualifiers(BLonData bLonData) {
        Class clazz = class$javax$baja$lonworks$londata$BLonElementQualifiers;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$londata$BLonElementQualifiers = LocalToXif.class("[Ljavax.baja.lonworks.londata.BLonElementQualifiers;", false);
        }
        Array array = new Array(clazz);
        try {
            this.getElementQualifiers(bLonData, array);
        }
        catch (LonException lonException) {
            throw new BajaRuntimeException((Throwable)((Object)lonException));
        }
        return (BLonElementQualifiers[])array.trim();
    }

    private final void getElementQualifiers(BLonData bLonData, Array array) throws LonException {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            Type type = bObject.getType();
            if (type.is(BLonPrimitive.TYPE)) {
                array.add((Object)LonFacetsUtil.getElementQualifiers(bLonData, slotCursor.property()));
                continue;
            }
            if (!type.is(BLonData.TYPE)) continue;
            this.getElementQualifiers((BLonData)bObject, array);
        }
    }

    private final int typeToInt(BLonElementType bLonElementType) {
        switch (bLonElementType.getOrdinal()) {
            case 0: 
            case 14: {
                return 0;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 3;
            }
        }
        return 5;
    }

    private final int signed(BLonElementType bLonElementType) {
        switch (bLonElementType.getOrdinal()) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                return 0;
            }
        }
        return 1;
    }

    private final int booleanToInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    private final int appTypeToInt(String string) {
        if (string.equals("mip")) {
            return 1;
        }
        if (string.equals("neuron")) {
            return 2;
        }
        if (string.equals("hostSelect")) {
            return 3;
        }
        if (string.equals("hostNISelect")) {
            return 4;
        }
        return 0;
    }

    private final int srvTypeToInt(BLonServiceType bLonServiceType) {
        if (bLonServiceType == BLonServiceType.acked) {
            return 0;
        }
        if (bLonServiceType == BLonServiceType.unackedRpt) {
            return 1;
        }
        if (bLonServiceType == BLonServiceType.unacked) {
            return 2;
        }
        return 2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

