/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.xif;

import com.tridium.lonworks.resource.CpType;
import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateRecord;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.util.selfdoc.SelfDocUtil;
import com.tridium.lonworks.util.xif.XifLineReader;
import com.tridium.lonworks.xml.XConfigProperty;
import com.tridium.lonworks.xml.XLonDataUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.lonworks.enums.BLonConfigScope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConfigFileParser {
    private NodeSelfDoc nodeSelfDoc;
    private XifLineReader reader;
    private PrintStream out;
    private CrossReference crossRef;

    public Vector parse() {
        Vector<XConfigProperty> vector = new Vector<XConfigProperty>();
        try {
            String string;
            int n = 0;
            while ((string = this.readRecord()).length() != 0) {
                String string2 = string.substring(string.indexOf(";") + 1);
                if ((string = string.substring(0, string.indexOf(";"))).equals("")) break;
                vector.addElement(this.parseConfig(string, string2, n++));
            }
            DuplicateNamesUtil.eliminateDuplicateNames(vector);
        }
        catch (IOException iOException) {}
        return vector;
    }

    private final String readRecord() throws IOException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl) {
            String string = this.reader.readXifLine(false);
            if (string.length() == 0) {
                return "";
            }
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.indexOf(";") >= 0) {
                bl = true;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private final XConfigProperty parseConfig(String string, String string2, int n) {
        Object object;
        ConfigTemplateRecord configTemplateRecord = new ConfigTemplateRecord(string);
        XConfigProperty xConfigProperty = new XConfigProperty();
        xConfigProperty.scope = XLonDataUtil.scopeToString(configTemplateRecord.getHdr());
        xConfigProperty.select = configTemplateRecord.getSelect();
        xConfigProperty.modifyFlag = XLonDataUtil.flagToString(configTemplateRecord.getFlags());
        xConfigProperty.length = configTemplateRecord.getLength();
        xConfigProperty.dimension = configTemplateRecord.getDimension();
        if (configTemplateRecord.hasMin()) {
            xConfigProperty.min = configTemplateRecord.getMin();
        }
        if (configTemplateRecord.hasMax()) {
            xConfigProperty.max = configTemplateRecord.getMax();
        }
        if (this.crossRef != null) {
            try {
                object = this.crossRef.findCpType(configTemplateRecord.getTypeScope(), configTemplateRecord.getConfigIndex());
                if (((CpType)object).inherited && xConfigProperty.scope.equals(BLonConfigScope.object.getTag())) {
                    int n2 = this.nodeSelfDoc.getObjectType(SelfDocUtil.getFirstIndex(xConfigProperty.select));
                    xConfigProperty.principalNv = this.crossRef.getPrincipalNv(n2);
                }
                if (configTemplateRecord.getTypeScope() == 0) {
                    xConfigProperty.scptType = "Cp" + NameUtil.toJavaName(((CpType)object).node.name, true);
                } else {
                    xConfigProperty.setTypeDef("Cp" + NameUtil.toJavaName(((CpType)object).node.name, true));
                    this.crossRef.mark(((CpType)object).scope);
                }
            }
            catch (Throwable throwable) {
                this.warning(throwable);
            }
        }
        if (((String)(object = this.getCpName(xConfigProperty, configTemplateRecord, string2))).length() == 0) {
            object = "config" + n;
        } else if (((String)object).startsWith("nci")) {
            object = ((String)object).substring(3);
        } else if (((String)object).startsWith("Cp")) {
            object = ((String)object).substring(2);
        }
        object = NameUtil.toJavaName((String)object, false);
        xConfigProperty.setName((String)object);
        return xConfigProperty;
    }

    private final String getCpName(XConfigProperty xConfigProperty, ConfigTemplateRecord configTemplateRecord, String string) {
        int n = string.indexOf("n=\"");
        if (n >= 0) {
            return string.substring(n + 3, string.indexOf("\"", n + 4));
        }
        try {
            int n2;
            if (this.crossRef != null && xConfigProperty.scope.equals("object") && (n2 = this.getObjectType(xConfigProperty.select)) >= 0) {
                try {
                    return this.crossRef.getCpName(n2, configTemplateRecord.getTypeScope(), configTemplateRecord.getConfigIndex());
                }
                catch (Throwable throwable) {}
            }
            return xConfigProperty.scptType.length() > 0 ? xConfigProperty.scptType : xConfigProperty.getTypeDef();
        }
        catch (Throwable throwable) {
            this.warning(throwable);
            return "";
        }
    }

    private final int getObjectType(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",-~.");
            int n = Integer.decode(stringTokenizer.nextToken());
            return this.nodeSelfDoc.getObject(n).getType();
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private final void warning(Throwable throwable) {
        String string = throwable.getMessage();
        String string2 = throwable instanceof RuntimeException ? "" : throwable.getClass().getName();
        this.out.println("WARNING:" + string2 + ' ' + (string != null ? string : ""));
    }

    private final /* synthetic */ void this() {
        this.nodeSelfDoc = null;
    }

    public ConfigFileParser(XifLineReader xifLineReader, PrintStream printStream, CrossReference crossReference, String string) {
        this.this();
        this.reader = xifLineReader;
        this.out = printStream;
        this.crossRef = crossReference;
        this.nodeSelfDoc = new NodeSelfDoc(string);
    }

    static class DuplicateNamesUtil {
        private static final void bucketize(Hashtable hashtable, Iterator iterator) {
            while (iterator.hasNext()) {
                XConfigProperty xConfigProperty = (XConfigProperty)iterator.next();
                String string = xConfigProperty.getName();
                Vector<XConfigProperty> vector = (Vector<XConfigProperty>)hashtable.get(string);
                if (vector == null) {
                    vector = new Vector<XConfigProperty>();
                    hashtable.put(string, vector);
                }
                vector.addElement(xConfigProperty);
            }
        }

        private static final Hashtable bucketize(Vector vector) {
            Hashtable hashtable = new Hashtable(vector.size());
            DuplicateNamesUtil.bucketize(hashtable, vector.iterator());
            return hashtable;
        }

        private static final void examineBucket(Vector vector) {
            if (vector.size() > 1) {
                DuplicateNamesUtil.addNameSuffixes(vector.elements());
            }
        }

        private static final void addNameSuffixes(Enumeration enumeration) {
            int n = 1;
            while (enumeration.hasMoreElements()) {
                XConfigProperty xConfigProperty = (XConfigProperty)enumeration.nextElement();
                xConfigProperty.setName(xConfigProperty.getName() + n);
                ++n;
            }
        }

        static void eliminateDuplicateNames(Vector vector) {
            Enumeration enumeration = DuplicateNamesUtil.bucketize(vector).elements();
            while (enumeration.hasMoreElements()) {
                DuplicateNamesUtil.examineBucket((Vector)enumeration.nextElement());
            }
        }

        DuplicateNamesUtil() {
        }
    }
}

