/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.selfdoc.InstallUtil;
import com.tridium.lonworks.util.selfdoc.NodeSelfDoc;
import com.tridium.lonworks.util.selfdoc.NvDoc;
import com.tridium.lonworks.util.selfdoc.SnvtStruct;
import java.util.Vector;
import javax.baja.log.Log;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.io.LonInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelfDoc
implements NetMessages {
    public static final int MAX_DATA_SIZE = 11;
    private LonComm lonComm;
    private SnvtStruct hdr;
    public int snvtPtr;
    private LonAddress sendAddr;
    private boolean auth;
    private boolean countsOnly;
    public byte[] doc;
    public String nodeDocString;
    public NodeSelfDoc nodeDoc;
    public NvDoc[] nvs;
    public int hdrLength;
    public int docLength;
    private boolean bindingII;
    private boolean queryStats;
    private int aliasCnt;
    private boolean extended;

    private final void processSelfDocV2() throws LonException {
        this.bindingII = this.hdr.bindingII;
        this.queryStats = this.hdr.queryStats;
        this.aliasCnt = this.hdr.aliasCount;
        if (this.countsOnly) {
            return;
        }
        this.nodeDocString = InstallUtil.getNodeInfo(this.lonComm, this.sendAddr, this.auth);
        this.log().trace("\nnode self documentation string =>" + this.nodeDocString);
        try {
            this.nodeDoc = new NodeSelfDoc(this.nodeDocString);
        }
        catch (Throwable throwable) {
            this.nodeDoc = null;
        }
        int n = this.hdr.currentNvCount;
        Vector<NvDoc> vector = new Vector<NvDoc>(n);
        int n2 = 0;
        int n3 = this.hdr.maxNvInUse;
        while (n2 <= n3) {
            try {
                NvDoc nvDoc = NvDoc.makeNvDocVersion2(this.lonComm, this.sendAddr, n2, this.auth, this.extended);
                n2 += nvDoc.getArraySize();
                vector.addElement(nvDoc);
            }
            catch (FailedResponseException failedResponseException) {
                ++n2;
            }
            catch (LonException lonException) {
                lonException.printStackTrace();
                throw lonException;
            }
        }
        this.nvs = new NvDoc[vector.size()];
        vector.copyInto(this.nvs);
    }

    private final void processSelfDocV01() throws LonException {
        this.hdrLength = this.hdr.hdrLength;
        this.docLength = this.hdr.docLength;
        int n = this.hdr.numNvsDocs;
        if (this.docLength <= this.hdrLength) {
            return;
        }
        this.doc = this.getData(this.lonComm, this.sendAddr, this.hdrLength, this.docLength - this.hdrLength, this.auth);
        this.log().trace("self documentation length = " + this.doc.length + ' ' + LonByteArrayUtil.toString(this.doc));
        LonInputStream lonInputStream = new LonInputStream(this.doc);
        LonInputStream lonInputStream2 = new LonInputStream(this.doc);
        lonInputStream2.skip(n * 2);
        this.nodeDocString = lonInputStream2.readString();
        this.log().trace("node self documentation string =>" + this.nodeDocString);
        this.nodeDoc = new NodeSelfDoc(this.nodeDocString);
        this.nvs = new NvDoc[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            BNvConfigData bNvConfigData = NmUtil.queryNvConfigData(this.lonComm, this.sendAddr, n2, this.auth, this.extended);
            this.nvs[n3] = NvDoc.makeNvDocVersion01(lonInputStream, lonInputStream2, bNvConfigData, n2, this.extended);
            if (!this.countsOnly && this.nvs[n3].getSnvtType() == 0) {
                this.nvs[n3].setNvLength(NmUtil.getNvLength(this.lonComm, this.sendAddr, n2, this.auth));
            }
            n2 += this.nvs[n3].getArraySize();
            ++n3;
        }
        if (lonInputStream2.available() <= 0) {
            return;
        }
        n3 = lonInputStream2.read();
        if (n3 >= 0) {
            boolean bl = false;
            if ((n3 & 0x80) > 0) {
                bl = true;
            }
            this.bindingII = bl;
            boolean bl2 = false;
            if ((n3 & 0x40) > 0) {
                bl2 = true;
            }
            this.queryStats = bl2;
            this.aliasCnt = n3 & 0x3F;
            if (this.aliasCnt == 63) {
                this.aliasCnt = lonInputStream2.available() >= 2 ? lonInputStream2.readUnsigned16() : 0;
            }
        }
    }

    private final byte[] getData(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl) throws LonException {
        byte[] byArray = this.snvtPtr == (char)-1 ? Neuron.querySnvt(lonComm, lonAddress, n, n2, bl, 11) : Neuron.readMemory(lonComm, 0, lonAddress, this.snvtPtr + n, n2, bl, false, 11);
        return byArray;
    }

    public NvDoc[] getNvDocs() {
        return this.nvs;
    }

    public NodeSelfDoc getNodeDoc() {
        return this.nodeDoc;
    }

    public int getMaxNvIndex() {
        if (this.nvs == null || this.nvs.length == 0) {
            return 0;
        }
        NvDoc nvDoc = this.nvs[this.nvs.length - 1];
        return nvDoc.getNvIndex() + nvDoc.getArraySize() - 1;
    }

    public int getAliasOffset() {
        if (this.getVersion() < 2) {
            return this.getMaxNvIndex() + 1;
        }
        return this.hdr.maxMumNvs;
    }

    public boolean hasNvs() {
        boolean bl = false;
        if (this.nvs != null && this.nvs.length > 0) {
            bl = true;
        }
        return bl;
    }

    public int getVersion() {
        return this.hdr.version;
    }

    public int getMsgtagCount() {
        return this.hdr.mtagCount;
    }

    public boolean getBindingII() {
        return this.bindingII;
    }

    public boolean getQueryStats() {
        return this.queryStats;
    }

    public int getAliasCnt() {
        return this.aliasCnt;
    }

    public SnvtStruct getSnvtStruct() {
        return this.hdr;
    }

    private final Log log() {
        return this.lonComm.lonNetwork().log();
    }

    private final /* synthetic */ void this() {
        this.hdr = null;
        this.nodeDocString = null;
        this.nodeDoc = null;
        this.nvs = null;
        this.bindingII = false;
        this.queryStats = false;
        this.aliasCnt = 0;
        this.extended = false;
    }

    public SelfDoc(BLonDevice bLonDevice) throws LonException {
        this(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.authenticate(), false, bLonDevice.isExtended());
    }

    public SelfDoc(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        this(lonComm, lonAddress, bl, false, bl2);
    }

    public SelfDoc(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2, boolean bl3) throws LonException {
        this.this();
        this.lonComm = lonComm;
        this.sendAddr = lonAddress;
        this.auth = bl;
        this.countsOnly = bl2;
        this.extended = bl3;
        this.hdr = new SnvtStruct(lonComm, this.sendAddr, this.auth);
        if (!this.hdr.hasSelfDoc) {
            return;
        }
        this.snvtPtr = this.hdr.snvtPtr;
        switch (this.hdr.version) {
            case 0: 
            case 1: {
                this.processSelfDocV01();
                break;
            }
            case 2: {
                this.processSelfDocV2();
                break;
            }
        }
    }
}

