/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util.selfdoc;

import com.tridium.lonworks.util.NameUtil;
import com.tridium.lonworks.util.selfdoc.LonMarkObjectUtil;
import com.tridium.lonworks.util.selfdoc.MakeUniqueSupercatName;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NodeSelfDoc {
    private boolean debug;
    public String selfDocString;
    public int minorVersion;
    public LonMarkObj[] objects;
    public String description;
    public SuperCat[] cats;
    private boolean valid;
    private boolean compressSuperCats;

    public void compressSuperCats() {
        this.compressSuperCats = true;
    }

    public LonMarkObj[] getObjects() {
        return this.objects;
    }

    public LonMarkObj getObject(int n) {
        if (this.objects == null || n >= this.objects.length) {
            return null;
        }
        return this.objects[n];
    }

    public int getObjectType(int n) {
        if (this.objects == null || n >= this.objects.length) {
            return -1;
        }
        return this.objects[n].getType();
    }

    public boolean hasLonObjects() {
        return this.objects != null;
    }

    public SuperCat[] getSuperCats() {
        if (!this.hasLonObjects()) {
            return null;
        }
        if (this.cats == null) {
            this.assignSuperCat();
        }
        return this.cats;
    }

    public boolean hasNodeObject() {
        if (this.objects != null) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] != null && this.objects[n].getType() == 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public int getNodeObjectIndex() {
        if (this.objects != null) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] != null && this.objects[n].getType() == 0) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int getSuperCat(int n) {
        if (!this.hasLonObjects()) {
            return -1;
        }
        if (this.cats == null) {
            this.assignSuperCat();
        }
        if (n < 0 || n >= this.objects.length) {
            return -1;
        }
        return this.objects[n].catIndex;
    }

    public String[] getSuperCatNames() {
        if (!this.hasLonObjects()) {
            return null;
        }
        if (this.cats == null) {
            this.assignSuperCat();
        }
        String[] stringArray = new String[this.cats.length];
        int n = 0;
        while (n < this.cats.length) {
            SuperCat superCat = this.cats[n];
            if (superCat.getName() != null && this.makeLegal(superCat.getName()).length() > 0) {
                stringArray[n] = NameUtil.toJavaName(this.makeLegal(superCat.getName()), true);
            } else {
                String string = LonMarkObjectUtil.getObjectName(superCat.getType());
                int n2 = superCat.getTypeCount();
                if (n2 != 0) {
                    string = string + n2;
                }
                superCat.setName(string);
                stringArray[n] = string;
            }
            ++n;
        }
        MakeUniqueSupercatName makeUniqueSupercatName = new MakeUniqueSupercatName();
        int n3 = 0;
        while (n3 < this.cats.length) {
            stringArray[n3] = makeUniqueSupercatName.getUniqueScatName(stringArray[n3]);
            ++n3;
        }
        return stringArray;
    }

    public boolean isValid() {
        return this.valid;
    }

    private final String makeLegal(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (n2 == 0 && Character.isJavaIdentifierStart(c) || n2 > 0 && Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private final void assignSuperCat() {
        int n = this.objects.length;
        IntHashMap intHashMap = new IntHashMap(n);
        Vector<SuperCat> vector = new Vector<SuperCat>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            SuperCat superCat;
            LonMarkObj lonMarkObj = this.objects[n3];
            int n4 = lonMarkObj.type;
            if (!this.compressSuperCats || (superCat = (SuperCat)intHashMap.get(n4)) == null) {
                SuperCat superCat2;
                int n5 = 0;
                if (!this.compressSuperCats && (superCat2 = (SuperCat)intHashMap.get(n4)) != null) {
                    n5 = superCat2.typeCount + 1;
                }
                superCat = new SuperCat(n4, n2++, n5);
                superCat.name = lonMarkObj.name;
                intHashMap.put(n4, (Object)superCat);
                vector.addElement(superCat);
            }
            lonMarkObj.catIndex = superCat.index;
            lonMarkObj.catMember = superCat.count++;
            ++n3;
        }
        this.cats = new SuperCat[vector.size()];
        vector.copyInto(this.cats);
    }

    private final void parseNodeSelfDocumentation(String string) {
        if (this.debug) {
            System.out.println("\nParsing self doc =>" + string);
        }
        int n = string.indexOf(64);
        this.minorVersion = Integer.parseInt(string.substring(string.indexOf(46) + 1, n));
        String string2 = string.substring(n + 1, string.length());
        int n2 = string2.indexOf(59);
        if (n2 != -1) {
            this.description = string2.substring(n2);
            string2 = string2.substring(0, n2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        Vector<LonMarkObj> vector = new Vector<LonMarkObj>();
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            int n4 = 0;
            LonMarkObj lonMarkObj = new LonMarkObj();
            String string3 = stringTokenizer.nextToken().trim();
            lonMarkObj.type = this.getInteger(string3);
            if ((string3 = this.removeInteger(string3)).length() > 0 && string3.startsWith("[")) {
                string3 = string3.substring(1);
                n4 = this.getInteger(string3);
                if ((string3 = this.removeInteger(string3)).startsWith("]")) {
                    String string4 = string3 = string3.length() > 1 ? string3.substring(1) : "";
                }
            }
            if (this.debug) {
                System.out.println("token=" + string3);
            }
            String string5 = null;
            if (string3.length() > 0) {
                if (n4 > 1) {
                    string5 = string3;
                    lonMarkObj.name = string3 + '1';
                } else {
                    lonMarkObj.name = string3;
                }
            } else {
                lonMarkObj.name = null;
            }
            if (this.debug) {
                System.out.println("\ntype " + lonMarkObj.type + " arrayCount = " + n4 + " name = " + lonMarkObj.name + " objectIndex = " + n3);
            }
            lonMarkObj.index = n3++;
            vector.addElement(lonMarkObj);
            while (n4 > 1) {
                LonMarkObj lonMarkObj2 = new LonMarkObj();
                lonMarkObj2.type = lonMarkObj.type;
                if (string5 != null) {
                    lonMarkObj2.name = string5 + (n3 - lonMarkObj.index + 1);
                }
                if (this.debug) {
                    System.out.println("\ntype " + lonMarkObj2.type + " arrayCount = " + n4 + " name = " + lonMarkObj2.name + " objectIndex = " + n3 + " groupPrefix=");
                }
                lonMarkObj2.index = n3++;
                vector.addElement(lonMarkObj2);
                --n4;
            }
        }
        this.objects = new LonMarkObj[vector.size()];
        vector.copyInto(this.objects);
        this.valid = true;
    }

    private final int getInteger(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) break;
            ++n;
        }
        return Integer.parseInt(string.substring(0, n));
    }

    private final String removeInteger(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isDigit(string.charAt(n))) break;
            ++n;
        }
        string = string.length() > n ? string.substring(n) : "";
        return string;
    }

    private final /* synthetic */ void this() {
        this.minorVersion = 0;
        this.objects = null;
        this.cats = null;
        this.valid = false;
        this.compressSuperCats = false;
    }

    public NodeSelfDoc(String string) {
        this(string, false);
    }

    public NodeSelfDoc(String string, boolean bl) {
        this.this();
        this.debug = bl;
        this.selfDocString = string;
        if (string.length() == 0) {
            return;
        }
        if (string.indexOf(64) < 1) {
            return;
        }
        if (string.startsWith("&")) {
            string = string.substring(1);
        }
        try {
            this.parseNodeSelfDocumentation(string);
        }
        catch (Throwable throwable) {
            System.out.println("Unable to parse node self doc \"" + string + "\":" + throwable);
        }
    }

    public static class LonMarkObj {
        public int type;
        public String name;
        public int index;
        public int catIndex;
        public int catMember;

        public int getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCatIndex() {
            return this.catIndex;
        }

        public int getCatMember() {
            return this.catMember;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String toString() {
            return "type; " + this.type + " index: " + this.index + " name: " + this.name;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class SuperCat {
        public String name;
        public int type;
        public int count;
        public int index;
        public int typeCount;

        public int getType() {
            return this.type;
        }

        public int getTypeCount() {
            return this.typeCount;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        private final /* synthetic */ void this() {
            this.count = 0;
        }

        public SuperCat(int n, int n2, int n3) {
            this.this();
            this.type = n;
            this.index = n2;
            this.typeCount = n3;
        }
    }
}

