/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.resource.CrossReference;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.ResourceFileUtil;
import com.tridium.lonworks.resource.ResourceToXLon;
import com.tridium.lonworks.resource.TypeFile;
import com.tridium.lonworks.util.xif.XifToXDevice;
import com.tridium.lonworks.xml.DevToXLon;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import java.io.IOException;
import java.io.PrintStream;
import javax.baja.file.BIFile;
import javax.baja.lonworks.BLonDevice;

public class XLonUtil {
    public static XLonDevice xifToXDevice(BIFile bIFile) throws IOException {
        return XifToXDevice.convert(bIFile, null);
    }

    public static XLonDevice xifToXDevice(String string, CrossReference crossReference) throws IOException {
        return XifToXDevice.convert(string, crossReference);
    }

    public static XLonInterfaceFile resourceToXLonFile(ResourceFile resourceFile, CrossReference crossReference, PrintStream printStream) throws IOException {
        ResourceToXLon resourceToXLon = new ResourceToXLon(crossReference, true, printStream);
        XLonInterfaceFile xLonInterfaceFile = resourceToXLon.convert((TypeFile)resourceFile, crossReference.getConversion(resourceFile.fileName));
        return xLonInterfaceFile;
    }

    public static XLonInterfaceFile resourceToXLonFile(String string, CrossReference crossReference) throws IOException {
        return XLonUtil.resourceToXLonFile(string, crossReference, System.out);
    }

    private static final XLonInterfaceFile resourceToXLonFile(String string, CrossReference crossReference, PrintStream printStream) throws IOException {
        ResourceFile resourceFile = ResourceFileUtil.getResourceFile(string);
        ResourceToXLon resourceToXLon = new ResourceToXLon(crossReference, true, printStream);
        XLonInterfaceFile xLonInterfaceFile = resourceToXLon.convert((TypeFile)resourceFile, crossReference.getConversion(string));
        return xLonInterfaceFile;
    }

    public static XLonInterfaceFile deviceToXLonFile(BLonDevice bLonDevice) throws Exception {
        return XLonUtil.deviceToXLonFile(bLonDevice, bLonDevice.getDisplayName(null));
    }

    public static XLonInterfaceFile deviceToXLonFile(BLonDevice bLonDevice, String string) throws Exception {
        XLonInterfaceFile xLonInterfaceFile = DevToXLon.devToXLon(bLonDevice);
        xLonInterfaceFile.getLonDevice().setName(string);
        xLonInterfaceFile.setName(string);
        return xLonInterfaceFile;
    }
}

