/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.lonworks.xml.XLonInterfaceFile;
import com.tridium.lonworks.xml.XNetworkVariable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BIFile;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.io.LonOutputStream;

public class NxeUtil {
    private static final int INTEL_LEAD_CHAR = 58;
    private static final int SRECORD_LEAD_CHAR = 83;

    public static byte[] nxeFileToByteArray(BIFile bIFile) throws IOException {
        InputStream inputStream = bIFile.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        switch (inputStream.read()) {
            case 58: {
                NxeUtil.sendIntelHexFile(inputStream, byteArrayOutputStream);
                break;
            }
            case 83: {
                NxeUtil.sendSRecordFile(inputStream, byteArrayOutputStream);
                break;
            }
            default: {
                throw new IOException("Unknown file record format.");
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static final void sendIntelHexFile(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        while (inputStream.available() > 0) {
            int n;
            int n2 = NxeUtil.getByte(inputStream);
            if (n2 > 0) {
                byteArrayOutputStream.write(n2);
            }
            if (n2 > 0) {
                byteArrayOutputStream.write(NxeUtil.getByte(inputStream));
                byteArrayOutputStream.write(NxeUtil.getByte(inputStream));
            } else {
                NxeUtil.getByte(inputStream);
                NxeUtil.getByte(inputStream);
            }
            if (NxeUtil.getByte(inputStream) == 1) {
                byteArrayOutputStream.write(0);
                return;
            }
            int n3 = 0;
            while (n3 < n2) {
                byteArrayOutputStream.write(NxeUtil.getByte(inputStream));
                ++n3;
            }
            while (inputStream.available() > 0 && (n = inputStream.read()) != 58) {
            }
        }
    }

    private static final void sendSRecordFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        while (inputStream.available() > 0) {
            int n;
            if (inputStream.read() == 57) {
                outputStream.write(0);
                return;
            }
            int n2 = NxeUtil.getByte(inputStream) - 3;
            if (n2 > 0) {
                outputStream.write(n2);
            }
            if (n2 > 0) {
                outputStream.write(NxeUtil.getByte(inputStream));
                outputStream.write(NxeUtil.getByte(inputStream));
            } else {
                NxeUtil.getByte(inputStream);
                NxeUtil.getByte(inputStream);
            }
            int n3 = 0;
            while (n3 < n2) {
                n = NxeUtil.getByte(inputStream);
                outputStream.write(n);
                ++n3;
            }
            while (inputStream.available() > 0 && (n = inputStream.read()) != 83) {
            }
        }
    }

    private static final byte getByte(InputStream inputStream) throws IOException {
        int n = (Character.digit((char)inputStream.read(), 16) << 4) + Character.digit((char)inputStream.read(), 16);
        return (byte)n;
    }

    public static BProgramId findProgramId(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = ((byArray[n + 1] & 0xFF) << 8) + (byArray[n + 2] & 0xFF);
            if (n2 == 61453) {
                byte[] byArray2 = new byte[8];
                System.arraycopy(byArray, n + 3, byArray2, 0, byArray2.length);
                return BProgramId.make(byArray2);
            }
            n += byArray[n] + 3;
        }
        return null;
    }

    public static byte[] getNvDirectionByteArray(XLonDevice xLonDevice) throws IOException {
        LonOutputStream lonOutputStream = new LonOutputStream();
        XNetworkVariable[] xNetworkVariableArray = xLonDevice.getNetworkVariables();
        int n = 0;
        while (n < xNetworkVariableArray.length) {
            lonOutputStream.writeUnsigned16(xNetworkVariableArray[n].index);
            lonOutputStream.writeUnsigned16(xNetworkVariableArray[n].arraySize);
            lonOutputStream.write(1 - xNetworkVariableArray[n].direction.equalsIgnoreCase("input"));
            ++n;
        }
        return lonOutputStream.toByteArray();
    }

    public static void updateDevice(BLonDevice bLonDevice, XLonDevice xLonDevice) {
        if (bLonDevice instanceof BDynamicDevice) {
            XLonInterfaceFile xLonInterfaceFile = new XLonInterfaceFile();
            xLonInterfaceFile.addAttribute("", xLonDevice);
            BImportParameters bImportParameters = new BImportParameters();
            boolean bl = false;
            if (bLonDevice.getLonObjects().length > 0) {
                bl = true;
            }
            bImportParameters.setUseLonObjects(bl);
            DynaDev.importXLon((BDynamicDevice)bLonDevice, xLonInterfaceFile, bImportParameters);
        } else {
            System.out.println("NxeUtil.updateDevice() not implemented for " + bLonDevice.getType());
        }
    }

    public static void updateDevice(BLonDevice bLonDevice, XLonInterfaceFile xLonInterfaceFile) {
        if (bLonDevice instanceof BDynamicDevice) {
            BImportParameters bImportParameters = new BImportParameters();
            boolean bl = false;
            if (bLonDevice.getLonObjects().length > 0) {
                bl = true;
            }
            bImportParameters.setUseLonObjects(bl);
            DynaDev.importXLon((BDynamicDevice)bLonDevice, xLonInterfaceFile, bImportParameters);
        } else {
            System.out.println("NxeUtil.updateDevice() not implemented for " + bLonDevice.getType());
        }
    }
}

