/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.util;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NetMessageReceiver;
import com.tridium.lonworks.datatypes.BLinkDescriptor;
import com.tridium.lonworks.device.DeviceFacets;
import com.tridium.lonworks.loncomm.NAppBuffer;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmessages.CapacityInfoRequest;
import com.tridium.lonworks.netmessages.ChecksumRecalcRequest;
import com.tridium.lonworks.netmessages.ClearStatus;
import com.tridium.lonworks.netmessages.ExEnumerateAddressRequest;
import com.tridium.lonworks.netmessages.ExEnumerateAliasRequest;
import com.tridium.lonworks.netmessages.ExEnumerateDomainRequest;
import com.tridium.lonworks.netmessages.ExEnumerateNvConfigRequest;
import com.tridium.lonworks.netmessages.ExInitRequest;
import com.tridium.lonworks.netmessages.ExUpdateAddressReq;
import com.tridium.lonworks.netmessages.ExUpdateAliasRequest;
import com.tridium.lonworks.netmessages.ExUpdateDomainRequest;
import com.tridium.lonworks.netmessages.ExUpdateNvConfigRequest;
import com.tridium.lonworks.netmessages.FetchNvRequest;
import com.tridium.lonworks.netmessages.FetchNvResponse;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryAddrRequest;
import com.tridium.lonworks.netmessages.QueryAddrResponse;
import com.tridium.lonworks.netmessages.QueryAliasRequest;
import com.tridium.lonworks.netmessages.QueryAliasResponse;
import com.tridium.lonworks.netmessages.QueryDomainRequest;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.QueryIdRequest;
import com.tridium.lonworks.netmessages.QueryIdResponse;
import com.tridium.lonworks.netmessages.QueryNvConfigRequest;
import com.tridium.lonworks.netmessages.QueryNvConfigResponse;
import com.tridium.lonworks.netmessages.QueryStatusRequest;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import com.tridium.lonworks.netmessages.RespondToQueryRequest;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmessages.SetNodeModeRequest;
import com.tridium.lonworks.netmessages.UnprocessedNV;
import com.tridium.lonworks.netmessages.UpdateAddress;
import com.tridium.lonworks.netmessages.UpdateAliasRequest;
import com.tridium.lonworks.netmessages.UpdateDomainRequest;
import com.tridium.lonworks.netmessages.UpdateNvConfigRequest;
import com.tridium.lonworks.netmessages.WinkRequest;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BBroadcast;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BImplicit;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonConfigSourceEnum;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NmUtil
implements NetMessages,
NetMgmtConst {
    public static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    public static final BFacets showMilliSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;
    static /* synthetic */ Class class$com$tridium$lonworks$BLonRouter;

    public static void setDeviceState(BLonDevice bLonDevice, BLonNodeState bLonNodeState) throws LonException {
        NmUtil.setDeviceState(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonNodeState, bLonDevice.isLocal(), bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static void setDeviceState(BLonRouter bLonRouter, BLonNodeState bLonNodeState, boolean bl) throws LonException {
        NmUtil.setDeviceState(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), bLonNodeState, false, bLonRouter.getNearDeviceData().getAuthenticate(), bl);
    }

    /*
     * Unable to fully structure code
     */
    public static void setDeviceState(LonComm var0, LonAddress var1_1, BLonNodeState var2_2, boolean var3_3, boolean var4_4, boolean var5_5) throws LonException {
        if (var2_2 == BLonNodeState.unknown) {
            return;
        }
        var9_6 = false;
        var10_7 = 0;
        var11_8 = null;
        while (!var9_6) {
            block36: {
                try {
                    var7_10 = NmUtil.queryStatus((LonComm)var0, (LonAddress)var1_1, (int)1, (boolean)var4_4, (boolean)var5_5).nodeState;
                }
                catch (LonException var12_13) {
                    var7_10 = 0;
                }
                if (var2_2 == BLonNodeState.unconfigured) {
                    if (var7_10 == 2) {
                        return;
                    }
                    try {
                        NmUtil.setNodeState(var0, var1_1, 2, var4_4, var5_5);
                        if (var3_3) {
                            return;
                        }
                        break block36;
                    }
                    catch (LonException var12_14) {
                        var6_9 = new SetNodeModeRequest(0);
                        if (var5_5) {
                            var6_9.setFarSide();
                        }
                        var0.sendAcked(var1_1, var6_9);
                        var8_11 = 2;
                        var7_10 = NmUtil.queryStatus((LonComm)var0, (LonAddress)var1_1, (int)1, (boolean)var4_4, (boolean)var5_5).nodeState;
                        ** while ((var7_10 & 15) != 12 && var8_11-- > 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        NmUtil.wait(100);
                        var7_10 = NmUtil.queryStatus((LonComm)var0, (LonAddress)var1_1, (int)1, (boolean)var4_4, (boolean)var5_5).nodeState;
                        continue;
                    }
lbl31:
                    // 1 sources

                    NmUtil.setNodeState(var0, var1_1, 2, var4_4, var5_5);
                } else if (var2_2 == BLonNodeState.applicationless) {
                    if (var7_10 == 3) {
                        return;
                    }
                    try {
                        NmUtil.setNodeState(var0, var1_1, 3, var4_4, var5_5);
                        if (var3_3) {
                            return;
                        }
                        break block36;
                    }
                    catch (LonException var12_15) {
                        var6_9 = new SetNodeModeRequest(0);
                        if (var5_5) {
                            var6_9.setFarSide();
                        }
                        var0.sendAcked(var1_1, var6_9);
                        var8_11 = 2;
                        var7_10 = NmUtil.queryStatus((LonComm)var0, (LonAddress)var1_1, (int)1, (boolean)var4_4, (boolean)var5_5).nodeState;
                        ** while ((var7_10 & 15) != 12 && var8_11-- > 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        NmUtil.wait(100);
                        var7_10 = NmUtil.queryStatus((LonComm)var0, (LonAddress)var1_1, (int)1, (boolean)var4_4, (boolean)var5_5).nodeState;
                        continue;
                    }
lbl52:
                    // 1 sources

                    NmUtil.setNodeState(var0, var1_1, 3, var4_4, var5_5);
                } else if (var2_2 == BLonNodeState.configOffline) {
                    if ((var7_10 = NmUtil.setStateConfigOnline(var0, var1_1, var7_10, var4_4, var5_5)) == 12) {
                        return;
                    }
                    var6_9 = new SetNodeModeRequest(0);
                    if (var5_5) {
                        var6_9.setFarSide();
                    }
                    var6_9.setAuthenticate(var4_4);
                    var0.sendAcked(var1_1, var6_9);
                } else if (var2_2 == BLonNodeState.configOnline) {
                    if ((var7_10 = NmUtil.setStateConfigOnline(var0, var1_1, var7_10, var4_4, var5_5)) == 4) {
                        return;
                    }
                    var6_9 = new SetNodeModeRequest(1);
                    if (var5_5) {
                        var6_9.setFarSide();
                    }
                    var6_9.setAuthenticate(var4_4);
                    var0.sendAcked(var1_1, var6_9);
                } else if (var2_2 == BLonNodeState.hardOffline) {
                    if (var7_10 == 6) {
                        return;
                    }
                    NmUtil.setNodeState(var0, var1_1, 6, var4_4, var5_5);
                }
            }
            var11_8 = null;
            var8_11 = 15;
            while ((var11_8 == null || var11_8 != var2_2) && --var8_11 > 0) {
                NmUtil.wait(1000);
                try {
                    var11_8 = NmUtil.getDeviceState(var0, var1_1, var4_4, var5_5);
                }
                catch (LonException v0) {}
            }
            if (var11_8 == var2_2 || var10_7 >= 5) {
                var9_6 = true;
            } else {
                NmUtil.wait((int)(5000.0 * Math.pow(2, var10_7)));
            }
            ++var10_7;
        }
        if (var11_8 != var2_2) {
            var12_12 = "Unable to set state to " + (Object)var2_2 + " state now = " + var11_8;
            var0.lonNetwork().log().error(var12_12);
            throw new LonException(var12_12);
        }
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {}
    }

    public static BLonNodeState getDeviceState(BLonDevice bLonDevice) throws LonException {
        return NmUtil.getDeviceState(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static BLonNodeState getDeviceState(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        return NmUtil.getDeviceState(lonComm, lonAddress, bl, false);
    }

    public static BLonNodeState getDeviceState(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        QueryStatusResponse queryStatusResponse = NmUtil.queryStatus(lonComm, lonAddress, 1, bl, bl2);
        int n = queryStatusResponse.nodeState;
        if ((n & 7) == 3) {
            return BLonNodeState.applicationless;
        }
        if ((n & 7) == 2) {
            return BLonNodeState.unconfigured;
        }
        if ((n & 7) >= 4) {
            if ((n & 7) == 6) {
                return BLonNodeState.hardOffline;
            }
            if ((n & 0xF) == 4) {
                return BLonNodeState.configOnline;
            }
            return BLonNodeState.configOffline;
        }
        lonComm.lonNetwork().log().warning("could not decode state " + Integer.toString(n, 16) + " in " + lonAddress);
        return BLonNodeState.unknown;
    }

    private static final boolean isStateCnfgOnline(int n) {
        boolean bl = false;
        if ((n & 7) == 4) {
            bl = true;
        }
        return bl;
    }

    private static final int setStateConfigOnline(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        int n2 = n;
        int n3 = 0;
        while (!NmUtil.isStateCnfgOnline(n2) && n3++ < 2) {
            int n4;
            NmUtil.setNodeState(lonComm, lonAddress, 4, bl, bl2);
            int n5 = 0;
            do {
                n4 = bl2 ? 3 : 1;
            } while (!NmUtil.isStateCnfgOnline(n2 = NmUtil.queryStatus((LonComm)lonComm, (LonAddress)lonAddress, (int)n4, (boolean)bl, (boolean)bl2).nodeState) && n5++ < 3);
        }
        return n2;
    }

    private static final void setNodeState(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        SetNodeModeRequest setNodeModeRequest = new SetNodeModeRequest(3, n);
        if (bl2) {
            setNodeModeRequest.setFarSide();
        }
        setNodeModeRequest.setAuthenticate(bl);
        setNodeModeRequest.setTransmitTimer(BLonRepeatTimer.milliSec192);
        try {
            lonComm.sendAcked(lonAddress, setNodeModeRequest);
        }
        catch (LonException lonException) {}
    }

    public static void resetNode(BLonDevice bLonDevice) throws LonException {
        NmUtil.resetNode(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static void resetNode(BLonRouter bLonRouter) throws LonException {
        NmUtil.resetNode(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), bLonRouter.getNearDeviceData().getAuthenticate(), false);
        NmUtil.resetNode(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), bLonRouter.getNearDeviceData().getAuthenticate(), true);
    }

    public static void resetNode(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        SetNodeModeRequest setNodeModeRequest = new SetNodeModeRequest(2);
        if (bl2) {
            setNodeModeRequest.setFarSide();
        }
        if (!bl) {
            lonComm.sendUnacknowledged(lonAddress, setNodeModeRequest);
        } else {
            setNodeModeRequest.setRetryCount(0);
            setNodeModeRequest.setAuthenticate(true);
            try {
                lonComm.sendAcked(lonAddress, setNodeModeRequest);
            }
            catch (LonException lonException) {}
        }
        NmUtil.wait(100);
        NmUtil.queryStatus(lonComm, lonAddress, 3, bl, bl2);
    }

    public static ServicePin receiveServicePin(BLonNetmgmt bLonNetmgmt) throws LonException {
        ServicePin servicePin = null;
        NetMessageReceiver netMessageReceiver = bLonNetmgmt.lonNetwork().netMessageReceiver();
        netMessageReceiver.clearServicePin();
        try {
            servicePin = netMessageReceiver.getServicePin(bLonNetmgmt.getServicePinWait() * 1000);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return servicePin;
    }

    public static void sendServicePin(BLocalLonDevice bLocalLonDevice) throws LonException {
        BDeviceData bDeviceData = bLocalLonDevice.getDeviceData();
        ServicePin servicePin = new ServicePin(bDeviceData.getNeuronId(), bDeviceData.getProgramId());
        boolean bl = bLocalLonDevice.lonNetwork().netmgmt().getDomainId().isZeroLength();
        boolean bl2 = false;
        if (bDeviceData.getWorkingDomain() == 0) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        int n = 0;
        if (bl && bl3 || !bl && !bl3) {
            n = 1;
        }
        int n2 = 1 - n;
        bLocalLonDevice.lonComm().sendUnacknowledged(BBroadcast.make(n2), servicePin);
    }

    public static void updateDomainTable(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice) throws LonException {
        NmUtil.updateDomainTable(bLonNetmgmt, bLonDevice, bLonDevice.getDeviceData().getAuthenticate());
    }

    public static void updateDomainTable(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice, boolean bl) throws LonException {
        BDomainId bDomainId = bLonNetmgmt.getDomainId();
        BAuthenticationKey bAuthenticationKey = bLonNetmgmt.getAuthenticationKey();
        NmUtil.updateDomainTable(bLonDevice, bDomainId, bAuthenticationKey, bl);
    }

    public static void updateDomainTable(BLonDevice bLonDevice, BDomainId bDomainId, BAuthenticationKey bAuthenticationKey, boolean bl) throws LonException {
        int n;
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n2 = bDeviceData.getSubnetNodeId().getSubnetId();
        int n3 = bDeviceData.getSubnetNodeId().getNodeId();
        boolean bl2 = bLonDevice.isExtended();
        LonAddress lonAddress = NmUtil.getSendAddress(bLonDevice);
        int n4 = bDeviceData.getWorkingDomain();
        LonMessage lonMessage = bl2 ? new ExUpdateDomainRequest(n4, bDomainId.getDomainId(), n2, n3, bDomainId.getLength(), bAuthenticationKey.getByteArray()) : new UpdateDomainRequest(n4, bDomainId.getDomainId(), n2, n3, bDomainId.getLength(), bAuthenticationKey.getByteArray());
        lonMessage.setAuthenticate(bl);
        try {
            bLonDevice.lonComm().sendRequest(lonAddress, lonMessage);
        }
        catch (FailedResponseException failedResponseException) {
            try {
                if (!bl2 && NmUtil.isExtended(bLonDevice.lonComm(), lonAddress, bl)) {
                    bLonDevice.log().error(bLonDevice.getDisplayName(null) + " requires extended netmgmt support. Need updated *.lnml or execute learnNv.");
                }
            }
            catch (Throwable throwable) {}
            throw failedResponseException;
        }
        if (!bDeviceData.getTwoDomains()) {
            return;
        }
        int n5 = 0;
        if (n4 == 0) {
            n5 = n = 1;
        }
        lonMessage = !bDomainId.isZeroLength() && (bLonDevice.isLocal() || bLonDevice.lonNetwork().getLonNetmgmt().getAlwaysInZeroLengthDomain()) ? (bl2 ? new ExUpdateDomainRequest(n, new byte[6], n2, n3, 0, bAuthenticationKey.getByteArray()) : new UpdateDomainRequest(n, new byte[6], n2, n3, 0, bAuthenticationKey.getByteArray())) : (bl2 ? new ExUpdateDomainRequest(n) : new UpdateDomainRequest(n));
        lonMessage.setAuthenticate(bl);
        bLonDevice.lonComm().sendRequest(lonAddress, lonMessage);
    }

    public static boolean verifyDomainTable(BLonDevice bLonDevice, BLonNetmgmt bLonNetmgmt) throws LonException {
        return NmUtil.verifyDomainTable(bLonDevice, bLonNetmgmt, false);
    }

    public static boolean verifyDomainTable(BLonDevice bLonDevice, BLonNetmgmt bLonNetmgmt, boolean bl) throws LonException {
        BSubnetNode bSubnetNode;
        int n = 0;
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        boolean bl2 = bDeviceData.getAuthenticate();
        LonAddress lonAddress = NmUtil.getSendAddress(bLonDevice);
        LonComm lonComm = bLonDevice.lonComm();
        QueryDomainResponse queryDomainResponse = NmUtil.queryDomain(lonComm, lonAddress, n, bl2);
        BDomainId bDomainId = bLonNetmgmt.getDomainId();
        BDomainId bDomainId2 = null;
        if (queryDomainResponse.inUse()) {
            bDomainId2 = BDomainId.make(queryDomainResponse.len, queryDomainResponse.getDomainId());
        }
        if (bDomainId2 == null || !bDomainId.equals((Object)bDomainId2)) {
            if (!bDeviceData.getTwoDomains()) {
                return false;
            }
            n = 1;
            queryDomainResponse = NmUtil.queryDomain(lonComm, lonAddress, n, bl2);
            bDomainId2 = BDomainId.make(queryDomainResponse.len, queryDomainResponse.getDomainId());
            if (!bDomainId.equals((Object)bDomainId2)) {
                return false;
            }
        }
        if ((bSubnetNode = bDeviceData.getSubnetNodeId()).getSubnetId() != queryDomainResponse.getSubnet() || bSubnetNode.getNodeId() != queryDomainResponse.getNodeId()) {
            return false;
        }
        if (bl && !LonByteArrayUtil.equals(queryDomainResponse.getKey(), bLonNetmgmt.getAuthenticationKey().getByteArray())) {
            return false;
        }
        if (bDeviceData.getWorkingDomain() != n) {
            bDeviceData.setWorkingDomain(n);
        }
        return true;
    }

    public static void setWorkingDomain(BLonDevice bLonDevice, BLonNetmgmt bLonNetmgmt) throws LonException {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        boolean bl = bDeviceData.getAuthenticate();
        LonAddress lonAddress = NmUtil.getSendAddress(bLonDevice);
        LonComm lonComm = bLonDevice.lonComm();
        BDomainId bDomainId = bLonNetmgmt.getDomainId();
        QueryDomainResponse queryDomainResponse = NmUtil.queryDomain(lonComm, lonAddress, 0, bl);
        BDomainId bDomainId2 = null;
        if (queryDomainResponse.len <= 6) {
            bDomainId2 = BDomainId.make(queryDomainResponse.len, queryDomainResponse.getDomainId());
        }
        QueryDomainResponse queryDomainResponse2 = NmUtil.queryDomain(lonComm, lonAddress, 1, bl);
        BDomainId bDomainId3 = null;
        if (queryDomainResponse2.len <= 6) {
            bDomainId3 = BDomainId.make(queryDomainResponse2.len, queryDomainResponse2.getDomainId());
        }
        if (bDomainId2 != null && bDomainId.equals((Object)bDomainId2)) {
            bDeviceData.setWorkingDomain(0);
        } else if (bDomainId3 != null && bDomainId.equals((Object)bDomainId3)) {
            bDeviceData.setWorkingDomain(1);
        } else {
            bDeviceData.setNodeState(BLonNodeState.unknown);
        }
    }

    public static QueryDomainResponse queryDomain(BLonDevice bLonDevice, int n) throws LonException {
        return NmUtil.queryDomain(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bLonDevice.getDeviceData().getAuthenticate(), false, bLonDevice.isExtended());
    }

    public static QueryDomainResponse queryDomain(LonComm lonComm, LonAddress lonAddress, int n, boolean bl) throws LonException {
        return NmUtil.queryDomain(lonComm, lonAddress, n, bl, false);
    }

    public static QueryDomainResponse queryDomain(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        try {
            return NmUtil.queryDomain(lonComm, lonAddress, n, bl, bl2, false);
        }
        catch (FailedResponseException failedResponseException) {
            return NmUtil.queryDomain(lonComm, lonAddress, n, bl, bl2, true);
        }
    }

    public static QueryDomainResponse queryDomain(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2, boolean bl3) throws LonException {
        LonMessage lonMessage = bl3 ? new ExEnumerateDomainRequest(n) : new QueryDomainRequest(n);
        if (bl2) {
            lonMessage.setFarSide();
        }
        lonMessage.setAuthenticate(bl);
        return (QueryDomainResponse)lonComm.sendRequest(lonAddress, lonMessage);
    }

    public static void initDiscover(BLonNetwork bLonNetwork, BLonNetmgmt bLonNetmgmt, boolean bl) throws LonException {
        Object object;
        BLonDevice[] bLonDeviceArray = bLonNetwork.addressManager().getDeviceList(false);
        int n = bLonDeviceArray.length;
        int n2 = bLonNetwork.getLocalLonDevice().getDeviceData().getWorkingDomain();
        int n3 = 0;
        if (n2 == 0) {
            n3 = 1;
        }
        int n4 = n3;
        NmUtil.setRespondToQuery(bLonNetwork.lonComm(), 1, n2);
        if (bl && bLonNetmgmt.getDomainId().getLength() != 0) {
            NmUtil.setRespondToQuery(bLonNetwork.lonComm(), 1, n4);
        }
        NmUtil.wait(500);
        int n5 = 0;
        while (n5 < n) {
            BLonDevice bLonDevice = bLonDeviceArray[n5];
            if (bLonDevice != null && !bLonDevice.isLocal()) {
                try {
                    object = bLonDevice.getDeviceData().getNeuronId();
                    if (!object.isZero()) {
                        NmUtil.setRespondToQuery(bLonNetwork.lonComm(), object, 0);
                    }
                }
                catch (Throwable throwable) {}
            }
            ++n5;
        }
        BLonRouter[] bLonRouterArray = bLonNetwork.addressManager().getRouterList();
        int n6 = 0;
        while (n6 < bLonRouterArray.length) {
            object = bLonRouterArray[n6];
            if (object != null) {
                try {
                    BNeuronId bNeuronId = ((BLonRouter)((Object)object)).getNearDeviceData().getNeuronId();
                    if (!bNeuronId.isZero()) {
                        NmUtil.setRespondToQuery(bLonNetwork.lonComm(), bNeuronId, 0);
                    }
                }
                catch (Throwable throwable) {}
            }
            ++n6;
        }
    }

    public static void setRespondToQuery(LonComm lonComm, int n, int n2) throws LonException {
        RespondToQueryRequest respondToQueryRequest = new RespondToQueryRequest(n);
        respondToQueryRequest.setRetryCount(3);
        lonComm.sendUnackRepeat(BBroadcast.make(n2), respondToQueryRequest);
    }

    public static void setRespondToQuery(BLonDevice bLonDevice, int n) throws LonException {
        NmUtil.setRespondToQuery(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n);
    }

    public static void setRespondToQuery(LonComm lonComm, LonAddress lonAddress, int n) throws LonException {
        RespondToQueryRequest respondToQueryRequest = new RespondToQueryRequest(n);
        lonComm.sendRequest(lonAddress, respondToQueryRequest);
    }

    public static QueryStatusResponse queryStatus(BLonDevice bLonDevice, int n) throws LonException {
        return NmUtil.queryStatus(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static QueryStatusResponse queryStatus(BLonRouter bLonRouter, int n, boolean bl) throws LonException {
        return NmUtil.queryStatus(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), n, bLonRouter.getNearDeviceData().getAuthenticate(), bl);
    }

    public static QueryStatusResponse queryStatus(LonComm lonComm, LonAddress lonAddress, int n, boolean bl) throws LonException {
        return NmUtil.queryStatus(lonComm, lonAddress, n, bl, false);
    }

    public static QueryStatusResponse queryStatus(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        LonException lonException = null;
        while (n >= 0) {
            try {
                QueryStatusRequest queryStatusRequest = new QueryStatusRequest();
                if (bl2) {
                    queryStatusRequest.setFarSide();
                }
                queryStatusRequest.setAuthenticate(bl);
                if (lonComm.lonNetwork().getLonCommConfig().getRepeatTimer().getOrdinal() < 7) {
                    queryStatusRequest.setTransmitTimer(BLonRepeatTimer.milliSec192);
                }
                QueryStatusResponse queryStatusResponse = (QueryStatusResponse)lonComm.sendRequest(lonAddress, queryStatusRequest);
                return queryStatusResponse;
            }
            catch (LonException lonException2) {
                lonException = lonException2;
                NmUtil.wait(100);
                --n;
            }
        }
        throw lonException;
    }

    public static QueryIdResponse queryId(LonComm lonComm, int n, int n2) {
        return NmUtil.queryId(lonComm, n2, new QueryIdRequest(n));
    }

    public static QueryIdResponse queryId(LonComm lonComm, int n, QueryIdRequest queryIdRequest) {
        QueryIdResponse queryIdResponse;
        try {
            queryIdResponse = (QueryIdResponse)lonComm.sendRequest(BBroadcast.make(n), queryIdRequest);
        }
        catch (LonException lonException) {
            return null;
        }
        return queryIdResponse;
    }

    public static void clearStatus(BLonDevice bLonDevice) throws LonException {
        NmUtil.clearStatus(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate(), false);
    }

    public static void clearStatus(BLonRouter bLonRouter) throws LonException {
        NmUtil.clearStatus(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), bLonRouter.getNearDeviceData().getAuthenticate(), true);
        NmUtil.clearStatus(bLonRouter.lonComm(), NmUtil.getSendAddress(bLonRouter), bLonRouter.getNearDeviceData().getAuthenticate(), false);
    }

    public static void clearStatus(LonComm lonComm, LonAddress lonAddress, boolean bl, boolean bl2) throws LonException {
        ClearStatus clearStatus = new ClearStatus();
        clearStatus.setAuthenticate(bl);
        if (bl2) {
            clearStatus.setFarSide();
        }
        lonComm.sendRequest(lonAddress, clearStatus);
    }

    public static void recalculateChecksum(BLonDevice bLonDevice, int n) throws LonException {
        ChecksumRecalcRequest checksumRecalcRequest = new ChecksumRecalcRequest(n);
        checksumRecalcRequest.setAuthenticate(bLonDevice.getDeviceData().getAuthenticate());
        checksumRecalcRequest.setTransmitTimer(BLonRepeatTimer.milliSec384);
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), checksumRecalcRequest);
    }

    public static void clearAddressTable(BLonDevice bLonDevice) throws LonException {
        bLonDevice.getDeviceData().clearAddressTable();
        if (bLonDevice.isExtended()) {
            NmUtil.extAddressTableInitialize(bLonDevice, 0, (char)-1);
            return;
        }
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getAddressCount();
        int n2 = 0;
        while (n2 < n) {
            NmUtil.updateAddressTable(bLonDevice, n2);
            ++n2;
        }
    }

    public static void extAddressTableInitialize(BLonDevice bLonDevice, int n, int n2) throws LonException {
        ExInitRequest exInitRequest = new ExInitRequest(3, n, n2);
        exInitRequest.setAuthenticate(bLonDevice.authenticate());
        exInitRequest.setRetryCount(15);
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), exInitRequest);
    }

    public static void updateAddressTable(BLonDevice bLonDevice) throws LonException {
        int n = bLonDevice.getDeviceData().getAddressCount();
        int n2 = 0;
        while (n2 < n) {
            NmUtil.updateAddressTable(bLonDevice, n2);
            ++n2;
        }
    }

    public static void updateAddressTable(BLonDevice bLonDevice, int n) throws LonException {
        BIAddressEntry bIAddressEntry = bLonDevice.getDeviceData().getAddressEntry(n);
        LonMessage lonMessage = bLonDevice.isExtended() ? new ExUpdateAddressReq(n, bIAddressEntry) : new UpdateAddress(n, bIAddressEntry);
        lonMessage.setAuthenticate(bLonDevice.getDeviceData().getAuthenticate());
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), lonMessage);
    }

    public static BIAddressEntry getBAddressTableEntry(BLonDevice bLonDevice, int n) throws LonException {
        QueryAddrResponse queryAddrResponse = NmUtil.getAddressTableEntry(bLonDevice, n);
        return BAddressEntry.make(queryAddrResponse.getAddressType(), queryAddrResponse.getSize(), queryAddrResponse.getGroupOrSubnet(), queryAddrResponse.getMemberOrNode(), 0, queryAddrResponse.getDomainIndex(), BLonRepeatTimer.make(queryAddrResponse.repeatTimer), queryAddrResponse.retryCount, BLonReceiveTimer.make(queryAddrResponse.receiveTimer), BLonRepeatTimer.make(queryAddrResponse.xmitTimer));
    }

    public static boolean verifyAddressEntry(BLonDevice bLonDevice, int n) {
        try {
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            BIAddressEntry bIAddressEntry = bDeviceData.getAddressEntry(n);
            BLinkDescriptor bLinkDescriptor = bLonDevice.lonNetwork().getLonNetmgmt().getLinkDescriptors().getDescriptor(bIAddressEntry.getDescriptor());
            QueryAddrResponse queryAddrResponse = NmUtil.getAddressTableEntry(bLonDevice, n);
            BAddressType bAddressType = queryAddrResponse.getAddressType();
            if (bAddressType != bIAddressEntry.getAddressType()) {
                return false;
            }
            switch (bAddressType.getOrdinal()) {
                case 1: {
                    if (queryAddrResponse.getDomainIndex() != bDeviceData.getWorkingDomain() || queryAddrResponse.getMemberOrNode() != bIAddressEntry.getMemberOrNode() || queryAddrResponse.getRepeatTimer() != bLinkDescriptor.getRepeatTimer() || queryAddrResponse.getRetryCount() != bLinkDescriptor.getRetries() || queryAddrResponse.getReceiveTimer() != bLinkDescriptor.getReceiveTimer() || queryAddrResponse.getXmitTimer() != bLinkDescriptor.getTransmitTimer() || queryAddrResponse.getGroupOrSubnet() != bIAddressEntry.getGroupOrSubnet()) {
                        return false;
                    }
                }
                case 2: {
                    if (queryAddrResponse.getDomainIndex() != bDeviceData.getWorkingDomain() || queryAddrResponse.getMemberOrNode() != bIAddressEntry.getMemberOrNode() || queryAddrResponse.getRepeatTimer() != bLinkDescriptor.getRepeatTimer() || queryAddrResponse.getRetryCount() != bLinkDescriptor.getRetries() || queryAddrResponse.getXmitTimer() != bLinkDescriptor.getTransmitTimer() || queryAddrResponse.getGroupOrSubnet() != bIAddressEntry.getGroupOrSubnet()) {
                        return false;
                    }
                }
                case 3: {
                    if (queryAddrResponse.getDomainIndex() != bDeviceData.getWorkingDomain() || queryAddrResponse.getRepeatTimer() != bLinkDescriptor.getRepeatTimer() || queryAddrResponse.getRetryCount() != bLinkDescriptor.getRetries() || queryAddrResponse.getXmitTimer() != bLinkDescriptor.getTransmitTimer() || queryAddrResponse.getGroupOrSubnet() != bIAddressEntry.getGroupOrSubnet()) {
                        return false;
                    }
                }
                case 4: {
                    if (queryAddrResponse.getRepeatTimer() == bLinkDescriptor.getRepeatTimer() && queryAddrResponse.getRetryCount() == bLinkDescriptor.getRetries() && queryAddrResponse.getXmitTimer() == bLinkDescriptor.getTransmitTimer()) break;
                    return false;
                }
            }
        }
        catch (LonException lonException) {
            return false;
        }
        return true;
    }

    public static QueryAddrResponse getAddressTableEntry(BLonDevice bLonDevice, int n) throws LonException {
        return NmUtil.getAddressTableEntry(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bLonDevice.getDeviceData().getAuthenticate(), bLonDevice.isExtended());
    }

    public static QueryAddrResponse getAddressTableEntry(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        LonMessage lonMessage = bl2 ? new ExEnumerateAddressRequest(n) : new QueryAddrRequest(n);
        lonMessage.setAuthenticate(bl);
        return (QueryAddrResponse)lonComm.sendRequest(lonAddress, lonMessage);
    }

    public static BLonLinkType getLinkType(int n) {
        switch (n) {
            case 0: {
                return BLonLinkType.unknown;
            }
            case 1: {
                return BLonLinkType.standard;
            }
            case 2: {
                return BLonLinkType.reliable;
            }
            case 3: {
                return BLonLinkType.critical;
            }
            case 4: {
                return BLonLinkType.authenticated;
            }
        }
        return BLonLinkType.unknown;
    }

    public static int linkTypeToDescriptor(BLonLinkType bLonLinkType) {
        if (bLonLinkType == null) {
            return 0;
        }
        switch (bLonLinkType.getOrdinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public static BLonLinkType getLinkType(BNvConfigData bNvConfigData) {
        if (bNvConfigData.getAuthenticated()) {
            return BLonLinkType.authenticated;
        }
        switch (bNvConfigData.getServiceType().getOrdinal()) {
            case 2: {
                return BLonLinkType.standard;
            }
            case 1: {
                return BLonLinkType.reliable;
            }
            case 0: {
                return BLonLinkType.critical;
            }
            case 3: {
                return BLonLinkType.critical;
            }
        }
        return BLonLinkType.standard;
    }

    public static BLonServiceType linkTypeToServiceType(BLonLinkType bLonLinkType) {
        switch (bLonLinkType.getOrdinal()) {
            case 0: {
                return BLonServiceType.unacked;
            }
            case 1: {
                return BLonServiceType.unacked;
            }
            case 2: {
                return BLonServiceType.unackedRpt;
            }
            case 3: {
                return BLonServiceType.acked;
            }
            case 4: {
                return BLonServiceType.acked;
            }
            case 5: {
                return BLonServiceType.request;
            }
        }
        return BLonServiceType.unacked;
    }

    public static BNvConfigData queryNvConfigData(BLonDevice bLonDevice, int n) throws LonException {
        return NmUtil.queryNvConfigData(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bLonDevice.getDeviceData().getAuthenticate(), bLonDevice.isExtended());
    }

    public static BNvConfigData queryNvConfigData(LonComm lonComm, LonAddress lonAddress, int n, boolean bl, boolean bl2) throws LonException {
        LonMessage lonMessage = bl2 ? new ExEnumerateNvConfigRequest(n) : new QueryNvConfigRequest(n);
        lonMessage.setAuthenticate(bl);
        QueryNvConfigResponse queryNvConfigResponse = (QueryNvConfigResponse)lonComm.sendRequest(lonAddress, lonMessage);
        return queryNvConfigResponse.getConfigData();
    }

    public static void extNvInitialize(BLonDevice bLonDevice, int n, int n2) throws LonException {
        ExInitRequest exInitRequest = new ExInitRequest(5, n, n2);
        exInitRequest.setAuthenticate(bLonDevice.authenticate());
        exInitRequest.setRetryCount(15);
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), exInitRequest);
    }

    public static boolean verifyNvConfig(BLonDevice bLonDevice, int n, BNvConfigData bNvConfigData) throws LonException {
        if (bLonDevice.isLocal()) {
            return true;
        }
        BNvConfigData bNvConfigData2 = NmUtil.queryNvConfigData(bLonDevice, n);
        return bNvConfigData2.equivalent((Object)bNvConfigData);
    }

    public static void updateNvConfig(BLonDevice bLonDevice, int n, BNvConfigData bNvConfigData) throws LonException {
        if (bLonDevice.isLocal()) {
            return;
        }
        LonMessage lonMessage = bLonDevice.isExtended() ? new ExUpdateNvConfigRequest(n, bNvConfigData) : new UpdateNvConfigRequest(n, bNvConfigData);
        lonMessage.setAuthenticate(bLonDevice.authenticate());
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), lonMessage);
    }

    public static void updateAliasConfig(BLonDevice bLonDevice, int n, BAliasConfigData bAliasConfigData) throws LonException {
        if (bLonDevice.isLocal()) {
            return;
        }
        LonMessage lonMessage = bLonDevice.isExtended() ? new ExUpdateAliasRequest(n, bAliasConfigData) : new UpdateAliasRequest(n + bLonDevice.getDeviceData().getAliasTable().getAliasOffset(), bAliasConfigData);
        lonMessage.setAuthenticate(bLonDevice.authenticate());
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), lonMessage);
    }

    public static void extAliasInitialize(BLonDevice bLonDevice, int n, int n2) throws LonException {
        ExInitRequest exInitRequest = new ExInitRequest(6, n, n2);
        exInitRequest.setAuthenticate(bLonDevice.authenticate());
        exInitRequest.setRetryCount(15);
        exInitRequest.setTransmitTimer(BLonRepeatTimer.milliSec384);
        bLonDevice.lonComm().sendRequest(NmUtil.getSendAddress(bLonDevice), exInitRequest);
    }

    public static boolean verifyAliasNvConfig(BLonDevice bLonDevice, int n, BAliasConfigData bAliasConfigData) throws LonException {
        QueryAliasResponse queryAliasResponse;
        if (bLonDevice.isLocal()) {
            return true;
        }
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        try {
            queryAliasResponse = NmUtil.queryAliasConfigData(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bDeviceData.getAliasTable().getAliasOffset(), bDeviceData.getAuthenticate(), bLonDevice.isExtended());
        }
        catch (FailedResponseException failedResponseException) {
            return false;
        }
        BAliasConfigData bAliasConfigData2 = queryAliasResponse.getAliasConfigData();
        bAliasConfigData2.setState(bAliasConfigData.getState());
        return bAliasConfigData2.equivalent((Object)bAliasConfigData);
    }

    public static void updateAliasTable(BLonDevice bLonDevice) throws LonException {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        BNeuronId bNeuronId = bDeviceData.getNeuronId();
        LonComm lonComm = bLonDevice.lonComm();
        boolean bl = bDeviceData.getAuthenticate();
        boolean bl2 = bLonDevice.isExtended();
        BAliasTable bAliasTable = bDeviceData.getAliasTable();
        int n = bAliasTable.getAliasCount();
        int n2 = bAliasTable.getAliasOffset();
        BAliasConfigData[] bAliasConfigDataArray = bAliasTable.getAliasArray();
        int n3 = 0;
        while (n3 < n) {
            LonMessage lonMessage = bl2 ? new ExUpdateAliasRequest(n2 + n3, bAliasConfigDataArray[n3]) : new UpdateAliasRequest(n2 + n3, bAliasConfigDataArray[n3]);
            lonMessage.setAuthenticate(bl);
            lonComm.sendRequest(bNeuronId, lonMessage);
            ++n3;
        }
    }

    public static BAliasConfigData queryAliasConfigData(BLonDevice bLonDevice, int n) throws LonException {
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        QueryAliasResponse queryAliasResponse = NmUtil.queryAliasConfigData(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), n, bDeviceData.getAliasTable().getAliasOffset(), bDeviceData.getAuthenticate(), bLonDevice.isExtended());
        return queryAliasResponse.getAliasConfigData();
    }

    public static QueryAliasResponse queryAliasConfigData(LonComm lonComm, LonAddress lonAddress, int n, int n2, boolean bl, boolean bl2) throws LonException {
        LonMessage lonMessage = bl2 ? new ExEnumerateAliasRequest(n) : new QueryAliasRequest(n + n2);
        lonMessage.setAuthenticate(bl);
        QueryAliasResponse queryAliasResponse = (QueryAliasResponse)lonComm.sendRequest(lonAddress, lonMessage);
        return queryAliasResponse;
    }

    public static void setOfflineInBind(BLonDevice bLonDevice, Vector vector) throws LonException {
        if (bLonDevice.isLocal()) {
            return;
        }
        if (bLonDevice.isConfigOnline() && !DeviceFacets.getDisableSetOfflineInBind(bLonDevice)) {
            NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOffline);
            NmUtil.setDeviceState(bLonDevice, BLonNodeState.hardOffline);
            bLonDevice.getDeviceData().set(BDeviceData.nodeState, (BValue)BLonNodeState.hardOffline, AddressManager.noDeviceChange);
            vector.addElement(bLonDevice);
        }
    }

    public static int getNvLength(LonComm lonComm, LonAddress lonAddress, int n, boolean bl) throws LonException {
        FetchNvRequest fetchNvRequest = new FetchNvRequest(n);
        fetchNvRequest.setAuthenticate(bl);
        FetchNvResponse fetchNvResponse = (FetchNvResponse)lonComm.sendRequest(lonAddress, fetchNvRequest);
        return fetchNvResponse.getNvDataLength();
    }

    public static byte[] fetchNv(BLonDevice bLonDevice, int n) throws LonException {
        BSimple bSimple = bLonDevice.isConfigOnline() ? bLonDevice.getSubnetNodeAddress() : bLonDevice.getNeuronIdAddress();
        return NmUtil.fetchNv(bLonDevice.lonComm(), bSimple, n, bLonDevice.getDeviceData().getAuthenticate());
    }

    public static byte[] fetchNv(LonComm lonComm, LonAddress lonAddress, int n, boolean bl) throws LonException {
        FetchNvRequest fetchNvRequest = new FetchNvRequest(n);
        fetchNvRequest.setAuthenticate(bl);
        FetchNvResponse fetchNvResponse = (FetchNvResponse)lonComm.sendRequest(lonAddress, fetchNvRequest);
        return fetchNvResponse.getNvData();
    }

    public static byte[] pollNv(BLonDevice bLonDevice, BNvConfigData bNvConfigData) throws LonException {
        BSubnetNode bSubnetNode = bLonDevice.getSubnetNodeAddress();
        UnprocessedNV unprocessedNV = new UnprocessedNV(bNvConfigData.getDirection(), bNvConfigData.getSelector(), new byte[0]);
        UnprocessedNV unprocessedNV2 = (UnprocessedNV)bLonDevice.lonComm().sendRequest(bSubnetNode, unprocessedNV);
        return unprocessedNV2.getData();
    }

    public static void sendNvUpdate(BLocalLonDevice bLocalLonDevice, BNvConfigData bNvConfigData, byte[] byArray) throws LonException {
        int n = bNvConfigData.getAddrIndex();
        if (n < 0 || n > 14) {
            throw new LonException("Invalid adrNdx " + n + " in " + bLocalLonDevice.getDisplayName(null) + ':' + bNvConfigData.getParent().getDisplayName(null));
        }
        UnprocessedNV unprocessedNV = new UnprocessedNV(bNvConfigData.getDirection().reverse(), bNvConfigData.getSelector(), byArray);
        BLonServiceType bLonServiceType = bNvConfigData.getServiceType();
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setServiceType(bLonServiceType);
        nAppBuffer.setAuthenticate(bNvConfigData.getAuthenticated());
        nAppBuffer.setDestAddress(BImplicit.make(n));
        nAppBuffer.setMessage(unprocessedNV);
        NmUtil.sendAppBuffer(nAppBuffer, (NLonComm)bLocalLonDevice.lonComm(), bLonServiceType);
    }

    private static final void sendAppBuffer(NAppBuffer nAppBuffer, NLonComm nLonComm, BLonServiceType bLonServiceType) throws LonException {
        NAppBuffer nAppBuffer2 = null;
        LonException lonException = null;
        try {
            nAppBuffer2 = bLonServiceType == BLonServiceType.request ? nLonComm.doLonCommSendRequest(nAppBuffer, -1) : nLonComm.doLonCommSendNormal(nAppBuffer);
        }
        catch (LonException lonException2) {
            lonException = lonException2;
        }
        if (!nAppBuffer.isNoTransaction()) {
            nAppBuffer.releaseAppBuffer();
        }
        if (nAppBuffer2 != null) {
            nAppBuffer2.releaseAppBuffer();
        }
        if (lonException != null) {
            throw lonException;
        }
    }

    public static void setNvValue(BLonDevice bLonDevice, BNvConfigData bNvConfigData, byte[] byArray) throws LonException {
        UnprocessedNV unprocessedNV = new UnprocessedNV(bNvConfigData.getDirection(), bNvConfigData.getSelector(), byArray);
        BLonServiceType bLonServiceType = bNvConfigData.getServiceType();
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setDomainIndex(bLonDevice.lonNetwork().getLocalLonDevice().getWorkingDomain());
        nAppBuffer.setServiceType(bLonServiceType);
        nAppBuffer.setAuthenticate(bNvConfigData.getAuthenticated());
        nAppBuffer.setDestAddress(bLonDevice.getDeviceData().getSubnetNodeId());
        nAppBuffer.setMessage(unprocessedNV);
        NmUtil.sendAppBuffer(nAppBuffer, (NLonComm)bLonDevice.lonComm(), bLonServiceType);
    }

    public static void setNvValue(LonAddress lonAddress, LonComm lonComm, BLonNvDirection bLonNvDirection, int n, BLonServiceType bLonServiceType, boolean bl, byte[] byArray) throws LonException {
        UnprocessedNV unprocessedNV = new UnprocessedNV(bLonNvDirection, n, byArray);
        NAppBuffer nAppBuffer = NAppBuffer.makeAppBuffer();
        nAppBuffer.setDomainIndex(lonComm.lonNetwork().getLocalLonDevice().getWorkingDomain());
        nAppBuffer.setServiceType(bLonServiceType);
        nAppBuffer.setAuthenticate(bl);
        nAppBuffer.setDestAddress(lonAddress);
        nAppBuffer.setMessage(unprocessedNV);
        NmUtil.sendAppBuffer(nAppBuffer, (NLonComm)lonComm, bLonServiceType);
    }

    public static void setConfigSrc(BLonDevice bLonDevice, BLonConfigSourceEnum bLonConfigSourceEnum) {
        BLonComponent bLonComponent = (BLonComponent)((Object)bLonDevice.findSnvtType(69));
        if (bLonComponent == null) {
            return;
        }
        try {
            bLonComponent.set("configSrc", (BValue)BLonEnum.make((BEnum)bLonConfigSourceEnum));
        }
        catch (Throwable throwable) {
            bLonDevice.log().error("Error setting configSrc in " + bLonDevice.getDisplayName(null), throwable);
        }
    }

    public static void wink(BLonDevice bLonDevice) throws LonException {
        NmUtil.wink(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static void wink(LonComm lonComm, LonAddress lonAddress, boolean bl) throws LonException {
        WinkRequest winkRequest = new WinkRequest();
        winkRequest.setAuthenticate(bl);
        lonComm.sendAcked(lonAddress, winkRequest);
    }

    public static BLonDevice[] getLonDevices(BIDeviceFolder bIDeviceFolder) {
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = NmUtil.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        Array array = new Array(clazz);
        NmUtil.addDevices(bIDeviceFolder, array);
        return (BLonDevice[])array.trim();
    }

    private static final void addDevices(BIDeviceFolder bIDeviceFolder, Array array) {
        SlotCursor slotCursor = ((BComponent)bIDeviceFolder).getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            if (bObject.getType().is(BLonDevice.TYPE)) {
                array.add((Object)bObject);
            }
            if (!bObject.getType().is(BIDeviceFolder.TYPE)) continue;
            NmUtil.addDevices((BIDeviceFolder)bObject, array);
        }
    }

    public static BLonRouter[] getLonRouters(BIDeviceFolder bIDeviceFolder) {
        Class clazz = class$com$tridium$lonworks$BLonRouter;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$BLonRouter = NmUtil.class("[Lcom.tridium.lonworks.BLonRouter;", false);
        }
        Array array = new Array(clazz);
        NmUtil.addRouters(bIDeviceFolder, array);
        return (BLonRouter[])array.trim();
    }

    private static final void addRouters(BIDeviceFolder bIDeviceFolder, Array array) {
        SlotCursor slotCursor = ((BComponent)bIDeviceFolder).getProperties();
        while (slotCursor.nextObject()) {
            BObject bObject = slotCursor.get();
            if (bObject.getType().is(BLonRouter.TYPE)) {
                array.add((Object)bObject);
            }
            if (!bObject.getType().is(BIDeviceFolder.TYPE)) continue;
            NmUtil.addRouters((BIDeviceFolder)bObject, array);
        }
    }

    public static boolean isExtended(BLonDevice bLonDevice) throws LonException {
        return NmUtil.isExtended(bLonDevice.lonComm(), NmUtil.getSendAddress(bLonDevice), bLonDevice.getDeviceData().getAuthenticate());
    }

    public static boolean isExtended(LonComm lonComm, LonAddress lonAddress, boolean bl) {
        try {
            CapacityInfoRequest capacityInfoRequest = new CapacityInfoRequest(0, 12);
            capacityInfoRequest.setAuthenticate(bl);
            LonMessage lonMessage = lonComm.sendRequest(lonAddress, capacityInfoRequest);
            byte[] byArray = lonMessage.getMessageData();
            int n = (byArray[0] & 0x3F) == 63 ? 11 : 9;
            boolean bl2 = false;
            if (byArray[n] > 0) {
                bl2 = true;
            }
            return bl2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void validateNeuronId(BNeuronId bNeuronId, BComponent bComponent) throws LonException {
        if (bNeuronId.isZero()) {
            return;
        }
        BLonNetwork bLonNetwork = NmUtil.getLonNetwork(bComponent);
        BLonDevice[] bLonDeviceArray = bLonNetwork.getLonDevices();
        int n = 0;
        while (n < bLonDeviceArray.length) {
            if (bLonDeviceArray[n] != bComponent && bLonDeviceArray[n].getNeuronIdAddress().equals(bNeuronId)) {
                throw new LonException("NeuronId already in use by " + bLonDeviceArray[n].getDisplayName(null));
            }
            ++n;
        }
        BLonRouter[] bLonRouterArray = bLonNetwork.getLonRouters();
        int n2 = 0;
        while (n2 < bLonRouterArray.length) {
            if (bLonRouterArray[n2] != bComponent && bLonRouterArray[n2].getNeuronIdAddress().equals(bNeuronId)) {
                throw new LonException("NeuronId already in use by " + bLonRouterArray[n2].getDisplayName(null));
            }
            ++n2;
        }
    }

    public static void threadState() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
        threadGroup.enumerate(threadArray);
        int n = 0;
        while (n < threadArray.length) {
            if (threadArray[n] != null) {
                System.out.println(threadArray[n]);
            }
            ++n;
        }
    }

    public static boolean toBool(byte by, int n) {
        boolean bl = false;
        if ((by >> n & 1) > 0) {
            bl = true;
        }
        return bl;
    }

    public static BLonNetwork getLonNetwork(BComponent bComponent) {
        return (BLonNetwork)NmUtil.getParent(bComponent, BLonNetwork.TYPE);
    }

    public static BLonDevice getLonDevice(BComponent bComponent) {
        return (BLonDevice)NmUtil.getParent(bComponent, BLonDevice.TYPE);
    }

    public static BLonObject getLonObject(BComponent bComponent) {
        return (BLonObject)NmUtil.getParent(bComponent, BLonObject.TYPE);
    }

    public static BComponent getParent(BComponent bComponent, Type type) {
        BComplex bComplex = bComponent.getParent();
        while (!bComplex.getType().is(type)) {
            bComplex = bComplex.getParent();
        }
        return (BComponent)bComplex;
    }

    public static Object[] getDecendantsByClass(BComponent bComponent, Class clazz) {
        Array array = new Array(clazz);
        NmUtil.getDecendantsByClass(array, bComponent, clazz);
        return array.trim();
    }

    private static final void getDecendantsByClass(Array array, BComponent bComponent, Class clazz) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            BObject bObject = slotCursor.get();
            if (clazz.isInstance(bObject)) {
                array.add((Object)bObject);
            }
            if (!(bObject instanceof BComponent)) continue;
            NmUtil.getDecendantsByClass(array, (BComponent)bObject, clazz);
        }
    }

    public static LonAddress getSendAddress(BLonDevice bLonDevice) {
        if (bLonDevice.isLocal()) {
            return BLocal.local;
        }
        return bLonDevice.getNeuronIdAddress();
    }

    public static LonAddress getSendAddress(BLonRouter bLonRouter) {
        return bLonRouter.getNeuronIdAddress();
    }

    public static String debugTimeStamp() {
        BAbsTime bAbsTime = BAbsTime.make((long)System.currentTimeMillis());
        return bAbsTime.toTimeString(null) + ':' + bAbsTime.getMillisecond();
    }

    public static String timeStamp() {
        return BAbsTime.make((long)System.currentTimeMillis()).toTimeString((Context)showMilliSecs);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

