/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.router;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BRouterEntryTable;
import com.tridium.lonworks.datatypes.BServicePinData;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.ui.router.BLonRtrMgrTable;
import com.tridium.lonworks.ui.router.RouterController;
import com.tridium.lonworks.ui.router.RouterLearn;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BInsets;
import javax.baja.lonworks.BLonDeviceFolder;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderModel;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonRouterManager
extends BDeviceManager {
    public static final Type TYPE;
    static final UiLexicon lexicon;
    boolean initialized;
    private boolean useNetAddress;
    MgrColumn colName;
    MgrColumn colStatus;
    MgrColumn colRouterType;
    MgrColumn colRouterMode;
    MgrColumn colState;
    MgrColumn colNearChannel;
    MgrColumn colNearSubnetNode;
    MgrColumn colFarChannel;
    MgrColumn colFarSubnetNode;
    MgrColumn colFaultCause;
    MgrColumn colNeuronId;
    MgrColumn[] cols;
    BJobBar jobBar;
    private BLonNetwork lon;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$router$BLonRouterManager;
    static /* synthetic */ Class class$com$tridium$lonworks$BLonRouter;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDeviceFolder;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new LonRouterModel(this);
    }

    protected MgrLearn makeLearn() {
        return new RouterLearn(this);
    }

    protected MgrController makeController() {
        return new RouterController(this);
    }

    public BLonNetwork getNetwork() {
        if (this.lon == null) {
            Thread.dumpStack();
        }
        return this.lon;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.lon = (BLonNetwork)((BIDeviceFolder)bObject).getNetwork();
        try {
            super.doLoadValue(bObject, context);
        }
        catch (Throwable throwable) {}
        if (!this.initialized) {
            this.initialized = true;
            this.jobBar = new BJobBar();
            this.attach((BWbComponentView.Attachable)this.jobBar);
            BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
            bBorderPane.setFill(Theme.widget().getWindowBackground());
            bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
            ((BEdgePane)this.getContent()).setTop((BWidget)bBorderPane);
        }
        this.registerFolder((BComponent)bObject);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.registerForComponentEvents(this.lon.netmgmt(), 1);
        this.updateDiscoveryRows(this.lon.netmgmt().getRouterDiscoverTable());
    }

    void registerRouter(BLonRouter bLonRouter) {
        this.registerForComponentEvents(bLonRouter, 0);
        this.registerForComponentEvents(bLonRouter.getNearDeviceData(), 0);
        this.registerForComponentEvents(bLonRouter.getFarDeviceData(), 0);
    }

    void reloadValue() {
        BComponent bComponent = this.getCurrentValue().asComponent();
        this.registerFolder(bComponent);
        if (((FolderModel)this.getModel()).isAllDescendants()) {
            this.loadDescendants();
        }
        this.updateDiscoveryRows(this.lon.netmgmt().getRouterDiscoverTable());
        this.repaint();
    }

    void loadDescendants() {
        BComponent bComponent = this.getCurrentValue().asComponent();
        BLonDeviceFolder[] bLonDeviceFolderArray = this.getFolders(bComponent);
        int n = 0;
        while (n < bLonDeviceFolderArray.length) {
            this.registerFolder((BComponent)bLonDeviceFolderArray[n]);
            ++n;
        }
    }

    private final void registerFolder(BComponent bComponent) {
        this.registerForComponentEvents(bComponent, 1);
        Class clazz = class$com$tridium$lonworks$BLonRouter;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$BLonRouter = BLonRouterManager.class("[Lcom.tridium.lonworks.BLonRouter;", false);
        }
        BLonRouter[] bLonRouterArray = (BLonRouter[])bComponent.getChildren(clazz);
        BComponent[] bComponentArray = new BComponent[bLonRouterArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < bLonRouterArray.length) {
            bComponentArray[n2++] = bLonRouterArray[n].getNearDeviceData();
            bComponentArray[n2++] = bLonRouterArray[n].getFarDeviceData();
            ++n;
        }
        this.registerForComponentEvents(bComponentArray, 0);
    }

    private final BLonDeviceFolder[] getFolders(BComponent bComponent) {
        Class clazz = class$javax$baja$lonworks$BLonDeviceFolder;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDeviceFolder = BLonRouterManager.class("[Ljavax.baja.lonworks.BLonDeviceFolder;", false);
        }
        Array array = new Array(clazz);
        this.scanForFolders(bComponent, array);
        return (BLonDeviceFolder[])array.trim();
    }

    private final void scanForFolders(BComponent bComponent, Array array) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            if (!property.getType().is(BLonDeviceFolder.TYPE)) continue;
            BComponent bComponent2 = (BComponent)slotCursor.get();
            this.registerForComponentEvents(bComponent2, 0);
            array.add((Object)bComponent2);
            this.scanForFolders(bComponent2, array);
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        int n = bComponentEvent.getId();
        BComponent bComponent = bComponentEvent.getSourceComponent();
        switch (n) {
            case 5: {
                if (bComponent == this.getNetwork()) {
                    if (bComponentEvent.getSlot() != BLonNetwork.deviceChange) break;
                    this.repaint();
                    break;
                }
                if (bComponent != this.getNetwork().netmgmt()) break;
                if (bComponentEvent.getSlot() == BLonNetmgmt.learnComplete) {
                    this.reloadValue();
                    break;
                }
                if (bComponentEvent.getSlot() == BLonNetmgmt.routerDiscoveryUpdated) {
                    this.updateDiscoveryRows((BRouterEntryTable)bComponentEvent.getValue());
                    break;
                }
                if (bComponentEvent.getSlot() != BLonNetmgmt.servicePinReceived) break;
                BNeuronId bNeuronId = ((BServicePinData)bComponentEvent.getValue()).getNeuronId();
                BMgrTable bMgrTable = this.getModel().getTable();
                int n2 = bMgrTable.getComponentModel().getRowCount();
                int n3 = 0;
                while (n3 < n2) {
                    BComponent bComponent2 = bMgrTable.getComponentAt(n3);
                    if (bComponent2.getType().is(BLonRouter.TYPE) && ((BLonRouter)bComponent2).getNeuronIdAddress().equals(bNeuronId)) {
                        bMgrTable.getSelection().select(n3, true);
                        break;
                    }
                    ++n3;
                }
                BRouterEntry[] bRouterEntryArray = (BRouterEntry[])this.getLearn().getRoots();
                int n4 = 0;
                while (n4 < bRouterEntryArray.length) {
                    if (bRouterEntryArray[n4].getNeuronId().equals(bNeuronId)) {
                        this.getLearn().getTable().getSelection().select(n4, true);
                    }
                    ++n4;
                }
                break;
            }
            case 0: {
                if (!bComponent.getType().is(BLonRouter.TYPE) && !bComponent.getType().is(BDeviceData.TYPE)) break;
                this.repaint();
                break;
            }
        }
        super.handleComponentEvent(bComponentEvent);
    }

    void updateDiscoveryRows(BRouterEntryTable bRouterEntryTable) {
        BRouterEntry[] bRouterEntryArray = bRouterEntryTable.getRouterEntries();
        this.getLearn().updateRoots((Object[])bRouterEntryArray);
    }

    public BSubnetNode validate(MgrEditRow mgrEditRow, BSubnetNode bSubnetNode) {
        BOrd bOrd = this.lon.getLonNetmgmt().deviceForSubnetNodeId(bSubnetNode);
        BLonRouter bLonRouter = (BLonRouter)mgrEditRow.getTarget();
        if (bOrd != null && !bOrd.equals((Object)bLonRouter.getHandleOrd())) {
            if (bLonRouter.isMounted()) {
                throw new BajaRuntimeException("Address " + bSubnetNode + " already in use.");
            }
            return BSubnetNode.DEFAULT;
        }
        return bSubnetNode;
    }

    public boolean isUseNetAddress() {
        return this.useNetAddress;
    }

    public void setUseNetAddress(boolean bl) {
        this.useNetAddress = bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.initialized = false;
        this.useNetAddress = true;
        this.colName = new MgrColumn.Name();
        this.colStatus = new StatusColumn();
        this.colRouterType = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.rtrType"), new Property[]{BLonRouter.routerType}, 1);
        this.colRouterMode = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.rtrMode"), new Property[]{BLonRouter.routerMode}, 1);
        this.colState = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.state"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.nodeState}, 5);
        this.colNearChannel = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.nearChannelId"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.channelId}, 1);
        this.colNearSubnetNode = new SubNetNodeColumn(lexicon.getText("router.columnTitle.nearAdr"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.subnetNodeId}, 1);
        this.colFarChannel = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.farChannelId"), new Property[]{BLonRouter.farDeviceData, BDeviceData.channelId}, 1);
        this.colFarSubnetNode = new SubNetNodeColumn(lexicon.getText("router.columnTitle.farAdr"), new Property[]{BLonRouter.farDeviceData, BDeviceData.subnetNodeId}, 1);
        this.colFaultCause = new MgrColumn.PropPath(lexicon.getText("device.columnTitle.faultCause"), new Property[]{BLonRouter.faultCause}, 4);
        this.colNeuronId = new MgrColumn.PropPath(lexicon.getText("router.columnTitle.neuronId"), new Property[]{BLonRouter.nearDeviceData, BDeviceData.neuronId}, 5);
        this.cols = new MgrColumn[]{this.colName, this.colStatus, this.colRouterType, this.colRouterMode, this.colState, this.colNearChannel, this.colNearSubnetNode, this.colFarChannel, this.colFarSubnetNode, this.colFaultCause, this.colNeuronId};
    }

    public BLonRouterManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$lonworks$ui$router$BLonRouterManager;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$ui$router$BLonRouterManager = BLonRouterManager.class("[Lcom.tridium.lonworks.ui.router.BLonRouterManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$lonworks$ui$router$BLonRouterManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$lonworks$ui$router$BLonRouterManager = BLonRouterManager.class("[Lcom.tridium.lonworks.ui.router.BLonRouterManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LonRouterModel
    extends DeviceModel {
        public MgrTypeInfo[] getNewTypes() {
            TypeInfo[] typeInfoArray = new TypeInfo[]{BLonRouter.TYPE.getTypeInfo()};
            return MgrTypeInfo.makeArray((TypeInfo[])typeInfoArray);
        }

        protected MgrColumn[] makeColumns() {
            return BLonRouterManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BLonRouter.TYPE, BLonDeviceFolder.TYPE};
        }

        protected BMgrTable makeTable() {
            return new BLonRtrMgrTable((MgrModel)this);
        }

        LonRouterModel(BLonRouterManager bLonRouterManager2) {
            super((BDeviceManager)bLonRouterManager2);
        }
    }

    static class StatusColumn
    extends MgrColumn {
        public Object get(Object object) {
            return ((BLonRouter)((Object)object)).getStatus().flagsToString(null);
        }

        public StatusColumn() {
            super(lexicon.getText("device.columnTitle.status"), 2);
        }
    }

    static class SubNetNodeColumn
    extends MgrColumn.PropPath {
        Property prop;

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BLonRouterManager bLonRouterManager = (BLonRouterManager)mgrEditRow.getManager();
            BSubnetNode bSubnetNode = bLonRouterManager.validate(mgrEditRow, (BSubnetNode)bValue);
            BDeviceData bDeviceData = (BDeviceData)((BLonRouter)mgrEditRow.getTarget()).get(this.prop);
            bDeviceData.setSubnetNodeId(bSubnetNode);
        }

        public SubNetNodeColumn(String string, Property[] propertyArray, int n) {
            super(string, propertyArray, n);
            this.prop = propertyArray[0];
        }
    }
}

