/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.point;

import com.tridium.lonworks.ui.point.BLonCreationEntry;
import com.tridium.lonworks.ui.point.BLonPointManager;
import java.util.ArrayList;
import javax.baja.control.BControlPoint;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonObject;
import javax.baja.lonworks.BLonObjectFolder;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonSimple;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.proxy.BLonProxyExt;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class PointLearn
extends MgrLearn {
    static Lexicon lex = BLonPointManager.lexicon;
    static BImage FloatElementIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    static BImage BooleanElementIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    static BImage EnumElementIcon = BImage.make((String)"module://icons/x16/statusEnum.png");
    static BImage StringElementIcon = BImage.make((String)"module://icons/x16/statusString.png");
    static BImage LonObjectIcon = BImage.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/object.png");
    static BImage LonObjectFolderIcon = BImage.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/objectFolder.png");
    BLonDevice dev;

    public void load(BComponent bComponent) {
        super.load(bComponent);
        BComplex bComplex = bComponent.getParent();
        while (!bComplex.getType().is(BLonDevice.TYPE)) {
            bComplex = bComplex.getParent();
        }
        this.dev = (BLonDevice)bComplex;
        this.dev.getComponentSpace().update((BComponent)this.dev, Integer.MAX_VALUE);
        this.updateDiscoveryRows();
    }

    void updateDiscoveryRows() {
        ArrayList arrayList = new ArrayList();
        this.doUpdateDiscoveryRows(arrayList, (BComponent)this.dev, "");
        BLonCreationEntry[] bLonCreationEntryArray = arrayList.toArray(new BLonCreationEntry[arrayList.size()]);
        this.updateRoots((Object[])bLonCreationEntryArray);
    }

    private final void doUpdateDiscoveryRows(ArrayList arrayList, BComponent bComponent, String string) {
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextObject()) {
            Object object;
            Object object2;
            Object object3;
            if (slotCursor.property().getType().is(BLonComponent.TYPE)) {
                BLonCreationEntry bLonCreationEntry;
                object3 = (BLonComponent)slotCursor.get();
                object2 = object3.getData();
                object = object3.getDisplayName(null);
                if (object3 != object2) {
                    object = object + '/' + object2.getDisplayName(null);
                }
                if ((bLonCreationEntry = this.addElementRows(bComponent, (BLonData)((Object)object2), (String)object, string)) == null) {
                    System.out.println("e==null");
                    continue;
                }
                arrayList.add(bLonCreationEntry);
                continue;
            }
            if (slotCursor.property().getType().is(BLonObject.TYPE)) {
                object3 = (BLonObject)slotCursor.get();
                object2 = new ArrayList();
                this.doUpdateDiscoveryRows((ArrayList)object2, (BComponent)object3, object3.getDisplayName(null));
                object = new BLonCreationEntry((BComponent)object3);
                ((BLonCreationEntry)((Object)object)).children = ((ArrayList)object2).toArray(new BLonCreationEntry[((ArrayList)object2).size()]);
                arrayList.add(object);
                continue;
            }
            if (!slotCursor.property().getType().is(BLonObjectFolder.TYPE)) continue;
            object3 = (BLonObjectFolder)slotCursor.get();
            object2 = new ArrayList();
            this.doUpdateDiscoveryRows((ArrayList)object2, (BComponent)object3, object3.getDisplayName(null));
            object = new BLonCreationEntry((BComponent)object3);
            ((BLonCreationEntry)((Object)object)).children = ((ArrayList)object2).toArray(new BLonCreationEntry[((ArrayList)object2).size()]);
            arrayList.add(object);
        }
    }

    private final BLonCreationEntry addElementRows(BComponent bComponent, BLonData bLonData, String string, String string2) {
        BLonCreationEntry[] bLonCreationEntryArray;
        BLonCreationEntry bLonCreationEntry = null;
        ArrayList<BLonCreationEntry> arrayList = null;
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            Object object;
            bLonCreationEntryArray = slotCursor.property();
            BLonCreationEntry bLonCreationEntry2 = null;
            if (bLonCreationEntryArray.getType().is(BLonPrimitive.TYPE)) {
                object = bLonCreationEntryArray.getFacets();
                BUnit bUnit = (BUnit)object.get("units");
                String string3 = bUnit == null ? "" : bUnit.getSymbol();
                bLonCreationEntry2 = new BLonCreationEntry(bLonData, bLonCreationEntryArray.getName(), string3);
            } else if (bLonCreationEntryArray.getType().is(BLonData.TYPE)) {
                object = string + '/' + bLonCreationEntryArray.getDefaultDisplayName(null);
                bLonCreationEntry2 = this.addElementRows(bComponent, (BLonData)slotCursor.get(), (String)object, string2);
            }
            if (bLonCreationEntry2 == null) continue;
            if (bLonCreationEntry == null) {
                bLonCreationEntry = bLonCreationEntry2;
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<BLonCreationEntry>();
            }
            arrayList.add(bLonCreationEntry2);
        }
        if (arrayList != null) {
            bLonCreationEntryArray = arrayList.toArray(new BLonCreationEntry[arrayList.size()]);
            bLonCreationEntry.children = bLonCreationEntryArray;
        }
        return bLonCreationEntry;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Prop(lex.getText("learn.columnTitle.targetName"), BLonCreationEntry.targetName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.elementName"), BLonCreationEntry.elementName, 1), new MgrColumn.Prop(lex.getText("learn.columnTitle.units"), BLonCreationEntry.units, 1)};
    }

    public boolean isDepthExpandable(int n) {
        return true;
    }

    public boolean hasChildren(Object object) {
        return ((BLonCreationEntry)((Object)object)).hasChildren();
    }

    public Object[] getChildren(Object object) {
        BLonCreationEntry[] bLonCreationEntryArray = ((BLonCreationEntry)((Object)object)).getChildren();
        if (bLonCreationEntryArray == null) {
            return new Object[0];
        }
        return bLonCreationEntryArray;
    }

    public BImage getIcon(Object object) {
        Type type = ((BLonCreationEntry)((Object)object)).getTarget().getType();
        if (type.is(BLonObject.TYPE)) {
            return LonObjectIcon;
        }
        if (type.is(BLonObjectFolder.TYPE)) {
            return LonObjectFolderIcon;
        }
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            return FloatElementIcon;
        }
        if (type == BLonBoolean.TYPE) {
            return BooleanElementIcon;
        }
        if (type == BLonEnum.TYPE) {
            return EnumElementIcon;
        }
        if (type == BLonString.TYPE || type == BLonByteArray.TYPE || type == BLonSimple.TYPE) {
            return StringElementIcon;
        }
        return null;
    }

    public MgrTypeInfo[] toTypes(Object object) throws Exception {
        BLonCreationEntry bLonCreationEntry = (BLonCreationEntry)((Object)object);
        ArrayList arrayList = new ArrayList();
        boolean bl = bLonCreationEntry.getLonComponent().isWriteable();
        Type type = bLonCreationEntry.getTarget().getType();
        if (type == BLonFloat.TYPE || type == BLonInteger.TYPE || type == BLonDouble.TYPE || type == BLonLong.TYPE || type == BLonBigInteger.TYPE) {
            PointModel.addNumericPointTypes(arrayList, (boolean)bl);
            PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
            PointModel.addStringPointTypes(arrayList, (boolean)bl);
            PointModel.addEnumPointTypes(arrayList, (boolean)bl);
        } else if (type == BLonBoolean.TYPE) {
            PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
            PointModel.addNumericPointTypes(arrayList, (boolean)bl);
            PointModel.addStringPointTypes(arrayList, (boolean)bl);
        } else if (type == BLonEnum.TYPE) {
            PointModel.addEnumPointTypes(arrayList, (boolean)bl);
            PointModel.addStringPointTypes(arrayList, (boolean)bl);
            PointModel.addNumericPointTypes(arrayList, (boolean)bl);
            PointModel.addBooleanPointTypes(arrayList, (boolean)bl);
        } else {
            PointModel.addStringPointTypes(arrayList, (boolean)bl);
        }
        return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
    }

    public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
        BLonCreationEntry bLonCreationEntry = (BLonCreationEntry)((Object)object);
        BLonPointManager bLonPointManager = (BLonPointManager)mgrEditRow.getManager();
        mgrEditRow.setDefaultName(bLonCreationEntry.getDefaultProxyName());
        mgrEditRow.setCell(bLonPointManager.colTarget, (BValue)BString.make((String)bLonCreationEntry.getTargetPathName()));
        mgrEditRow.setCell(bLonPointManager.colElement, (BValue)BString.make((String)bLonCreationEntry.getElementName()));
        mgrEditRow.setCell(bLonPointManager.colFacets, (BValue)bLonCreationEntry.getFacets());
    }

    public boolean isExisting(Object object, BComponent bComponent) {
        if (!(bComponent instanceof BControlPoint)) {
            return false;
        }
        BLonCreationEntry bLonCreationEntry = (BLonCreationEntry)((Object)object);
        BControlPoint bControlPoint = (BControlPoint)bComponent;
        BLonProxyExt bLonProxyExt = (BLonProxyExt)bControlPoint.getProxyExt();
        String string = bLonProxyExt.getTargetComp();
        boolean bl = false;
        if (string.equals(bLonCreationEntry.getTargetName()) && bLonProxyExt.getTargetName().equals(bLonCreationEntry.getElementName())) {
            bl = true;
        }
        return bl;
    }

    public PointLearn(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
    }
}

