/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui.changeable;

import com.tridium.lonworks.datatypes.BChangeNvTypeParameter;
import com.tridium.lonworks.util.LonStringUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.control.BControlPoint;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.lonworks.BConfigParameter;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonComponent;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BNetworkConfig;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonConfigScope;
import javax.baja.lonworks.enums.BLonElementType;
import javax.baja.lonworks.enums.BLonNvTypeCategoryEnum;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonElementQualifiers;
import javax.baja.lonworks.londata.LonFacetsUtil;
import javax.baja.lonworks.util.ScptUtil;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BChangeableNvManager
extends BWbComponentView {
    public static final Type TYPE;
    public static final UiLexicon lexicon;
    private BLonDevice dev;
    private BTable nvTable = new BTable();
    private NvTableModel nvTableModel;
    private BButton updateBtn;
    private BButton editBtn;
    private BJobBar jobBar;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$changeable$BChangeableNvManager;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.dev = (BLonDevice)bObject;
        this.registerForComponentEvents((BComponent)this.dev, 4);
        Command command = new Command((BWidget)this.getWbShell(), BChangeableNvManager.lexicon.module, "change.editType"){

            public final CommandArtifact doInvoke() {
                BChangeableNvManager.this.editType();
                return null;
            }
        };
        this.editBtn = new BButton(command, true, true);
        this.editBtn.setEnabled(false);
        Command command2 = new Command((BWidget)this.getWbShell(), BChangeableNvManager.lexicon.module, "change.updateType"){

            public final CommandArtifact doInvoke() {
                BChangeableNvManager.this.updateType();
                return null;
            }
        };
        this.updateBtn = new BButton(command2, true, true);
        this.updateBtn.setEnabled(true);
        this.nvTableModel = new NvTableModel();
        this.nvTable.setModel((TableModel)this.nvTableModel);
        this.nvTable.setMultipleSelection(true);
        BFlowPane bFlowPane = new BFlowPane(BHalign.center);
        bFlowPane.add("editType", (BValue)this.editBtn);
        bFlowPane.add("updateType", (BValue)this.updateBtn);
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5, (double)0.0, (double)5));
        bBorderPane.setFill(Theme.widget().getWindowBackground());
        bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)bFlowPane);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)BTitlePane.makePane((String)lexicon.getText("changeableNv"), (BTable)this.nvTable));
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bEdgePane));
        bEdgePane2.setTop((BWidget)bBorderPane);
        this.setContent((BWidget)bEdgePane2);
        this.refreshTable();
    }

    private final void refreshTable() {
        this.nvTableModel.removeAllRows();
        this.dev.refreshNvList();
        BINetworkVariable[] bINetworkVariableArray = this.dev.getNetworkVariables();
        int n = 0;
        while (n < bINetworkVariableArray.length) {
            BNetworkVariable bNetworkVariable;
            if (bINetworkVariableArray[n] != null && bINetworkVariableArray[n].isNetworkVariable() && (bNetworkVariable = (BNetworkVariable)bINetworkVariableArray[n]).getNvProps().getChangeableType()) {
                this.nvTableModel.addRow(bNetworkVariable.getDisplayName(null), n, BLonSnvtType.make(bNetworkVariable.getNvProps().getSnvtType()));
            }
            ++n;
        }
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        if (bComponentEvent.getId() == 0 && bComponentEvent.getSlot() == BNetworkVariable.nvProps && ((BNvProps)bComponentEvent.getValue()).getChangeableType() || bComponentEvent.getId() == 5 && bComponentEvent.getSlot() == BDynamicDevice.dynamicOpComplete) {
            this.refreshTable();
        }
    }

    private final void updateType() {
        int[] nArray;
        TableSelection tableSelection = this.nvTable.getSelection();
        if (tableSelection.getRows().length > 0) {
            int[] nArray2 = tableSelection.getRows();
            nArray = new int[nArray2.length];
            int n = 0;
            while (n < nArray2.length) {
                nArray[n] = this.nvTableModel.getEntry((int)nArray2[n]).nvIndex;
                ++n;
            }
        } else {
            int n = this.nvTableModel.getRowCount();
            nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.nvTableModel.getEntry((int)n2).nvIndex;
                ++n2;
            }
        }
        this.changeNvType(this.dev, nArray, null, 0, 0, true);
    }

    private final void editType() {
        BLonComponent bLonComponent;
        TableSelection tableSelection = this.nvTable.getSelection();
        if (tableSelection.getRows().length < 1) {
            return;
        }
        int[] nArray = tableSelection.getRows();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add("label", (BValue)new BLabel(lexicon.getText("change.editTypeText")));
        BListDropDown bListDropDown = new BListDropDown();
        BList bList = bListDropDown.getList();
        BLonSnvtType bLonSnvtType = this.nvTableModel.getEntry((int)nArray[0]).nvType;
        String string = this.fillNvTypeList(bList, bLonSnvtType);
        bListDropDown.setSelectedItem((Object)string);
        bGridPane.add("comboBox", (BValue)bListDropDown);
        bGridPane.add(null, (BValue)new BWidget());
        int n = BDialog.open((BWidget)this, (String)lexicon.getText("change.editType.description"), (Object)bGridPane, (int)3);
        if (n == 2) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = this.nvTableModel.getEntry((int)nArray[n2]).nvIndex;
            ++n2;
        }
        n2 = this.getSnvtTypeFromDisplayString((String)bList.getSelectedItem());
        BLonData bLonData = SnvtUtil.getLonData(n2);
        int n3 = bLonData.getByteLength();
        int n4 = 0;
        while (n4 < nArray2.length) {
            bLonComponent = ScptUtil.findScptForNv(this.dev, nArray2[n4], 255);
            int n5 = 10;
            if (bLonComponent != null && (n5 = bLonComponent.getLonInt("maxNVLength")) < n3) {
                BDialog.error((BWidget)this, (String)"Max Length Error", (Object)"Length of selected type exceeds max.", (String)("Selected type has length of " + n3 + ".\nMaximum length specified in " + bLonComponent.getDisplayName(null) + " = " + n5 + '.'));
                return;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray2.length) {
            bLonComponent = this.dev.getNetworkVariable(nArray2[n4]);
            if (this.checkLinks((BNetworkVariable)bLonComponent)) {
                return;
            }
            if (this.checkProxyPoints(bLonComponent)) {
                return;
            }
            BLonComponent[] bLonComponentArray = ScptUtil.findInheritedConfigsForNv(this.dev, nArray2[n4]);
            int n6 = 0;
            while (n6 < bLonComponentArray.length) {
                if (this.checkProxyPoints(bLonComponentArray[n6])) {
                    return;
                }
                ++n6;
            }
            ++n4;
        }
        this.changeNvType(this.dev, nArray2, bLonData, 0, n2, false);
    }

    private final boolean checkLinks(BNetworkVariable bNetworkVariable) {
        BLink[] bLinkArray = this.dev.getLinks((Slot)bNetworkVariable.getPropertyInParent());
        if (bLinkArray.length > 0) {
            int n = BDialog.open((BWidget)this, (String)"Linked Nv", (Object)(bNetworkVariable.getDisplayName(null) + " is linked.\n \nPress OK to delete links.\n"), (int)3, (BImage)BDialog.WARNING_ICON);
            if (n != 1) {
                return true;
            }
            int n2 = 0;
            while (n2 < bLinkArray.length) {
                this.dev.remove((BComplex)bLinkArray[n2]);
                ++n2;
            }
        }
        return false;
    }

    private final boolean checkProxyPoints(BLonComponent bLonComponent) {
        BControlPoint[] bControlPointArray = this.dev.getLonProxies(bLonComponent);
        if (bControlPointArray.length > 0) {
            String string = bLonComponent.isNetworkVariable() ? "Nv has proxies " : "Inherited cp has proxies";
            int n = BDialog.open((BWidget)this, (String)string, (Object)(bLonComponent.getDisplayName(null) + " has proxies.\n \nPress OK to delete proxies.\n"), (int)3, (BImage)BDialog.WARNING_ICON);
            if (n != 1) {
                return true;
            }
            int n2 = 0;
            while (n2 < bControlPointArray.length) {
                ((BComponent)bControlPointArray[n2].getParent()).remove((BComplex)bControlPointArray[n2]);
                ++n2;
            }
        }
        return false;
    }

    private final void changeNvType(BLonDevice bLonDevice, int[] nArray, BLonData bLonData, int n, int n2, boolean bl) {
        Action action = bLonDevice.getAction("ChangeNvTypeAction");
        if (action == null) {
            throw new RuntimeException("No ChangeNvType action on dev " + bLonDevice.getDisplayName(null));
        }
        String[] stringArray = new String[nArray.length];
        BNetworkConfig[] bNetworkConfigArray = bLonDevice.getNetworkConfigs();
        BConfigParameter[] bConfigParameterArray = bLonDevice.getConfigParameters();
        int n3 = 0;
        while (n3 < nArray.length) {
            BStruct bStruct;
            BLonComponent bLonComponent;
            int n4 = nArray[n3];
            BLonComponent bLonComponent2 = null;
            int n5 = 0;
            while (n5 < bNetworkConfigArray.length) {
                bLonComponent = bNetworkConfigArray[n5];
                bStruct = ((BNetworkConfig)bLonComponent).getNcProps();
                if (bStruct.getScope().equals((Object)BLonConfigScope.nv) && ScptUtil.doesSelectContain(n4, bStruct.getSelect()) && bStruct.getConfigIndex() == 254) {
                    bLonComponent2 = bLonComponent;
                    break;
                }
                ++n5;
            }
            if (bLonComponent2 == null) {
                n5 = 0;
                while (n5 < bConfigParameterArray.length) {
                    bLonComponent = bConfigParameterArray[n5];
                    bStruct = ((BConfigParameter)bLonComponent).getConfigProps();
                    if (bStruct.getScope().equals((Object)BLonConfigScope.nv) && ScptUtil.doesSelectContain(n4, bStruct.getSelect()) && bStruct.getConfigIndex() == 254) {
                        bLonComponent2 = bLonComponent;
                        break;
                    }
                    ++n5;
                }
            }
            if (bLonComponent2 == null) {
                throw new RuntimeException("No NvType Scpt for nv" + n4);
            }
            stringArray[n3] = bLonComponent2.getName();
            ++n3;
        }
        BChangeNvTypeParameter bChangeNvTypeParameter = new BChangeNvTypeParameter();
        bChangeNvTypeParameter.setNvIndex(LonStringUtil.toString(nArray));
        bChangeNvTypeParameter.setNvTypeScpt(LonStringUtil.toString(stringArray));
        bChangeNvTypeParameter.setUpdate(bl);
        if (!bl) {
            bChangeNvTypeParameter.setTypeScope(n);
            bChangeNvTypeParameter.setTypeIndex(n2);
            BChangeableNvManager.updateNvTypePara(bChangeNvTypeParameter, bLonData);
        }
        BOrd bOrd = (BOrd)bLonDevice.invoke(action, (BValue)bChangeNvTypeParameter);
        this.setJob(bOrd);
    }

    public static void updateNvTypePara(BChangeNvTypeParameter bChangeNvTypeParameter, BLonData bLonData) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        BLonNvTypeCategoryEnum bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatNul;
        Property[] propertyArray = bLonData.getPropertiesArray();
        if (propertyArray[0].getType().is(BLonData.TYPE) || propertyArray.length > 1) {
            bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatStruct;
        } else {
            BFacets bFacets = propertyArray[0].getFacets();
            BLonElementQualifiers bLonElementQualifiers = LonFacetsUtil.getQualifiers(bFacets);
            BLonElementType bLonElementType = bLonElementQualifiers.getElemtype();
            switch (bLonElementType.getOrdinal()) {
                case 0: 
                case 2: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatUnsignedChar;
                    break;
                }
                case 1: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatSignedChar;
                    break;
                }
                case 3: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatSignedLong;
                    break;
                }
                case 4: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatUnsignedLong;
                    break;
                }
                case 5: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatSignedQuad;
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatBitfield;
                    break;
                }
                case 6: 
                case 7: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatEnum;
                    break;
                }
                case 8: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatFloat;
                    break;
                }
                case 14: 
                case 15: {
                    bLonNvTypeCategoryEnum = BLonNvTypeCategoryEnum.nvtCatArray;
                    break;
                }
            }
            if (bLonElementQualifiers.getResolution() != 1.0f) {
                double d = Math.log(bLonElementQualifiers.getResolution()) / Math.log(10.0);
                n2 = (int)Math.floor(d);
                n = (int)Math.rint(Math.pow(10.0, d - (double)n2));
            }
            if (bLonElementQualifiers.hasOffset()) {
                n3 = (int)bLonElementQualifiers.getOffset();
            }
        }
        bChangeNvTypeParameter.setTypeCategory(bLonNvTypeCategoryEnum.getOrdinal());
        bChangeNvTypeParameter.setTypeLength(bLonData.getByteLength());
        bChangeNvTypeParameter.setScalingFactorA(n);
        bChangeNvTypeParameter.setScalingFactorB(n2);
        bChangeNvTypeParameter.setScalingFactorC(n3);
    }

    private final void setJob(BOrd bOrd) {
        try {
            BComponent bComponent = (BComponent)this.getCurrentValue();
            bComponent.getComponentSpace().sync();
            BJob bJob = (BJob)bOrd.get((BObject)bComponent);
            this.registerForComponentEvents((BComponent)bJob);
            this.jobBar.load(bJob);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private final String fillNvTypeList(BList bList, BLonSnvtType bLonSnvtType) {
        BEnumRange bEnumRange = BLonSnvtType.SnvtXxx.getRange();
        int[] nArray = bEnumRange.getOrdinals();
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BChangeableNvManager.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz, nArray.length);
        String string = null;
        int n = 0;
        while (n < nArray.length) {
            String string2 = bEnumRange.getTag(nArray[n]) + ' ' + nArray[n];
            array.add((Object)string2);
            if (bEnumRange.get(nArray[n], false) == bLonSnvtType) {
                string = string2;
            }
            ++n;
        }
        array = array.sort();
        String[] stringArray = (String[])array.array();
        int n2 = 0;
        while (n2 < stringArray.length) {
            bList.addItem((Object)stringArray[n2]);
            ++n2;
        }
        return string;
    }

    private final int getSnvtTypeFromDisplayString(String string) {
        return Integer.parseInt(string.substring(string.indexOf(32) + 1));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BChangeableNvManager() {
        this.nvTable.setController((TableController)new Controller());
        this.autoRegisterForComponentEvents = false;
    }

    static {
        Class clazz = class$com$tridium$lonworks$ui$changeable$BChangeableNvManager;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$ui$changeable$BChangeableNvManager = BChangeableNvManager.class("[Lcom.tridium.lonworks.ui.changeable.BChangeableNvManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$lonworks$ui$changeable$BChangeableNvManager;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$lonworks$ui$changeable$BChangeableNvManager = BChangeableNvManager.class("[Lcom.tridium.lonworks.ui.changeable.BChangeableNvManager;", false);
        }
        lexicon = new UiLexicon(clazz2);
    }

    static class NvTableModel
    extends DefaultTableModel {
        public void addRow(String string, int n, BLonSnvtType bLonSnvtType) {
            Object[] objectArray = new Object[]{string, new Integer(n), bLonSnvtType};
            this.addRow(objectArray);
        }

        public NvType getEntry(int n) {
            NvType nvType = new NvType();
            nvType.nvName = (String)this.getValueAt(n, 0);
            nvType.nvIndex = (Integer)this.getValueAt(n, 1);
            nvType.nvType = (BLonSnvtType)((Object)this.getValueAt(n, 2));
            return nvType;
        }

        public void setEntry(int n, NvType nvType) {
            this.set(n, 0, nvType.nvName);
            this.set(n, 1, new Integer(nvType.nvIndex));
            this.set(n, 2, (Object)nvType.nvType);
        }

        public NvTableModel() {
            this(new String[]{"nvName", "nvIndex", "type"});
        }

        private NvTableModel(String[] stringArray) {
            super(stringArray);
        }
    }

    static class NvType {
        public String nvName;
        public int nvIndex;
        public BLonSnvtType nvType;

        NvType() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        public void focusGained(BFocusEvent bFocusEvent) {
            this.checkEdit();
            this.getTable().repaint();
        }

        protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellReleased(bMouseEvent, n, n2);
            this.checkEdit();
            this.getTable().repaint();
        }

        protected void backgroundReleased(BMouseEvent bMouseEvent) {
            super.backgroundReleased(bMouseEvent);
            BChangeableNvManager.this.editBtn.setEnabled(false);
        }

        private final void checkEdit() {
            BTable bTable = this.getTable();
            TableSelection tableSelection = bTable.getSelection();
            boolean bl = false;
            if (tableSelection.getRows().length > 0) {
                bl = true;
            }
            boolean bl2 = bl;
            BChangeableNvManager.this.editBtn.setEnabled(bl2);
        }

        Controller() {
        }
    }
}

