/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.ui;

import com.tridium.workbench.fieldeditors.BFloatFE;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.baja.lonworks.londata.BLonBigInteger;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonLong;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.units.BUnit;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonBigIntegerFE
extends BWbFieldEditor {
    public static final Type TYPE;
    private static final String NAN = "nan";
    private BTextField field;
    private BLabel postlabel;
    private BLabel prelabel;
    private Values values;
    static /* synthetic */ Class class$com$tridium$lonworks$ui$BLonBigIntegerFE;

    public Type getType() {
        return TYPE;
    }

    protected void doSetReadonly(boolean bl) {
        this.field.setEditable(bl ^ true);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        if (bObject instanceof BLonInteger) {
            this.values = new IntValues(context);
        } else if (bObject instanceof BLonLong) {
            this.values = new LongValues(context);
        } else if (bObject instanceof BLonBigInteger) {
            this.values = new BigIntegerValues(context);
        }
        this.field.setVisibleColumns(this.values.width);
        String string = this.values.toString(bObject);
        this.field.setText(string);
        this.prelabel.setText(this.values.premeta);
        this.postlabel.setText(this.values.postmeta);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        String string = this.field.getText();
        BValue bValue = this.values.fromString(string);
        this.field.setText(this.values.toString((BObject)bValue));
        return bValue;
    }

    static /* synthetic */ String access$0() {
        return NAN;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.field = new BTextField("");
        this.postlabel = new BLabel("");
        this.prelabel = new BLabel("");
    }

    public BLonBigIntegerFE() {
        this.this();
        this.field.setController((TextController)new BFloatFE.Controller());
        BGridPane bGridPane = new BGridPane(3);
        bGridPane.add("prelabel", (BValue)this.prelabel);
        bGridPane.add("field", (BValue)this.field);
        bGridPane.add("postlabel", (BValue)this.postlabel);
        this.setContent((BWidget)bGridPane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    static {
        Class clazz = class$com$tridium$lonworks$ui$BLonBigIntegerFE;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$ui$BLonBigIntegerFE = BLonBigIntegerFE.class("[Lcom.tridium.lonworks.ui.BLonBigIntegerFE;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class IntValues
    extends Values {
        String toString(BObject bObject) {
            int n = ((BLonInteger)bObject).getInt();
            if (this.invalid != null && n == this.invalid.getInt()) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(n);
        }

        BValue fromString(String string) throws CannotSaveException {
            int n;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(string)) {
                    if (this.invalid == null) {
                        throw new CannotSaveException(string + " is not valid.");
                    }
                    return BLonInteger.make(this.invalid.getInt());
                }
                String string2 = string.startsWith("+") ? string.substring(1) : string;
                ParsePosition parsePosition = new ParsePosition(0);
                n = this.fromStringFormat.parse(string2, parsePosition).intValue();
                if (parsePosition.getIndex() != string2.length()) {
                    throw new CannotSaveException("Invalid format: " + string);
                }
            }
            catch (CannotSaveException cannotSaveException) {
                throw cannotSaveException;
            }
            catch (Exception exception) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            if (n < this.min.getInt()) {
                throw new CannotSaveException(string + " < " + this.min.toString() + ' ' + this.range);
            }
            if (n > this.max.getInt()) {
                throw new CannotSaveException(string + " > " + this.max.toString() + ' ' + this.range);
            }
            return BLonInteger.make(n);
        }

        public IntValues(Context context) {
            super(context);
            if (this.width == 0) {
                this.width = 14;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LongValues
    extends Values {
        String toString(BObject bObject) {
            long l = ((BLonLong)bObject).getLong();
            if (this.invalid != null && l == this.invalid.getLong()) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(l);
        }

        BValue fromString(String string) throws CannotSaveException {
            long l;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(string)) {
                    if (this.invalid == null) {
                        throw new CannotSaveException(string + " is not valid.");
                    }
                    return BLonLong.make(this.invalid.getLong(), true);
                }
                String string2 = string.startsWith("+") ? string.substring(1) : string;
                ParsePosition parsePosition = new ParsePosition(0);
                l = this.fromStringFormat.parse(string2, parsePosition).longValue();
                if (parsePosition.getIndex() != string2.length()) {
                    throw new CannotSaveException("Invalid format: " + string);
                }
            }
            catch (CannotSaveException cannotSaveException) {
                throw cannotSaveException;
            }
            catch (Exception exception) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            if (l < this.min.getLong()) {
                throw new CannotSaveException(string + " < " + this.min.toString() + ' ' + this.range);
            }
            if (l > this.max.getLong()) {
                throw new CannotSaveException(string + " > " + this.max.toString() + ' ' + this.range);
            }
            return BLonLong.make(l, false);
        }

        public LongValues(Context context) {
            super(context);
            if (this.width == 0) {
                this.width = 20;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BigIntegerValues
    extends Values {
        BigInteger biMin;
        BigInteger biMax;
        BigInteger biInvalid;

        String toString(BObject bObject) {
            BigInteger bigInteger = ((BLonBigInteger)bObject).getBigInteger();
            if (this.biInvalid != null && bigInteger.compareTo(this.biInvalid) == 0) {
                return BLonBigIntegerFE.NAN;
            }
            return this.toStringFormat.format(bigInteger);
        }

        BValue fromString(String string) throws CannotSaveException {
            BigInteger bigInteger;
            try {
                if (BLonBigIntegerFE.NAN.equalsIgnoreCase(string)) {
                    if (this.biInvalid == null) {
                        throw new CannotSaveException(string + " is not valid.");
                    }
                    return BLonBigInteger.make(BigInteger.valueOf(this.invalid.getLong()), true);
                }
                String string2 = string.startsWith("+") ? string.substring(1) : string;
                ParsePosition parsePosition = new ParsePosition(0);
                bigInteger = BigInteger.valueOf(this.fromStringFormat.parse(string2, parsePosition).longValue());
                if (parsePosition.getIndex() != string2.length()) {
                    throw new CannotSaveException("Invalid format: " + string);
                }
            }
            catch (CannotSaveException cannotSaveException) {
                throw cannotSaveException;
            }
            catch (Exception exception) {
                throw new CannotSaveException("Invalid format: " + string);
            }
            if (bigInteger.compareTo(this.biMin) < 0) {
                throw new CannotSaveException(string + " < " + this.biMin.toString() + ' ' + this.range);
            }
            if (bigInteger.compareTo(this.biMax) > 0) {
                throw new CannotSaveException(string + " > " + this.biMax.toString() + ' ' + this.range);
            }
            return BLonBigInteger.make(bigInteger, false);
        }

        public BigIntegerValues(Context context) {
            super(context);
            if (this.width == 0) {
                this.width = 20;
            }
            this.biMin = BigInteger.valueOf(this.min.getLong());
            this.biMax = BigInteger.valueOf(this.max.getLong());
            this.biInvalid = this.invalid != null ? BigInteger.valueOf(this.invalid.getLong()) : null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Values {
        final boolean showSeparators;
        final boolean forceSign;
        final DecimalFormat toStringFormat;
        final DecimalFormat fromStringFormat;
        BNumber min;
        BNumber max;
        BNumber invalid;
        String range;
        String postmeta;
        String premeta;
        int width;

        abstract String toString(BObject var1);

        abstract BValue fromString(String var1) throws CannotSaveException;

        private final /* synthetic */ void this() {
            this.min = null;
            this.max = null;
            this.invalid = null;
            this.range = "";
            this.postmeta = "";
            this.premeta = "";
            this.width = 0;
        }

        public Values(Context context) {
            BInteger bInteger;
            this.this();
            BFacets bFacets = context == null ? BFacets.DEFAULT : context.getFacets();
            BUnit bUnit = (BUnit)context.getFacet("units");
            if (bUnit != null && !bUnit.isNull()) {
                if (bUnit.getIsPrefix()) {
                    this.premeta = bUnit.getSymbol();
                } else {
                    this.postmeta = bUnit.getSymbol();
                }
            }
            if ((bInteger = (BInteger)context.getFacet("fieldWidth")) != null) {
                this.width = bInteger.getInt();
            }
            this.showSeparators = bFacets.getb("showSeparators", false);
            this.forceSign = bFacets.getb("forceSign", false);
            String string = null;
            string = this.showSeparators ? "#,##0" : "#0";
            this.fromStringFormat = new DecimalFormat(string);
            string = this.forceSign ? "+" + string + ";-" + string : string;
            this.toStringFormat = new DecimalFormat(string);
            this.min = (BNumber)context.getFacet("min");
            this.max = (BNumber)context.getFacet("max");
            this.invalid = (BNumber)context.getFacet("invld");
            String string2 = this.min == null ? "min" : this.min.toString();
            String string3 = this.max == null ? "max" : this.max.toString();
            this.range = "[" + string2 + " - " + string3 + ']';
            if (this.postmeta.length() > 0) {
                this.postmeta = this.postmeta + ' ';
            }
            this.postmeta = this.postmeta + this.range;
        }
    }
}

