/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.CatalogFile;
import com.tridium.lonworks.resource.FptFile;
import com.tridium.lonworks.resource.LanguageFile;
import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.resource.TypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;

public class ResourceFileUtil {
    public static ResourceFile getResourceFile(String string) throws IOException {
        String string2 = string.replace('\\', '/');
        BIFile bIFile = (BIFile)BOrd.make((String)("file:/" + string2)).resolve().get();
        return ResourceFileUtil.getResourceFile(bIFile);
    }

    public static ResourceFile getResourceFile(File file) throws IOException {
        return ResourceFileUtil.getResourceFile(new FileInputStream(file), file.getName());
    }

    public static ResourceFile getResourceFile(BIFile bIFile) throws IOException {
        return ResourceFileUtil.getResourceFile(bIFile.getInputStream(), bIFile.getFileName());
    }

    private static final ResourceFile getResourceFile(InputStream inputStream, String string) throws IOException {
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)inputStream.read();
            ++n2;
        }
        return ResourceFileUtil.getResourceFile(new ResFileInputStream(byArray), string);
    }

    private static final ResourceFile getResourceFile(ResFileInputStream resFileInputStream, String string) throws IOException {
        ResourceFile resourceFile;
        int n;
        resFileInputStream.readCharacter();
        resFileInputStream.fileType = n = ResourceFileUtil.typeStringToInt(resFileInputStream.readString(3));
        resFileInputStream.seek(0L);
        switch (n) {
            case 1: {
                resourceFile = new CatalogFile();
                break;
            }
            case 2: {
                resourceFile = new LanguageFile();
                break;
            }
            case 3: {
                resourceFile = new TypeFile();
                break;
            }
            case 4: {
                resourceFile = new FptFile();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + n);
            }
        }
        resourceFile.fileName = string;
        try {
            resourceFile.parse(resFileInputStream);
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            throwable.printStackTrace();
        }
        return resourceFile;
    }

    public static int typeStringToInt(String string) {
        if (string.equalsIgnoreCase("CAT")) {
            return 1;
        }
        if (string.equalsIgnoreCase("RES")) {
            return 2;
        }
        if (string.equalsIgnoreCase("TYP")) {
            return 3;
        }
        if (string.equalsIgnoreCase("FPT")) {
            return 4;
        }
        if (string.equalsIgnoreCase("FMT")) {
            return 5;
        }
        return 0;
    }

    public static String typeIntToString(int n) {
        switch (n) {
            case 1: {
                return "Catalog";
            }
            case 2: {
                return "Lanquage Resource";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "FPT";
            }
            case 5: {
                return "Format";
            }
        }
        return "Unknown file type";
    }
}

