/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFileUtil;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ResourceFile {
    private static final int MAX_FILE_INFO_STRING = 256;
    private static final int SIZE_DESC_STRING = 252;
    private static final int SIZE_CRE_STRING = 256;
    private static final int SIZE_URL_STRING = 256;
    protected static final int NUM_SCOPES = 7;
    protected static final int NUM_PROG_ID_BYTES = 8;
    public static final int LDRF_CATALOG = 1;
    public static final int LDRF_LANG_RESOURCE = 2;
    public static final int LDRF_TYPE = 3;
    public static final int LDRF_FPT = 4;
    public static final int LDRF_FORMAT = 5;
    public boolean userFlag;
    public int fileType;
    String desc;
    String creator;
    String sURL;
    int resDescScope;
    int resDescIndex;
    int resCreScope;
    int resCreIndex;
    int majorDataVer;
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
    int minorDataVer;
    int majorFmtVer;
    int minorFmtVer;
    int headerSize;
    int headerCRC;
    int dataAddress;
    int dataSize;
    public String fileName;

    public abstract void parse(ResFileInputStream var1) throws IOException;

    public void parseHeader(ResFileInputStream resFileInputStream) throws IOException {
        boolean bl = false;
        if (resFileInputStream.readCharacter() == 'U') {
            bl = true;
        }
        this.userFlag = bl;
        resFileInputStream.fileType = this.fileType = ResourceFileUtil.typeStringToInt(resFileInputStream.readString(3));
        this.desc = resFileInputStream.readString(252);
        this.creator = resFileInputStream.readString(256);
        this.sURL = resFileInputStream.readString(256);
        this.resDescScope = resFileInputStream.readUnsigned8();
        this.resDescIndex = resFileInputStream.readUnsigned24();
        this.resCreScope = resFileInputStream.readUnsigned8();
        this.resCreIndex = resFileInputStream.readUnsigned24();
        this.majorDataVer = resFileInputStream.readUnsigned16();
        this.year = resFileInputStream.readUnsigned16();
        this.month = resFileInputStream.readUnsigned8();
        this.day = resFileInputStream.readUnsigned8();
        this.hour = resFileInputStream.readUnsigned8();
        this.minute = resFileInputStream.readUnsigned8();
        this.second = resFileInputStream.readUnsigned8();
        this.minorDataVer = resFileInputStream.readUnsigned8();
        resFileInputStream.majorFmtVer = this.majorFmtVer = resFileInputStream.readUnsigned8();
        this.verifyVersion();
        resFileInputStream.minorFmtVer = this.minorFmtVer = resFileInputStream.readUnsigned8();
        this.headerSize = this.fileType == 3 && this.majorFmtVer >= 3 || this.fileType != 3 && this.majorFmtVer >= 2 ? resFileInputStream.readSigned32() : resFileInputStream.readUnsigned16();
        this.headerCRC = resFileInputStream.readUnsigned16();
        this.dataAddress = resFileInputStream.readSigned32();
        this.dataSize = resFileInputStream.readSigned32();
    }

    private final void verifyVersion() throws IOException {
        int n = 0;
        int n2 = 0;
        switch (this.fileType) {
            case 1: {
                n = 1;
                n2 = 2;
                break;
            }
            case 3: {
                n = 2;
                n2 = 6;
                break;
            }
            case 2: {
                n = 1;
                n2 = 3;
                break;
            }
            case 4: {
                n = 1;
                n2 = 5;
                break;
            }
        }
        if (this.majorFmtVer >= n && this.majorFmtVer <= n2) {
            return;
        }
        throw new IOException("Unsupported format version " + this.majorFmtVer + " for resournce type " + ResourceFileUtil.typeIntToString(this.fileType));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("userFlag      = ").append(this.userFlag ? "User" : "Standard").append("\n");
        stringBuffer.append("fileType      = ").append(ResourceFileUtil.typeIntToString(this.fileType)).append("\n");
        stringBuffer.append("desc          = ").append(this.desc).append("\n");
        stringBuffer.append("creator       = ").append(this.creator).append("\n");
        stringBuffer.append("sURL          = ").append(this.sURL).append("\n");
        stringBuffer.append("resDescScope  = ").append(this.resDescScope).append(',').append(this.resDescIndex).append("\n");
        stringBuffer.append("resCreScope   = ").append(this.resCreScope).append(',').append(this.resCreIndex).append("\n");
        stringBuffer.append("DataVer       = ").append(this.majorDataVer).append('.').append(this.minorDataVer).append("\n");
        stringBuffer.append("FmtVer        = ").append(this.majorFmtVer).append('.').append(this.minorFmtVer).append("\n");
        stringBuffer.append("Data          = ").append(this.month).append('/').append(this.day).append('/').append(this.year).append(' ').append(this.hour).append('.').append(this.minute).append(':').append(this.second).append("\n");
        stringBuffer.append("headerSize    = ").append(this.headerSize);
        stringBuffer.append("  headerCRC   = ").append(this.headerCRC).append("\n");
        stringBuffer.append("dataAddress   = ").append(this.dataAddress);
        stringBuffer.append("  dataSize    = ").append(this.dataSize).append("\n");
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.fileName = "";
    }

    public ResourceFile() {
        this.this();
    }
}

