/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResourceFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ResFileInputStream
extends ByteArrayInputStream {
    int majorFmtVer;
    int minorFmtVer;
    int fileType;

    public synchronized int read() {
        int n = super.read();
        return n;
    }

    public boolean readBool() throws IOException {
        return this.read() != 0;
    }

    public int readSigned32() throws IOException {
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        int n3 = this.read() & 0xFF;
        int n4 = this.read() & 0xFF;
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public long readUnsigned32() throws IOException {
        long l = 0L;
        int n = 0;
        while (n < 4) {
            l <<= 8;
            l |= (long)(this.read() & 0xFF);
            ++n;
        }
        return l;
    }

    public long readSigned64() throws IOException {
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l <<= 8;
            l |= (long)(this.read() & 0xFF);
            ++n;
        }
        return l;
    }

    public int readDirectory(ResourceFile resourceFile) throws IOException {
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        int n3 = this.read() & 0xFF;
        int n4 = this.read() & 0xFF;
        if (this.fileType == 3 && this.majorFmtVer >= 3 || this.fileType != 3 && this.majorFmtVer >= 2) {
            return n << 24 | n2 << 16 | n3 << 8 | n4;
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public int readUnsigned24() throws IOException {
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        int n3 = this.read() & 0xFF;
        return n << 16 | n2 << 8 | n3;
    }

    public int readUnsigned16() throws IOException {
        int n = this.read() & 0xFF;
        int n2 = this.read() & 0xFF;
        return n << 8 | n2;
    }

    public int readSigned16() throws IOException {
        int n = this.read();
        int n2 = this.read() & 0xFF;
        boolean bl = false;
        int n3 = 0;
        if ((n & 0x80) != 0) {
            bl = true;
        }
        n3 = n << 8 | n2;
        if (bl) {
            return n3 | 0xFFFF0000;
        }
        return n3;
    }

    public int readSigned8() throws IOException {
        int n = this.read();
        if ((n & 0x80) != 0) {
            return n | 0xFFFFFF00;
        }
        return n;
    }

    public int readUnsigned8() throws IOException {
        return this.read() & 0xFF;
    }

    public char readCharacter() throws IOException {
        return (char)this.read();
    }

    public String readString(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = (char)this.read();
            if (!bl) {
                if (c == '\u0000') {
                    bl = true;
                } else {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String readLString() throws IOException {
        return this.readString(this.readUnsigned8());
    }

    public byte[] readByteArray(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)this.read();
            ++n2;
        }
        return byArray;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readSigned32());
    }

    public double readDouble() throws IOException {
        double d = Double.longBitsToDouble(this.readSigned64());
        return d;
    }

    public int getCurrentPosition() {
        return this.pos;
    }

    public int swap16(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        return n2 << 8 | n3;
    }

    public void seek(long l) throws IOException {
        this.pos = (int)l;
    }

    public ResFileInputStream(byte[] byArray) {
        super(byArray);
    }
}

