/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.IOException;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LanguageFile
extends ResourceFile {
    public byte[] refId;
    public int scope;
    public int locale;
    public int numStrings;
    public int numEmptyStrings;
    public int[] dirStrings;
    public LangRec[] langRecs;

    public void parse(ResFileInputStream resFileInputStream) throws IOException {
        this.parseHeader(resFileInputStream);
        this.refId = resFileInputStream.readByteArray(8);
        this.scope = resFileInputStream.readUnsigned8();
        this.locale = resFileInputStream.readSigned32();
        this.numStrings = resFileInputStream.readUnsigned24();
        if (this.majorFmtVer > 2) {
            this.numEmptyStrings = resFileInputStream.readUnsigned24();
        }
        this.dirStrings = new int[this.numStrings];
        int n = 0;
        while (n < this.numStrings) {
            this.dirStrings[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.langRecs = new LangRec[this.numStrings];
        n = 0;
        while (n < this.numStrings) {
            resFileInputStream.seek(this.dirStrings[n]);
            this.langRecs[n] = new LangRec(resFileInputStream);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("refId      = ").append(LonByteArrayUtil.toString(this.refId)).append("\n");
        stringBuffer.append("scope      = ").append(this.scope).append("\n");
        stringBuffer.append("locale     = ").append(Integer.toString(this.locale, 16)).append("\n");
        stringBuffer.append("numStrings = ").append(this.numStrings).append("\n");
        int n = 0;
        while (n < this.numStrings) {
            this.langRecs[n].toString(stringBuffer);
            ++n;
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.numEmptyStrings = 0;
    }

    public LanguageFile() {
        this.this();
    }

    static class LangRec {
        public int index;
        public int recSize;
        public int hashCode;
        public int unicode;
        public String resStr;

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append(TextUtil.padRight((String)Integer.toString(this.index), (int)3)).append(" ");
            if (this.unicode != 0) {
                stringBuffer.append("[unicode = ").append(this.unicode).append("] ");
            }
            stringBuffer.append(this.resStr).append("\n");
        }

        LangRec(ResFileInputStream resFileInputStream) throws IOException {
            this.index = resFileInputStream.readUnsigned24();
            this.recSize = resFileInputStream.readUnsigned16();
            this.hashCode = resFileInputStream.readUnsigned16();
            this.unicode = resFileInputStream.readUnsigned8();
            int n = this.recSize - 2 - 1;
            this.resStr = resFileInputStream.readString(n);
        }
    }
}

