/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.resource;

import com.tridium.lonworks.resource.ResFileInputStream;
import com.tridium.lonworks.resource.ResourceFile;
import com.tridium.lonworks.util.LonByteArrayUtil;
import java.io.IOException;

public class CatalogFile
extends ResourceFile {
    int stale;
    int numDirec;
    int numLangFiles;
    int numTypeFiles;
    int numFPTFiles;
    int numFormatFiles;
    int[] dirDirec;
    int[] dirLangFiles;
    int[] dirTypeFiles;
    int[] dirFPTFiles;
    int[] dirFormatFiles;
    DirInfo[] dirs;
    FileInfo[] langFiles;
    FileInfo[] typeFiles;
    FileInfo[] fptFiles;
    FileInfo[] formatFiles;

    public void parse(ResFileInputStream resFileInputStream) throws IOException {
        this.parseHeader(resFileInputStream);
        this.stale = resFileInputStream.readUnsigned8();
        this.numDirec = resFileInputStream.readUnsigned16();
        this.numLangFiles = resFileInputStream.readUnsigned16();
        this.numTypeFiles = resFileInputStream.readUnsigned16();
        this.numFPTFiles = resFileInputStream.readUnsigned16();
        this.numFormatFiles = resFileInputStream.readUnsigned16();
        this.dirDirec = new int[this.numDirec];
        int n = 0;
        while (n < this.numDirec) {
            this.dirDirec[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.dirLangFiles = new int[this.numLangFiles];
        n = 0;
        while (n < this.numLangFiles) {
            this.dirLangFiles[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.dirTypeFiles = new int[this.numTypeFiles];
        n = 0;
        while (n < this.numTypeFiles) {
            this.dirTypeFiles[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.dirFPTFiles = new int[this.numFPTFiles];
        n = 0;
        while (n < this.numFPTFiles) {
            this.dirFPTFiles[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.dirFormatFiles = new int[this.numFormatFiles];
        n = 0;
        while (n < this.numFormatFiles) {
            this.dirFormatFiles[n] = resFileInputStream.readDirectory(this);
            ++n;
        }
        this.dirs = new DirInfo[this.numDirec];
        n = 0;
        while (n < this.numDirec) {
            resFileInputStream.seek(this.dirDirec[n]);
            this.dirs[n] = new DirInfo(resFileInputStream);
            ++n;
        }
        this.langFiles = new FileInfo[this.numLangFiles];
        n = 0;
        while (n < this.numLangFiles) {
            resFileInputStream.seek(this.dirLangFiles[n]);
            this.langFiles[n] = new FileInfo(resFileInputStream);
            ++n;
        }
        this.typeFiles = new FileInfo[this.numTypeFiles];
        n = 0;
        while (n < this.numTypeFiles) {
            resFileInputStream.seek(this.dirTypeFiles[n]);
            this.typeFiles[n] = new FileInfo(resFileInputStream);
            ++n;
        }
        this.fptFiles = new FileInfo[this.numFPTFiles];
        n = 0;
        while (n < this.numFPTFiles) {
            resFileInputStream.seek(this.dirFPTFiles[n]);
            this.fptFiles[n] = new FileInfo(resFileInputStream);
            ++n;
        }
        this.formatFiles = new FileInfo[this.numFormatFiles];
        n = 0;
        while (n < this.numFormatFiles) {
            resFileInputStream.seek(this.dirFormatFiles[n]);
            this.formatFiles[n] = new FileInfo(resFileInputStream);
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("stale          = ").append(this.stale).append("\n");
        stringBuffer.append("numDirec       = ").append(this.numDirec).append("\n");
        stringBuffer.append("numLangFiles   = ").append(this.numLangFiles).append("\n");
        stringBuffer.append("numTypeFiles   = ").append(this.numTypeFiles).append("\n");
        stringBuffer.append("numFPTFiles    = ").append(this.numFPTFiles).append("\n");
        stringBuffer.append("numFormatFiles = ").append(this.numFormatFiles).append("\n");
        int n = 0;
        while (n < this.numDirec) {
            stringBuffer.append("dirDirec[" + n + "]    = ").append(Integer.toString(this.dirDirec[n], 16)).append("\n");
            ++n;
        }
        n = 0;
        while (n < this.numLangFiles) {
            stringBuffer.append("dirLangFiles[" + n + "]    = ").append(Integer.toString(this.dirLangFiles[n], 16)).append("\n");
            ++n;
        }
        n = 0;
        while (n < this.numTypeFiles) {
            stringBuffer.append("dirTypeFiles[" + n + "]    = ").append(Integer.toString(this.dirTypeFiles[n], 16)).append("\n");
            ++n;
        }
        n = 0;
        while (n < this.numFPTFiles) {
            stringBuffer.append("dirFPTFiles[" + n + "]    = ").append(Integer.toString(this.dirFPTFiles[n], 16)).append("\n");
            ++n;
        }
        n = 0;
        while (n < this.numFormatFiles) {
            stringBuffer.append("dirFormatFiles[" + n + "]    = ").append(Integer.toString(this.dirFormatFiles[n], 16)).append("\n");
            ++n;
        }
        try {
            n = 0;
            while (n < this.numDirec) {
                this.dirs[n].toString(stringBuffer);
                ++n;
            }
            n = 0;
            while (n < this.numLangFiles) {
                this.langFiles[n].toString(stringBuffer);
                ++n;
            }
            n = 0;
            while (n < this.numTypeFiles) {
                this.typeFiles[n].toString(stringBuffer);
                ++n;
            }
            n = 0;
            while (n < this.numFPTFiles) {
                this.fptFiles[n].toString(stringBuffer);
                ++n;
            }
            n = 0;
            while (n < this.numFormatFiles) {
                this.formatFiles[n].toString(stringBuffer);
                ++n;
            }
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        return stringBuffer.toString();
    }

    static class DirInfo {
        public int index;
        public int recSize;
        public String dirPath;

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append("index        = ").append(this.index).append("\n");
            stringBuffer.append("recSize     = ").append(this.recSize).append("\n");
            stringBuffer.append("dirPath      = ").append(this.dirPath).append("\n");
        }

        DirInfo(ResFileInputStream resFileInputStream) throws IOException {
            this.index = resFileInputStream.readUnsigned16();
            this.recSize = resFileInputStream.readUnsigned16();
            this.dirPath = resFileInputStream.readLString();
        }
    }

    static class FileInfo {
        public int index;
        public int recSize;
        public int fileType;
        public int scope;
        public byte[] refId;
        public int direcIndex;
        public int majorDataVer;
        public int minorDataVer;
        public int locale;
        public String fileName;

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append("index        = ").append(this.index).append("\n");
            stringBuffer.append("recSize      = ").append(this.recSize).append("\n");
            stringBuffer.append("fileType     = ").append(this.fileType).append("\n");
            stringBuffer.append("scope        = ").append(this.scope).append("\n");
            stringBuffer.append("refId        = ").append(LonByteArrayUtil.toString(this.refId)).append("\n");
            stringBuffer.append("direcIndex   = ").append(this.direcIndex).append("\n");
            stringBuffer.append("DataVer maj.min = ").append(this.majorDataVer).append('.').append(this.minorDataVer).append("\n");
            stringBuffer.append("locale       = ").append(Integer.toString(this.locale, 16)).append("\n");
            stringBuffer.append("fileName     = ").append(this.fileName).append("\n");
        }

        FileInfo(ResFileInputStream resFileInputStream) throws IOException {
            this.index = resFileInputStream.readUnsigned16();
            this.recSize = resFileInputStream.readUnsigned16();
            this.fileType = resFileInputStream.readUnsigned8();
            this.scope = resFileInputStream.readUnsigned8();
            this.refId = resFileInputStream.readByteArray(8);
            this.direcIndex = resFileInputStream.readUnsigned16();
            this.majorDataVer = resFileInputStream.readUnsigned16();
            this.minorDataVer = resFileInputStream.readUnsigned8();
            this.locale = resFileInputStream.readSigned32();
            this.fileName = resFileInputStream.readLString();
        }
    }
}

