/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.NetMessageReceiver;
import com.tridium.lonworks.datatypes.BDeviceEntry;
import com.tridium.lonworks.datatypes.BLonRouteTable;
import com.tridium.lonworks.datatypes.BRouterEntry;
import com.tridium.lonworks.datatypes.BUtilCmdJob;
import com.tridium.lonworks.datatypes.BUtilitiesCommand;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.loncomm.NLonComm;
import com.tridium.lonworks.netmessages.ExEnumerateAddressResponse;
import com.tridium.lonworks.netmessages.ExEnumerateAliasResponse;
import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryAddrResponse;
import com.tridium.lonworks.netmessages.QueryAliasResponse;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.QueryStatusResponse;
import com.tridium.lonworks.netmessages.RouterStatusResponse;
import com.tridium.lonworks.netmessages.ServicePin;
import com.tridium.lonworks.netmgmt.BLonDiscoverJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.PTable;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import com.tridium.lonworks.netmgmt.VerifyChannels;
import com.tridium.lonworks.util.LonByteArrayUtil;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateFile;
import com.tridium.lonworks.util.selfdoc.ConfigTemplateRecord;
import com.tridium.lonworks.util.selfdoc.NvDoc;
import com.tridium.lonworks.util.selfdoc.ReadOnlyStruct;
import com.tridium.lonworks.util.selfdoc.SelfDoc;
import com.tridium.lonworks.util.selfdoc.SnvtStruct;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAuthenticationKey;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BLocal;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.datatypes.LonAddress;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonReceiveTimer;
import javax.baja.lonworks.enums.BLonRepeatTimer;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.util.LonFile;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.util.SortUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LonUtilRequest
implements Runnable,
NetMgmtConst,
NetMessages {
    private static final int MAX_DATA_SIZE = 16;
    private BUtilitiesCommand cmd;
    private BLonDevice lonDevice;
    private BLonRouter lonRouter;
    private BLonNetmgmt netmgmt;
    private BLonNetwork lonworks;
    private NLonComm lonComm;
    private LonAddress deviceAddr;
    private String deviceName;
    private boolean auth;
    private boolean isRouter;
    private boolean isExtended;
    private boolean checkExtended;
    private PrintWriter out;
    private BUtilCmdJob job;
    static /* synthetic */ Class class$java$lang$String;

    public void run() {
        this.execute();
    }

    public void execute() {
        if (!this.cmd.getCommand().isNoDeviceCmd() && this.deviceAddr.getAddressType() == 2 && ((BNeuronId)this.deviceAddr).isZero()) {
            this.append("Can not execute utility on " + this.deviceName + ". NeuronId is zero.");
            return;
        }
        try {
            String string = "Utility not implemented";
            boolean bl = false;
            if (this.lonDevice != null) {
                bl = this.lonDevice.isLocal();
            }
            boolean bl2 = bl;
            switch (this.cmd.getCommand().getOrdinal()) {
                case 9: {
                    string = this.getStatus();
                    break;
                }
                case 10: {
                    NmUtil.clearStatus(this.lonComm, this.deviceAddr, this.auth, false);
                    if (this.isRouter) {
                        NmUtil.clearStatus(this.lonComm, this.deviceAddr, this.auth, true);
                    }
                    string = this.getStatus();
                    break;
                }
                case 13: {
                    NmUtil.resetNode(this.lonComm, this.deviceAddr, this.auth, false);
                    if (this.isRouter) {
                        NmUtil.resetNode(this.lonComm, this.deviceAddr, this.auth, true);
                    }
                    string = this.getStatus();
                    break;
                }
                case 11: {
                    NmUtil.setDeviceState(this.lonComm, this.deviceAddr, BLonNodeState.unconfigured, bl2, this.auth, false);
                    if (this.isRouter) {
                        NmUtil.setDeviceState(this.lonComm, this.deviceAddr, BLonNodeState.unconfigured, bl2, this.auth, true);
                    }
                    this.updateNodeState(BLonNodeState.unconfigured);
                    string = this.getStatus();
                    break;
                }
                case 12: {
                    NmUtil.setDeviceState(this.lonComm, this.deviceAddr, BLonNodeState.configOnline, bl2, this.auth, false);
                    if (this.isRouter) {
                        NmUtil.setDeviceState(this.lonComm, this.deviceAddr, BLonNodeState.configOnline, bl2, this.auth, true);
                    }
                    this.updateNodeState(BLonNodeState.configOnline);
                    string = this.getStatus();
                    break;
                }
                case 36: {
                    if (this.lonDevice != null) {
                        NmUtil.recalculateChecksum(this.lonDevice, 1);
                        string = "Recalculated checksum on " + this.getName((BComponent)this.lonDevice);
                        break;
                    }
                    string = "This action only allowed on database devices.";
                    break;
                }
                case 14: {
                    string = this.getFileDirectory();
                    break;
                }
                case 15: {
                    string = this.getConfigTemplate();
                    break;
                }
                case 16: {
                    string = this.getConfigValue();
                    break;
                }
                case 17: {
                    string = this.getOtherFile();
                    break;
                }
                case 1: {
                    string = this.discover();
                    break;
                }
                case 18: {
                    string = this.wink();
                    break;
                }
                case 19: {
                    string = this.servicePin();
                    break;
                }
                case 20: {
                    string = this.clearServicePin();
                    break;
                }
                case 21: {
                    string = this.getAddressTable();
                    break;
                }
                case 23: {
                    string = this.getReadOnlyStruct();
                    break;
                }
                case 24: {
                    string = this.getConfigStruct();
                    break;
                }
                case 22: {
                    string = this.getDomainTable();
                    break;
                }
                case 26: {
                    string = this.getNvConfig();
                    break;
                }
                case 27: {
                    string = this.getNvValue();
                    break;
                }
                case 28: {
                    string = this.getSelfDoc();
                    break;
                }
                case 25: {
                    string = this.getAliasTable();
                    break;
                }
                case 29: {
                    string = this.getRouteTable();
                    break;
                }
                case 5: {
                    string = this.disableAuthentication();
                    break;
                }
                case 30: {
                    string = this.getNetMgmtSummary();
                    break;
                }
                case 31: {
                    string = this.getProgramIdSummary();
                    break;
                }
                case 32: {
                    string = this.getTransmitErrors(true);
                    break;
                }
                case 33: {
                    string = this.getTransmitErrors(false);
                    break;
                }
                case 34: {
                    string = this.verify();
                    break;
                }
                case 37: {
                    VerifyChannels.verify(this.lonworks, this.out);
                    string = "";
                    break;
                }
                case 35: {
                    string = this.getNetworkSummary();
                    break;
                }
                case 7: {
                    string = this.readMemory();
                    break;
                }
                case 8: {
                    this.test();
                    break;
                }
            }
            if (string.length() > 0) {
                this.append(string);
            }
        }
        catch (JobCancelException jobCancelException) {
            this.job.canceled();
        }
        catch (Throwable throwable) {
            String string = "LonUtil command failed.\n" + throwable.toString();
            this.netmgmt.log().error(string, throwable);
            this.append(string);
        }
    }

    private final String getOtherFile() throws LonException {
        byte[] byArray;
        if (this.lonDevice == null) {
            return "Cannot access files on devices not added to database.";
        }
        int n = this.cmd.getFileNum();
        LonFile lonFile = this.lonDevice.getLonFileOpen(n, false, false);
        if (lonFile == null) {
            return "No files on " + this.deviceName;
        }
        this.append("Hex file dump for filenum ").append(n).append("\n");
        try {
            byArray = lonFile.read();
        }
        catch (LonException lonException) {
            lonFile.close();
            throw lonException;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray.length - n2;
            if (n3 > 16) {
                n3 = 16;
            }
            this.append(LonByteArrayUtil.toString(byArray, 16, ' ', n3, n2, true));
            this.append("   ");
            this.bytesToString(byArray, n2, n3);
            this.append("\n");
            n2 += n3;
        }
        lonFile.close();
        return "";
    }

    private final String getConfigTemplate() throws LonException {
        ConfigTemplateFile configTemplateFile;
        if (this.lonDevice == null) {
            return "Cannot access files on devices not added to database.";
        }
        LonFile lonFile = this.lonDevice.getLonFileOpen(0, false, false);
        if (lonFile == null) {
            return "No files on " + this.deviceName;
        }
        this.append("Configuration Template File for " + this.deviceName + '\n');
        this.append("FILE index 0 type 2\n");
        try {
            configTemplateFile = new ConfigTemplateFile(lonFile.read());
        }
        catch (LonException lonException) {
            lonFile.close();
            throw lonException;
        }
        configTemplateFile.toString(this.out);
        lonFile.close();
        return "";
    }

    private final String getFileDirectory() throws LonException {
        if (this.lonDevice == null) {
            return "Cannot access files on devices not added to database.";
        }
        LonFile lonFile = this.lonDevice.getLonFileOpen(0, false, false);
        if (lonFile == null) {
            return "No files on " + this.deviceName;
        }
        return lonFile.getDirectoryString();
    }

    private final String getConfigValue() throws LonException {
        if (this.lonDevice == null) {
            return "Cannot access files on devices not added to database.";
        }
        LonFile lonFile = this.lonDevice.getLonFileOpen(0, false, false);
        if (lonFile == null) {
            return "No files on " + this.deviceName;
        }
        int n = lonFile.findFileNum(2);
        if (n == -1) {
            return "No template file on " + this.deviceName;
        }
        LonInputStream lonInputStream = null;
        this.append("Configuration Value File for " + this.deviceName + '\n');
        ConfigTemplateFile configTemplateFile = new ConfigTemplateFile(lonFile.read());
        lonFile.close();
        n = lonFile.findFileNum(1);
        lonFile.open(n, false, false);
        LonInputStream lonInputStream2 = new LonInputStream(lonFile.read());
        lonFile.close();
        n = lonFile.findFileNum(1, n);
        if (n > 0) {
            lonFile.open(n, false, false);
            lonInputStream = new LonInputStream(lonFile.read());
            lonFile.close();
        }
        ConfigTemplateRecord[] configTemplateRecordArray = configTemplateFile.getRecords();
        int n2 = 0;
        int n3 = 0;
        String[] stringArray = new String[]{"Select", "Type", "Access", "Offset", "Value"};
        PTable pTable = new PTable(stringArray, 2);
        pTable.setColumnAttribute(2, 0);
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = configTemplateRecordArray.length;
        int n5 = 0;
        while (n5 < n4) {
            ConfigTemplateRecord configTemplateRecord = configTemplateRecordArray[n5];
            int n6 = configTemplateRecord.getNumRecs();
            int n7 = 0;
            while (n7 < n6) {
                int n8;
                int n9 = configTemplateRecord.getHdr();
                if (n9 == 1) {
                    pTable.add("Obj " + configTemplateRecord.getSelect());
                } else if (n9 == 2) {
                    pTable.add("Nv " + configTemplateRecord.getSelect());
                } else {
                    pTable.add("Node");
                }
                if (configTemplateRecord.isScpt()) {
                    pTable.add("Scpt" + configTemplateRecord.getConfigIndex());
                } else {
                    pTable.add("Ucpt" + configTemplateRecord.getConfigIndex());
                }
                if (configTemplateRecord.isReadWrite()) {
                    pTable.add("R/W");
                } else {
                    pTable.add("R/O");
                }
                int n10 = configTemplateRecord.getLength();
                stringBuffer.setLength(0);
                if (!configTemplateRecord.isReadWrite() && lonInputStream != null) {
                    pTable.add(n3);
                    n8 = 0;
                    while (n8 < n10) {
                        stringBuffer.append(Integer.toString(lonInputStream.read(), 16) + ' ');
                        ++n8;
                    }
                    n3 += n10;
                } else {
                    pTable.add(n2);
                    n8 = 0;
                    while (n8 < n10) {
                        stringBuffer.append(Integer.toString(lonInputStream2.read(), 16) + ' ');
                        ++n8;
                    }
                    n2 += n10;
                }
                pTable.add(stringBuffer.toString());
                ++n7;
            }
            ++n5;
        }
        pTable.toString(this.out);
        if (lonInputStream != null) {
            this.append("NOTE: This device has seperate file for readOnly parameters.");
        }
        return "";
    }

    private final String getAddressTable() throws LonException {
        int n = Neuron.getAddressCount(this.lonComm, this.deviceAddr, this.auth, this.isExtended());
        this.append("Address table for " + this.deviceName + '\n');
        String[] stringArray = new String[]{"Index", "Type", "Size", "Group/Subnet", "Member/Node", "Domain Ndx", "Repeat", "Retry", "Receive", "Transmit", "Restrict"};
        PTable pTable = new PTable(stringArray);
        int n2 = 0;
        while (n2 < n) {
            block11: {
                QueryAddrResponse queryAddrResponse;
                block10: {
                    try {
                        queryAddrResponse = NmUtil.getAddressTableEntry(this.lonComm, this.deviceAddr, n2, this.auth, this.isExtended());
                        if (!queryAddrResponse.isExtended()) break block10;
                        n2 = ((ExEnumerateAddressResponse)queryAddrResponse).getAddressIndex();
                    }
                    catch (FailedResponseException failedResponseException) {
                        break;
                    }
                }
                pTable.add(n2);
                switch (queryAddrResponse.getAddressType().getOrdinal()) {
                    case 0: {
                        pTable.addBanner("Not in use");
                        break block11;
                    }
                    case 1: {
                        pTable.add("Group");
                        pTable.add(queryAddrResponse.getSize());
                        break;
                    }
                    case 2: {
                        pTable.add("Subnet");
                        pTable.add("");
                        break;
                    }
                    case 3: {
                        pTable.add("Broadcast");
                        pTable.add("");
                        break;
                    }
                    case 4: {
                        pTable.add("Turnaround");
                        pTable.newRow();
                        break block11;
                    }
                    default: {
                        pTable.add("error");
                    }
                }
                pTable.add(queryAddrResponse.groupOrSubnet);
                pTable.add(queryAddrResponse.memberOrNode);
                pTable.add(queryAddrResponse.domainIndex);
                pTable.add(BLonRepeatTimer.make(queryAddrResponse.repeatTimer).getTag());
                pTable.add(queryAddrResponse.retryCount);
                pTable.add(BLonReceiveTimer.make(queryAddrResponse.receiveTimer).getTag());
                pTable.add(BLonRepeatTimer.make(queryAddrResponse.xmitTimer).getTag());
                pTable.add(queryAddrResponse.getRestriction().getTag());
            }
            ++n2;
        }
        pTable.toString(this.out);
        return "";
    }

    private final String getReadOnlyStruct() throws LonException {
        this.append("Read Only data structure for " + this.deviceName + '\n');
        this.getReadOnlyStruct(false);
        if (this.isRouter) {
            this.append("\n\nFar side");
            this.getReadOnlyStruct(true);
        }
        return "";
    }

    private final void getReadOnlyStruct(boolean bl) throws LonException {
        ReadOnlyStruct readOnlyStruct = ReadOnlyStruct.make(this.deviceAddr, this.lonComm, this.auth, bl);
        this.append("\n  neuronId             =  " + readOnlyStruct.getNeuronId());
        this.append("\n  model Number         =  " + (readOnlyStruct.getModelNumber() == 0 ? "3120" : "3150"));
        this.append("\n  minor Model Number   =  " + readOnlyStruct.getMinorModelNumber());
        this.append("\n  nvFixed pointer      =  " + Integer.toString(readOnlyStruct.getNvFixedPointer(), 16));
        this.append("\n  Read Write Protect   =  " + readOnlyStruct.getReadWriteProtect());
        this.append("\n  Network variables    =  " + readOnlyStruct.getNvCount());
        this.append("\n  Snvt structs pointer =  " + Integer.toString(readOnlyStruct.getSnvtStructsPointer(), 16));
        this.append("\n  Program Id           =  " + (Object)((Object)readOnlyStruct.getProgramId()));
        byte[] byArray = readOnlyStruct.getProgramId().getByteArray();
        if ((byArray[0] & 0x80) == 0) {
            this.append(" \"");
            this.getString(byArray, 0, 8);
            this.append("\"");
        }
        this.append("\n  Nv Processing Off    =  " + readOnlyStruct.getNvProcessingOff());
        this.append("\n  Two Domains          =  " + readOnlyStruct.getTwoDomains());
        this.append("\n  Explicit Addressing  =  " + readOnlyStruct.getExplicitAddressing());
        this.append("\n  Address Count        =  " + readOnlyStruct.getAddressCount());
        this.append("\n  TX by address        =  " + readOnlyStruct.getTxByAddress());
        this.append("\n  Idempotent duplicate =  " + readOnlyStruct.getIdempotentDuplicate());
        this.append("\n  Alias Count          =  " + readOnlyStruct.getAliasCount());
        this.append("\n  Message Tag Count    =  " + readOnlyStruct.getMessageTagCount());
        this.append("\n  Compatibility Info   =  " + readOnlyStruct.getHasEcs());
        this.append("\n");
        this.append("\n  Receive Transaction Count                     =  " + (readOnlyStruct.getRcvTransCount() + 1));
        this.append("\n  Size of Output Application Buffer             =  " + this.getBufferSize(readOnlyStruct.getAppBufOutSize()));
        this.append("\n  Size of Input Application Buffer              =  " + this.getBufferSize(readOnlyStruct.getAppBufInSize()));
        this.append("\n  Size of Output Network Buffer                 =  " + this.getBufferSize(readOnlyStruct.getNetBufOutSize()));
        this.append("\n  Size of Input Network Buffer                  =  " + this.getBufferSize(readOnlyStruct.getNetBufInSize()));
        this.append("\n  Number of Priority Output Network Buffers     =  " + this.getBufferCount(readOnlyStruct.getNetBufOutPriorityCount()));
        this.append("\n  Number of Priority Output Application Buffers =  " + this.getBufferCount(readOnlyStruct.getAppBufOutPriorityCount()));
        this.append("\n  Number of Output Application Buffers          =  " + this.getBufferCount(readOnlyStruct.getAppBufOutCount()));
        this.append("\n  Number of Input Application Buffers           =  " + this.getBufferCount(readOnlyStruct.getAppBufInCount()));
        this.append("\n  Number of Output Network Buffers              =  " + this.getBufferCount(readOnlyStruct.getNetBufOutCount()));
        this.append("\n  Number of Input Network Buffers               =  " + this.getBufferCount(readOnlyStruct.getNetBufInCount()));
    }

    private final String getBufferCount(int n) {
        int n2 = Neuron.getBufferCount(n);
        return n2 + " (" + n + ')';
    }

    private final String getBufferSize(int n) {
        int n2 = Neuron.getBufferSize(n);
        return n2 + " (" + n + ')';
    }

    private final void getString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            byte by;
            this.append((by = byArray[n + n3++]) >= 48 && by <= 122 ? (char)by : (char)'.');
        }
    }

    private final String getConfigStruct() throws LonException {
        this.append("Config data structure for " + this.deviceName + '\n');
        this.getConfigStruct(false);
        if (this.isRouter) {
            this.append("Far side");
            this.getConfigStruct(true);
        }
        return "";
    }

    private final void getConfigStruct(boolean bl) throws LonException {
        byte[] byArray = Neuron.getConfigStruct(this.lonComm, this.deviceAddr, this.auth, bl);
        this.append("\n  Channel Id              =  " + (byArray[0] << 8 | byArray[1] & 0xFF));
        this.append("\n  Location                =  " + LonByteArrayUtil.toString(byArray, 16, ' ', 6, 2));
        this.append(" \"");
        this.getString(byArray, 2, 6);
        this.append("\"");
        this.append("\n  Comm clock              =  " + this.getCommClock((byArray[8] & 0xF8) >> 3));
        this.append("\n  Input clock             =  " + this.getInputClock(byArray[8] & 7));
        this.append("\n  Comm type               =  " + this.getCommType((byArray[9] & 0xE0) >> 5));
        int n = byArray[9] & 0x1F;
        this.append("\n  Comm pin direction      =  " + this.getCommPinDirection(n));
        this.append("\n  Preamble length         =  " + byArray[10]);
        this.append("\n  Packet cycle            =  " + byArray[11]);
        this.append("\n  Beta2 control           =  " + byArray[12]);
        this.append("\n  Xmit interpacket        =  " + byArray[13]);
        this.append("\n  Recv interpacket        =  " + byArray[14]);
        this.append("\n  Node priority           =  " + byArray[15]);
        this.append("\n  Channel priorities      =  " + byArray[16]);
        int n2 = 7;
        int n3 = 17;
        if (n == 12 || n == 14) {
            byte by = byArray[17];
            byte by2 = byArray[18];
            this.append("\n   Col Det               =  " + this.toBool(by, 7));
            this.append("\n   Bit Sync              =  " + ((by & 0x60) >> 5));
            this.append("\n   Filter                =  " + ((by & 0x18) >> 3));
            this.append("\n   Hysteresis            =  " + (by & 7));
            this.append("\n   ColDet toEnd          =  " + ((by2 & 0xFC) >> 3));
            this.append("\n   ColDet Tail           =  " + (by2 & 2));
            this.append("\n   ColDet Preamble       =  " + this.toBool(by2 & 1, 0));
            n2 -= 2;
            n3 += 2;
        }
        this.append("\n  Transceiver parameters  =  " + LonByteArrayUtil.toString(byArray, 16, ' ', n2, n3));
        this.append("\n  Nongroup timer          =  " + this.getNongroupTimer((byArray[24] & 0xF0) >> 4));
        this.append("\n  Net mgmt authentication =  " + this.toBool(byArray[24], 3));
        this.append("\n  Preamble timeout        =  " + this.getPreambleTimeout(byArray[24] & 7));
        this.append("\n\n");
    }

    private final String getCommClock(int n) {
        switch (n) {
            case 0: {
                return "8:1";
            }
            case 1: {
                return "16:1";
            }
            case 2: {
                return "32:1";
            }
            case 3: {
                return "64:1";
            }
            case 4: {
                return "128:1";
            }
            case 5: {
                return "256:1";
            }
            case 6: {
                return "512:1";
            }
            case 7: {
                return "1,024:1";
            }
        }
        return "Invalid value " + n;
    }

    private final String getInputClock(int n) {
        switch (n) {
            case 7: {
                return "40.0 MHz";
            }
            case 6: {
                return "20.0 MHz";
            }
            case 5: {
                return "10.0 MHz";
            }
            case 4: {
                return "5.0 MHz";
            }
            case 3: {
                return "2.5 MHz";
            }
            case 2: {
                return "1.25 MHz";
            }
            case 1: {
                return "625 kHz";
            }
            case 0: {
                return "Not Used";
            }
        }
        return "Invalid value " + n;
    }

    private final String getCommType(int n) {
        switch (n) {
            case 0: {
                return "Blank Neuron Chip";
            }
            case 1: {
                return "Single-ended";
            }
            case 2: {
                return "Special-purpose";
            }
            case 5: {
                return "Differential";
            }
        }
        return "Invalid value " + n;
    }

    private final String getCommPinDirection(int n) {
        switch (n) {
            case 0: {
                return "Blank Neuron Chip";
            }
            case 14: {
                return "Direct mode - single-ended";
            }
            case 12: {
                return "Direct mode - differential";
            }
            case 30: {
                return "Special purpose - wake up pin is output";
            }
            case 23: {
                return "Special purpose - wake up pin is input";
            }
        }
        return "Invalid value " + n;
    }

    private final String getNongroupTimer(int n) {
        return BLonReceiveTimer.make(n).getTag();
    }

    private final String getPreambleTimeout(int n) {
        switch (n) {
            case 0: {
                return "Forever";
            }
            case 1: {
                return "2 seconds";
            }
            case 2: {
                return "4 seconds";
            }
            case 3: {
                return "6 seconds";
            }
            case 4: {
                return "8 seconds";
            }
            case 5: {
                return "10 seconds";
            }
            case 6: {
                return "12 seconds";
            }
            case 7: {
                return "14 seconds";
            }
        }
        return "Invalid value " + n;
    }

    private final String wink() throws LonException {
        NmUtil.wink(this.lonComm, this.deviceAddr, this.auth);
        return "wink complete";
    }

    private final String clearServicePin() throws LonException {
        this.lonworks.netMessageReceiver().clearServicePin();
        return "";
    }

    private final String servicePin() throws LonException {
        this.lonDevice = null;
        NetMessageReceiver netMessageReceiver = this.lonworks.netMessageReceiver();
        netMessageReceiver.clearServicePin();
        this.append("Waiting on service pin.\n\n");
        ServicePin servicePin = netMessageReceiver.getServicePin();
        if (servicePin == null) {
            return "Cancel service pin.";
        }
        this.append("Received service pin:");
        String string = LonByteArrayUtil.toString(servicePin.getNeuronId().getByteArray(), ':');
        this.append("\n  NeuronId    = " + string);
        byte[] byArray = servicePin.getIdString().getByteArray();
        this.append("\n  Program Id  = " + LonByteArrayUtil.toString(byArray, ':'));
        if ((byArray[0] & 0x80) == 0) {
            this.append(" \"");
            this.getString(byArray, 0, 8);
            this.append("\"");
        }
        this.deviceAddr = servicePin.getNeuronId();
        this.append("\n\n\n");
        this.deviceName = string;
        try {
            this.append(this.getDomainTable());
            return "";
        }
        catch (LonException lonException) {
            try {
                this.auth = true;
                this.append(this.getDomainTable());
                this.append("\n**** Authentication set ****");
            }
            catch (LonException lonException2) {
                this.append("Unable to read domain table.");
                this.append("\nDevice possibly authenticated with different authentication key.");
                this.append("\nMust set authentication key on LonNetwork\\LonNetmgmt and commision");
                this.append("\nthe LocalLondevice.");
            }
            return "";
        }
    }

    private final String getRouteTable() throws LonException {
        if (!this.isRouter) {
            return "Not a router.";
        }
        this.append("Routing table for " + this.deviceName + '\n');
        QueryStatusResponse queryStatusResponse = NmUtil.queryStatus(this.lonComm, this.deviceAddr, 1, this.auth, false);
        if (queryStatusResponse.versionNumber < 5) {
            return "Version " + queryStatusResponse.versionNumber + " does not support table report.";
        }
        String[] stringArray = new String[]{"Domain", "Storage", "Type", "Side", "Table"};
        PTable pTable = new PTable(stringArray);
        int n = this.getNumberDomains();
        int n2 = 0;
        while (n2 < n) {
            this.getRouterTable(pTable, n2, 1, 0, this.auth, false);
            this.getRouterTable(pTable, n2, 0, 0, this.auth, false);
            this.getRouterTable(pTable, n2, 1, 0, this.auth, true);
            this.getRouterTable(pTable, n2, 0, 0, this.auth, true);
            this.getRouterTable(pTable, n2, 1, 1, this.auth, false);
            this.getRouterTable(pTable, n2, 0, 1, this.auth, false);
            this.getRouterTable(pTable, n2, 1, 1, this.auth, true);
            this.getRouterTable(pTable, n2, 0, 1, this.auth, true);
            ++n2;
        }
        pTable.toString(this.out);
        return "";
    }

    private final void getRouterTable(PTable pTable, int n, int n2, int n3, boolean bl, boolean bl2) throws LonException {
        byte[] byArray = RouterUtil.getRouterTable(this.lonComm, this.deviceAddr, n, n2, n3, bl, bl2);
        pTable.add(n);
        pTable.add(n3 == 0 ? "RAM" : "EEPROM");
        pTable.add(n2 == 1 ? "Group" : "Subnet");
        pTable.add(bl2 ? "FarSide" : "NearSide");
        pTable.add(LonByteArrayUtil.toString(byArray, true));
    }

    private final String getDomainTable() throws LonException {
        this.getDomainTable(false);
        if (this.isRouter) {
            this.getDomainTable(true);
        }
        return "";
    }

    private final int getNumberDomains() throws LonException {
        if (this.lonDevice != null) {
            return this.lonDevice.getDeviceData().getTwoDomains() + 1;
        }
        return Neuron.isTwoDomains(this.lonComm, this.deviceAddr, this.auth, false) + 1;
    }

    private final void getDomainTable(boolean bl) throws LonException {
        int n = this.getNumberDomains();
        if (!bl) {
            this.append("Domain table for " + this.deviceName + '\n');
        } else {
            this.append("\nDomain table for far side\n");
        }
        String[] stringArray = new String[]{"Index", "Subnet", "Node", "Auth key", "Domain Len", "Domain Id"};
        PTable pTable = new PTable(stringArray);
        int n2 = 0;
        while (n2 < n) {
            block8: {
                QueryDomainResponse queryDomainResponse;
                try {
                    queryDomainResponse = NmUtil.queryDomain(this.lonComm, this.deviceAddr, n2, this.auth, bl, this.isExtended());
                }
                catch (Throwable throwable) {
                    break block8;
                }
                pTable.add(n2);
                if (!queryDomainResponse.inUse()) {
                    pTable.addBanner("Not in use");
                } else {
                    pTable.add(queryDomainResponse.subnet);
                    pTable.add(queryDomainResponse.node);
                    pTable.add(LonByteArrayUtil.toString(queryDomainResponse.key));
                    pTable.add(queryDomainResponse.len);
                    if (queryDomainResponse.len > 0) {
                        pTable.add(LonByteArrayUtil.toString(queryDomainResponse.id, 16, ' ', queryDomainResponse.len));
                    }
                    pTable.newRow();
                }
            }
            ++n2;
        }
        pTable.toString(this.out);
    }

    private final String getNvConfig() throws LonException {
        this.append("Network Variable config table for " + this.deviceName + '\n');
        String[] stringArray = new String[]{"NvIndex", "Direction", "Selector", "Address Index", "Service", "Priority", "Authenticate", "Turnaround"};
        PTable pTable = new PTable(stringArray);
        int n = this.lonDevice != null ? this.getNvCount(this.lonDevice) : this.getNvCount(this.deviceAddr);
        int n2 = 0;
        while (n2 < n) {
            BNvConfigData bNvConfigData;
            try {
                bNvConfigData = NmUtil.queryNvConfigData(this.lonComm, this.deviceAddr, n2, this.auth, this.isExtended());
            }
            catch (FailedResponseException failedResponseException) {
                NmUtil.resetNode(this.lonComm, this.deviceAddr, this.auth, false);
                break;
            }
            pTable.add(n2);
            pTable.add((BObject)bNvConfigData.getDirection());
            pTable.add(Integer.toString(bNvConfigData.getSelector(), 16));
            pTable.add(bNvConfigData.getAddrIndex());
            pTable.add((BObject)bNvConfigData.getServiceType());
            pTable.add(this.toBool(bNvConfigData.getPriority()));
            pTable.add(this.toBool(bNvConfigData.getAuthenticated()));
            pTable.add(this.toBool(bNvConfigData.getTurnAround()));
            ++n2;
        }
        pTable.toString(this.out);
        return "";
    }

    private final String getAliasTable() throws LonException {
        int n;
        boolean bl = this.isExtended();
        int n2 = n = this.lonDevice != null ? this.lonDevice.getDeviceData().getAliasTable().getAliasCount() : Neuron.getAliasCount(this.lonComm, this.deviceAddr, this.auth);
        if (n <= 0) {
            return "Alias count = 0";
        }
        int n3 = Neuron.getAliasOffset(this.lonComm, this.deviceAddr, this.auth, bl);
        this.append("Alias Network Variable config table for " + this.deviceName + '\n');
        String[] stringArray = bl ? new String[]{"AliasIndex", "PrimaryNv", "Direction", "Selector", "Address Index", "Service", "Priority", "Authenticate", "Turnaround", "TargetNvIndex", "WriteByIndex", "RemoteNvAuth", "ReadByIndex"} : new String[]{"AliasIndex", "PrimaryNv", "Direction", "Selector", "Address Index", "Service", "Priority", "Authenticate", "Turnaround"};
        PTable pTable = new PTable(stringArray);
        int n4 = 0;
        while (n4 < n) {
            BAliasConfigData bAliasConfigData;
            QueryAliasResponse queryAliasResponse;
            block5: {
                try {
                    queryAliasResponse = NmUtil.queryAliasConfigData(this.lonComm, this.deviceAddr, n4, n3, this.auth, bl);
                    bAliasConfigData = queryAliasResponse.getAliasConfigData();
                    if (!queryAliasResponse.isExtended()) break block5;
                    n4 = ((ExEnumerateAliasResponse)queryAliasResponse).getAliasIndex();
                }
                catch (FailedResponseException failedResponseException) {
                    break;
                }
            }
            pTable.add(n4);
            pTable.add(bAliasConfigData.getPrimary());
            pTable.add((BObject)bAliasConfigData.getDirection());
            pTable.add(Integer.toString(bAliasConfigData.getSelector(), 16));
            pTable.add(bAliasConfigData.getAddrIndex());
            pTable.add((BObject)bAliasConfigData.getServiceType());
            pTable.add(this.toBool(bAliasConfigData.getPriority()));
            pTable.add(this.toBool(bAliasConfigData.getAuthenticated()));
            pTable.add(this.toBool(bAliasConfigData.getTurnAround()));
            if (bl) {
                ExEnumerateAliasResponse exEnumerateAliasResponse = (ExEnumerateAliasResponse)queryAliasResponse;
                pTable.add(exEnumerateAliasResponse.getTgtNvIndex());
                pTable.add(this.toBool(exEnumerateAliasResponse.getNvWriteByIndex()));
                pTable.add(this.toBool(exEnumerateAliasResponse.getNvRemoteNvAuth()));
                pTable.add(this.toBool(exEnumerateAliasResponse.getNvReadByIndex()));
            }
            ++n4;
        }
        pTable.toString(this.out);
        return "";
    }

    private final String getNvValue() throws LonException {
        PTable pTable;
        String[] stringArray;
        this.append("Network Variable value table for " + this.deviceName + '\n');
        if (this.lonDevice != null) {
            stringArray = new String[]{"Ndx", "Name", "Data"};
            pTable = new PTable(stringArray, 2);
        } else {
            stringArray = new String[]{"Ndx", "Data"};
            pTable = new PTable(stringArray, 2);
        }
        int n = Neuron.getAliasOffset(this.lonComm, this.deviceAddr, this.auth, this.isExtended());
        BINetworkVariable[] bINetworkVariableArray = this.lonDevice != null ? this.lonDevice.getNetworkVariables() : null;
        int n2 = 0;
        while (n2 < n) {
            String string;
            try {
                byte[] byArray = NmUtil.fetchNv(this.lonComm, this.deviceAddr, n2, this.auth);
                string = LonByteArrayUtil.toString(byArray);
            }
            catch (FailedResponseException failedResponseException) {
                break;
            }
            catch (Throwable throwable) {
                string = "*** ERROR:" + throwable.getMessage();
            }
            pTable.add(n2);
            if (this.lonDevice != null) {
                if (n2 < bINetworkVariableArray.length && bINetworkVariableArray[n2] != null) {
                    pTable.add(bINetworkVariableArray[n2].getName() + "  ");
                } else {
                    pTable.add("");
                }
            }
            pTable.add(string);
            ++n2;
        }
        pTable.toString(this.out);
        return "";
    }

    private final String discover() throws LonException {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        BLonDiscoverJob bLonDiscoverJob = new BLonDiscoverJob(this.netmgmt);
        bLonDiscoverJob.doDiscover();
        boolean bl = false;
        BDeviceEntry[] bDeviceEntryArray = this.netmgmt.getDeviceDiscoverTable().getDeviceEntries();
        if (bDeviceEntryArray.length > 0) {
            this.append("Discovered devices\n");
            objectArray = new String[]{"Channel", "S/N", "Status", "Mfg", "Program Id", "NeuronId"};
            object3 = new PTable((String[])objectArray);
            int n = 0;
            while (n < bDeviceEntryArray.length) {
                object2 = bDeviceEntryArray[n];
                ((PTable)object3).add(((BDeviceEntry)((Object)object2)).getChannelId());
                ((PTable)object3).add("" + ((BDeviceEntry)((Object)object2)).getSubnet() + '/' + ((BDeviceEntry)((Object)object2)).getNode());
                ((PTable)object3).add((BObject)((BDeviceEntry)((Object)object2)).getState());
                ((PTable)object3).add(((BDeviceEntry)((Object)object2)).getMfgId().getConvertedName());
                ((PTable)object3).add((BObject)((BDeviceEntry)((Object)object2)).getProgramId());
                ((PTable)object3).add((BObject)((BDeviceEntry)((Object)object2)).getNeuronId());
                ++n;
            }
            ((PTable)object3).toString(this.out);
            bl = true;
        }
        if ((objectArray = this.netmgmt.getRouterDiscoverTable().getRouterEntries()).length > 0) {
            this.append("Discovered routers\n");
            object3 = new String[]{"NearChannel", "Near S/N", "FarChannel", "Far S/N", "Status", "NeuronId"};
            PTable pTable = new PTable((String[])object3);
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                pTable.add(((BRouterEntry)((Object)object)).getNearChannel());
                pTable.add((BObject)((BRouterEntry)((Object)object)).getNearAddress());
                pTable.add(((BRouterEntry)((Object)object)).getFarChannel());
                pTable.add((BObject)((BRouterEntry)((Object)object)).getFarAddress());
                pTable.add((BObject)((BRouterEntry)((Object)object)).getState());
                pTable.add((BObject)((BRouterEntry)((Object)object)).getNeuronId());
                ++n;
            }
            pTable.toString(this.out);
            bl = true;
        }
        if (!bl) {
            this.append("No new devices discovered.");
        }
        object3 = this.lonworks.addressManager().getDeviceList(false);
        int n = 0;
        while (n < ((BLonDevice[])object3).length) {
            object2 = object3[n];
            try {
                object = new StringBuffer();
                if (this.verifyDomainTable((BLonDevice)object2, (StringBuffer)object)) {
                    this.append("\n" + this.getName((BComponent)object2) + " domain table mismatch:" + ((StringBuffer)object).toString() + '\n');
                }
            }
            catch (LonException lonException) {
                this.append("\nUnable to verify domain table for " + this.getName((BComponent)object2) + ':' + lonException.getMessage());
            }
            ++n;
        }
        return "";
    }

    public String verify() {
        this.append("Verify physical device and database match.\n");
        this.append("======================================");
        try {
            if (this.isRouter) {
                this.verifyRouter(this.lonRouter);
            } else if (this.lonDevice != null) {
                if (!this.lonDevice.isLocal()) {
                    this.verifyDevice(this.lonDevice);
                } else {
                    NAddressManager nAddressManager = (NAddressManager)this.lonworks.addressManager();
                    BLonDevice[] bLonDeviceArray = nAddressManager.getDeviceList(true);
                    int n = 0;
                    while (n < bLonDeviceArray.length) {
                        BLonDevice bLonDevice = bLonDeviceArray[n];
                        if (!bLonDevice.isLocal()) {
                            this.verifyDevice(bLonDevice);
                            if (this.job != null) {
                                this.job.progress((n + 1) * 100 / bLonDeviceArray.length);
                            }
                        }
                        ++n;
                    }
                    BLonRouter[] bLonRouterArray = nAddressManager.getRouterList();
                    int n2 = 0;
                    while (n2 < bLonRouterArray.length) {
                        this.verifyRouter(bLonRouterArray[n2]);
                        ++n2;
                    }
                }
            }
            this.append("\n\nReport run at " + Clock.time() + '\n');
            this.append("To correct discrepancies do replaceNode on device if device in error\n");
            this.append("   upload links if database in error.\n");
            this.append("\n");
        }
        catch (Throwable throwable) {
            String string = "Error accessing in verify.\n\n" + throwable.toString();
            System.out.println(string);
            throwable.printStackTrace();
            return string;
        }
        return "";
    }

    private final String getName(BComponent bComponent) {
        return bComponent.getDisplayName(null);
    }

    private final void verifyRouter(BLonRouter bLonRouter) {
        this.append("\n\nVerify " + this.getName(bLonRouter));
        BNeuronId bNeuronId = bLonRouter.getNeuronIdAddress();
        try {
            QueryStatusResponse queryStatusResponse = NmUtil.queryStatus(this.lonComm, bNeuronId, 1, this.auth, false);
            if (queryStatusResponse.versionNumber < 5) {
                this.append("version does not support table report");
                return;
            }
            int n = bLonRouter.getNearDeviceData().getWorkingDomain();
            this.verifyRouterTable(bNeuronId, n, 1, 0, this.auth, false, bLonRouter.getNearGroupTable());
            this.verifyRouterTable(bNeuronId, n, 0, 0, this.auth, false, bLonRouter.getNearSubnetTable());
            this.verifyRouterTable(bNeuronId, n, 1, 0, this.auth, true, bLonRouter.getFarGroupTable());
            this.verifyRouterTable(bNeuronId, n, 0, 0, this.auth, true, bLonRouter.getFarSubnetTable());
            this.verifyRouterTable(bNeuronId, n, 1, 1, this.auth, false, bLonRouter.getNearGroupTable());
            this.verifyRouterTable(bNeuronId, n, 0, 1, this.auth, false, bLonRouter.getNearSubnetTable());
            this.verifyRouterTable(bNeuronId, n, 1, 1, this.auth, true, bLonRouter.getFarGroupTable());
            this.verifyRouterTable(bNeuronId, n, 0, 1, this.auth, true, bLonRouter.getFarSubnetTable());
        }
        catch (LonException lonException) {
            this.append("\n  Router not responding");
        }
    }

    private final void verifyRouterTable(LonAddress lonAddress, int n, int n2, int n3, boolean bl, boolean bl2, BLonRouteTable bLonRouteTable) throws LonException {
        byte[] byArray = bLonRouteTable.getByteArrayCopy();
        byte[] byArray2 = RouterUtil.getRouterTable(this.lonComm, lonAddress, n, n2, n3, bl, bl2);
        int n4 = 0;
        while (n4 < byArray.length) {
            if (byArray[n4] != byArray2[n4]) {
                this.append("\nmismatch in ");
                this.append(bl2 ? "FarSide:" : "NearSide:");
                this.append(n3 == 0 ? "RAM " : "EEPROM ");
                this.append(n2 == 1 ? "Group Table " : "Subnet Table ");
                this.append("\ndb  :").append(LonByteArrayUtil.toString(byArray, true));
                this.append("\nrtr :").append(LonByteArrayUtil.toString(byArray2, true));
                return;
            }
            ++n4;
        }
    }

    public void verifyDevice(BLonDevice bLonDevice) throws LonException {
        this.append("\n\nVerify " + this.getName((BComponent)bLonDevice));
        try {
            BProgramId bProgramId;
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            boolean bl = bDeviceData.getAuthenticate();
            if (bl != Neuron.isNMAuthSet(bLonDevice)) {
                this.append(" Authentication mismatch:");
                if (bl) {
                    this.append("db set device not set.\n");
                } else {
                    this.append("device set db not set.\n");
                }
                return;
            }
            BProgramId bProgramId2 = Neuron.getProgramId(bLonDevice);
            if (!bProgramId2.equals((Object)(bProgramId = bDeviceData.getProgramId()))) {
                this.append(" ProgramId mismatch:\n   device is - " + (Object)((Object)bProgramId2) + "\n   db is - " + (Object)((Object)bProgramId));
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.verifyDomainTable(bLonDevice, stringBuffer)) {
                this.append(stringBuffer.toString());
            }
            this.verifyAddressTable(bLonDevice);
            try {
                Object object;
                BINetworkVariable[] bINetworkVariableArray = bLonDevice.getNetworkVariables();
                BNvConfigData bNvConfigData = NmUtil.queryNvConfigData(bLonDevice, 0);
                int n = this.getNvCount(bLonDevice);
                int n2 = 0;
                while (n2 < n) {
                    if (n2 > 0) {
                        bNvConfigData = NmUtil.queryNvConfigData(bLonDevice, n2);
                    }
                    if (n2 < bINetworkVariableArray.length && bINetworkVariableArray[n2] != null) {
                        object = bINetworkVariableArray[n2].getNvConfigData();
                        this.verifyNvConfigReport(bNvConfigData, (BNvConfigData)((Object)object), false, n2);
                    } else if (bNvConfigData.isBoundNv()) {
                        this.append("\n  nv " + n2 + " is bound but not represented in db - selector = " + bNvConfigData.getSelector());
                    }
                    ++n2;
                }
                object = bDeviceData.getAliasTable();
                int n3 = object.getAliasCount();
                BAliasConfigData[] bAliasConfigDataArray = object.getAliasArray();
                int n4 = 0;
                while (n4 < n3) {
                    bNvConfigData = NmUtil.queryAliasConfigData(bLonDevice, n4);
                    if (n4 < bAliasConfigDataArray.length && bAliasConfigDataArray[n4] != null) {
                        this.verifyNvConfigReport(bNvConfigData, bAliasConfigDataArray[n4], true, n4);
                    } else if (bNvConfigData.isBoundNv()) {
                        this.append("\n  alias " + n4 + " is bound but not represented in db - selector = " + bNvConfigData.getSelector());
                    }
                    ++n4;
                }
            }
            catch (FailedResponseException failedResponseException) {
                NmUtil.resetNode(bLonDevice);
            }
        }
        catch (LonException lonException) {
            this.append("\n  Device not responding");
        }
    }

    private final int getNvCount(BLonDevice bLonDevice) throws LonException {
        int n = bLonDevice.getDeviceData().getAliasTable().getAliasOffset();
        if (n > 0) {
            return n;
        }
        boolean bl = NmUtil.isExtended(bLonDevice);
        return Neuron.getAliasOffset(this.lonComm, NmUtil.getSendAddress(bLonDevice), this.auth, bl);
    }

    private final int getNvCount(LonAddress lonAddress) throws LonException {
        boolean bl = NmUtil.isExtended(this.lonComm, lonAddress, this.auth);
        return Neuron.getAliasOffset(this.lonComm, lonAddress, this.auth, bl);
    }

    private final boolean verifyDomainTable(BLonDevice bLonDevice, StringBuffer stringBuffer) throws LonException {
        BAuthenticationKey bAuthenticationKey;
        stringBuffer.setLength(0);
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        int n = bDeviceData.getWorkingDomain();
        QueryDomainResponse queryDomainResponse = NmUtil.queryDomain(bLonDevice, n);
        BSubnetNode bSubnetNode = BSubnetNode.make(queryDomainResponse.getSubnet(), queryDomainResponse.getNodeId());
        if (!bSubnetNode.equals(bDeviceData.getSubnetNodeId())) {
            stringBuffer.append("\n  subnet/node mismatch : device = " + bSubnetNode + " db = " + bDeviceData.getSubnetNodeId());
        }
        if (!queryDomainResponse.sameDomain(this.netmgmt.getDomainId())) {
            stringBuffer.append("\n  domain mismatch : device = " + LonByteArrayUtil.toString(queryDomainResponse.getDomainId()) + " db = " + (Object)((Object)this.netmgmt.getDomainId()));
        }
        if (!(bAuthenticationKey = BAuthenticationKey.make(queryDomainResponse.getKey())).equals((Object)this.netmgmt.getAuthenticationKey())) {
            stringBuffer.append("\n  authentication key mismatch : device = " + (Object)((Object)bAuthenticationKey) + " db = " + (Object)((Object)this.netmgmt.getAuthenticationKey()));
        }
        if (bDeviceData.getTwoDomains()) {
            int n2;
            int n3 = 0;
            if (n == 0) {
                n3 = 1;
            }
            if ((queryDomainResponse = NmUtil.queryDomain(bLonDevice, n2 = n3)).inUse()) {
                stringBuffer.append("\n  domain mismatch : domain " + n2 + " not \"not in use\". " + queryDomainResponse);
            }
        }
        boolean bl = false;
        if (stringBuffer.length() > 0) {
            bl = true;
        }
        return bl;
    }

    private final void verifyNvConfigReport(BNvConfigData bNvConfigData, BNvConfigData bNvConfigData2, boolean bl, int n) {
        boolean bl2;
        boolean bl3 = false;
        if (bNvConfigData.isBoundNv() || bNvConfigData2.isBoundNv()) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        boolean bl5 = false;
        if (bNvConfigData.getDirection() != bNvConfigData2.getDirection()) {
            bl5 = true;
        }
        boolean bl6 = bl5;
        boolean bl7 = false;
        if (bNvConfigData.getSelector() != bNvConfigData2.getSelector()) {
            bl7 = true;
        }
        boolean bl8 = bl7;
        boolean bl9 = false;
        if (bl4 && bNvConfigData.getAddrIndex() != bNvConfigData2.getAddrIndex()) {
            bl9 = true;
        }
        boolean bl10 = bl9;
        boolean bl11 = false;
        if (bl4 && bNvConfigData.getAuthenticated() != bNvConfigData2.getAuthenticated()) {
            bl11 = true;
        }
        boolean bl12 = bl11;
        boolean bl13 = false;
        if (bl4 && bNvConfigData.getServiceType() != bNvConfigData2.getServiceType()) {
            bl13 = true;
        }
        boolean bl14 = bl13;
        boolean bl15 = false;
        if (bl4 && bNvConfigData.getPriority() != bNvConfigData2.getPriority()) {
            bl15 = true;
        }
        boolean bl16 = bl15;
        boolean bl17 = false;
        if (bl4 && bNvConfigData.getTurnAround() != bNvConfigData2.getTurnAround()) {
            bl17 = true;
        }
        boolean bl18 = bl17;
        boolean bl19 = false;
        if (bl && bl4 && ((BAliasConfigData)bNvConfigData).getPrimary() != ((BAliasConfigData)bNvConfigData2).getPrimary()) {
            bl19 = bl2 = true;
        }
        if (bl6 || bl8 || bl10 || bl12 || bl14 || bl16 || bl18 || bl2) {
            if (bl) {
                this.append("\n\n alias");
            } else {
                this.append("\n\n nv");
            }
            this.append(n + " mismatch:");
        }
        if (bl6) {
            this.append("\n  device direction = " + (Object)((Object)bNvConfigData.getDirection()) + " db direction = " + (Object)((Object)bNvConfigData2.getDirection()));
        }
        if (bl8) {
            this.append("\n  device selector = " + bNvConfigData.getSelector() + " db selector = " + bNvConfigData2.getSelector());
        }
        if (bl10) {
            this.append("\n  device addrIndex = " + bNvConfigData.getAddrIndex() + " db addrIndex = " + bNvConfigData2.getAddrIndex());
        }
        if (bl12) {
            this.append("\n  device authenticate = " + bNvConfigData.getAuthenticated() + " db authenticate = " + bNvConfigData2.getAuthenticated());
        }
        if (bl14) {
            this.append("\n  device service type = " + (Object)((Object)bNvConfigData.getServiceType()) + " db service type = " + (Object)((Object)bNvConfigData2.getServiceType()));
        }
        if (bl16) {
            this.append("\n  device priority = " + bNvConfigData.getPriority() + " db priority = " + bNvConfigData2.getPriority());
        }
        if (bl18) {
            this.append("\n  device turn around = " + bNvConfigData.getTurnAround() + " db turn around = " + bNvConfigData2.getTurnAround());
        }
        if (bl2) {
            this.append("\n  device primary nv = " + ((BAliasConfigData)bNvConfigData).getPrimary() + " db primary nv = " + ((BAliasConfigData)bNvConfigData2).getPrimary());
        }
    }

    private final void verifyAddressTable(BLonDevice bLonDevice) throws LonException {
        Object object;
        int n = bLonDevice.getDeviceData().getAddressCount();
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (!bDeviceData.isExtended() || bDeviceData.getExtAddressTable().isEntryInUse(n2)) {
                object = bDeviceData.getAddressEntry(n2);
                QueryAddrResponse queryAddrResponse = NmUtil.getAddressTableEntry(bLonDevice, n2);
                this.addressError((BIAddressEntry)object, queryAddrResponse, n2);
                bl = false;
            }
            ++n2;
        }
        if (bDeviceData.isExtended() && bl) {
            try {
                n2 = 0;
                while (n2 < n) {
                    object = NmUtil.getAddressTableEntry(bLonDevice, n2);
                    n2 = ((ExEnumerateAddressResponse)object).getAddressIndex();
                    this.addressError(bDeviceData.getAddressEntry(n2), (QueryAddrResponse)object, n2);
                    ++n2;
                }
            }
            catch (FailedResponseException failedResponseException) {
                return;
            }
        }
    }

    private final void addressError(BIAddressEntry bIAddressEntry, QueryAddrResponse queryAddrResponse, int n) {
        BAddressEntry bAddressEntry = BAddressEntry.make(queryAddrResponse.getAddressType(), queryAddrResponse.getSize(), queryAddrResponse.getGroupOrSubnet(), queryAddrResponse.getMemberOrNode(), bIAddressEntry.getDescriptor(), queryAddrResponse.getDomainIndex(), BLonRepeatTimer.make(queryAddrResponse.repeatTimer), queryAddrResponse.retryCount, BLonReceiveTimer.make(queryAddrResponse.receiveTimer), BLonRepeatTimer.make(queryAddrResponse.xmitTimer));
        if (!bIAddressEntry.equals(bAddressEntry)) {
            this.append("\n\n address entry " + n + " mismatch:");
            this.append("\n   device entry = " + bAddressEntry);
            try {
                this.append(" " + bAddressEntry.encodeToString());
            }
            catch (IOException iOException) {}
            this.append("\n   db entry = " + bIAddressEntry);
            try {
                this.append(" " + bIAddressEntry.encodeToString());
            }
            catch (IOException iOException) {}
        }
    }

    public String getNetworkSummary() {
        BDeviceData bDeviceData;
        NAddressManager nAddressManager = (NAddressManager)this.lonworks.addressManager();
        this.append("Lonworks Network Summary\n");
        this.append("\nLon Routers\n");
        Object[] objectArray = nAddressManager.getRouterList();
        Object object = new String[]{"Router", "Near Address", "Near Channel", "Far Address", "Far Channel", "NeuronId"};
        BLonDevice[] bLonDeviceArray = new PTable((String[])object);
        int n = 0;
        while (n < objectArray.length) {
            bDeviceData = objectArray[n].getFarDeviceData();
            BDeviceData bDeviceData2 = objectArray[n].getNearDeviceData();
            bLonDeviceArray.add(this.getName(objectArray[n]));
            bLonDeviceArray.add(bDeviceData2.getSubnetNodeId().toString());
            bLonDeviceArray.add(bDeviceData2.getChannelId());
            bLonDeviceArray.add(bDeviceData.getSubnetNodeId().toString());
            bLonDeviceArray.add(bDeviceData.getChannelId());
            bLonDeviceArray.add(bDeviceData2.getNeuronId().toString());
            ++n;
        }
        bLonDeviceArray.toString(this.out);
        objectArray = new String[]{"Device", "Channel", "Address", "NeuronId"};
        object = new PTable((String[])objectArray);
        bLonDeviceArray = nAddressManager.getDeviceList(true);
        n = 0;
        while (n < bLonDeviceArray.length) {
            bDeviceData = bLonDeviceArray[n].getDeviceData();
            ((PTable)object).add(this.getName((BComponent)bLonDeviceArray[n]));
            ((PTable)object).add(bDeviceData.getChannelId());
            ((PTable)object).add(bDeviceData.getSubnetNodeId().toString());
            ((PTable)object).add(bDeviceData.getNeuronId().toString());
            ++n;
        }
        ((PTable)object).toString(this.out);
        return "";
    }

    public String getNetMgmtSummary() {
        int n;
        String[] stringArray;
        Object object;
        Object object2;
        ConnectionTable connectionTable = new ConnectionTable(this.lonworks);
        this.append("Lonworks Network Management Summary \n");
        this.append("\nNetwork Variable Link Table\n");
        String[] stringArray2 = new String[]{"Sel", "Type", "Hub", "Status", "Addr", "Target", "Status", "Addr"};
        PTable pTable = new PTable(stringArray2);
        Connection[] connectionArray = connectionTable.getConnectionArray();
        int n2 = 0;
        while (n2 < connectionArray.length) {
            object2 = connectionArray[n2];
            while (object2 != null) {
                LonPoint lonPoint = object2.getHub();
                object = object2.getTargets();
                pTable.add(n2);
                pTable.add((Object)((Object)object2.getLinkType()) + (object2.getPriority() ? "/Priority" : ""));
                if (lonPoint == null) {
                    pTable.add("", 2);
                    if (((LonPoint[])object).length > 0) {
                        pTable.add("");
                    }
                } else {
                    pTable.add(lonPoint.getSummaryString());
                    pTable.add((Object)((Object)lonPoint.getStatus()) + (lonPoint.isPolled() ? "/Polled" : ""));
                    pTable.add(lonPoint.isLocal() ? "" : Integer.toString(lonPoint.getAddressIndex()));
                }
                if (((LonPoint[])object).length > 0) {
                    int n3 = 0;
                    while (n3 < ((LonPoint[])object).length) {
                        stringArray = object[n3];
                        pTable.add(stringArray.getSummaryString());
                        pTable.add((Object)((Object)stringArray.getStatus()) + (stringArray.isPolled() ? "/Polled" : ""));
                        pTable.add(stringArray.isLocal() ? "" : Integer.toString(stringArray.getAddressIndex()));
                        pTable.newRow();
                        pTable.add("", 5);
                        ++n3;
                    }
                }
                pTable.newRow();
                object2 = object2.getSecondary();
            }
            ++n2;
        }
        pTable.toString(this.out);
        this.append("\n");
        this.append("\nMessage Tag Link Table\n");
        String[] stringArray3 = new String[]{"AddrGrp", "Output", "AdrIndex", "Status", "Input", "Status"};
        pTable = new PTable(stringArray3);
        object2 = connectionTable.getMessageTagTable();
        int n4 = 0;
        while (n4 < ((TagConnection[])object2).length) {
            object = object2[n4].getInputs();
            TagPoint tagPoint = object2[n4].getOutput();
            int n5 = 1;
            if (((NetMgmtConst[])object).length != 0) {
                n5 = ((NetMgmtConst[])object).length;
            }
            int n6 = n5;
            n = 0;
            while (n < n6) {
                if (n == 0) {
                    pTable.add(object2[n4].getAddressGroup());
                    pTable.add(tagPoint.getSummaryString());
                    pTable.add(tagPoint.getTagIndex());
                    pTable.add((BObject)tagPoint.getStatus());
                } else {
                    pTable.add("", 4);
                }
                if (n < ((Object)object).length) {
                    pTable.add(((TagPoint)object[n]).getSummaryString());
                    pTable.add((BObject)((TagPoint)object[n]).getStatus());
                } else {
                    pTable.add("", 2);
                }
                ++n;
            }
            ++n4;
        }
        pTable.toString(this.out);
        this.append("\n");
        BLonDevice[] bLonDeviceArray = this.lonworks.addressManager().getDeviceList(true);
        object = connectionTable.getGroupTable();
        Group[] groupArray = ((GroupTable)object).getGroupArray();
        this.append("\nGroup Table\n");
        stringArray = new String[]{"Group", "Type", "Member", "Device", "Addr Ndx"};
        pTable = new PTable(stringArray);
        n = 0;
        while (n < groupArray.length) {
            if (groupArray[n] != null) {
                Group group = groupArray[n];
                pTable.add(n);
                pTable.add((BObject)group.getLinkType());
                GroupMember[] groupMemberArray = group.getMembers();
                int n7 = 0;
                while (n7 < groupMemberArray.length) {
                    GroupMember groupMember = groupMemberArray[n7];
                    pTable.add(n7);
                    pTable.add(this.getName((BComponent)bLonDeviceArray[groupMember.getDeviceIndex()]));
                    pTable.add(groupMember.getAddressIndex() + (groupMember.isMessageTag() ? "(mtag)" : ""));
                    pTable.newRow();
                    pTable.add("", 2);
                    ++n7;
                }
                pTable.newRow();
            }
            ++n;
        }
        pTable.toString(this.out);
        return "";
    }

    private final String getStatus() throws LonException {
        this.append("Device status for " + this.deviceName + '\n');
        this.getStatus(false);
        if (this.isRouter) {
            this.getRouterStatus(false);
            this.append("\n\nFar side");
            this.getStatus(true);
            this.getRouterStatus(true);
        }
        return "";
    }

    private final void updateNodeState(BLonNodeState bLonNodeState) {
        if (this.lonDevice != null) {
            this.lonDevice.getDeviceData().set(BDeviceData.nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
        }
        if (this.lonRouter != null) {
            this.lonRouter.getNearDeviceData().set(BDeviceData.nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
            this.lonRouter.getFarDeviceData().set(BDeviceData.nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
        }
    }

    private final void getStatus(boolean bl) throws LonException {
        QueryStatusResponse queryStatusResponse = NmUtil.queryStatus(this.lonComm, this.deviceAddr, 1, this.auth, bl);
        this.append("\n Transmit Errors               =  " + queryStatusResponse.xmitErrors);
        this.append("\n Transaction Timeouts          =  " + queryStatusResponse.transactionTimeouts);
        this.append("\n Receive Transaction Full      =  " + queryStatusResponse.rcvTransactionFull);
        this.append("\n Lost Messages (no app buff)   =  " + queryStatusResponse.lostMsgs);
        this.append("\n Missed Messages (no net buff) =  " + queryStatusResponse.missedMsgs);
        this.append("\n Reset Cause                   =  ");
        int n = queryStatusResponse.resetCause;
        if ((n & 1) != 0) {
            this.append("Power-up reset");
        } else if ((n & 2) != 0) {
            this.append("External reset");
        } else if ((n & 0xC) != 0) {
            this.append("Watchdog reset");
        } else if ((n & 0x14) != 0) {
            this.append("Software reset");
        } else if (n == 0) {
            this.append("Cleared");
        } else {
            this.append("0x" + Integer.toString(n, 16));
        }
        this.append("\n Node State                    =  ");
        int n2 = queryStatusResponse.nodeState;
        if ((n2 & 7) == 3) {
            this.append("Applicationless and unconfigured");
        } else if ((n2 & 7) == 2) {
            this.append("Unconfigured");
        } else if ((n2 & 0x8F) == 6) {
            this.append("Configured, hard off-line");
        } else if ((n2 & 0x8F) == 14) {
            this.append("Configured, hard off-line(0xe)");
        } else if ((n2 & 0x8F) == 140) {
            this.append("Configured, bypass off-line");
        } else if ((n2 & 0x8F) == 12) {
            this.append("Configured, soft off-line");
        } else if ((n2 & 0x8F) == 4) {
            this.append("Configured, on-line");
        } else {
            this.append("0x" + Integer.toString(n2, 16));
        }
        this.append("\n Version Number                =  " + queryStatusResponse.versionNumber);
        this.append("\n Error Log                     =  " + (queryStatusResponse.errorLog != 0 ? "ERROR: " : "") + this.getErrorText(queryStatusResponse.errorLog));
        this.append("\n Neuron Chip model             =  ");
        if (queryStatusResponse.modelNumber == 0) {
            this.append("3150");
        } else if (queryStatusResponse.modelNumber == 8) {
            this.append("3120");
        } else {
            this.append("model number " + queryStatusResponse.modelNumber);
        }
        try {
            byte[] byArray = Neuron.readMemory(this.lonComm, 3, this.deviceAddr, 10, 16, this.auth, bl);
            LonInputStream lonInputStream = new LonInputStream(byArray);
            this.append("\n Messages received by node     =  " + lonInputStream.readUnsigned16());
            this.append("\n Messages addressed to node    =  " + lonInputStream.readUnsigned16());
            this.append("\n Messages sent to MAC layer    =  " + lonInputStream.readUnsigned16());
            this.append("\n Retries                       =  " + lonInputStream.readUnsigned16());
            this.append("\n Backlog overflows             =  " + lonInputStream.readUnsigned16());
            this.append("\n Late acks of responses        =  " + lonInputStream.readUnsigned16());
            this.append("\n Collisions detected           =  " + lonInputStream.readUnsigned16());
            StringBuffer stringBuffer = new StringBuffer("\n EEPROM Lock                   =  ");
            boolean bl2 = false;
            if (lonInputStream.readUnsigned16() == 1) {
                bl2 = true;
            }
            this.append(stringBuffer.append(this.toBool(bl2)).toString());
        }
        catch (Throwable throwable) {
            this.append("\n\n Unable to read statistics struct");
        }
    }

    private final void getRouterStatus(boolean bl) throws LonException {
        RouterStatusResponse routerStatusResponse = RouterUtil.getRouterStatus(this.lonComm, this.deviceAddr, this.auth, bl);
        this.append("\n\nRouter type - ").append((Object)BLonRouterType.make(routerStatusResponse.getType()));
        this.append(" | mode - ").append((Object)BLonRouterMode.make(routerStatusResponse.getMode()));
    }

    private final String getErrorText(int n) {
        switch (n) {
            case 0: {
                return "no_error";
            }
            case 129: {
                return "bad_event";
            }
            case 130: {
                return "nv_length_mismatch";
            }
            case 131: {
                return "mv_msg_too_short";
            }
            case 132: {
                return "eeprom_write_fail";
            }
            case 133: {
                return "bad_address_type";
            }
            case 134: {
                return "preemption_mode_timeout";
            }
            case 135: {
                return "already_preempted";
            }
            case 136: {
                return "sync_nv_update_lost";
            }
            case 137: {
                return "invalid_resp_alloc";
            }
            case 138: {
                return "invalid_domain";
            }
            case 139: {
                return "read_past_end_of_msg";
            }
            case 140: {
                return "write_past_end_of_msg";
            }
            case 141: {
                return "invalid_addr_table_index";
            }
            case 142: {
                return "incomplete_msg";
            }
            case 143: {
                return "nv_update_on_output_nv";
            }
            case 144: {
                return "no_msg_avail";
            }
            case 145: {
                return "illegal_send";
            }
            case 146: {
                return "unknown_pdu";
            }
            case 147: {
                return "invalid_nv_index";
            }
            case 148: {
                return "divide_by_zero";
            }
            case 149: {
                return "invalid_appl_error";
            }
            case 150: {
                return "memory_alloc_railure";
            }
            case 151: {
                return "write_past_end_of_net_buffer";
            }
            case 152: {
                return "appl_cs_error";
            }
            case 153: {
                return "cnfg_cs_error";
            }
            case 154: {
                return "invalid_xcvr_reg_addr";
            }
            case 155: {
                return "xcvr_reg_timeout";
            }
            case 156: {
                return "write_past_end_of_appl_buffer";
            }
            case 157: {
                return "io_ready";
            }
            case 158: {
                return "self_test_failed";
            }
            case 159: {
                return "subnet_router";
            }
            case 160: {
                return "authentication_mismatch";
            }
            case 161: {
                return "self_inst_semaphore_set";
            }
            case 162: {
                return "read_write_semaphore_seet";
            }
            case 163: {
                return "appl_signature_bad";
            }
            case 164: {
                return "router_firmware_version_mismatch";
            }
        }
        return "unknown code " + Integer.toString(n);
    }

    public String getProgramIdSummary() {
        this.append("Table of available lnml files for Lonworks devices.\n");
        try {
            int n;
            Object[] objectArray;
            String[] stringArray = new String[]{"Module", "Name", "ProgramId"};
            PTable pTable = new PTable(stringArray, 2);
            String[] stringArray2 = Sys.getRegistry().getDefs();
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = LonUtilRequest.class("[Ljava.lang.String;", false);
            }
            Array array = new Array(clazz);
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = LonUtilRequest.class("[Ljava.lang.String;", false);
            }
            Array array2 = new Array(clazz2);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].startsWith("lonworks")) {
                    objectArray = Sys.getRegistry().getDefs(stringArray2[n2]);
                    n = 0;
                    while (n < objectArray.length) {
                        array.add((Object)stringArray2[n2].substring(9));
                        array2.add((Object)((String)objectArray[n]).substring(((String)objectArray[n]).indexOf("=") + 1));
                        ++n;
                    }
                }
                ++n2;
            }
            Object[] objectArray2 = (String[])array.trim();
            objectArray = (String[])array2.trim();
            SortUtil.sort((Object[])objectArray, (Object[])objectArray2);
            n = 0;
            while (n < objectArray.length) {
                int n3 = ((String)objectArray[n]).indexOf("/");
                if (n3 < 0) {
                    n3 = ((String)objectArray[n]).indexOf(":");
                }
                if (n3 >= 0) {
                    pTable.add(((String)objectArray[n]).substring(0, n3));
                    pTable.add(((String)objectArray[n]).substring(n3 + 1));
                    pTable.add((String)objectArray2[n]);
                    pTable.newRow();
                }
                ++n;
            }
            pTable.toString(this.out);
        }
        catch (Throwable throwable) {
            this.append("Error accessing londevices for available classes.\n\n");
            this.append(throwable.toString());
        }
        return "";
    }

    public String getTransmitErrors(boolean bl) {
        this.append("Table of lon device transmission errors.\n");
        try {
            String[] stringArray = new String[]{"Device", "Transmit", "Timeout", "ReceiveFull", "LostMsg", "MissedMsg", "LastError"};
            PTable pTable = new PTable(stringArray);
            BLonDevice[] bLonDeviceArray = this.lonworks.addressManager().getDeviceList(true);
            int n = 0;
            while (n < bLonDeviceArray.length) {
                block7: {
                    QueryStatusResponse queryStatusResponse;
                    block6: {
                        BLonDevice bLonDevice = bLonDeviceArray[n];
                        pTable.add(this.getName((BComponent)bLonDevice));
                        try {
                            queryStatusResponse = NmUtil.queryStatus(bLonDevice, 1);
                            if (!bl) break block6;
                            NmUtil.clearStatus(bLonDevice);
                        }
                        catch (LonException lonException) {
                            pTable.addBanner("Device not responding");
                            break block7;
                        }
                    }
                    pTable.add(queryStatusResponse.xmitErrors);
                    pTable.add(queryStatusResponse.transactionTimeouts);
                    pTable.add(queryStatusResponse.rcvTransactionFull);
                    pTable.add(queryStatusResponse.lostMsgs);
                    pTable.add(queryStatusResponse.missedMsgs);
                    pTable.add(this.getErrorText(queryStatusResponse.errorLog));
                    pTable.newRow();
                }
                ++n;
            }
            pTable.toString(this.out);
            this.append("\n");
            this.append("Report run at " + BAbsTime.make().toString(null) + '\n');
            if (bl) {
                this.append("NOTE: Running this report performs a clearStatus on specified devices.\n\n");
            }
            this.append("Transmit    - number of CRC errors detected during packet reception.\n");
            this.append("Timeout     - number of times node failed to receive expected msg response.\n");
            this.append("ReceiveFull - number of incoming messages discarded due to no room in transaction db.\n");
            this.append("LostMsg     - number of incoming messages discarded due to no app buffers.\n");
            this.append("MissedMsg   - number of incoming messages discarded due to no net buffers.\n");
            this.append("\n");
        }
        catch (Throwable throwable) {
            this.append("Error creating transmission error report.\n\n");
            this.append(throwable.toString());
        }
        return "";
    }

    public String readMemory() {
        this.append("Read memory:\n");
        int n = this.cmd.getMemAddr();
        int n2 = this.cmd.getCount();
        int n3 = 0;
        try {
            while (n3 < n2) {
                int n4 = n2 - n3;
                int n5 = n + n3;
                if (n4 > 16) {
                    n4 = 16;
                }
                byte[] byArray = Neuron.readMemory(this.lonComm, 0, this.deviceAddr, n5, n4, this.auth);
                n3 += byArray.length;
                this.append(this.toHex(n5 >> 8 & 0xFF) + this.toHex(n5 & 0xFF) + "   ");
                int n6 = 0;
                while (n6 < 16) {
                    this.append((n6 < byArray.length ? this.toHex(byArray[n6]) : "  ") + ' ');
                    ++n6;
                }
                this.append("  ");
                this.getString(byArray, 0, byArray.length);
                this.append("\n");
            }
        }
        catch (Throwable throwable) {
            this.append("\nERROR: reading memory");
        }
        return "";
    }

    private final String disableAuthentication() {
        try {
            Neuron.setNMAuthenticate(this.lonComm, this.deviceAddr, false);
        }
        catch (Throwable throwable) {
            return "Unable to disable authentication on " + this.deviceName + '.';
        }
        if (this.lonDevice != null) {
            this.lonDevice.getDeviceData().setAuthenticate(false);
        }
        return "Disabled authentication on " + this.deviceName + '.';
    }

    private final String getSelfDoc() {
        if (this.deviceAddr == BLocal.local) {
            return "Cannot access selfDocumentation on local device.";
        }
        this.append("Self Documentation for " + this.deviceName + ":\n");
        try {
            SelfDoc selfDoc = new SelfDoc(this.lonComm, this.deviceAddr, this.auth, this.isExtended());
            this.append("\nNode Self Documentation:\n");
            this.append(selfDoc.nodeDocString);
            this.append("\n");
            if (selfDoc.getBindingII()) {
                this.append("\nuses bindingII constraints");
            }
            if (selfDoc.getQueryStats()) {
                this.append("\nhas extended statistics");
            }
            this.append("\naliasCnt = ").append(selfDoc.getAliasCnt());
            this.append("\nmtagCnt = ").append(selfDoc.getMsgtagCount());
            this.append("\n\nSnvt self documentation:\n");
            String[] stringArray = new String[]{"Index", "Name", "Snvt", "Descriptor", "Array", "String"};
            PTable pTable = new PTable(stringArray);
            pTable.setColumnAttribute(1, 2);
            pTable.setColumnAttribute(2, 2);
            pTable.setColumnAttribute(3, 2);
            pTable.setColumnAttribute(5, 2);
            NvDoc[] nvDocArray = selfDoc.nvs;
            int n = 0;
            while (n < nvDocArray.length) {
                NvDoc nvDoc = nvDocArray[n];
                pTable.add(n);
                pTable.add(nvDoc.getName());
                pTable.add("" + (Object)((Object)BLonSnvtType.make(nvDoc.getSnvtType())) + '{' + nvDoc.getSnvtType() + '}');
                pTable.add(this.getDescFlags(nvDoc));
                pTable.add(nvDoc.getArraySize());
                if (nvDoc.selfDoc != null) {
                    pTable.add(this.fixString(nvDoc.selfDoc.selfDoc));
                } else {
                    pTable.newRow();
                }
                ++n;
            }
            pTable.toString(this.out);
            if (selfDoc.doc == null) {
                return "";
            }
            this.append("\nRaw data:\n");
            n = selfDoc.doc.length;
            int n2 = 0;
            int n3 = selfDoc.getSnvtStruct().numNvsDocs;
            byte[] byArray = selfDoc.doc;
            this.append("Snvt struct:\n");
            SnvtStruct snvtStruct = selfDoc.getSnvtStruct();
            this.append(LonByteArrayUtil.toString(snvtStruct.data, 16, ' ', selfDoc.hdrLength));
            this.append("\n\nDescriptor structs:\n");
            int n4 = 0;
            while (n4 < n3) {
                n2 += this.getBytes(byArray, n2, 2);
                this.append("\n");
                ++n4;
            }
            this.append("\nNode self doc:\n");
            n2 += this.getStringBytes(byArray, n2);
            this.append("\n\nNv self doc:\n");
            n4 = 0;
            while (n4 < n3) {
                byte by = selfDoc.doc[n2++];
                this.append(this.toHex(by)).append(' ');
                if ((by & 0x80) != 0) {
                    n2 += this.getBytes(byArray, n2, 1);
                }
                if ((by & 0x40) != 0) {
                    n2 += this.getBytes(byArray, n2, 1);
                }
                if ((by & 0x20) != 0) {
                    n2 += this.getStringBytes(byArray, n2);
                }
                if ((by & 0x10) != 0) {
                    n2 += this.getStringBytes(byArray, n2);
                }
                if ((by & 8) != 0) {
                    n2 += this.getBytes(byArray, n2, 2);
                }
                this.append('\n');
                ++n4;
            }
            if (n2 < n) {
                this.append("\nAlias field descriptions:\n");
                this.getBytes(byArray, n2, n - n2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.append("\n\nUnable to read self documentation.");
        }
        return "";
    }

    private final String getDescFlags(NvDoc nvDoc) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nvDoc.hasExtension()) {
            stringBuffer.append("ext,");
        }
        if (nvDoc.isSychronous()) {
            stringBuffer.append("sync,");
        }
        if (nvDoc.isPolled()) {
            stringBuffer.append("polled,");
        }
        if (nvDoc.isUpdateOffline()) {
            stringBuffer.append("updOfLn,");
        }
        if (nvDoc.isServTypeConfig()) {
            stringBuffer.append("svrCnf,");
        }
        if (nvDoc.isPriorityConfig()) {
            stringBuffer.append("priCnf,");
        }
        if (nvDoc.isAuthConfigurable()) {
            stringBuffer.append("authCnf,");
        }
        if (nvDoc.isConfigNv()) {
            stringBuffer.append("cnfgNv");
        }
        String string = stringBuffer.toString();
        return string.substring(0, string.length() - 1);
    }

    private final String fixString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c <= ' ') {
                stringBuffer.append('\\').append(this.toHex(c + 64));
            } else if (c >= '\u007f') {
                stringBuffer.append("\\x").append(this.toHex(c));
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private final int getBytes(byte[] byArray, int n, int n2) {
        this.append(LonByteArrayUtil.toString(byArray, 16, ' ', n2, n));
        return n2;
    }

    private final int getStringBytes(byte[] byArray, int n) {
        char c;
        int n2 = 0;
        while ((c = (char)byArray[n + n2]) != '\u0000') {
            this.append(this.toHex(c)).append(' ');
            ++n2;
        }
        this.append(this.toHex(c)).append(' ');
        return ++n2;
    }

    private final void bytesToString(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2 && n + n3 < byArray.length) {
            byte by;
            if ((by = byArray[n + n3++]) >= 32 && by <= 126) {
                this.append((char)by);
                continue;
            }
            this.append('.');
        }
    }

    private final String test() throws LonException {
        return "Test complete.";
    }

    private final LonUtilRequest append(String string) {
        this.out.print(string);
        this.out.flush();
        return this;
    }

    private final LonUtilRequest append(int n) {
        this.out.print(n);
        return this;
    }

    private final LonUtilRequest append(char c) {
        this.out.print(c);
        return this;
    }

    private final LonUtilRequest append(Object object) {
        return this.append(object.toString());
    }

    private final boolean isExtended() {
        if (this.checkExtended) {
            this.isExtended = NmUtil.isExtended(this.lonComm, this.deviceAddr, this.auth);
            this.checkExtended = false;
        }
        return this.isExtended;
    }

    private final String toHex(int n) {
        return ((n &= 0xFF) > 15 ? "" : "0") + Integer.toString(n, 16);
    }

    private final String toBool(int n, int n2) {
        return (n >>> n2 & 1) == 1 ? "Yes" : "No";
    }

    private final String toBool(boolean bl) {
        return bl ? "Yes" : "No";
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LonUtilRequest(BUtilitiesCommand bUtilitiesCommand, BLonNetmgmt bLonNetmgmt, PrintWriter printWriter) {
        this(bUtilitiesCommand, bLonNetmgmt, printWriter, null);
    }

    public LonUtilRequest(BUtilitiesCommand bUtilitiesCommand, BLonNetmgmt bLonNetmgmt, PrintWriter printWriter, BUtilCmdJob bUtilCmdJob) {
        this.netmgmt = bLonNetmgmt;
        this.lonworks = bLonNetmgmt.lonNetwork();
        this.lonComm = (NLonComm)this.lonworks.lonComm();
        this.cmd = bUtilitiesCommand;
        this.out = printWriter;
        this.job = bUtilCmdJob;
        if (bUtilitiesCommand.isDevice()) {
            this.deviceAddr = bUtilitiesCommand.getNeuronId();
            this.lonDevice = this.lonworks.addressManager().getDeviceByAddress(bUtilitiesCommand.getSubnetNodeId());
            if (this.lonDevice == null) {
                this.deviceName = SlotPath.unescape((String)bUtilitiesCommand.getDisplayName());
                this.auth = false;
                this.checkExtended = true;
            } else {
                this.deviceName = this.getName((BComponent)this.lonDevice);
                this.auth = this.lonDevice.authenticate();
                if (this.lonDevice.isLocal()) {
                    this.deviceAddr = BLocal.local;
                }
                this.isExtended = this.lonDevice.isExtended();
                this.checkExtended = false;
            }
            this.isRouter = false;
        } else {
            this.deviceAddr = bUtilitiesCommand.getNeuronId();
            this.lonRouter = this.lonworks.addressManager().getRouterByAddress(bUtilitiesCommand.getSubnetNodeId());
            if (this.lonRouter == null) {
                this.deviceName = SlotPath.unescape((String)bUtilitiesCommand.getDisplayName());
                this.auth = false;
            } else {
                this.deviceName = this.getName(this.lonRouter);
                this.auth = this.lonRouter.authenticate();
            }
            this.isRouter = true;
        }
        try {
            this.auth = Neuron.isNMAuthSet(this.lonComm, this.deviceAddr, this.auth, false);
        }
        catch (Throwable throwable) {}
    }
}

