/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BLinkDescriptor;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.lonworks.BINvContainer;
import javax.baja.lonworks.BLocalLonDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonServiceType;
import javax.baja.sys.BComponent;

public class LonPoint
implements NetMgmtConst {
    protected BINvContainer nvCntr;
    protected BNetworkVariable origNv;
    protected BLonLinkStatus status;
    protected int addressIndex;
    public int overlappCnt;

    public Object cloneMe() {
        LonPoint lonPoint = new LonPoint();
        lonPoint.nvCntr = this.nvCntr;
        lonPoint.status = this.status;
        lonPoint.origNv = this.origNv;
        lonPoint.addressIndex = this.addressIndex;
        return lonPoint;
    }

    public BINvContainer getNvContainer() {
        return this.nvCntr;
    }

    public BLonDevice getLonDevice() {
        return this.nvCntr.getLonDevice();
    }

    public int getNvIndex() {
        return this.getNvProps().getNvIndex();
    }

    public int getAddressIndex() {
        return this.addressIndex;
    }

    public BLonLinkStatus getStatus() {
        return this.status;
    }

    public BLonNvDirection getDirection() {
        return this.getNvConfigData().getDirection();
    }

    public BNvProps getNvProps() {
        return this.origNv.getNvProps();
    }

    public BNvConfigData getNvConfigData() {
        return this.origNv.getNvConfigData();
    }

    public BNetworkVariable getNetworkVariable() {
        return this.origNv;
    }

    public boolean isAuthenticated() {
        return this.getNvConfigData().getAuthenticated();
    }

    public boolean isPolled() {
        return this.getNvProps().getPolled();
    }

    public int getOrigSelector() {
        return this.getNvConfigData().getSelector();
    }

    public BNvConfigData getWorkingNvConfigData() {
        return this.getNvConfigData();
    }

    public boolean isSameDevicePoint(LonPoint lonPoint) {
        boolean bl = false;
        if (this.getLonDevice() == lonPoint.getLonDevice()) {
            bl = true;
        }
        return bl;
    }

    public void setAddressIndex(int n) {
        this.addressIndex = n;
    }

    public void setStatus(BLonLinkStatus bLonLinkStatus) {
        this.status = bLonLinkStatus;
    }

    public boolean isNew() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.newLink) {
            bl = true;
        }
        return bl;
    }

    public boolean isObsolete() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.obsolete) {
            bl = true;
        }
        return bl;
    }

    public boolean isBound() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.bound) {
            bl = true;
        }
        return bl;
    }

    public boolean isUnbound() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.unbound) {
            bl = true;
        }
        return bl;
    }

    public boolean isActive() {
        boolean bl = false;
        if (this.status == BLonLinkStatus.bound || this.status == BLonLinkStatus.newLink) {
            bl = true;
        }
        return bl;
    }

    public boolean isOutput() {
        boolean bl = false;
        if (this.getDirection() == BLonNvDirection.output) {
            bl = true;
        }
        return bl;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public boolean isPseudo() {
        return false;
    }

    public boolean isError() {
        return this.status.isError();
    }

    public int getSnvtType() {
        return this.getNvProps().getSnvtType();
    }

    public boolean isAliasPoint() {
        return false;
    }

    public String getDeviceName() {
        if (this.nvCntr == null) {
            return "null";
        }
        if (this.nvCntr.isLonObject()) {
            return this.nvCntr.getLonDevice().getDisplayName(null) + '.' + this.nvCntr.getDisplayName(null);
        }
        if (((BComponent)this.nvCntr).getParent() instanceof BLonNetwork) {
            return this.nvCntr.getDisplayName(null);
        }
        return ((BComponent)this.nvCntr).getParent().getDisplayName(null) + '.' + this.nvCntr.getDisplayName(null);
    }

    public boolean isSameNode(BINvContainer bINvContainer) {
        boolean bl = false;
        if (this.nvCntr.getLonDevice() == bINvContainer.getLonDevice()) {
            bl = true;
        }
        return bl;
    }

    public boolean requiresUnbind(boolean bl) {
        boolean bl2 = false;
        if (this.isObsolete() || this.isBound() && bl) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean requiresAddressEntry() {
        boolean bl;
        if (this.isPolled()) {
            bl = false;
            if (this.getDirection() == BLonNvDirection.input) {
                bl = true;
            }
        } else {
            bl = false;
            if (this.getDirection() == BLonNvDirection.output) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isPriority() {
        return this.getNvConfigData().getPriority();
    }

    public void clearLocalIndex() {
    }

    public int getAddressGroup() {
        BIAddressEntry bIAddressEntry;
        if (this.addressIndex != -1 && (bIAddressEntry = this.getAddressEntry(this.addressIndex)).isGroupAddress()) {
            return bIAddressEntry.getGroupOrSubnet();
        }
        return -1;
    }

    public BIAddressEntry getAddressEntry() {
        if (this.addressIndex != -1) {
            return this.getAddressEntry(this.addressIndex);
        }
        return null;
    }

    protected BIAddressEntry getAddressEntry(int n) {
        return this.nvCntr.getDeviceData().getAddressEntry(n);
    }

    public void setAddressEntry(BIAddressEntry bIAddressEntry) {
        this.nvCntr.getDeviceData().setAddressEntry(this.addressIndex, bIAddressEntry);
    }

    public String getNvName() {
        String string = this.getNvProps().getParent().getDisplayName(null);
        return string == null ? "" : string;
    }

    public String getSummaryString() {
        return this.getDeviceName() + ':' + this.getNvName() + '.' + this.getNvIndex();
    }

    public int hashCode() {
        BSubnetNode bSubnetNode = this.nvCntr.getDeviceData().getSubnetNodeId();
        int n = (bSubnetNode.getSubnetId() << 20) + (bSubnetNode.getNodeId() << 13) + this.getNvIndex();
        return n;
    }

    public boolean equals(LonPoint lonPoint) {
        boolean bl = false;
        if (this.hashCode() == lonPoint.hashCode()) {
            bl = true;
        }
        return bl;
    }

    public void changeLinkType(BLonLinkType bLonLinkType, boolean bl) {
        if (this.status == BLonLinkStatus.serviceTypeError) {
            this.status = BLonLinkStatus.newLink;
        }
        this.validatePoint(bLonLinkType, bl, false);
    }

    public boolean addressIndexIsLocal() {
        BIAddressEntry bIAddressEntry = this.getAddressEntry();
        if (bIAddressEntry == null || this.nvCntr == null) {
            return false;
        }
        BLocalLonDevice bLocalLonDevice = this.nvCntr.getLonNetwork().getLocalLonDevice();
        switch (bIAddressEntry.getAddressType().getOrdinal()) {
            case 2: {
                BSubnetNode bSubnetNode = bLocalLonDevice.getSubnetNodeAddress();
                if (bIAddressEntry.getGroupOrSubnet() != bSubnetNode.getSubnetId() || bIAddressEntry.getMemberOrNode() != bSubnetNode.getNodeId()) break;
                return true;
            }
            case 1: {
                int n = bIAddressEntry.getGroupOrSubnet();
                BAddressEntry[] bAddressEntryArray = bLocalLonDevice.getDeviceData().getAddressTable().getAddresses();
                int n2 = 0;
                while (n2 < bAddressEntryArray.length) {
                    if (bAddressEntryArray[n2].getGroupOrSubnet() == n) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        return false;
    }

    public boolean validatePoint(BLonLinkType bLonLinkType, boolean bl, boolean bl2) {
        return this.validatePoint(bLonLinkType, bl, bl2, false);
    }

    public boolean validatePoint(BLonLinkType bLonLinkType, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4;
        if (!this.isActive()) {
            return true;
        }
        BNvConfigData bNvConfigData = this.getWorkingNvConfigData();
        BLonServiceType bLonServiceType = NmUtil.linkTypeToServiceType(bLonLinkType);
        if (!this.getNvProps().getServiceConf() && bLonServiceType != bNvConfigData.getServiceType()) {
            if (bl2) {
                System.out.println("service type is not configurable");
            }
            this.status = BLonLinkStatus.serviceTypeError;
            return false;
        }
        boolean bl5 = false;
        if (bLonLinkType == BLonLinkType.authenticated) {
            bl5 = bl4 = true;
        }
        if (!this.getNvProps().getAuthConf() && bNvConfigData.getAuthenticated() != bl4) {
            if (bl2) {
                System.out.println("authenticate is not configurable");
            }
            this.status = BLonLinkStatus.authicateError;
            return false;
        }
        if (this.requiresAddressEntry() && !this.getNvProps().getPriorityConf() && bNvConfigData.getPriority() != bl) {
            if (bl2) {
                System.out.println("priority is not configurable");
            }
            this.status = BLonLinkStatus.priorityError;
            return false;
        }
        if (!(this.isLocal() || this.isPseudo() || (object = this.nvCntr.getLonDevice()).isConfigOnline() && !object.getStatus().isDown())) {
            if (bl2) {
                System.out.println("not communicative state");
            }
            this.status = BLonLinkStatus.deviceError;
            return false;
        }
        if (bLonLinkType == BLonLinkType.pollOnly) {
            return true;
        }
        if (this.addressIndex != -1 && (object = this.getAddressEntry()) != null && !this.entryMatch((BIAddressEntry)object, bLonLinkType) && this.status == BLonLinkStatus.bound) {
            if (bl2) {
                System.out.println("descriptors must match");
            }
            this.status = BLonLinkStatus.descriptorError;
            return false;
        }
        if (bl3 && bNvConfigData.getServiceType() != bLonServiceType && this.status == BLonLinkStatus.bound) {
            if (bl2) {
                System.out.println("Must match nvConfig service type");
            }
            this.status = BLonLinkStatus.newLink;
            return false;
        }
        if (bNvConfigData.getAuthenticated() != bl4) {
            if (bl2) {
                System.out.println("Must match nvConfig authenticate ");
            }
            this.status = BLonLinkStatus.newLink;
            return false;
        }
        if ((this.requiresAddressEntry() || this.isPolled() && this.isOutput()) && bNvConfigData.getServiceType() != bLonServiceType) {
            if (bl2) {
                System.out.println("Must match nvConfig service type");
            }
            this.status = BLonLinkStatus.newLink;
            return false;
        }
        if ((this.requiresAddressEntry() || this.isPolled() && this.isOutput()) && bNvConfigData.getPriority() != bl) {
            if (bl2) {
                System.out.println("Must match nvConfig service type priority");
            }
            this.status = BLonLinkStatus.newLink;
            return false;
        }
        return true;
    }

    private final boolean entryMatch(BIAddressEntry bIAddressEntry, BLonLinkType bLonLinkType) {
        if (NmUtil.getLinkType(bIAddressEntry.getDescriptor()) != bLonLinkType) {
            return false;
        }
        BLinkDescriptor bLinkDescriptor = this.getLonDevice().lonNetwork().netmgmt().getLinkDescriptors().getDescriptor(bIAddressEntry.getDescriptor());
        return bLinkDescriptor.entryMatches(bIAddressEntry);
    }

    public String toString() {
        return this.getSummaryString() + (this.isAuthenticated() ? " authenticate" : "") + ' ' + (Object)((Object)this.status) + " adrNdx = " + this.addressIndex;
    }

    public LonPoint(BINvContainer bINvContainer, BNetworkVariable bNetworkVariable) {
        this(bINvContainer, bNetworkVariable, BLonLinkStatus.newLink);
    }

    public LonPoint(BINvContainer bINvContainer, BNetworkVariable bNetworkVariable, BLonLinkStatus bLonLinkStatus) {
        this.nvCntr = bINvContainer;
        this.status = bLonLinkStatus;
        this.origNv = bNetworkVariable;
        this.addressIndex = -1;
    }

    protected LonPoint() {
    }
}

