/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import java.util.BitSet;
import javax.baja.lonworks.BLonDevice;

public class GroupBitSet {
    private BitSet bitSet;
    private int groupSize;

    public static GroupBitSet getMirror(int n, GroupBitSet groupBitSet) {
        GroupBitSet groupBitSet2 = new GroupBitSet(n);
        int n2 = Math.min(n, groupBitSet.size());
        int n3 = 0;
        while (n3 < n2) {
            if (!groupBitSet.get(n3)) {
                groupBitSet2.set(n3);
            }
            ++n3;
        }
        return groupBitSet2;
    }

    public static int findDeviceNdx(BLonDevice[] bLonDeviceArray, BLonDevice bLonDevice) {
        int n = bLonDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (bLonDeviceArray[n2] == bLonDevice) {
                return n2;
            }
            ++n2;
        }
        System.out.println("ERROR: in GroupBitSet.findDeviceNdx() could not find device " + bLonDevice.getDisplayName(null));
        return 0;
    }

    public boolean contains(GroupBitSet groupBitSet, GroupBitSet groupBitSet2) {
        BitSet bitSet = (BitSet)groupBitSet.bitSet.clone();
        bitSet.and(this.bitSet);
        if (!bitSet.equals(groupBitSet.bitSet)) {
            return false;
        }
        if (groupBitSet2 != null) {
            int n = 0;
            while (n < this.bitSet.size()) {
                if (groupBitSet2.bitSet.get(n) && this.bitSet.get(n)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public boolean equals(GroupBitSet groupBitSet) {
        return this.bitSet.equals(groupBitSet.bitSet);
    }

    public boolean excludes(GroupBitSet groupBitSet) {
        if (groupBitSet == null) {
            return true;
        }
        int n = 0;
        while (n < this.bitSet.size()) {
            if (groupBitSet.bitSet.get(n) && this.bitSet.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void set(int n) {
        if (this.bitSet.get(n)) {
            return;
        }
        ++this.groupSize;
        this.bitSet.set(n);
    }

    public void clear(int n) {
        if (!this.bitSet.get(n)) {
            return;
        }
        --this.groupSize;
        this.bitSet.clear(n);
    }

    public boolean get(int n) {
        return this.bitSet.get(n);
    }

    public void or(GroupBitSet groupBitSet) {
        this.bitSet.or(groupBitSet.bitSet);
    }

    public void and(GroupBitSet groupBitSet) {
        this.bitSet.and(groupBitSet.bitSet);
    }

    public void xor(GroupBitSet groupBitSet) {
        this.bitSet.xor(groupBitSet.bitSet);
    }

    public String toString() {
        return this.bitSet.toString();
    }

    public int size() {
        return this.bitSet.size();
    }

    public int getGroupSize() {
        return this.groupSize;
    }

    public GroupBitSet(int n) {
        this.bitSet = new BitSet(n);
        this.groupSize = 0;
    }

    public GroupBitSet(GroupBitSet groupBitSet) {
        this.bitSet = (BitSet)groupBitSet.bitSet.clone();
        this.groupSize = groupBitSet.groupSize;
    }

    public GroupBitSet(BLonDevice[] bLonDeviceArray, BLonDevice[] bLonDeviceArray2) {
        int n = bLonDeviceArray2.length;
        this.bitSet = new BitSet(bLonDeviceArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, bLonDeviceArray2[n2]));
            ++n2;
        }
    }

    public GroupBitSet(BLonDevice[] bLonDeviceArray, Connection connection) {
        LonPoint lonPoint = connection.getHub();
        LonPoint[] lonPointArray = connection.getTargets();
        this.bitSet = new BitSet(bLonDeviceArray.length);
        if (lonPoint != null && lonPoint.isActive()) {
            this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, lonPoint.getLonDevice()));
        }
        int n = 0;
        while (n < lonPointArray.length) {
            if (lonPointArray[n].isActive()) {
                this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, lonPointArray[n].getLonDevice()));
            }
            ++n;
        }
    }

    public GroupBitSet(BLonDevice[] bLonDeviceArray, LonPoint[] lonPointArray) {
        this.bitSet = new BitSet(bLonDeviceArray.length);
        int n = 0;
        while (n < lonPointArray.length) {
            if (lonPointArray[n].isActive()) {
                this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, lonPointArray[n].getLonDevice()));
            }
            ++n;
        }
    }

    public GroupBitSet(BLonDevice[] bLonDeviceArray, TagConnection tagConnection, boolean bl) {
        TagPoint[] tagPointArray = tagConnection.getInputs();
        this.bitSet = new BitSet(bLonDeviceArray.length);
        int n = 0;
        while (n < tagPointArray.length) {
            if (tagPointArray[n].isActive() && (bl || !tagPointArray[n].isMtag())) {
                this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, tagPointArray[n].getLonDevice()));
            }
            ++n;
        }
        if (bl) {
            this.set(GroupBitSet.findDeviceNdx(bLonDeviceArray, tagConnection.getOutput().getLonDevice()));
        }
    }
}

