/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.GroupBitSet;
import com.tridium.lonworks.netmgmt.GroupMember;
import com.tridium.lonworks.util.NmUtil;
import java.util.Vector;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.enums.BAddressType;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.sys.BComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Group {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_MODIFIED = 1;
    public static final int STATUS_UPDATED = 2;
    public static final int STATUS_ERROR = 3;
    private int groupNum;
    private BLonLinkType linkType;
    private Vector members;
    private GroupBitSet groupBits;
    private int size;
    private int expectedSize;
    private int status;

    public int getGroupNum() {
        return this.groupNum;
    }

    public BLonLinkType getLinkType() {
        return this.linkType;
    }

    public GroupBitSet getBitSet() {
        return this.groupBits;
    }

    public int getSize() {
        return this.size;
    }

    public int getExpectedSize() {
        return this.expectedSize;
    }

    public int getStatus() {
        return this.status;
    }

    public GroupMember[] getMembers() {
        Object[] objectArray = new GroupMember[this.members.size()];
        this.members.copyInto(objectArray);
        return objectArray;
    }

    public void setLinkType(BLonLinkType bLonLinkType) {
        this.linkType = bLonLinkType;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public boolean isUpdated() {
        boolean bl = false;
        if (this.status == 2) {
            bl = true;
        }
        return bl;
    }

    public int[] getMemberIndices() {
        int[] nArray = new int[this.members.size()];
        int n = 0;
        while (n < this.members.size()) {
            GroupMember groupMember = (GroupMember)this.members.elementAt(n);
            nArray[n] = groupMember.getDeviceIndex();
            ++n;
        }
        return nArray;
    }

    public BLonDevice[] getMemberDevices(BLonDevice[] bLonDeviceArray) {
        BLonDevice[] bLonDeviceArray2 = new BLonDevice[this.members.size()];
        int n = 0;
        while (n < this.members.size()) {
            GroupMember groupMember = (GroupMember)this.members.elementAt(n);
            bLonDeviceArray2[n] = bLonDeviceArray[groupMember.getDeviceIndex()];
            ++n;
        }
        return bLonDeviceArray2;
    }

    public void addMember(GroupMember groupMember) {
        if (!this.isMember(groupMember.getDeviceIndex())) {
            this.members.addElement(groupMember);
            this.groupBits.set(groupMember.getDeviceIndex());
            ++this.size;
        }
    }

    public boolean isMember(int n) {
        return this.groupBits.get(n);
    }

    public void removeMember(int n) {
        int n2 = this.members.size();
        if (this.isMember(n)) {
            this.groupBits.clear(n);
            --this.size;
            int n3 = 0;
            while (n3 < n2) {
                if (((GroupMember)this.members.elementAt(n3)).getDeviceIndex() == n) {
                    this.members.removeElementAt(n3);
                    if (this.status == 2) {
                        this.status = 1;
                    }
                    return;
                }
                ++n3;
            }
        }
    }

    public void updateGroup(BLonDevice[] bLonDeviceArray, Vector vector, BLonBindJob bLonBindJob) {
        int n = this.members.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            GroupMember groupMember = (GroupMember)this.members.elementAt(n3);
            BLonDevice bLonDevice = bLonDeviceArray[groupMember.getDeviceIndex()];
            int n4 = NmUtil.linkTypeToDescriptor(this.linkType);
            BAddressEntry bAddressEntry = BAddressEntry.make(BAddressType.group, n, this.groupNum, n3, n4, bLonDevice.getDeviceData().getWorkingDomain(), NmUtil.getLonNetwork((BComponent)bLonDevice).netmgmt().getLinkDescriptors().getDescriptor(n4));
            BDeviceData bDeviceData = bLonDevice.getDeviceData();
            int n5 = groupMember.getAddressIndex();
            bDeviceData.setAddressEntry(n5, bAddressEntry, AddressManager.noDeviceChange);
            try {
                if (Lon.n()) {
                    NmUtil.setOfflineInBind(bLonDevice, vector);
                    NmUtil.updateAddressTable(bLonDevice, n5);
                    if (!NmUtil.verifyAddressEntry(bLonDevice, n5)) {
                        bLonBindJob.error("ERROR: unable to verify address entry " + n5 + " in " + bLonDevice.getDisplayName(null), null);
                    }
                }
            }
            catch (Throwable throwable) {
                bLonBindJob.error("ERROR: in Group.updateGroup() - comm failure to " + bLonDevice.getDisplayName(null), throwable);
                n2 = 1;
                bAddressEntry = BAddressEntry.make(BAddressType.group, 0, this.groupNum, n3, n4, bLonDevice.getDeviceData().getWorkingDomain(), NmUtil.getLonNetwork((BComponent)bLonDevice).netmgmt().getLinkDescriptors().getDescriptor(n4));
                bDeviceData.setAddressEntry(n5, bAddressEntry);
            }
            ++n3;
        }
        this.status = n2 + 2;
    }

    public GroupMember findMember(int n) {
        int n2 = this.members.size();
        int n3 = 0;
        while (n3 < n2) {
            GroupMember groupMember = (GroupMember)this.members.elementAt(n3);
            if (groupMember.getDeviceIndex() == n) {
                return groupMember;
            }
            ++n3;
        }
        return null;
    }

    public boolean hasMessageTag() {
        int n = this.members.size();
        int n2 = 0;
        while (n2 < n) {
            if (((GroupMember)this.members.elementAt(n2)).isMessageTag()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.members.size();
        stringBuffer.append("\nGroup #").append(this.groupNum).append(" linkType = ").append((Object)this.linkType);
        stringBuffer.append(" size = ").append(n).append(" expected = ").append(this.expectedSize);
        stringBuffer.append(" status - ");
        switch (this.status) {
            case 0: {
                stringBuffer.append("NEW");
                break;
            }
            case 1: {
                stringBuffer.append("MODIFIED");
                break;
            }
            case 2: {
                stringBuffer.append("UPDATED");
                break;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n   member #").append(n2).append(" ").append(this.members.elementAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.linkType = BLonLinkType.unknown;
        this.members = new Vector(32);
        this.size = 0;
        this.expectedSize = 0;
    }

    public Group(int n, int n2) {
        this(n, n2, BLonLinkType.unknown, 0);
    }

    public Group(int n, int n2, BLonLinkType bLonLinkType) {
        this(n, n2, bLonLinkType, 0);
    }

    public Group(int n, int n2, BLonLinkType bLonLinkType, int n3) {
        this(n, n2, bLonLinkType, n3, 0);
    }

    public Group(int n, int n2, BLonLinkType bLonLinkType, int n3, int n4) {
        this.this();
        this.groupNum = n;
        this.linkType = bLonLinkType;
        this.status = n3;
        this.expectedSize = n4;
        this.groupBits = new GroupBitSet(n2);
    }
}

