/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupBitSet;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.LonPointAlias;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import java.util.Vector;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNvDirection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Connection
implements NetMgmtConst {
    LonPoint[] tgtArray;
    private boolean foundExBitSet;
    private GroupBitSet groupBitSet;
    private GroupBitSet excludeBits;
    private GroupBitSet targetBitSet;
    private BLonLinkType linkType;
    private int addressGroup;
    private boolean addressChange;
    private LonPoint hub;
    private Vector targets;
    private Vector aliasConnections;
    private Connection primary;
    private boolean debug;
    private boolean priority;
    private int selector;
    private Connection root;
    private Connection secondary;

    public int getTargetCount() {
        return this.targets.size();
    }

    public int getAddressGroup() {
        return this.addressGroup;
    }

    public BLonLinkType getLinkType() {
        return this.linkType;
    }

    public LonPoint getHub() {
        return this.hub;
    }

    public boolean isAddressChange() {
        return this.addressChange;
    }

    public int getSelector() {
        return this.selector;
    }

    public Connection getSecondary() {
        return this.secondary;
    }

    public Connection getPrimary() {
        return this.primary;
    }

    public Connection getRoot() {
        return this.root;
    }

    public boolean getPriority() {
        return this.priority;
    }

    public LonPoint[] getTargets() {
        if (this.tgtArray == null || this.tgtArray.length != this.targets.size()) {
            this.tgtArray = new LonPoint[this.targets.size()];
        }
        this.targets.copyInto(this.tgtArray);
        return this.tgtArray;
    }

    public LonPoint getTarget(int n) {
        return (LonPoint)this.targets.elementAt(n);
    }

    public void setAddressChange(boolean bl) {
        this.addressChange = bl;
    }

    public void setAddressGroup(int n) {
        this.addressGroup = n;
    }

    public void setLinkType(BLonLinkType bLonLinkType) {
        this.linkType = bLonLinkType;
    }

    public void setHub(LonPoint lonPoint) {
        this.hub = lonPoint;
    }

    public void setSelector(int n) {
        this.selector = n;
    }

    public void setPriority(boolean bl) {
        this.priority = bl;
    }

    public void changeLinkType(BLonLinkType bLonLinkType, boolean bl) {
        this.doChangeLinkType(bLonLinkType, bl);
    }

    private final void doChangeLinkType(BLonLinkType bLonLinkType, boolean bl) {
        this.linkType = bLonLinkType;
        if (this.hub != null) {
            this.hub.changeLinkType(bLonLinkType, bl);
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            ((LonPoint)this.targets.elementAt(n2)).changeLinkType(bLonLinkType, bl);
            ++n2;
        }
    }

    public boolean isAcknowledged() {
        boolean bl = false;
        if (this.linkType == BLonLinkType.critical || this.linkType == BLonLinkType.authenticated) {
            bl = true;
        }
        return bl;
    }

    public boolean isAuthenticated() {
        boolean bl = false;
        if (this.linkType == BLonLinkType.authenticated) {
            bl = true;
        }
        return bl;
    }

    public int getActiveTargetCount() {
        int n = this.targets.size();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            block3: {
                block4: {
                    LonPoint lonPoint = (LonPoint)this.targets.elementAt(n3);
                    if (!lonPoint.isActive()) break block3;
                    if (!lonPoint.isProxy()) break block4;
                    if (bl) break block3;
                    bl = true;
                }
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public boolean hasActiveTarget() {
        int n = 0;
        while (n < this.targets.size()) {
            if (((LonPoint)this.targets.elementAt(n)).isActive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public LonPoint getActiveTargetNotTurnaround() {
        int n = 0;
        while (n < this.targets.size()) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n);
            if ((this.hub == null || !this.hub.isSameNode(lonPoint.getLonDevice())) && lonPoint.isActive()) {
                return lonPoint;
            }
            ++n;
        }
        return null;
    }

    public int discoverAddressGroup() {
        int n;
        if (this.hub != null && !this.hub.isNew() && (n = this.hub.getAddressGroup()) > 0) {
            return n;
        }
        int n2 = this.targets.size();
        int n3 = 0;
        while (n3 < n2) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n3);
            if (!lonPoint.isNew() && (n = lonPoint.getAddressGroup()) > 0) {
                return n;
            }
            ++n3;
        }
        return -1;
    }

    public boolean isNew() {
        if (this.hub != null && this.hub.isNew()) {
            return true;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            if (((LonPoint)this.targets.elementAt(n2)).isNew()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPollOnly() {
        boolean bl = false;
        if (this.linkType != null && this.linkType == BLonLinkType.pollOnly) {
            bl = true;
        }
        return bl;
    }

    public boolean isPolled() {
        if (this.hub != null && this.hub.isOutput()) {
            return this.hub.isPolled();
        }
        return this.targets.size() > 0 && ((LonPoint)this.targets.elementAt(0)).isPolled();
    }

    public LonPoint getPntRequiringAddressEntry() {
        if (this.hub == null) {
            return null;
        }
        if (this.hub.requiresAddressEntry()) {
            return this.hub;
        }
        return this.getActiveTargetNotTurnaround();
    }

    public LonPoint getAddressPnt(boolean bl) {
        if (this.hub == null || this.targets.size() == 0) {
            return null;
        }
        LonPoint lonPoint = (LonPoint)this.targets.elementAt(0);
        if (this.hub.isOutput() && this.hub.isPolled() || lonPoint.isOutput() && !lonPoint.isPolled()) {
            int n = 0;
            while (n < this.targets.size()) {
                lonPoint = (LonPoint)this.targets.elementAt(n);
                if (bl && lonPoint.isActive()) {
                    return lonPoint;
                }
                ++n;
            }
            return null;
        }
        return this.hub;
    }

    public void setError() {
        this.setStatus(BLonLinkStatus.error);
    }

    public void setStatus(BLonLinkStatus bLonLinkStatus) {
        if (this.hub != null) {
            this.hub.setStatus(bLonLinkStatus);
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            ((LonPoint)this.targets.elementAt(n2)).setStatus(bLonLinkStatus);
            ++n2;
        }
    }

    public void setAllBoundNew() {
        if (this.hub != null) {
            this.setBoundNew(this.hub);
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            this.setBoundNew((LonPoint)this.targets.elementAt(n2));
            ++n2;
        }
    }

    public boolean isError() {
        if (this.hub != null && this.hub.isError()) {
            return true;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            if (((LonPoint)this.targets.elementAt(n2)).isError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isActive() {
        if (this.hub == null || !this.hub.isActive()) {
            return false;
        }
        int n = this.targets.size();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (((LonPoint)this.targets.elementAt(n2)).isActive()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public LonPoint getSubnetNodeAddressTarget() {
        int n = this.targets.size();
        if (!this.hub.requiresAddressEntry()) {
            return null;
        }
        LonPoint lonPoint = null;
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint2 = (LonPoint)this.targets.elementAt(n2);
            if (lonPoint2.isActive()) {
                if (lonPoint2.requiresAddressEntry()) {
                    return null;
                }
                if (!lonPoint2.isSameNode(this.hub.getLonDevice())) {
                    if (lonPoint == null) {
                        lonPoint = lonPoint2;
                    } else if (!lonPoint2.isSameNode(lonPoint.getLonDevice())) {
                        return null;
                    }
                }
            }
            ++n2;
        }
        return lonPoint;
    }

    public boolean isTurnAroundAddressEntry() {
        if (this.hub == null || this.hub.isLocal() || this.targets.size() < 1) {
            return false;
        }
        BLonDevice bLonDevice = this.hub.getLonDevice();
        int n = this.targets.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (!lonPoint.isObsolete()) {
                if (lonPoint.isLocal() || !lonPoint.isSameNode(bLonDevice)) {
                    return false;
                }
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public boolean hasTurnAround() {
        if (this.hub == null || this.targets.size() < 1) {
            return false;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (!lonPoint.isLocal() && !lonPoint.isObsolete() && lonPoint.isSameNode(this.hub.getLonDevice())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isLocal() {
        boolean bl = false;
        if (this.getLocal() != null) {
            bl = true;
        }
        return bl;
    }

    public LonPoint getLocal() {
        if (this.hub != null && this.hub.isLocal()) {
            return this.hub;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (lonPoint.isLocal()) {
                return lonPoint;
            }
            ++n2;
        }
        return null;
    }

    public void addPoint(LonPoint lonPoint) {
        if (this.findPoint(lonPoint) != null) {
            return;
        }
        if (lonPoint.getDirection() != BLonNvDirection.output) {
            this.targets.addElement(lonPoint);
        } else if (this.hub == null) {
            this.hub = lonPoint;
        } else {
            this.addSecondary(new Connection(lonPoint, this.selector, this.debug));
        }
    }

    public void parseTargets(GroupTable groupTable) {
        int[] nArray;
        LonPoint lonPoint;
        if (this.secondary == null || this.targets.size() == 0) {
            return;
        }
        boolean[] blArray = new boolean[this.targets.size()];
        Connection connection = this.getSecondary();
        while (connection != null) {
            lonPoint = connection.getHub();
            if (lonPoint != null && (nArray = this.getAddressedList(lonPoint, groupTable)) != null) {
                int n = 0;
                while (n < this.targets.size()) {
                    LonPoint lonPoint2 = (LonPoint)this.targets.elementAt(n);
                    if (!lonPoint2.isLocal() && this.isDeviceInList(lonPoint2, nArray, groupTable)) {
                        blArray[n] = true;
                        if (this.debug) {
                            System.out.println("\nCopy target to secondary:  sel=" + this.selector + "\n   " + lonPoint2);
                        }
                        connection.targets.addElement(lonPoint2.cloneMe());
                    }
                    ++n;
                }
            }
            connection = connection.getSecondary();
        }
        lonPoint = this.getHub();
        if (lonPoint == null) {
            return;
        }
        nArray = this.getAddressedList(lonPoint, groupTable);
        if (nArray == null) {
            return;
        }
        int n = this.targets.size() - 1;
        while (n >= 0) {
            LonPoint lonPoint3 = (LonPoint)this.targets.elementAt(n);
            if (!this.isDeviceInList(lonPoint3, nArray, groupTable) && blArray[n]) {
                if (this.debug) {
                    System.out.println("\nDelete target from root:  sel=" + this.selector + "\n   " + lonPoint3);
                }
                this.targets.removeElementAt(n);
            }
            --n;
        }
    }

    private final boolean isDeviceInList(LonPoint lonPoint, int[] nArray, GroupTable groupTable) {
        int n = groupTable.findDeviceIndex(lonPoint.getLonDevice());
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final int[] getAddressedList(LonPoint lonPoint, GroupTable groupTable) {
        BIAddressEntry bIAddressEntry = lonPoint.getAddressEntry();
        if (bIAddressEntry == null) {
            return null;
        }
        int[] nArray = null;
        switch (bIAddressEntry.getAddressType().getOrdinal()) {
            case 1: {
                Group group = groupTable.getGroup(bIAddressEntry.getGroupOrSubnet());
                if (group == null) break;
                nArray = group.getMemberIndices();
                break;
            }
            case 2: {
                nArray = new int[1];
                BSubnetNode bSubnetNode = BSubnetNode.make(bIAddressEntry.getGroupOrSubnet(), bIAddressEntry.getMemberOrNode());
                BLonDevice bLonDevice = groupTable.lonworks.addressManager().getDeviceByAddress(bSubnetNode);
                if (bLonDevice == null) break;
                nArray[0] = groupTable.findDeviceIndex(bLonDevice);
                break;
            }
            case 4: {
                nArray = new int[]{groupTable.findDeviceIndex(lonPoint.getLonDevice())};
                return nArray;
            }
        }
        if (nArray == null) {
            return null;
        }
        if (!lonPoint.getNvConfigData().getTurnAround()) {
            return nArray;
        }
        int n = groupTable.findDeviceIndex(lonPoint.getLonDevice());
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] == n) {
                return nArray;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2 + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        nArray2[n2] = n;
        return nArray2;
    }

    public void addLinkedPoint(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
        if (lonPoint.getDirection() == BLonNvDirection.output) {
            if (this.hub == null || !this.hub.equals(lonPoint)) {
                if (this.secondary == null) {
                    this.addSecondary(new Connection(lonPoint, lonPoint2, this.selector, bLonLinkType, bl, this.debug));
                } else {
                    this.secondary.addLinkedPoint(lonPoint, lonPoint2, bLonLinkType, bl);
                }
                return;
            }
            if (this.findTarget(lonPoint2) == null) {
                this.targets.addElement(lonPoint2);
                this.setObsoleteBound(this.hub);
            }
        } else {
            this.addSecondary(new Connection(lonPoint, lonPoint2, this.selector, bLonLinkType, bl, this.debug));
            return;
        }
        this.updateLinktype(bLonLinkType);
        this.priority = bl;
    }

    public void addLinkedProxy(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
        LonPoint lonPoint3;
        if (lonPoint.getDirection() == BLonNvDirection.output) {
            if (this.hub == null || !this.hub.equals(lonPoint)) {
                if (this.secondary == null) {
                    this.addSecondary(new Connection(lonPoint, lonPoint2, this.selector, bLonLinkType, bl, this.debug));
                } else {
                    this.secondary.addLinkedProxy(lonPoint, lonPoint2, bLonLinkType, bl);
                }
                return;
            }
            lonPoint3 = this.hub;
            this.targets.addElement(lonPoint2);
        } else {
            lonPoint3 = this.findTarget(lonPoint);
            if (this.hub != null || lonPoint3 == null) {
                if (this.secondary == null) {
                    this.addSecondary(new Connection(lonPoint, lonPoint2, this.selector, bLonLinkType, bl, this.debug));
                } else {
                    this.secondary.addLinkedProxy(lonPoint, lonPoint2, bLonLinkType, bl);
                }
                return;
            }
            this.hub = lonPoint2;
        }
        this.setObsoleteBound(lonPoint3);
        this.setObsoleteBound(lonPoint2);
        this.updateLinktype(bLonLinkType);
        this.priority = bl;
    }

    public void addLink(LonPoint lonPoint, LonPoint lonPoint2, BLonLinkType bLonLinkType, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (lonPoint.getDirection() == BLonNvDirection.output) {
            bl3 = true;
        }
        LonPoint lonPoint3 = (bl2 = bl3) ? lonPoint : lonPoint2;
        LonPoint lonPoint4 = bl2 ? lonPoint2 : lonPoint;
        Connection connection = this;
        while (connection != null) {
            if (connection.hub != null && connection.hub.equals(lonPoint3)) break;
            connection = connection.getSecondary();
        }
        if (connection == null) {
            System.out.println("*** INTERNAL ERROR could not find hub connection in Connection.addLink ***\nhubPoint:" + lonPoint3 + '\n' + this.toString());
            connection = new Connection(lonPoint, lonPoint2, this.selector, bLonLinkType, bl, this.debug);
            connection.setError();
            this.addSecondary(connection);
            return;
        }
        LonPoint lonPoint5 = connection.findTarget(lonPoint4);
        if (lonPoint5 == null) {
            lonPoint5 = this.findConnection(lonPoint4).findTarget(lonPoint4);
            lonPoint5 = lonPoint5 == null ? lonPoint4 : (LonPoint)lonPoint5.cloneMe();
            connection.targets.addElement(lonPoint5);
        }
        this.setObsoleteBound(connection.hub);
        this.setObsoleteBound(lonPoint5);
        connection.updateLinktype(bLonLinkType);
        connection.priority = bl;
    }

    public void removeObsoleteOverlappPnts() {
        if (this.secondary == null) {
            return;
        }
        Connection connection = this;
        while (connection != null) {
            Vector vector = connection.targets;
            int n = vector.size() - 1;
            while (n >= 0) {
                LonPoint lonPoint = (LonPoint)vector.elementAt(n);
                if (lonPoint.isObsolete()) {
                    boolean bl = false;
                    Connection connection2 = this.root;
                    while (connection2 != null) {
                        if (connection2 != connection && connection2.findTarget(lonPoint) != null) {
                            bl = true;
                            break;
                        }
                        connection2 = connection2.getSecondary();
                    }
                    if (bl) {
                        if (this.debug) {
                            System.out.println("\nremove redundant tgt:" + lonPoint);
                        }
                        vector.removeElementAt(n);
                    }
                }
                --n;
            }
            connection = connection.secondary;
        }
    }

    public Connection removeNoOverlappSecondary() {
        if (this.hub == null && this.targets.size() == 0) {
            return this;
        }
        if (this.secondary == null) {
            return null;
        }
        Connection connection = this;
        Connection connection2 = this.secondary;
        boolean bl = false;
        while (connection2 != null) {
            if (connection2.isActive()) {
                bl = true;
                if (!connection2.hasAnyOverlappingTargets(null)) {
                    connection.secondary = connection2.secondary;
                    connection2.secondary = null;
                    return connection2;
                }
            }
            connection = connection2;
            connection2 = connection2.secondary;
        }
        if (!bl) {
            return null;
        }
        if (!this.hasAnyOverlappingTargets(null)) {
            connection2 = this.secondary;
            this.secondary = null;
            return connection2;
        }
        return null;
    }

    public boolean hasAnyOverlappingTargets(LonPoint lonPoint) {
        Vector vector = this.targets;
        int n = 0;
        while (n < vector.size()) {
            LonPoint lonPoint2 = (LonPoint)vector.elementAt(n);
            if (lonPoint == null || !lonPoint2.equals(lonPoint)) {
                Connection connection = this.root;
                while (connection != null) {
                    if (connection != this && connection.findTarget(lonPoint2) != null) {
                        return true;
                    }
                    connection = connection.getSecondary();
                }
            }
            ++n;
        }
        return false;
    }

    public boolean hasOverlappingTarget(LonPoint lonPoint, Connection connection) {
        Connection connection2 = this.root;
        while (connection2 != null) {
            LonPoint lonPoint2;
            if (connection2 != connection && (lonPoint2 = connection2.findTarget(lonPoint)) != null && lonPoint2.isActive()) {
                return true;
            }
            connection2 = connection2.getSecondary();
        }
        return false;
    }

    public void mergeConnection(Connection connection) {
        Connection connection2 = connection;
        while (connection2 != null) {
            connection2.selector = this.selector;
            connection2.root = this.root;
            connection2 = connection2.secondary;
        }
        this.addSecondary(connection);
    }

    private final void setObsoleteBound(LonPoint lonPoint) {
        if (lonPoint.getStatus() == BLonLinkStatus.obsolete) {
            lonPoint.setStatus(BLonLinkStatus.bound);
        }
    }

    private final void setBoundNew(LonPoint lonPoint) {
        if (lonPoint.getStatus() == BLonLinkStatus.bound) {
            lonPoint.setStatus(BLonLinkStatus.newLink);
        }
    }

    public void addSecondary(Connection connection) {
        if (this.debug) {
            System.out.println("*** addSecondary to " + this.selector + " *** ");
        }
        if (this.secondary == null) {
            this.secondary = connection;
            connection.root = this.root;
            connection.selector = this.selector;
        } else {
            this.secondary.addSecondary(connection);
        }
    }

    public void removeSecondary(Connection connection) {
        if (this.debug) {
            System.out.println("*** removeSecondary from " + this.selector + " *** ");
        }
        if (this.secondary == connection) {
            this.secondary = connection.secondary;
            connection.root = connection;
            connection.secondary = null;
        } else if (this.secondary != null) {
            this.secondary.removeSecondary(connection);
        }
    }

    public Connection removeAllSecondaries() {
        Connection connection = this.secondary;
        this.secondary = null;
        Connection connection2 = connection;
        while (connection2 != null) {
            connection2.root = connection;
            connection2 = connection2.getSecondary();
        }
        return connection;
    }

    public void newSelector(int n) {
        Connection connection = this;
        while (connection != null) {
            connection.selector = n;
            connection.root = this;
            connection.setAllBoundNew();
            connection = connection.secondary;
        }
    }

    public LonPoint findPoint(int n) {
        if (this.hub != null && this.hub.hashCode() == n) {
            return this.hub;
        }
        int n2 = this.targets.size();
        int n3 = 0;
        while (n3 < n2) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n3);
            if (lonPoint.hashCode() == n) {
                return lonPoint;
            }
            ++n3;
        }
        return null;
    }

    public LonPoint findPoint(LonPoint lonPoint) {
        if (this.hub != null && this.hub.equals(lonPoint)) {
            return this.hub;
        }
        return this.findTarget(lonPoint);
    }

    public Connection findConnection(LonPoint lonPoint) {
        return this.findConnection(lonPoint, false);
    }

    public Connection findConnection(LonPoint lonPoint, boolean bl) {
        Connection connection = this;
        Connection connection2 = null;
        int n = 0;
        while (connection != null) {
            if (connection.findPoint(lonPoint) != null) {
                if (!bl) {
                    return connection;
                }
                int n2 = connection.getActiveTargetCount();
                if (connection2 == null || n2 < n) {
                    connection2 = connection;
                    n = n2;
                }
            }
            connection = connection.getSecondary();
        }
        return connection2;
    }

    public boolean okayToRemove(LonPoint lonPoint) {
        Connection connection = this;
        while (connection != null) {
            LonPoint lonPoint2 = connection.findPoint(lonPoint);
            if (lonPoint2 != null && !lonPoint2.isObsolete()) {
                return false;
            }
            connection = connection.getSecondary();
        }
        return true;
    }

    public boolean primaryOverlappsSelector(int n) {
        if (this.primary.selector == n) {
            return true;
        }
        Vector vector = this.primary.aliasConnections;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (((Connection)vector.elementAt((int)n2)).selector == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Connection findAliasPrimary(int n) {
        Connection connection = this;
        while (connection != null) {
            if (connection.hub != null && connection.hub.hashCode() == n) {
                return connection;
            }
            connection = connection.getSecondary();
        }
        return null;
    }

    public void finalRemove() {
        if (this.primary != null) {
            this.primary.aliasConnections.removeElement(this);
        }
    }

    public int countPoints() {
        int n = 0;
        Connection connection = this;
        while (connection != null) {
            if (connection.hub != null) {
                ++n;
            }
            n += this.targets.size();
            connection = connection.getSecondary();
        }
        return n;
    }

    private final LonPoint findTarget(LonPoint lonPoint) {
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            if (((LonPoint)this.targets.elementAt(n2)).equals(lonPoint)) {
                return (LonPoint)this.targets.elementAt(n2);
            }
            ++n2;
        }
        return null;
    }

    public LonPoint findAliasPoint(LonPoint lonPoint) {
        if (this.hub != null && this.hub.isAliasPoint() && lonPoint.hashCode() == ((LonPointAlias)this.hub).primaryHashCode()) {
            return this.hub;
        }
        return null;
    }

    boolean containsDevice(BLonDevice bLonDevice) {
        if (this.hub != null && this.hub.isSameNode(bLonDevice)) {
            return true;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (lonPoint.isSameNode(bLonDevice)) {
                return true;
            }
            ++n2;
        }
        if (this.getSecondary() != null) {
            return this.getSecondary().containsDevice(bLonDevice);
        }
        return false;
    }

    public LonPoint[] findAppDevice(BLonDevice bLonDevice) {
        return this.scanForDevice(bLonDevice, false);
    }

    public LonPoint[] findAppDeviceInTargets(BLonDevice bLonDevice) {
        return this.scanForDevice(bLonDevice, true);
    }

    private final LonPoint[] scanForDevice(BLonDevice bLonDevice, boolean bl) {
        Vector<LonPoint> vector = new Vector<LonPoint>();
        if (!bl && this.hub != null && !this.hub.isObsolete() && this.hub.isSameNode(bLonDevice)) {
            vector.addElement(this.hub);
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (!lonPoint.isObsolete() && lonPoint.isSameNode(bLonDevice)) {
                vector.addElement(lonPoint);
            }
            ++n2;
        }
        Object[] objectArray = new LonPoint[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void removePoint(LonPoint lonPoint) {
        if (this.hub != null && this.hub.equals(lonPoint)) {
            this.hub = null;
            return;
        }
        int n = this.targets.size();
        int n2 = 0;
        while (n2 < n) {
            if (((LonPoint)this.targets.elementAt(n2)).equals(lonPoint)) {
                this.targets.removeElementAt(n2);
                break;
            }
            ++n2;
        }
    }

    public boolean removeEmpty() {
        Connection connection = this.secondary;
        while (connection != null) {
            if (connection.isEmpty()) {
                this.removeSecondary(connection);
                connection.finalRemove();
            }
            connection = connection.secondary;
        }
        if (this.isEmpty()) {
            this.finalRemove();
            return true;
        }
        return false;
    }

    private final boolean isEmpty() {
        boolean bl = false;
        if (this.hub == null && this.targets.size() == 0) {
            bl = true;
        }
        return bl;
    }

    void clearAddressEntry() {
        this.setAddressChange(true);
        this.setAddressGroup(-1);
        this.getHub().setAddressIndex(-1);
        this.getHub().setStatus(BLonLinkStatus.newLink);
    }

    public void verifyConnection() {
        int n;
        if (!this.isActive()) {
            return;
        }
        Object object = this.getAddressPnt(true);
        if (object != null) {
            n = ((LonPoint)object).getAddressGroup();
            if (this.debug) {
                System.out.println(" set group# " + n);
            }
            this.setAddressGroup(n);
        }
        if (this.isAcknowledged() && this.getActiveTargetCount() > 5) {
            this.setStatus(BLonLinkStatus.maxCritError);
            return;
        }
        if (this.hub != null && !this.hub.validatePoint(this.linkType, this.priority, this.debug, false) && this.debug) {
            System.out.println(" changed status " + this.hub);
        }
        if ((n = this.targets.size()) == 0) {
            return;
        }
        Object[] objectArray = new LonPoint[n];
        this.targets.copyInto(objectArray);
        boolean bl = false;
        if (this.hub != null && (this.hub.isProxy() || this.hub.isPseudo())) {
            bl = true;
        }
        boolean bl2 = bl;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (!((LonPoint)object).validatePoint(this.linkType, this.priority, this.debug, bl2) && this.debug) {
                System.out.println(" changed status  " + object);
            }
            ++n2;
        }
        if (this.hub != null && (this.hub.isLocal() || this.hub.isProxy())) {
            object = objectArray[0];
            n2 = ((LonPoint)object).getSnvtType();
            int n3 = 1;
            while (n3 < n) {
                object = objectArray[n3];
                if (((LonPoint)object).getSnvtType() != n2) {
                    ((LonPoint)object).setStatus(BLonLinkStatus.nvTypeError);
                }
                ++n3;
            }
        }
        if (this.hub != null && this.hub.addressIndexIsLocal()) {
            n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                if (((LonPoint)object).isLocal() && ((LonPoint)object).isNew()) {
                    ((LonPoint)object).setStatus(BLonLinkStatus.bound);
                }
                ++n2;
            }
        }
    }

    public boolean canHaveAlias() {
        if (this.hub == null || this.hub.isAliasPoint() || !this.hub.requiresAddressEntry() || this.hub.getLonDevice().getDeviceData().getAliasTable().getAliasCount() == 0) {
            return false;
        }
        return this.targets.size() >= 2 || this.aliasConnections != null;
    }

    public boolean isAliasConnection() {
        boolean bl = false;
        if (this.hub != null && this.hub.isAliasPoint()) {
            bl = true;
        }
        return bl;
    }

    public boolean hasAliasConnection() {
        boolean bl = false;
        if (this.aliasConnections != null && this.aliasConnections.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean containsAliasConnection() {
        Connection connection = this;
        while (connection != null) {
            if (connection.isAliasConnection()) {
                return true;
            }
            connection = connection.secondary;
        }
        return false;
    }

    public Connection[] getAliasConnections() {
        if (this.aliasConnections == null || this.aliasConnections.size() == 0) {
            return null;
        }
        Object[] objectArray = new Connection[this.aliasConnections.size()];
        this.aliasConnections.copyInto(objectArray);
        return objectArray;
    }

    public Connection getActiveAliasConnection() {
        if (this.aliasConnections == null || this.aliasConnections.size() == 0) {
            return null;
        }
        int n = 0;
        while (n < this.aliasConnections.size()) {
            Connection connection = (Connection)this.aliasConnections.elementAt(n);
            if (connection.isActive()) {
                return connection;
            }
            ++n;
        }
        return null;
    }

    public boolean okToMerge(Connection connection) {
        Vector vector = this.getAliasSearchList();
        Vector vector2 = connection.getAliasSearchList();
        int n = 0;
        while (n < vector.size()) {
            LonPoint lonPoint = (LonPoint)vector.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                if (((LonPoint)vector2.elementAt(n2)).isSameDevicePoint(lonPoint)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    public Vector getAllSameDevicePoints() {
        Vector<LonPoint> vector = new Vector<LonPoint>();
        Vector vector2 = this.getAliasSearchList();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)vector2.elementAt(n2);
            lonPoint.overlappCnt = 0;
            int n3 = n2 + 1;
            while (n3 < n) {
                LonPoint lonPoint2 = (LonPoint)vector2.elementAt(n3);
                if (lonPoint2.equals(lonPoint)) {
                    ++lonPoint.overlappCnt;
                } else if (lonPoint2.isSameDevicePoint(lonPoint)) {
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        if (lonPoint2.equals((LonPoint)vector.elementAt(n4))) {
                            ++((LonPoint)vector.elementAt((int)n4)).overlappCnt;
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        lonPoint2.overlappCnt = 0;
                        vector.addElement(lonPoint2);
                    }
                }
                ++n3;
            }
            if (vector.size() > 0) {
                vector.addElement(lonPoint);
                break;
            }
            ++n2;
        }
        if (this.debug) {
            n2 = 0;
            while (n2 < vector.size()) {
                System.out.println("overLapps=" + ((LonPoint)vector.elementAt((int)n2)).overlappCnt + "  " + vector.elementAt(n2));
                ++n2;
            }
        }
        return vector;
    }

    private final Vector getAliasSearchList() {
        Vector<LonPoint> vector = new Vector<LonPoint>();
        Connection connection = this;
        while (connection != null) {
            Vector vector2 = connection.targets;
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                LonPoint lonPoint = (LonPoint)vector2.elementAt(n2);
                if (lonPoint.isActive()) {
                    vector.addElement(lonPoint);
                }
                ++n2;
            }
            connection = connection.getSecondary();
        }
        return vector;
    }

    public LonPoint[] getAliasPointsToCompress(Connection connection) {
        Vector<LonPoint> vector = new Vector<LonPoint>();
        LonPoint[] lonPointArray = connection.getTargets();
        int n = 0;
        while (n < lonPointArray.length) {
            LonPoint lonPoint = lonPointArray[n];
            if (lonPoint.isActive() && !connection.hasSameDevicePoints(lonPoint) && !this.hasSameDevicePoints(lonPoint)) {
                vector.addElement(lonPoint);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new LonPoint[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final boolean hasSameDevicePoints(LonPoint lonPoint) {
        boolean bl = false;
        Connection connection = this.root;
        while (connection != null) {
            Vector vector = connection.targets;
            int n = 0;
            while (n < vector.size()) {
                LonPoint lonPoint2 = (LonPoint)vector.elementAt(n);
                if (lonPoint2.equals(lonPoint)) {
                    if (bl) {
                        return true;
                    }
                    bl = true;
                }
                if (lonPoint2.isActive() && lonPoint2.isSameDevicePoint(lonPoint)) {
                    return true;
                }
                ++n;
            }
            connection = connection.getSecondary();
        }
        return false;
    }

    public Connection findAliasConnectionForPoint(LonPoint lonPoint, int n, boolean bl) {
        if (this.aliasConnections == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.aliasConnections.size()) {
            Connection connection = (Connection)this.aliasConnections.elementAt(n2);
            if (!(bl && connection.getSelector() != n || connection.hasSameDevicePoints(lonPoint))) {
                return connection;
            }
            ++n2;
        }
        return null;
    }

    public LonPoint[] getSameDevicePoints() {
        if (this.hub == null) {
            return null;
        }
        Vector<LonPoint> vector = new Vector<LonPoint>();
        int n = this.targets.size();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            LonPoint lonPoint = (LonPoint)this.targets.elementAt(n2);
            if (!lonPoint.isLocal() && lonPoint.isActive()) {
                if (!bl && lonPoint.isBound() && lonPoint.getOrigSelector() == this.selector) {
                    bl = true;
                }
                int n3 = n2 + 1;
                while (n3 < n) {
                    LonPoint lonPoint2 = (LonPoint)this.targets.elementAt(n3);
                    if (lonPoint2.isActive() && lonPoint.getLonDevice() == lonPoint2.getLonDevice()) {
                        if (bl) {
                            vector.addElement(lonPoint2);
                            break;
                        }
                        vector.addElement(lonPoint);
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new LonPoint[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void addAliasConnection(Connection connection) {
        if (this.aliasConnections == null) {
            this.aliasConnections = new Vector();
        }
        if (this.aliasConnections.contains(connection)) {
            return;
        }
        connection.primary = this;
        this.aliasConnections.addElement(connection);
    }

    public void removeAliasConnection(Connection connection) {
        if (this.aliasConnections == null) {
            return;
        }
        this.aliasConnections.removeElement(connection);
    }

    public Connection findAliasConnection(Connection connection, LonPoint lonPoint) {
        Connection connection2 = connection.findAliasConnection(lonPoint);
        if (connection2 == null) {
            return null;
        }
        if (this.hasAliasConnection(connection2)) {
            return connection2;
        }
        return null;
    }

    public Connection findAliasConnection(LonPoint lonPoint) {
        Connection connection = this;
        while (connection != null) {
            if (connection.findAliasPoint(lonPoint) != null) {
                return connection;
            }
            connection = connection.getSecondary();
        }
        return null;
    }

    public boolean hasAliasConnection(Connection connection) {
        Connection connection2 = this;
        while (connection2 != null) {
            if (connection2.aliasConnections != null && connection2.aliasConnections.contains(connection)) {
                return true;
            }
            connection2 = connection2.getSecondary();
        }
        return false;
    }

    public Connection getLocalAlias() {
        if (this.aliasConnections == null) {
            return null;
        }
        int n = 0;
        while (n < this.aliasConnections.size()) {
            Connection connection = (Connection)this.aliasConnections.elementAt(n);
            if (connection != null && connection.isLocal()) {
                return connection;
            }
            ++n;
        }
        return null;
    }

    public GroupBitSet getGroupBitSet(BLonDevice[] bLonDeviceArray) {
        if (this.groupBitSet == null) {
            this.groupBitSet = new GroupBitSet(bLonDeviceArray, this);
        }
        return this.groupBitSet;
    }

    public GroupBitSet getExcludeBitSet(BLonDevice[] bLonDeviceArray) {
        if (!this.foundExBitSet) {
            if (this.root != this || this.secondary != null) {
                this.excludeBits = new GroupBitSet(this.getTotalTargetBitSet(bLonDeviceArray));
                this.excludeBits.xor(this.getTargetBitSet(bLonDeviceArray));
                if (this.hub != null) {
                    this.excludeBits.clear(GroupBitSet.findDeviceNdx(bLonDeviceArray, this.hub.getLonDevice()));
                }
                if (this.excludeBits.getGroupSize() == 0) {
                    this.excludeBits = null;
                }
            }
            this.foundExBitSet = true;
        }
        return this.excludeBits;
    }

    private final GroupBitSet getTotalTargetBitSet(BLonDevice[] bLonDeviceArray) {
        if (this.root != this) {
            return this.root.getTotalTargetBitSet(bLonDeviceArray);
        }
        if (this.targetBitSet == null) {
            this.targetBitSet = this.getTargetBitSet(bLonDeviceArray);
            if (this.secondary != null) {
                Connection connection = this.secondary;
                while (connection != null) {
                    if (connection.isActive()) {
                        this.targetBitSet.or(connection.getTargetBitSet(bLonDeviceArray));
                    }
                    connection = connection.getSecondary();
                }
            }
        }
        return this.targetBitSet;
    }

    private final GroupBitSet getTargetBitSet(BLonDevice[] bLonDeviceArray) {
        return new GroupBitSet(bLonDeviceArray, this.getTargets());
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Connection =>");
        Connection connection = this;
        while (connection != null) {
            connection.doToString(stringBuffer, bl);
            Connection connection2 = connection = bl ? connection.getSecondary() : null;
            if (connection == null) continue;
            stringBuffer.append("\n  Secondary :");
        }
        return stringBuffer.toString();
    }

    private final void doToString(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(" linkType = ").append((Object)this.linkType);
        stringBuffer.append(" selector = ").append(this.selector);
        if (this.addressGroup != -1) {
            stringBuffer.append(" addressGroup = ").append(this.addressGroup);
        }
        stringBuffer.append("\n   Hub = ").append(this.hub);
        int n = this.targets.size();
        if (n == 0) {
            stringBuffer.append("\n   no targets");
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n   target #").append(n2).append(" ").append(this.targets.elementAt(n2));
            ++n2;
        }
        if (bl && this.aliasConnections != null) {
            n2 = 0;
            while (n2 < this.aliasConnections.size()) {
                Connection connection = (Connection)this.aliasConnections.elementAt(n2);
                if (connection != null) {
                    stringBuffer.append("\n  Alias ").append(connection.toString(false));
                }
                ++n2;
            }
        }
    }

    String identify() {
        return this.hub != null ? this.hub.getSummaryString() : "";
    }

    private final void updateLinktype(BLonLinkType bLonLinkType) {
        if (this.linkType.getOrdinal() < bLonLinkType.getOrdinal()) {
            this.linkType = bLonLinkType;
        }
    }

    private final /* synthetic */ void this() {
        this.tgtArray = null;
        this.foundExBitSet = false;
        this.groupBitSet = null;
        this.excludeBits = null;
        this.targetBitSet = null;
        this.linkType = BLonLinkType.unknown;
        this.addressGroup = -1;
        this.addressChange = true;
        this.hub = null;
        this.targets = new Vector(10);
        this.aliasConnections = null;
        this.primary = null;
        this.priority = false;
        this.root = this;
        this.secondary = null;
    }

    public Connection(LonPoint lonPoint, int n, boolean bl) {
        this.this();
        if (lonPoint.isOutput()) {
            this.hub = lonPoint;
        } else {
            this.targets.addElement(lonPoint);
        }
        this.debug = bl;
        this.selector = n;
    }

    public Connection(LonPoint lonPoint, LonPoint lonPoint2, int n, BLonLinkType bLonLinkType, boolean bl, boolean bl2) {
        this.this();
        if (lonPoint.isOutput()) {
            this.hub = lonPoint;
            this.targets.addElement(lonPoint2);
        } else {
            this.hub = lonPoint2;
            this.targets.addElement(lonPoint);
        }
        this.debug = bl2;
        this.selector = n;
        this.linkType = bLonLinkType;
        this.priority = bl;
    }
}

