/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.datatypes.BDeviceEntryTable;
import com.tridium.lonworks.datatypes.BLearnParameter;
import com.tridium.lonworks.device.DynaDev;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BLonRouterType;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import com.tridium.lonworks.netmessages.RouterStatusResponse;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.DeviceDef;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import com.tridium.lonworks.util.selfdoc.DocToXDevice;
import com.tridium.lonworks.xml.XLonDevice;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BDynamicDevice;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.LonComm;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.datatypes.BImportParameters;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IntHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonLearnJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE;
    private BLonDevice[] origDevs;
    private BLonRouter[] origRtrs;
    private LonComm lonComm;
    private BDomainId ourDomain;
    private IntHashMap storage;
    private IntHashMap duplicateCheck;
    private boolean auth;
    private BLearnParameter command;
    private Array uploadDevs;
    BComponent cont;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonLearnJob;
    static /* synthetic */ Class class$javax$baja$lonworks$BLonDevice;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonLearnJob$LonDeviceIds;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        try {
            BDeviceEntryTable bDeviceEntryTable = this.netMgmt.getDeviceDiscoverTable();
            bDeviceEntryTable.clearEntries();
            this.netMgmt.fireDeviceDiscoveryUpdated(bDeviceEntryTable);
            this.doLearn();
        }
        catch (JobCancelException jobCancelException) {
            this.canceled();
        }
        catch (Throwable throwable) {
            this.fatal("Learn failed ", throwable);
        }
        this.netMgmt.fireLearnComplete(null);
        this.end();
    }

    /*
     * Exception decompiling
     */
    private final void doLearn() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [9 : 813->817)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final boolean processDomainAndSubnetNode(LonDeviceIds lonDeviceIds, boolean bl) throws LonException {
        boolean bl2 = lonDeviceIds.authOn;
        BNeuronId bNeuronId = lonDeviceIds.nId;
        BProgramId bProgramId = lonDeviceIds.pId;
        lonDeviceIds.twoDomains = Neuron.isTwoDomains(this.lonComm, bNeuronId, bl2, bl);
        QueryDomainResponse queryDomainResponse = NmUtil.queryDomain(this.lonComm, bNeuronId, 0, bl2, bl);
        if (!lonDeviceIds.twoDomains || queryDomainResponse.sameDomain(this.ourDomain)) {
            lonDeviceIds.wrkDmn = 0;
        } else {
            queryDomainResponse = NmUtil.queryDomain(this.lonComm, bNeuronId, 1, bl2, bl);
            lonDeviceIds.wrkDmn = 1;
        }
        lonDeviceIds.duplicate = this.detectDuplicate(queryDomainResponse, lonDeviceIds.nId, bl);
        if (!this.command.getUnmanagedNetwork() && lonDeviceIds.duplicate) {
            this.fatal("Duplicate subnet node detected - " + Integer.toString(queryDomainResponse.getSubnet()) + '/' + Integer.toString(queryDomainResponse.getNodeId()));
            this.end();
            return false;
        }
        lonDeviceIds.domain = queryDomainResponse;
        lonDeviceIds.chanId = Neuron.getChannelId(this.lonComm, bNeuronId, bl2, bl);
        return true;
    }

    private final boolean matchExisting(LonDeviceIds lonDeviceIds) throws LonException {
        QueryDomainResponse queryDomainResponse = lonDeviceIds.domain;
        BLonDevice bLonDevice = this.lon.addressManager().getDeviceByAddress(BSubnetNode.make(queryDomainResponse.getSubnet(), queryDomainResponse.getNodeId()));
        if (bLonDevice == null) {
            return false;
        }
        BDeviceData bDeviceData = bLonDevice.getDeviceData();
        if (!bDeviceData.getNeuronId().isZero()) {
            return false;
        }
        BProgramId bProgramId = bDeviceData.getProgramId();
        if (bProgramId.isZero() || bProgramId.equals((Object)lonDeviceIds.pId)) {
            this.netMgmt.log().trace("found match remove from device list for " + bLonDevice);
            this.setDeviceData(bDeviceData, lonDeviceIds);
            this.uploadDevs.add((Object)bLonDevice);
            return true;
        }
        this.lon.addressManager().unregisterLonDevice(bLonDevice);
        this.storage.put(BLonLearnJob.getDeviceHash(bLonDevice), (Object)bLonDevice);
        this.netMgmt.log().trace("found subnet node - programIds don't match move " + bLonDevice.getDisplayName(null) + " to storage.");
        return false;
    }

    private final boolean matchExistingRouter(LonDeviceIds lonDeviceIds) throws LonException {
        int n = 0;
        while (n < this.origRtrs.length) {
            BLonRouter bLonRouter;
            if (this.origRtrs[n] != null && (bLonRouter = this.origRtrs[n]).getNearDeviceData().getNeuronId().isZero() && bLonRouter.getNearDeviceData().getChannelId() == lonDeviceIds.chanId && bLonRouter.getFarDeviceData().getChannelId() == lonDeviceIds.farIds.chanId) {
                this.netMgmt.log().trace("found match for " + bLonRouter.getDisplayName(null));
                this.setDeviceData(bLonRouter.getNearDeviceData(), lonDeviceIds);
                this.setDeviceData(bLonRouter.getFarDeviceData(), lonDeviceIds.farIds);
                RouterUtil.uploadTypeAndMode(bLonRouter);
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean matchProgramId(LonDeviceIds lonDeviceIds) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.origDevs.length) {
            BLonDevice bLonDevice = this.origDevs[n2];
            if (bLonDevice != null) {
                BDeviceData bDeviceData = bLonDevice.getDeviceData();
                if (bDeviceData.getNeuronId().isZero() && bDeviceData.getProgramId().equals((Object)lonDeviceIds.pId)) {
                    this.netMgmt.log().trace("found matching device " + bLonDevice.getDisplayName(null));
                    this.matchDevice(bLonDevice, lonDeviceIds);
                    this.origDevs[n2] = null;
                    return true;
                }
                if (n == -1 && bDeviceData.getProgramId().isZero()) {
                    n = n2;
                }
            }
            ++n2;
        }
        if (n >= 0) {
            this.netMgmt.log().trace(" matching node " + lonDeviceIds.getNodeId() + " with dynamic device");
            BLonDevice bLonDevice = this.origDevs[n];
            this.origDevs[n] = null;
            this.matchDevice(bLonDevice, lonDeviceIds);
            bLonDevice.getDeviceData().setProgramId(lonDeviceIds.pId);
            if (bLonDevice.getType().is(BDynamicDevice.TYPE)) {
                this.importXmlFile((BDynamicDevice)bLonDevice, lonDeviceIds.pId);
                this.buildDevice((BDynamicDevice)bLonDevice);
            }
            this.uploadDevs.add((Object)bLonDevice);
            return true;
        }
        this.netMgmt.log().trace("no programid match found for node " + lonDeviceIds.getNodeId());
        return false;
    }

    private final void matchDevice(BLonDevice bLonDevice, LonDeviceIds lonDeviceIds) {
        if (this.storage.get(BLonLearnJob.getDeviceHash(bLonDevice)) != null) {
            this.storage.remove(BLonLearnJob.getDeviceHash(bLonDevice));
            this.netMgmt.log().trace(" * match device from storage for s/n " + lonDeviceIds.getSubnet() + '/' + lonDeviceIds.getNodeId() + '\n');
        } else {
            this.lon.addressManager().unregisterLonDevice(bLonDevice);
            this.netMgmt.log().trace(" * device not in storage  s/n " + lonDeviceIds.getSubnet() + '/' + lonDeviceIds.getNodeId() + '\n');
        }
        this.setDeviceData(bLonDevice.getDeviceData(), lonDeviceIds);
        this.lon.addressManager().registerLonDevice(bLonDevice);
    }

    private final void setDeviceData(BDeviceData bDeviceData, LonDeviceIds lonDeviceIds) {
        bDeviceData.set(BDeviceData.neuronId, (BValue)lonDeviceIds.nId, AddressManager.noDeviceChange);
        bDeviceData.set(BDeviceData.programId, (BValue)lonDeviceIds.pId, AddressManager.noDeviceChange);
        bDeviceData.setInt(BDeviceData.workingDomain, lonDeviceIds.wrkDmn, AddressManager.noDeviceChange);
        bDeviceData.setBoolean(BDeviceData.authenticate, lonDeviceIds.authOn, AddressManager.noDeviceChange);
        bDeviceData.setBoolean(BDeviceData.twoDomains, lonDeviceIds.twoDomains, AddressManager.noDeviceChange);
        bDeviceData.setInt(BDeviceData.channelId, lonDeviceIds.chanId, AddressManager.noDeviceChange);
        BLonNodeState bLonNodeState = lonDeviceIds.state;
        if (!lonDeviceIds.duplicate) {
            bDeviceData.set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.make(lonDeviceIds.getSubnet(), lonDeviceIds.getNodeId()), AddressManager.noDeviceChange);
        } else if (bLonNodeState == BLonNodeState.configOnline || bLonNodeState == BLonNodeState.configOffline) {
            bLonNodeState = BLonNodeState.unconfigured;
        }
        bDeviceData.set(BDeviceData.nodeState, (BValue)bLonNodeState, AddressManager.noDeviceChange);
    }

    private final void emptyStorage() {
        Object[] objectArray = new BLonDevice[this.storage.size()];
        this.storage.toArray(objectArray);
        this.netMgmt.log().trace("EmptyStorage()");
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            this.netMgmt.log().trace("moving " + object.getDisplayName(null) + " addr " + ((BLonDevice)object).getDeviceData().getSubnetNodeId());
            ((BLonDevice)object).getDeviceData().set(BDeviceData.subnetNodeId, (BValue)BSubnetNode.DEFAULT, AddressManager.noDeviceChange);
            this.lon.addressManager().registerLonDevice((BLonDevice)object);
            this.netMgmt.log().trace("new addr " + ((BLonDevice)object).getDeviceData().getSubnetNodeId());
            ++n;
        }
    }

    private final void initDuplicateCheck() {
        Object object;
        int n = 0;
        while (n < this.origDevs.length) {
            object = this.origDevs[n];
            if (object != null && !object.getDeviceData().getNeuronId().isZero() && !object.isLocal()) {
                this.duplicateCheck.put(BLonLearnJob.getDeviceHash(object), object);
            }
            ++n;
        }
        n = 0;
        while (n < this.origRtrs.length) {
            object = this.origRtrs[n];
            if (object != null && !((BLonRouter)((Object)object)).getNearDeviceData().getNeuronId().isZero()) {
                this.duplicateCheck.put(BLonLearnJob.getDeviceHash(((BLonRouter)((Object)object)).getNearDeviceData()), object);
                this.duplicateCheck.put(BLonLearnJob.getDeviceHash(((BLonRouter)((Object)object)).getFarDeviceData()), object);
            }
            ++n;
        }
    }

    private final boolean detectDuplicate(QueryDomainResponse queryDomainResponse, BNeuronId bNeuronId, boolean bl) {
        int n = BLonLearnJob.getDeviceHash(queryDomainResponse.getSubnet(), queryDomainResponse.getNodeId());
        if (this.duplicateCheck.get(n) != null) {
            BLonDevice bLonDevice = this.lon.addressManager().getDeviceByAddress(BSubnetNode.make(queryDomainResponse.getSubnet(), queryDomainResponse.getNodeId()));
            return bLonDevice == null || !bLonDevice.getDeviceData().getNeuronId().equals(bNeuronId);
        }
        this.duplicateCheck.put(n, (Object)queryDomainResponse);
        return false;
    }

    private final void addNewRouter(LonDeviceIds lonDeviceIds) throws Exception {
        BNeuronId bNeuronId = lonDeviceIds.nId;
        this.netMgmt.log().trace("Add router between channels " + lonDeviceIds.chanId + " & " + lonDeviceIds.farIds.chanId + '.');
        BLonRouter bLonRouter = new BLonRouter();
        this.setDeviceData(bLonRouter.getNearDeviceData(), lonDeviceIds);
        this.setDeviceData(bLonRouter.getFarDeviceData(), lonDeviceIds.farIds);
        bLonRouter = (BLonRouter)this.addDevice((BComplex)bLonRouter, "LonRouter");
        bLonRouter.set(BLonRouter.routerType, (BValue)BLonRouterType.make(lonDeviceIds.rtrStatus.getType()), BLonNetwork.lonNoWrite);
        bLonRouter.set(BLonRouter.routerMode, (BValue)BLonRouterMode.make(lonDeviceIds.rtrStatus.getMode()), BLonNetwork.lonNoWrite);
        RouterUtil.uploadRouterTables(bLonRouter);
    }

    private final boolean addDynamic(LonDeviceIds lonDeviceIds) throws Exception {
        DeviceDef deviceDef = new DeviceDef(lonDeviceIds.pId);
        BLonDevice bLonDevice = this.createDeviceForPid(deviceDef);
        String string = deviceDef.getName();
        if (string == null) {
            string = "LonDevice";
        }
        this.setDeviceData(bLonDevice.getDeviceData(), lonDeviceIds);
        bLonDevice = (BLonDevice)this.addDevice((BComplex)bLonDevice, string);
        if (bLonDevice.getType().is(BDynamicDevice.TYPE)) {
            this.buildDevice((BDynamicDevice)bLonDevice);
        }
        this.uploadDevs.add((Object)bLonDevice);
        return true;
    }

    private final BComplex addDevice(BComplex bComplex, String string) throws Exception {
        String string2 = string;
        int n = 1;
        while (this.cont.get(string2) != null) {
            string2 = string + '_' + n++;
        }
        BComponent bComponent = new BComponent();
        bComponent.add("exact", (BValue)BBoolean.TRUE);
        Mark mark = new Mark((BObject)bComplex, string2);
        TransferResult transferResult = TransferStrategy.make((int)16, (Mark)mark, (BObject)this.cont, (BComponent)bComponent, null).transfer();
        String[] stringArray = transferResult.getInsertNames();
        NmUtil.wait(500);
        return (BComplex)this.cont.get(stringArray[0]);
    }

    private final boolean importXmlFile(BDynamicDevice bDynamicDevice, BProgramId bProgramId) {
        BOrd bOrd = null;
        DeviceDef deviceDef = new DeviceDef(bProgramId);
        if (deviceDef.isXml()) {
            bOrd = deviceDef.getXmlOrd();
        }
        if (bOrd == null) {
            return false;
        }
        bDynamicDevice.setXmlFile(bOrd);
        return true;
    }

    private final BLonDevice createDeviceForPid(DeviceDef deviceDef) {
        BOrd bOrd = null;
        if (deviceDef.isClass()) {
            return deviceDef.getDevice();
        }
        if (deviceDef.isXml()) {
            bOrd = deviceDef.getXmlOrd();
        }
        BDynamicDevice bDynamicDevice = new BDynamicDevice();
        if (bOrd != null) {
            bDynamicDevice.setXmlFile(bOrd);
        }
        return bDynamicDevice;
    }

    private final void buildDevice(BDynamicDevice bDynamicDevice) {
        if (bDynamicDevice.getXmlFile() != BOrd.NULL) {
            try {
                bDynamicDevice.doImportXml(new BImportParameters(false, this.netMgmt.getUseLonObjects()));
                this.status("Import file for " + bDynamicDevice.getDisplayName(null));
                return;
            }
            catch (Throwable throwable) {
                this.warning(bDynamicDevice.getDisplayName(null) + " failed to import " + bDynamicDevice.getXmlFile().toString(), throwable);
            }
        }
        try {
            if (bDynamicDevice.getDeviceData().getNodeState() == BLonNodeState.applicationless) {
                return;
            }
            this.status("Import selfdoc for " + bDynamicDevice.getDisplayName(null));
            XLonDevice xLonDevice = DocToXDevice.extract(bDynamicDevice.getNeuronIdAddress(), this.lonComm, this.auth);
            DynaDev.importXLon(bDynamicDevice, xLonDevice, this.netMgmt.getUseLonObjects());
        }
        catch (Throwable throwable) {
            this.warning("Failed to learn nvs for " + bDynamicDevice.getDisplayName(null), throwable);
        }
    }

    private static final int getDeviceHash(BLonDevice bLonDevice) {
        return BLonLearnJob.getDeviceHash(bLonDevice.getDeviceData());
    }

    private static final int getDeviceHash(BDeviceData bDeviceData) {
        BSubnetNode bSubnetNode = bDeviceData.getSubnetNodeId();
        return BLonLearnJob.getDeviceHash(bSubnetNode.getSubnetId(), bSubnetNode.getNodeId());
    }

    private static final int getDeviceHash(int n, int n2) {
        return (n << 7) + n2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.storage = new IntHashMap(127);
        this.duplicateCheck = new IntHashMap(127);
        Class clazz = class$javax$baja$lonworks$BLonDevice;
        if (clazz == null) {
            clazz = class$javax$baja$lonworks$BLonDevice = BLonLearnJob.class("[Ljavax.baja.lonworks.BLonDevice;", false);
        }
        this.uploadDevs = new Array(clazz);
    }

    public BLonLearnJob() {
        this.this();
    }

    public BLonLearnJob(BLonNetmgmt bLonNetmgmt, BLearnParameter bLearnParameter) {
        super(bLonNetmgmt);
        this.this();
        this.command = bLearnParameter;
        this.lonComm = this.lon.lonComm();
        this.auth = bLonNetmgmt.getAuthenticate();
        this.ourDomain = bLonNetmgmt.getDomainId();
        this.origDevs = this.lon.addressManager().getDeviceList(false);
        this.origRtrs = this.lon.addressManager().getRouterList();
        this.cont = bLearnParameter.getContainer().isNull() ? this.lon : (BComponent)bLearnParameter.getContainer().get();
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonLearnJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonLearnJob = BLonLearnJob.class("[Lcom.tridium.lonworks.netmgmt.BLonLearnJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class LonDeviceIds {
        public QueryDomainResponse domain;
        public int wrkDmn;
        public boolean authOn;
        public BNeuronId nId;
        public BProgramId pId;
        public boolean twoDomains;
        public boolean duplicate;
        public int chanId;
        public BLonNodeState state;
        LonDeviceIds farIds;
        RouterStatusResponse rtrStatus;

        private final int getSubnet() {
            return this.domain.getSubnet();
        }

        private final int getNodeId() {
            return this.domain.getNodeId();
        }

        private final /* synthetic */ void this() {
            this.rtrStatus = null;
        }

        LonDeviceIds(BNeuronId bNeuronId, BProgramId bProgramId, boolean bl, BLonNodeState bLonNodeState) {
            this.this();
            this.nId = bNeuronId;
            this.pId = bProgramId;
            this.authOn = bl;
            this.state = bLonNodeState;
        }
    }
}

