/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.BLonRouter;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.RouterManager;
import com.tridium.lonworks.datatypes.BCommissionParameter;
import com.tridium.lonworks.enums.BLonRouterMode;
import com.tridium.lonworks.enums.BServicePinState;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonServicePinJob;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import com.tridium.lonworks.util.RouterUtil;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonCommissionRouterJob
extends BLonServicePinJob
implements NetMgmtConst {
    public static final Type TYPE;
    private static final BIcon icon;
    private BLonRouter router;
    private BSubnetNode[] sns;
    private boolean servicePin;
    private BNeuronId nId;
    private boolean tmpBrdg;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonCommissionRouterJob;

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block11: {
            this.tmpBrdg = this.netMgmt.getTempBridge();
            try {
                try {
                    if (!this.tmpBrdg) {
                        RouterUtil.setTemporaryBridge(this.lon);
                    }
                    this.percentFactor = this.sns.length;
                    int n = 0;
                    while (n < this.sns.length) {
                        this.router = this.lon.addressManager().getRouterByAddress(this.sns[n]);
                        if (this.router == null) {
                            throw new LonException("Router with s/n " + this.sns[n] + " has invalid subnet channelId configuration.");
                        }
                        if (!this.nId.equals(BNeuronId.DEFAULT)) {
                            this.router.getNearDeviceData().setNeuronId(this.nId);
                        }
                        this.percentOffset = (int)(100.0 / this.percentFactor) * n;
                        this.doCommission();
                        ++n;
                    }
                }
                catch (JobCancelException jobCancelException) {
                    this.canceled();
                }
                catch (Throwable throwable) {
                    this.fatal("Fatal error ", throwable);
                }
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                if (!this.tmpBrdg) {
                    RouterUtil.clearTemporaryBridge(this.lon);
                }
                throw throwable;
            }
            {
                Object var2_6 = null;
                if (this.tmpBrdg) break block11;
            }
            RouterUtil.clearTemporaryBridge(this.lon);
        }
        this.end();
    }

    private final void doCommission() {
        BDeviceData bDeviceData = this.router.getNearDeviceData();
        BDeviceData bDeviceData2 = this.router.getFarDeviceData();
        this.log().start("Commissioning " + this.router.getDisplayName(null));
        try {
            BProgramId bProgramId;
            Object object;
            BNeuronId bNeuronId = null;
            this.myProgress(2);
            if (this.servicePin) {
                this.setServicePinState(BServicePinState.waiting);
                object = this.receiveServicePin();
                if (object == null) {
                    return;
                }
                this.setServicePinState(BServicePinState.received);
                bNeuronId = object.getNeuronId();
                bProgramId = object.getIdString();
                this.validateNeuronId(bNeuronId, this.router);
            } else {
                bProgramId = Neuron.getProgramId(this.router, false);
            }
            if (!bProgramId.isRouter()) {
                this.fatal("Device is not a router - neuronId " + bNeuronId);
                return;
            }
            object = bDeviceData.getProgramId();
            if (!bProgramId.equals(object)) {
                bDeviceData.setProgramId(bProgramId);
                bDeviceData2.setProgramId(bProgramId);
            }
            this.myProgress(10);
            if (bNeuronId != null) {
                bDeviceData.setNeuronId(bNeuronId);
            }
            NmUtil.setDeviceState(this.router, BLonNodeState.configOffline, false);
            NmUtil.setDeviceState(this.router, BLonNodeState.configOffline, true);
            bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOffline, AddressManager.noDeviceChange);
            bDeviceData2.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOffline, AddressManager.noDeviceChange);
            NmUtil.setDeviceState(this.router, BLonNodeState.hardOffline, false);
            NmUtil.setDeviceState(this.router, BLonNodeState.hardOffline, true);
            this.myProgress(40);
            RouterUtil.updateDomainTable(this.netMgmt, this.router);
            Neuron.updateConfigData(this.netMgmt, this.router, false);
            Neuron.updateConfigData(this.netMgmt, this.router, true);
            this.myProgress(60);
            RouterUtil.setRouterType(this.router, this.router.getRouterType());
            RouterManager routerManager = ((NAddressManager)this.lon.addressManager()).routerManager();
            routerManager.updateRouteTables(this.router);
            RouterUtil.downloadRouterTables(this.router);
            if (!this.tmpBrdg) {
                RouterUtil.setRouterMode(this.router, BLonRouterMode.normal);
            }
            NmUtil.resetNode(this.router);
            this.myProgress(80);
            NmUtil.clearStatus(this.router);
            NmUtil.setDeviceState(this.router, BLonNodeState.configOnline, false);
            NmUtil.setDeviceState(this.router, BLonNodeState.configOnline, true);
            bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
            bDeviceData2.set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
            routerManager.verifySubnets();
            this.pass("Commission success");
        }
        catch (LonException lonException) {
            this.error("Commission failed for " + this.router.getDisplayName(null), (Throwable)((Object)lonException));
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.sns = null;
    }

    public BLonCommissionRouterJob() {
        this.this();
    }

    public BLonCommissionRouterJob(BLonNetmgmt bLonNetmgmt, BCommissionParameter bCommissionParameter) {
        super(bLonNetmgmt);
        this.this();
        this.sns = bCommissionParameter.getSubnetNodes();
        this.servicePin = bCommissionParameter.getServicePin();
        this.nId = bCommissionParameter.getNeuronId();
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonCommissionRouterJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonCommissionRouterJob = BLonCommissionRouterJob.class("[Lcom.tridium.lonworks.netmgmt.BLonCommissionRouterJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"build.png");
    }
}

