/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.Lon;
import com.tridium.lonworks.NAddressManager;
import com.tridium.lonworks.datatypes.BTagLinkEntry;
import com.tridium.lonworks.enums.BLonLinkStatus;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.Connection;
import com.tridium.lonworks.netmgmt.ConnectionTable;
import com.tridium.lonworks.netmgmt.Group;
import com.tridium.lonworks.netmgmt.GroupTable;
import com.tridium.lonworks.netmgmt.LonPoint;
import com.tridium.lonworks.netmgmt.LonPointAlias;
import com.tridium.lonworks.netmgmt.LonPointPseudo;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.netmgmt.TagConnection;
import com.tridium.lonworks.netmgmt.TagPoint;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BINetworkVariable;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.BLonNetwork;
import javax.baja.lonworks.BNetworkVariable;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BAliasConfigData;
import javax.baja.lonworks.datatypes.BAliasTable;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BNvProps;
import javax.baja.lonworks.enums.BLonLinkType;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonBindJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE;
    private int completes;
    private ConnectionTable connTable;
    private Connection[] table;
    private TagConnection[] tags;
    private NAddressManager adrMan;
    private GroupTable groupTable;
    private boolean debug;
    private BTagLinkEntry tagEntry;
    private BLonDevice selectDev;
    boolean bindMtags;
    Vector offDevs;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonBindJob;

    public Type getType() {
        return TYPE;
    }

    static void bindDevice(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice) {
        BLonBindJob bLonBindJob = new BLonBindJob(bLonNetmgmt, bLonDevice, false);
        bLonBindJob.run();
    }

    public void run() {
        this.log().start("Binding");
        if (this.debug) {
            System.out.println("Binding");
        }
        try {
            if (this.bindMtags) {
                this.processMessageTags();
            }
            this.myProgress(5);
            this.selectGroup();
            this.myProgress(10);
            this.status("Binding - processing groups");
            this.groupTable.processGroups(this.offDevs);
            this.myProgress(30);
            this.status("Binding - processing links");
            this.processConnections();
            this.myProgress(80);
            this.removeObsolete();
            this.verifyChannelPriorities();
            this.updateTagStatus();
            if (this.adrMan.isRouted() && Lon.n()) {
                this.groupTable.updateGroupRouteFlags(this.adrMan.routerManager());
            }
            this.setDevicesOnline();
            this.end();
        }
        catch (JobCancelException jobCancelException) {
            this.setDevicesOnline();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.fatal("Bind command failed.  ", throwable);
        }
        this.netMgmt.updateLinkTable(this.connTable);
        if (this.debug) {
            System.out.println("Bind complete");
        }
    }

    private final void setDevicesOnline() {
        int n = 0;
        while (n < this.offDevs.size()) {
            BLonDevice bLonDevice = (BLonDevice)this.offDevs.elementAt(n);
            try {
                if (!bLonDevice.isConfigOnline()) {
                    if (Lon.n()) {
                        NmUtil.setDeviceState(bLonDevice, BLonNodeState.configOnline);
                    }
                    bLonDevice.getDeviceData().set(BDeviceData.nodeState, (BValue)BLonNodeState.configOnline, AddressManager.noDeviceChange);
                }
                try {
                    bLonDevice.bindComplete();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                System.out.println("ERROR: in GroupTable.setDevicesOnline() - comm failure to " + bLonDevice.getDisplayName(null));
            }
            ++n;
        }
    }

    private final void updateTagStatus() {
        int n = 0;
        while (n < this.tags.length) {
            Group group;
            int n2;
            TagConnection tagConnection = this.tags[n];
            if (!tagConnection.isError() && (n2 = tagConnection.getAddressGroup()) != -1 && (group = this.groupTable.getGroup(n2)) != null && group.isUpdated()) {
                tagConnection.setUpdatedStatus();
            }
            ++n;
        }
    }

    private final void processMessageTags() {
        int n = 0;
        while (n < this.tags.length) {
            TagConnection tagConnection = this.tags[n];
            TagPoint tagPoint = tagConnection.getOutput();
            if (this.tagEntry != null) {
                if (tagPoint.getDeviceName().equals(SlotPath.unescape((String)this.tagEntry.getOutputDevice())) && tagPoint.getTagName().equals(SlotPath.unescape((String)this.tagEntry.getOutputTag()))) {
                    this.processTagConnection(tagConnection);
                    return;
                }
            } else if (this.selectDev != null) {
                if (tagConnection.containsDevice(this.selectDev)) {
                    this.processTagConnection(tagConnection);
                }
            } else {
                this.processTagConnection(tagConnection);
            }
            ++n;
        }
    }

    private final void processTagConnection(TagConnection tagConnection) {
        boolean bl;
        TagPoint tagPoint;
        if (this.debug) {
            System.out.println("processTagConnection: " + tagConnection);
        }
        if ((tagPoint = tagConnection.getOutput()) == null) {
            return;
        }
        int n = tagConnection.getAddressGroup();
        Group group = n >= 0 ? this.groupTable.getGroup(n) : null;
        BLonDevice bLonDevice = tagPoint.getLonDevice();
        if (tagPoint.isObsolete()) {
            if (group != null) {
                group.removeMember(this.connTable.getDeviceIndex(bLonDevice));
            }
            this.groupTable.clearAddressEntry(bLonDevice, tagPoint.getTagIndex(), this.offDevs);
            tagConnection.setStatus(BLonLinkStatus.unbound);
            tagConnection.setAddressGroup(-1);
            return;
        }
        boolean bl2 = false;
        if (tagPoint.getStatus() == BLonLinkStatus.dirtyDescriptor) {
            bl2 = true;
        }
        if ((bl = bl2) && group != null) {
            group.setLinkType(BLonLinkType.reliable);
            group.setStatus(1);
            tagConnection.setStatus(BLonLinkStatus.bound);
            return;
        }
        if (!(bl || !tagConnection.isError() && tagConnection.isNew())) {
            return;
        }
        TagPoint[] tagPointArray = tagConnection.getInputs();
        if (tagPointArray.length > 1 && n >= 0) {
            if (this.connTable.groupUse(n, true) <= 1 && this.groupTable.reconfigTagGroup(tagConnection, n, this.offDevs)) {
                return;
            }
            if (!this.groupTable.moveTagPoint(tagPoint, n, this.offDevs)) {
                tagConnection.setStatus(BLonLinkStatus.groupError);
                return;
            }
            group = null;
            n = -1;
            tagConnection.setAddressGroup(-1);
        }
        if (tagPointArray.length == 1 && group != null && !tagPointArray[0].isMtag()) {
            group.removeMember(this.connTable.getDeviceIndex(bLonDevice));
            tagConnection.setAddressGroup(-1);
        }
        if (tagPointArray.length == 1 && !tagPointArray[0].isMtag()) {
            BDeviceData bDeviceData = tagPointArray[0].getLonDevice().getDeviceData();
            BAddressEntry bAddressEntry = BAddressEntry.makeSubnetNodeEntry(bDeviceData.getSubnetNodeId(), 2, bDeviceData.getWorkingDomain(), this.netMgmt.getLinkDescriptors().getDescriptor(2));
            if (this.debug) {
                System.out.println("\n  update message tagCnctn " + tagPoint.getTagIndex() + " in " + bLonDevice.getDisplayName(null));
            }
            bLonDevice.getDeviceData().setAddressEntry(tagPoint.getTagIndex(), bAddressEntry);
            try {
                this.updateAddressTable(bLonDevice, tagPoint.getTagIndex());
            }
            catch (Throwable throwable) {
                tagPoint.setStatus(BLonLinkStatus.comError);
                return;
            }
            tagPoint.setStatus(BLonLinkStatus.bound);
            this.userUpdate();
        } else if (!this.groupTable.selectTagGroup(tagConnection, this.offDevs)) {
            tagConnection.setStatus(BLonLinkStatus.groupError);
        }
    }

    private final void selectGroup() {
        int n = 0;
        while (n < this.table.length) {
            Connection connection = this.table[n];
            while (connection != null) {
                if (connection.isActive() && !connection.isError() && !connection.isPollOnly()) {
                    if (connection.getHub().isProxy()) {
                        connection.setAddressChange(false);
                    } else if (connection.getHub().isPseudo() && connection.getActiveTargetCount() == 1) {
                        connection.clearAddressEntry();
                    } else {
                        Object object;
                        if (this.debug) {
                            System.out.println("\nselect addressing for connection " + connection.getSelector());
                        }
                        if (connection.isTurnAroundAddressEntry()) {
                            if (!this.groupTable.selectTurnAround(connection, this.offDevs)) {
                                connection.setStatus(BLonLinkStatus.groupError);
                            }
                        } else if (connection.getHub().isPolled()) {
                            object = connection.getTargets();
                            int n2 = 0;
                            while (n2 < ((LonPoint[])object).length) {
                                if (!object[n2].isProxy() && object[n2].isActive()) {
                                    this.groupTable.selectSingle(connection, object[n2], this.offDevs);
                                }
                                ++n2;
                            }
                        } else {
                            object = connection.getSubnetNodeAddressTarget();
                            if (!(object != null && this.groupTable.selectSingle(connection, (LonPoint)object, this.offDevs) || this.groupTable.selectGroup(connection, this.offDevs))) {
                                connection.setStatus(BLonLinkStatus.groupError);
                            }
                        }
                    }
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
    }

    private final boolean processSnAddress(Connection connection) {
        LonPoint lonPoint = connection.getPntRequiringAddressEntry();
        if (lonPoint == null || lonPoint.isLocal() || lonPoint.isPseudo()) {
            return true;
        }
        try {
            BLonDevice bLonDevice = lonPoint.getLonDevice();
            this.updateAddressTable(bLonDevice, lonPoint.getAddressIndex());
        }
        catch (Throwable throwable) {
            lonPoint.setStatus(BLonLinkStatus.comError);
            this.error("Failed to update address in BLonBindJob.processSnAddress() " + lonPoint, throwable);
            return false;
        }
        this.userUpdate();
        return true;
    }

    private final void updateAddressTable(BLonDevice bLonDevice, int n) throws Exception {
        if (Lon.n()) {
            NmUtil.setOfflineInBind(bLonDevice, this.offDevs);
            NmUtil.updateAddressTable(bLonDevice, n);
            if (!NmUtil.verifyAddressEntry(bLonDevice, n)) {
                this.error("ERROR: unable to verify address entry " + n + " in " + bLonDevice.getDisplayName(null), null);
            }
        }
    }

    private final void processConnections() {
        int n = 0;
        while (n < this.table.length) {
            Connection connection = this.table[n];
            while (connection != null) {
                if (!(connection.isError() || connection.isPollOnly() || connection.getAddressGroup() < 0 && connection.isAddressChange() && !this.processSnAddress(connection))) {
                    if (connection.isLocal()) {
                        this.processLocalConnection(connection);
                    } else {
                        this.processNetConnection(connection);
                    }
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
    }

    public void userUpdate() {
        if (++this.completes % 50 == 0) {
            this.incrementProgress(1, 80);
        }
    }

    private final void removeObsolete() {
        int n = 0;
        while (n < this.table.length) {
            Connection connection = this.table[n];
            while (connection != null) {
                boolean bl = connection.isPollOnly();
                LonPoint lonPoint = connection.getHub();
                if (lonPoint != null && lonPoint.requiresUnbind(bl)) {
                    this.unbind(lonPoint);
                }
                LonPoint[] lonPointArray = connection.getTargets();
                int n2 = 0;
                while (n2 < lonPointArray.length) {
                    if (lonPointArray[n2].requiresUnbind(bl)) {
                        this.unbind(lonPointArray[n2]);
                    }
                    ++n2;
                }
                connection = connection.getSecondary();
            }
            ++n;
        }
    }

    private final void processLocalConnection(Connection connection) {
        int n = connection.getSelector();
        LonPoint lonPoint = connection.getHub();
        LonPoint[] lonPointArray = connection.getTargets();
        int n2 = 0;
        while (n2 < lonPointArray.length) {
            this.bind(lonPointArray[n2], n, connection, false);
            ++n2;
        }
        if (lonPoint != null) {
            this.bind(lonPoint, n, connection, lonPoint.isLocal() ^ true);
        }
    }

    private final void processNetConnection(Connection connection) {
        int n = connection.getSelector();
        LonPoint lonPoint = connection.getHub();
        LonPoint[] lonPointArray = connection.getTargets();
        int n2 = 0;
        while (n2 < lonPointArray.length) {
            this.bind(lonPointArray[n2], n, connection, false);
            ++n2;
        }
        if (lonPoint != null) {
            this.bind(lonPoint, n, connection, false);
        }
    }

    private final void bind(LonPoint lonPoint, int n, Connection connection, boolean bl) {
        if (lonPoint == null || lonPoint.isObsolete() || lonPoint.isUnbound() || lonPoint.isError()) {
            return;
        }
        if (lonPoint.isAliasPoint()) {
            this.bindAlias((LonPointAlias)lonPoint, n, connection);
            return;
        }
        if (lonPoint.isPseudo()) {
            this.bindPseudo((LonPointPseudo)lonPoint, n, connection);
            return;
        }
        if (lonPoint.isLocal()) {
            lonPoint.setStatus(BLonLinkStatus.bound);
            return;
        }
        BNetworkVariable bNetworkVariable = lonPoint.getNetworkVariable();
        BNvProps bNvProps = bNetworkVariable.getNvProps();
        if (lonPoint.isBound()) {
            if (bNvProps.getBoundToLocal() != bl) {
                bNvProps.setBoundToLocal(bl);
                bNetworkVariable.bound();
            }
            return;
        }
        BNvConfigData bNvConfigData = bNetworkVariable.getNvConfigData();
        BNvConfigData bNvConfigData2 = (BNvConfigData)bNvConfigData.newCopy(true);
        bNvConfigData.setSelector(n);
        bNvConfigData.setAddrIndex(lonPoint.getAddressIndex());
        bNvConfigData.setAuthenticated(connection.isAuthenticated());
        bNvConfigData.setServiceType(NmUtil.linkTypeToServiceType(connection.getLinkType()));
        boolean bl2 = false;
        if (connection.getPriority() && !bNvConfigData.isInput()) {
            bl2 = true;
        }
        bNvConfigData.setPriority(bl2);
        boolean bl3 = false;
        if (lonPoint.isOutput() && connection.hasTurnAround()) {
            bl3 = true;
        }
        bNvConfigData.setTurnAround(bl3);
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for LonPoint " + lonPoint + "\nnvprops =>" + (Object)((Object)bNetworkVariable.getNvProps()));
        }
        BLonDevice bLonDevice = lonPoint.getLonDevice();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(bLonDevice, this.offDevs);
                NmUtil.updateNvConfig(bLonDevice, bNetworkVariable.getNvIndex(), bNvConfigData);
                if (!NmUtil.verifyNvConfig(bLonDevice, bNetworkVariable.getNvIndex(), bNvConfigData)) {
                    this.error("Failed to verifyNvConfig in BLonBindJob.bind() " + lonPoint, null);
                    bNvConfigData.copyFrom((BComplex)bNvConfigData2);
                    lonPoint.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.error("Failed to update NV config in BLonBindJob.bind() " + lonPoint, throwable);
            bNvConfigData.copyFrom((BComplex)bNvConfigData2);
            lonPoint.setStatus(BLonLinkStatus.comError);
            return;
        }
        lonPoint.setStatus(BLonLinkStatus.bound);
        bNetworkVariable.getNvProps().setBoundToLocal(bl);
        if (!bl && !bNvConfigData.isInput() && bNetworkVariable.getData().hasProxies()) {
            System.out.println("INTERNAL ERROR : not local but has proxies for " + lonPoint + '\n' + connection);
        }
        try {
            bNetworkVariable.bound();
        }
        catch (Throwable throwable) {}
        this.userUpdate();
    }

    private final void bindPseudo(LonPointPseudo lonPointPseudo, int n, Connection connection) {
        BPseudoNV bPseudoNV = lonPointPseudo.pseudoNv;
        if (lonPointPseudo.isBound()) {
            return;
        }
        BNvConfigData bNvConfigData = bPseudoNV.getNvConfigData();
        bNvConfigData.setSelector(n);
        bNvConfigData.setAddrIndex(lonPointPseudo.getAddressIndex());
        bNvConfigData.setAuthenticated(connection.isAuthenticated());
        bNvConfigData.setServiceType(NmUtil.linkTypeToServiceType(connection.getLinkType()));
        boolean bl = false;
        if (connection.getPriority() && !bNvConfigData.isInput()) {
            bl = true;
        }
        bNvConfigData.setPriority(bl);
        boolean bl2 = false;
        if (lonPointPseudo.isOutput() && connection.hasTurnAround()) {
            bl2 = true;
        }
        bNvConfigData.setTurnAround(bl2);
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for LonPoint " + lonPointPseudo + "\nnvprops =>" + (Object)((Object)bPseudoNV.getNvProps()));
        }
        lonPointPseudo.setStatus(BLonLinkStatus.bound);
        this.userUpdate();
    }

    private final void bindAlias(LonPointAlias lonPointAlias, int n, Connection connection) {
        if (lonPointAlias == null || !lonPointAlias.isNew()) {
            return;
        }
        BLonDevice bLonDevice = lonPointAlias.getLonDevice();
        BAliasConfigData bAliasConfigData = bLonDevice.getDeviceData().getAliasTable().getAliasArray()[lonPointAlias.getAliasIndex()];
        BAliasConfigData bAliasConfigData2 = (BAliasConfigData)bAliasConfigData.newCopy(true);
        bAliasConfigData.setSelector(n);
        bAliasConfigData.setAddrIndex(lonPointAlias.getAddressIndex());
        bAliasConfigData.setAuthenticated(connection.isAuthenticated());
        bAliasConfigData.setServiceType(NmUtil.linkTypeToServiceType(connection.getLinkType()));
        boolean bl = false;
        if (connection.getPriority() && !bAliasConfigData.isInput()) {
            bl = true;
        }
        bAliasConfigData.setPriority(bl);
        bAliasConfigData.setDirection(lonPointAlias.getDirection());
        boolean bl2 = false;
        if (lonPointAlias.isOutput() && connection.hasTurnAround()) {
            bl2 = true;
        }
        bAliasConfigData.setTurnAround(bl2);
        bAliasConfigData.setPrimary(lonPointAlias.getPrimaryNvIndex());
        bAliasConfigData.setBound();
        if (this.debug) {
            System.out.println("\nin BLonBindJob.bind() for bindAlias " + lonPointAlias + "\n  prim nvprops =>" + (Object)((Object)lonPointAlias.getNvProps()));
        }
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(bLonDevice, this.offDevs);
                NmUtil.updateAliasConfig(bLonDevice, lonPointAlias.getAliasIndex(), bAliasConfigData);
                if (!NmUtil.verifyAliasNvConfig(bLonDevice, lonPointAlias.getAliasIndex(), bAliasConfigData)) {
                    lonPointAlias.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.error("Failed to update NV config in BLonBindJob.bindAlias() " + lonPointAlias, throwable);
            bAliasConfigData.copyFrom((BComplex)bAliasConfigData2);
            lonPointAlias.setStatus(BLonLinkStatus.comError);
            return;
        }
        lonPointAlias.setStatus(BLonLinkStatus.bound);
        this.userUpdate();
    }

    private final void unbind(LonPoint lonPoint) {
        if (lonPoint.isAliasPoint()) {
            this.unbindAlias((LonPointAlias)lonPoint);
            return;
        }
        if (this.debug) {
            System.out.print("\nunbind() for " + lonPoint);
        }
        BNetworkVariable bNetworkVariable = lonPoint.getNetworkVariable();
        BNvConfigData bNvConfigData = (BNvConfigData)lonPoint.getNvConfigData().newCopy(true);
        bNvConfigData.setUnbound(bNetworkVariable.getNvIndex());
        BLonDevice bLonDevice = lonPoint.getLonDevice();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(bLonDevice, this.offDevs);
                NmUtil.updateNvConfig(bLonDevice, bNetworkVariable.getNvIndex(), bNvConfigData);
                if (!NmUtil.verifyNvConfig(bLonDevice, bNetworkVariable.getNvIndex(), bNvConfigData)) {
                    lonPoint.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.error("Failed to update NV config in BLonBindJob.unbind()" + lonPoint, throwable);
            lonPoint.setStatus(BLonLinkStatus.comError);
            return;
        }
        bNetworkVariable.setUnbound();
        lonPoint.setStatus(BLonLinkStatus.unbound);
        this.userUpdate();
    }

    private final void unbindAlias(LonPointAlias lonPointAlias) {
        if (this.debug) {
            System.out.print("\nunbindAlias() for  " + lonPointAlias);
        }
        BLonDevice bLonDevice = lonPointAlias.getLonDevice();
        BAliasTable bAliasTable = bLonDevice.getDeviceData().getAliasTable();
        BAliasConfigData bAliasConfigData = bAliasTable.getAliasEntry(lonPointAlias.getAliasIndex());
        BAliasConfigData bAliasConfigData2 = (BAliasConfigData)bAliasConfigData.newCopy(true);
        bAliasConfigData.clearData();
        try {
            if (Lon.n()) {
                NmUtil.setOfflineInBind(bLonDevice, this.offDevs);
                NmUtil.updateAliasConfig(bLonDevice, lonPointAlias.getAliasIndex(), bAliasConfigData);
                if (!NmUtil.verifyAliasNvConfig(bLonDevice, lonPointAlias.getAliasIndex(), bAliasConfigData)) {
                    lonPointAlias.setStatus(BLonLinkStatus.comError);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.error("Failed to update NV config in BLonBindJob.unbindAlias()" + lonPointAlias, throwable);
            bAliasConfigData.copyFrom((BComplex)bAliasConfigData2);
            lonPointAlias.setStatus(BLonLinkStatus.comError);
            return;
        }
        lonPointAlias.setStatus(BLonLinkStatus.unbound);
        this.userUpdate();
    }

    private final void verifyChannelPriorities() {
        int n;
        BLonDevice bLonDevice;
        BLonDevice[] bLonDeviceArray = this.adrMan.getDeviceList(false);
        Vector<BLonDevice> vector = new Vector<BLonDevice>();
        Vector<BLonDevice> vector2 = new Vector<BLonDevice>();
        int n2 = 0;
        while (n2 < bLonDeviceArray.length) {
            bLonDevice = bLonDeviceArray[n2];
            n = 0;
            BINetworkVariable[] bINetworkVariableArray = bLonDevice.getNetworkVariables();
            int n3 = 0;
            while (n3 < bINetworkVariableArray.length) {
                if (bINetworkVariableArray[n3] != null && bINetworkVariableArray[n3].isNetworkVariable() && ((BNetworkVariable)bINetworkVariableArray[n3]).requiresPrioritySlot()) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n != 0) {
                vector.addElement(bLonDevice);
                bLonDeviceArray[n2] = null;
            }
            int n4 = 0;
            if (bLonDevice.getDeviceData().getPrioritySlot() != 0) {
                n4 = 1;
            }
            if (n != n4 && n == 0) {
                vector2.addElement(bLonDevice);
                bLonDeviceArray[n2] = null;
            }
            ++n2;
        }
        try {
            n2 = vector.size();
            n = vector2.size();
            int n5 = 0;
            while (n5 < n2) {
                bLonDevice = (BLonDevice)vector.elementAt(n5);
                bLonDevice.getDeviceData().setPrioritySlot(n5 + 1);
                Neuron.setNodePriorityInfo(bLonDevice, n5 + 1, n2);
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                bLonDevice = (BLonDevice)vector2.elementAt(n5);
                bLonDevice.getDeviceData().setPrioritySlot(0);
                Neuron.setNodePriorityInfo(bLonDevice, 0, n2);
                ++n5;
            }
            if (n2 != this.netMgmt.getChannelPriorities()) {
                this.netMgmt.setChannelPriorities(n2);
                n5 = 0;
                while (n5 < bLonDeviceArray.length) {
                    bLonDevice = bLonDeviceArray[n5];
                    if (bLonDevice != null && !bLonDevice.getDeviceData().getFreezeChannelPriorities()) {
                        Neuron.setNodePriorityInfo(bLonDevice, 0, n2);
                    }
                    ++n5;
                }
            }
        }
        catch (LonException lonException) {
            System.out.println("\n com failure in BLonBindJob.verifyChannelPriorities()" + (Object)((Object)lonException));
            return;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.completes = 0;
        this.tagEntry = null;
        this.selectDev = null;
        this.bindMtags = true;
        this.offDevs = new Vector();
    }

    public BLonBindJob() {
        this.this();
    }

    public BLonBindJob(BLonNetmgmt bLonNetmgmt, BString bString, BTagLinkEntry bTagLinkEntry, boolean bl) {
        super(bLonNetmgmt);
        this.this();
        this.connTable = new ConnectionTable(bLonNetmgmt.lonNetwork());
        this.tags = this.connTable.getMessageTagTable();
        this.groupTable = this.connTable.getGroupTable();
        this.tagEntry = bTagLinkEntry;
        this.debug = bl;
        this.adrMan = (NAddressManager)((BLonNetwork)bLonNetmgmt.getParent()).addressManager();
        this.groupTable.bindJob = this;
        if (bTagLinkEntry != null) {
            this.table = new Connection[0];
            return;
        }
        this.table = this.connTable.getConnectionArray();
        if (bString == null) {
            return;
        }
        String string = bString.getString();
        if (string.length() > 0) {
            this.bindMtags = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            Vector<Connection> vector = new Vector<Connection>();
            while (stringTokenizer.hasMoreTokens()) {
                int n = Integer.decode(stringTokenizer.nextToken());
                vector.addElement(this.table[n]);
            }
            this.table = new Connection[vector.size()];
            vector.copyInto(this.table);
        }
    }

    public BLonBindJob(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice, boolean bl) {
        this(bLonNetmgmt, bLonDevice, true, bl);
    }

    public BLonBindJob(BLonNetmgmt bLonNetmgmt, BLonDevice bLonDevice, boolean bl, boolean bl2) {
        super(bLonNetmgmt);
        this.this();
        this.connTable = new ConnectionTable(bLonNetmgmt.lonNetwork());
        this.tags = this.connTable.getMessageTagTable();
        this.groupTable = this.connTable.getGroupTable();
        this.selectDev = bLonDevice;
        this.debug = bl2;
        this.adrMan = (NAddressManager)((BLonNetwork)bLonNetmgmt.getParent()).addressManager();
        this.groupTable.bindJob = this;
        this.table = this.connTable.getConnectionArray();
        Vector<Connection> vector = new Vector<Connection>();
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != null && this.table[n].containsDevice(bLonDevice)) {
                vector.addElement(this.table[n]);
            }
            ++n;
        }
        this.table = new Connection[vector.size()];
        vector.copyInto(this.table);
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonBindJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonBindJob = BLonBindJob.class("[Lcom.tridium.lonworks.netmgmt.BLonBindJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

