/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmgmt;

import com.tridium.lonworks.datatypes.BAppDownloadParameter;
import com.tridium.lonworks.netmgmt.BLonBindJob;
import com.tridium.lonworks.netmgmt.BLonCommissionJob;
import com.tridium.lonworks.netmgmt.BLonNetmgmt;
import com.tridium.lonworks.netmgmt.BLonNetmgmtJob;
import com.tridium.lonworks.netmgmt.NetMgmtConst;
import com.tridium.lonworks.util.Neuron;
import com.tridium.lonworks.util.NmUtil;
import javax.baja.job.JobCancelException;
import javax.baja.lonworks.AddressManager;
import javax.baja.lonworks.BLonDevice;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.datatypes.BDeviceData;
import javax.baja.lonworks.datatypes.BNvConfigData;
import javax.baja.lonworks.datatypes.BSubnetNode;
import javax.baja.lonworks.enums.BLonNodeState;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.sys.BBlob;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonAppDownloadJob
extends BLonNetmgmtJob
implements NetMgmtConst {
    public static final Type TYPE;
    private BLonDevice dev;
    private BAppDownloadParameter param;
    private NxeRecordStream appStream;
    private NvDirRecordStream nvDirStream;
    static /* synthetic */ Class class$com$tridium$lonworks$netmgmt$BLonAppDownloadJob;

    public Type getType() {
        return TYPE;
    }

    public void run() {
        try {
            BBlob bBlob = this.param.getAppFile();
            if (bBlob.length() > 0) {
                this.appStream = new NxeRecordStream(bBlob.copyBytes());
            }
            if ((bBlob = this.param.getNvDirFile()).length() > 0) {
                this.nvDirStream = new NvDirRecordStream(bBlob.copyBytes());
            }
            BSubnetNode[] bSubnetNodeArray = this.param.getSubnetNodes();
            this.percentFactor = bSubnetNodeArray.length;
            int n = 0;
            while (n < bSubnetNodeArray.length) {
                this.dev = this.lon.addressManager().getDeviceByAddress(bSubnetNodeArray[n]);
                this.percentOffset = (int)(100.0 / this.percentFactor) * n;
                this.doAppDownload();
                ++n;
            }
        }
        catch (JobCancelException jobCancelException) {
            this.canceled();
        }
        catch (Throwable throwable) {
            this.fatal("Fatal error ", throwable);
        }
        this.end();
    }

    private final void doAppDownload() {
        if (this.dev.isLocal()) {
            this.fatal("Can not download application to local device " + this.dev.getDisplayName(null));
            return;
        }
        try {
            if (Neuron.isHostedNode(this.dev)) {
                this.fatal("Hosted node - application download not allowed " + this.dev.getDisplayName(null));
                return;
            }
        }
        catch (LonException lonException) {
            this.fatal("Unable to communicate with device " + this.dev.getDisplayName(null), (Throwable)((Object)lonException));
            return;
        }
        this.downLoadApp();
    }

    private final void downLoadApp() {
        BDeviceData bDeviceData = this.dev.getDeviceData();
        this.log().start("Application Download to " + this.dev.getDisplayName(null));
        try {
            int n;
            NmUtil.setDeviceState(this.dev, BLonNodeState.applicationless);
            bDeviceData.set(BDeviceData.nodeState, (BValue)BLonNodeState.applicationless, AddressManager.noDeviceChange);
            NmUtil.resetNode(this.dev);
            if (this.appStream != null) {
                this.appStream.reset();
                this.appStream.next();
                n = 0;
                this.myProgress(5);
                while (this.appStream.available()) {
                    this.appStream.writeRecord();
                    if (++n % 20 != 0) continue;
                    this.myProgress(5 + (int)((double)this.appStream.getPercentComplete() * 0.65));
                }
                this.myProgress(70);
                this.appStream.reset();
                this.appStream.writeRecord();
                NmUtil.resetNode(this.dev);
                NmUtil.recalculateChecksum(this.dev, 1);
                this.dev.updateMaxMessageLength();
            }
            if (this.nvDirStream != null) {
                this.nvDirStream.reset();
                n = 0;
                while (this.nvDirStream.available()) {
                    if (++n % 20 == 0) {
                        this.myProgress(70 + (int)((double)this.appStream.getPercentComplete() * 0.15));
                    }
                    this.nvDirStream.updateNv();
                }
            }
            this.myProgress(85);
            BLonCommissionJob.commission(this.netMgmt, this.dev);
            if (this.param.getBind()) {
                BLonBindJob.bindDevice(this.netMgmt, this.dev);
            }
            this.pass("Application Download success");
        }
        catch (LonException lonException) {
            this.fatal("Application Download failed for " + this.dev.getDisplayName(null), (Throwable)((Object)lonException));
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.appStream = null;
        this.nvDirStream = null;
    }

    public BLonAppDownloadJob() {
        this.this();
    }

    public BLonAppDownloadJob(BLonNetmgmt bLonNetmgmt, BAppDownloadParameter bAppDownloadParameter) {
        super(bLonNetmgmt);
        this.this();
        this.param = bAppDownloadParameter;
    }

    static {
        Class clazz = class$com$tridium$lonworks$netmgmt$BLonAppDownloadJob;
        if (clazz == null) {
            clazz = class$com$tridium$lonworks$netmgmt$BLonAppDownloadJob = BLonAppDownloadJob.class("[Lcom.tridium.lonworks.netmgmt.BLonAppDownloadJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NxeRecordStream {
        byte[] data;
        int pos;

        void writeRecord() throws LonException {
            Neuron.writeMemory(0, BLonAppDownloadJob.this.dev, this.getAddress(), 0, this.getRecordData());
            this.next();
        }

        void next() {
            if (this.available()) {
                this.pos += this.getLength() + 3;
            }
        }

        boolean available() {
            boolean bl = false;
            if (this.getLength() > 0) {
                bl = true;
            }
            return bl;
        }

        void reset() {
            this.pos = 0;
        }

        int getLength() {
            return this.data[this.pos] & 0xFF;
        }

        int getAddress() {
            return ((this.data[this.pos + 1] & 0xFF) << 8) + (this.data[this.pos + 2] & 0xFF);
        }

        byte[] getRecordData() {
            int n = this.getLength();
            byte[] byArray = new byte[n];
            System.arraycopy(this.data, this.pos + 3, byArray, 0, n);
            return byArray;
        }

        int getPercentComplete() {
            return (int)((float)this.pos / (float)this.data.length * 100.0f);
        }

        NxeRecordStream(byte[] byArray) {
            this.data = byArray;
            this.reset();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class NvDirRecordStream {
        byte[] data;
        int pos;

        void updateNv() throws LonException {
            BLonNvDirection bLonNvDirection = this.getDirection();
            int n = this.getArraySize();
            int n2 = this.getIndex();
            int n3 = 0;
            while (n3 < n) {
                int n4 = n2 + n3;
                BNvConfigData bNvConfigData = NmUtil.queryNvConfigData(BLonAppDownloadJob.this.dev, n4);
                if (bLonNvDirection != bNvConfigData.getDirection()) {
                    bNvConfigData.setDirection(bLonNvDirection);
                    bNvConfigData.setSelector(16383 - n4);
                    NmUtil.updateNvConfig(BLonAppDownloadJob.this.dev, n4, bNvConfigData);
                }
                ++n3;
            }
            this.next();
        }

        void next() {
            if (this.available()) {
                this.pos += 5;
            }
        }

        boolean available() {
            boolean bl = false;
            if (this.pos < this.data.length) {
                bl = true;
            }
            return bl;
        }

        void reset() {
            this.pos = 0;
        }

        int getIndex() {
            return ((this.data[this.pos] & 0xFF) << 8) + (this.data[this.pos + 1] & 0xFF);
        }

        int getArraySize() {
            int n = ((this.data[this.pos + 2] & 0xFF) << 8) + (this.data[this.pos + 3] & 0xFF);
            int n2 = 1;
            if (n != 0) {
                n2 = n;
            }
            return n2;
        }

        BLonNvDirection getDirection() {
            return this.data[this.pos + 4] == 0 ? BLonNvDirection.input : BLonNvDirection.output;
        }

        int getPercentComplete() {
            return this.pos / this.data.length * 100;
        }

        NvDirRecordStream(byte[] byArray) {
            this.data = byArray;
            this.reset();
        }
    }
}

