/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WriteMemRequest
extends LonMessage
implements NetMessages {
    public static final int MSG_LENGTH_NO_DATA = 6;
    private int mode;
    private int offset;
    private int count;
    private int form;
    private byte[] data;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public int getForm() {
        return this.form;
    }

    public void setForm(int n) {
        this.form = n;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) throws LonException {
        if (this.data == null || byArray.length > this.data.length) {
            this.data = new byte[byArray.length];
        }
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned8(this.mode);
        lonOutputStream.writeUnsigned16(this.offset);
        lonOutputStream.writeUnsigned8(this.count);
        lonOutputStream.writeUnsigned8(this.form);
        lonOutputStream.writeByteArray(this.data);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 110) {
            throw new InvalidResponseException(n);
        }
        this.mode = lonInputStream.readUnsigned8();
        this.offset = lonInputStream.readUnsigned16();
        this.count = lonInputStream.readUnsigned8();
        this.form = lonInputStream.readUnsigned8();
        this.data = lonInputStream.readByteArray();
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 14) {
            throw new FailedResponseException();
        }
        if (n != 46) {
            throw new InvalidResponseException(n);
        }
        return new NoDataResponse(46);
    }

    public String toString() {
        return "WriteMemRequest:mode = " + this.mode + " offset = " + this.offset + " count = " + this.count + " form = " + this.form + " data = " + LonByteArrayUtil.toString(this.data, ' ');
    }

    private final /* synthetic */ void this() {
        this.data = null;
    }

    public WriteMemRequest() {
        this.this();
        this.code = 110;
    }

    public WriteMemRequest(int n, int n2, int n3, int n4, byte[] byArray) {
        this.this();
        this.code = 110;
        this.mode = n;
        this.offset = n2;
        this.count = n3;
        this.form = n4;
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, this.data.length);
    }

    public WriteMemRequest(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) {
        this.this();
        this.code = 110;
        this.mode = n;
        this.offset = n2;
        this.count = n3;
        this.form = n4;
        if (n5 > byArray.length - n6) {
            n5 = byArray.length - n6;
        }
        this.data = new byte[n5];
        System.arraycopy(byArray, n6, this.data, 0, n5);
    }
}

