/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WinkResponse
extends LonMessage
implements NetMessages {
    public static final int WINK = 0;
    public static final int SEND_ID_INFO = 1;
    public static final int UNUSED_SUBCOMMAND = -1;
    public static final int INTERFACE_ACTIVE = 0;
    public static final int INTERFACE_INACTIVE = 1;
    public static final int WINK_RESPONSE_LEN = 15;
    private boolean interfaceStatus;
    private byte[] neuronID;
    private byte[] idString;

    public boolean isInterfaceUp() {
        return this.interfaceStatus;
    }

    public void setInterfaceStatus(boolean bl) {
        this.interfaceStatus = bl;
    }

    public byte[] getNeuronID() {
        return this.neuronID;
    }

    public void setNeuronID(byte[] byArray) throws LonException {
        if (byArray.length != 6) {
            throw new IllegalArgumentException("Invalid neuronID length");
        }
        System.arraycopy(byArray, 0, this.neuronID, 0, 6);
    }

    public byte[] getIDString() {
        return this.idString;
    }

    public void setIDString(byte[] byArray) throws LonException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Invalid idString length.");
        }
        System.arraycopy(byArray, 0, this.idString, 0, 8);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.code == 48) {
            if (this.interfaceStatus) {
                lonOutputStream.writeUnsigned8(0);
            } else {
                lonOutputStream.writeUnsigned8(1);
            }
            lonOutputStream.writeByteArray(this.neuronID, 6);
            lonOutputStream.writeByteArray(this.idString, 8);
        }
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        this.interfaceStatus = lonInputStream.read() == 0;
        this.neuronID = lonInputStream.readByteArray(6);
        this.idString = lonInputStream.readByteArray(8);
    }

    private final /* synthetic */ void this() {
        this.interfaceStatus = false;
        this.neuronID = new byte[6];
        this.idString = new byte[8];
    }

    public WinkResponse() {
        this.this();
        this.code = 48;
    }

    public WinkResponse(boolean bl, byte[] byArray, byte[] byArray2) throws LonException {
        this.this();
        this.code = 48;
        this.interfaceStatus = bl;
        this.neuronID = byArray;
        this.idString = byArray2;
    }

    public WinkResponse(LonInputStream lonInputStream) throws LonException {
        this.this();
        this.code = 48;
        this.fromInputStream(lonInputStream);
    }
}

