/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.WinkResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WinkRequest
extends LonMessage
implements NetMessages {
    public static final int WINK = 0;
    public static final int SEND_ID_INFO = 1;
    public static final int NV_DEFINE = 2;
    public static final int NV_REMOVE = 3;
    public static final int QUERY_NV_INFO = 4;
    public static final int QUERY_NODE_INFO = 5;
    public static final int UPDATE_NV_INFO = 6;
    public static final int UNUSED_SUBCOMMAND = -1;
    private int subCommand;
    private int networkInterface;

    public int getSubCommand() {
        return this.subCommand;
    }

    public void setSubCommand(int n) throws LonException {
        this.subCommand = n;
    }

    public int getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(int n) {
        this.networkInterface = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.subCommand != -1) {
            lonOutputStream.write(this.subCommand);
            if (this.subCommand == 1) {
                lonOutputStream.write(this.networkInterface);
            }
        }
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 112) {
            throw new InvalidResponseException(n);
        }
        if (lonInputStream.available() > 0) {
            this.subCommand = lonInputStream.read();
            switch (this.subCommand) {
                case 0: 
                case 1: {
                    this.networkInterface = lonInputStream.read();
                    break;
                }
            }
        }
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 16) {
            throw new FailedResponseException();
        }
        if (n != 48) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new WinkResponse(lonInputStream);
    }

    private final /* synthetic */ void this() {
        this.subCommand = -1;
        this.networkInterface = 0;
    }

    public WinkRequest() {
        this.this();
        this.code = 112;
    }

    public WinkRequest(int n, int n2) throws LonException {
        this.this();
        this.code = 112;
        this.setSubCommand(n);
        if (n == 1) {
            this.networkInterface = n2;
        }
    }
}

