/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpdateDomainRequest
extends LonMessage
implements NetMessages {
    private static final int VALID_DOMAIN_LEN0 = 0;
    private static final int VALID_DOMAIN_LEN1 = 1;
    private static final int VALID_DOMAIN_LEN3 = 3;
    private static final int VALID_DOMAIN_LEN6 = 6;
    public static final int DOMAIN_NOT_USED_LEN = 255;
    public int domainIndex;
    public byte[] id;
    public int subnet;
    public int node;
    public int len;
    public byte[] key;

    public int getDomainIndex() {
        return this.domainIndex;
    }

    public void setDomainIndex(int n) {
        this.domainIndex = n;
    }

    public byte[] getId() {
        return this.id;
    }

    public void setId(byte[] byArray) {
        System.arraycopy(byArray, 0, this.id, 0, byArray.length);
    }

    public int getSubnet() {
        return this.subnet;
    }

    public void setSubnet(int n) {
        this.subnet = n;
    }

    public int getNode() {
        return this.node;
    }

    public void setNode(int n) {
        this.node = n;
    }

    public int getLength() {
        return this.len;
    }

    public void setLength(int n) {
        this.len = n;
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] byArray) {
        System.arraycopy(byArray, 0, this.key, 0, byArray.length);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned8(this.domainIndex);
        lonOutputStream.writeByteArray(this.id);
        lonOutputStream.writeUnsigned8(this.subnet);
        lonOutputStream.writeUnsigned8(this.node | 0x80);
        lonOutputStream.writeUnsigned8(this.len);
        lonOutputStream.writeByteArray(this.key);
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 3) {
            throw new FailedResponseException();
        }
        if (n != 35) {
            throw new InvalidResponseException(n);
        }
        return new NoDataResponse(35);
    }

    public String toString() {
        return "UpdateDomainRequest: domainIndex = " + this.domainIndex + " id = " + LonByteArrayUtil.toString(this.id, ':') + " subnet = " + this.subnet + " node = " + this.node + " len = " + this.len + " key = " + LonByteArrayUtil.toString(this.key, ':');
    }

    private final /* synthetic */ void this() {
        this.id = new byte[6];
        this.key = new byte[6];
    }

    public UpdateDomainRequest(int n) {
        this(n, 0, 0);
        this.len = 255;
    }

    public UpdateDomainRequest(int n, int n2, int n3) {
        this.this();
        this.code = 99;
        this.domainIndex = n;
        this.subnet = n2;
        this.node = n3;
        this.len = 0;
        int n4 = 0;
        while (n4 < 6) {
            this.id[n4] = 0;
            ++n4;
        }
        n4 = 0;
        while (n4 < 6) {
            this.key[n4] = 0;
            ++n4;
        }
    }

    public UpdateDomainRequest(int n, byte[] byArray, int n2, int n3, int n4, byte[] byArray2) throws LonException {
        this.this();
        this.code = 99;
        this.domainIndex = n;
        this.len = n4;
        switch (n4) {
            case 1: 
            case 3: 
            case 6: {
                System.arraycopy(byArray, 0, this.id, 0, n4);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ");
            }
        }
        int n5 = n4;
        while (n5 < 6) {
            this.id[n5] = 0;
            ++n5;
        }
        this.subnet = n2;
        this.node = n3;
        if (byArray2.length != 6) {
            throw new IllegalArgumentException("Invalid ");
        }
        System.arraycopy(byArray2, 0, this.key, 0, 6);
    }
}

