/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.NoDataResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BAddressEntry;
import javax.baja.lonworks.datatypes.BIAddressEntry;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class UpdateAddress
extends LonMessage
implements NetMessages {
    private int addrIndex;
    private BIAddressEntry entry;

    public int getAddrIndex() {
        return this.addrIndex;
    }

    public void setAddrIndex(int n) {
        this.addrIndex = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.write(this.addrIndex);
        BAddressEntry.make(this.entry).toOutputStream(lonOutputStream);
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 6) {
            throw new FailedResponseException();
        }
        if (n != 38) {
            throw new InvalidResponseException(n);
        }
        return new NoDataResponse(38);
    }

    public UpdateAddress() {
        this(15, BAddressEntry.DEFAULT);
    }

    public UpdateAddress(int n, BIAddressEntry bIAddressEntry) {
        this.code = 102;
        this.addrIndex = n;
        this.entry = bIAddressEntry;
    }
}

