/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BNeuronId;
import javax.baja.lonworks.datatypes.BProgramId;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ServicePin
extends LonMessage
implements NetMessages {
    public static final int SERVICE_PIN_LEN = 14;
    private byte[] neuronId;
    private byte[] idString;

    public BNeuronId getNeuronId() {
        return BNeuronId.make(this.neuronId);
    }

    public void setNeuronId(byte[] byArray) throws LonException {
        if (byArray.length != 6) {
            throw new IllegalArgumentException("Invalid neuronId length");
        }
        System.arraycopy(byArray, 0, this.neuronId, 0, 6);
    }

    public BProgramId getIdString() {
        return BProgramId.make(this.idString);
    }

    public void setIdString(byte[] byArray) throws LonException {
        if (byArray.length != 8) {
            throw new IllegalArgumentException("Invalid idString length");
        }
        System.arraycopy(byArray, 0, this.idString, 0, 8);
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeByteArray(this.neuronId, 6);
        lonOutputStream.writeByteArray(this.idString, 8);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 127) {
            throw new InvalidResponseException(n);
        }
        this.neuronId = lonInputStream.readByteArray(6);
        this.idString = lonInputStream.readByteArray(8);
    }

    public String toString() {
        return "\nneuronId " + LonByteArrayUtil.toString(this.neuronId, ':') + "\nidString " + LonByteArrayUtil.toString(this.idString, ':');
    }

    private final /* synthetic */ void this() {
        this.neuronId = new byte[6];
        this.idString = new byte[8];
    }

    public ServicePin() {
        this.this();
        this.code = 127;
    }

    public ServicePin(BNeuronId bNeuronId, BProgramId bProgramId) throws LonException {
        this.this();
        this.code = 127;
        this.setNeuronId(bNeuronId.getByteArray());
        this.setIdString(bProgramId.getByteArray());
    }
}

