/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class QueryStatusResponse
extends LonMessage
implements NetMessages {
    public int xmitErrors;
    public int transactionTimeouts;
    public int rcvTransactionFull;
    public int lostMsgs;
    public int missedMsgs;
    public int resetCause;
    public int nodeState;
    public int versionNumber;
    public int errorLog;
    public int modelNumber;

    public int getXmitErrors() {
        return this.xmitErrors;
    }

    public int getTransactionTimeouts() {
        return this.transactionTimeouts;
    }

    public int getRcvTransactionFull() {
        return this.rcvTransactionFull;
    }

    public int getLostMsgs() {
        return this.lostMsgs;
    }

    public int getMissedMsgs() {
        return this.missedMsgs;
    }

    public int getResetCause() {
        return this.resetCause;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public int getErrorLog() {
        return this.errorLog;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public int getNodeState() {
        return (this.nodeState & 7) == 4 ? this.nodeState & 0x8F : this.nodeState & 7;
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 49) {
            throw new InvalidResponseException(n);
        }
        this.xmitErrors = lonInputStream.readUnsigned16();
        this.transactionTimeouts = lonInputStream.readUnsigned16();
        this.rcvTransactionFull = lonInputStream.readUnsigned16();
        this.lostMsgs = lonInputStream.readUnsigned16();
        this.missedMsgs = lonInputStream.readUnsigned16();
        this.resetCause = lonInputStream.readUnsigned8();
        this.nodeState = lonInputStream.readUnsigned8();
        this.versionNumber = lonInputStream.readUnsigned8();
        this.errorLog = lonInputStream.readUnsigned8();
        this.modelNumber = lonInputStream.readUnsigned8();
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned16(this.xmitErrors);
        lonOutputStream.writeUnsigned16(this.transactionTimeouts);
        lonOutputStream.writeUnsigned16(this.rcvTransactionFull);
        lonOutputStream.writeUnsigned16(this.lostMsgs);
        lonOutputStream.writeUnsigned16(this.missedMsgs);
        lonOutputStream.writeUnsigned8(this.resetCause);
        lonOutputStream.writeUnsigned8(this.nodeState);
        lonOutputStream.writeUnsigned8(this.versionNumber);
        lonOutputStream.writeUnsigned8(this.errorLog);
        lonOutputStream.writeUnsigned8(this.modelNumber);
    }

    public String toString() {
        return "\nxmitErrors = " + this.xmitErrors + "\ntransactionTimeouts = " + this.transactionTimeouts + "\nrcvTransactionFull = " + this.rcvTransactionFull + "\nlostMsgs = " + this.lostMsgs + "\nmissedMsgs = " + this.missedMsgs + "\nresetCause = 0x" + Integer.toHexString(this.resetCause) + "\nnodeState = " + this.nodeState + "\nversionNumber = " + this.versionNumber + "\nerrorLog = " + this.errorLog + "\nmodelNumber = " + this.modelNumber;
    }

    public QueryStatusResponse() {
        this.code = 49;
    }

    public QueryStatusResponse(LonInputStream lonInputStream) throws LonException {
        this.code = 49;
        this.fromInputStream(lonInputStream);
    }
}

