/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryNvConfigResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class QueryNvConfigRequest
extends LonMessage
implements NetMessages {
    private int nvIndex;

    public int getNvIndex() {
        return this.nvIndex;
    }

    public void setNvIndex(int n) {
        this.nvIndex = n;
    }

    public String toString() {
        return "nvIndex=" + this.nvIndex;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        if (this.nvIndex > 254) {
            lonOutputStream.writeUnsigned8(255);
            lonOutputStream.writeUnsigned16(this.nvIndex);
        } else {
            lonOutputStream.writeUnsigned8(this.nvIndex);
        }
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 104) {
            throw new InvalidResponseException(n);
        }
        this.nvIndex = lonInputStream.readUnsigned8();
        if (this.nvIndex == 255) {
            this.nvIndex = lonInputStream.readUnsigned16();
        }
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 8) {
            throw new FailedResponseException();
        }
        if (n != 40) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new QueryNvConfigResponse(lonInputStream);
    }

    public QueryNvConfigRequest() {
        this.code = 104;
    }

    public QueryNvConfigRequest(int n) {
        this.code = 104;
        this.nvIndex = n;
    }
}

