/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.util.LonByteArrayUtil;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.datatypes.BDomainId;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueryDomainResponse
extends LonMessage
implements NetMessages {
    public byte[] id;
    public int subnet;
    public int node;
    public int len;
    public byte[] key;

    public boolean isExtended() {
        return false;
    }

    public byte[] getDomainId() {
        return this.id;
    }

    public int getNodeId() {
        return this.node;
    }

    public int getSubnet() {
        return this.subnet;
    }

    public int getLen() {
        return this.len;
    }

    public byte[] getKey() {
        return this.key;
    }

    public boolean inUse() {
        boolean bl = false;
        if (this.len != 255) {
            bl = true;
        }
        return bl;
    }

    public boolean sameDomain(BDomainId bDomainId) {
        if (this.len != bDomainId.getLength()) {
            return false;
        }
        byte[] byArray = bDomainId.getDomainId();
        int n = 0;
        while (n < this.len) {
            if (this.id[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        this.writeMessageData(lonOutputStream);
    }

    protected void writeMessageData(LonOutputStream lonOutputStream) {
        lonOutputStream.writeByteArray(this.id, 6);
        lonOutputStream.writeUnsigned8(this.subnet);
        lonOutputStream.writeUnsigned8(this.node | 0x80);
        lonOutputStream.writeUnsigned8(this.len);
        lonOutputStream.writeByteArray(this.key, 6);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 42) {
            throw new InvalidResponseException(n);
        }
        this.readMessageData(lonInputStream);
    }

    protected void readMessageData(LonInputStream lonInputStream) {
        this.id = lonInputStream.readByteArray(6);
        this.subnet = lonInputStream.readUnsigned8();
        this.node = lonInputStream.readUnsigned8() & 0xFFFFFF7F;
        this.len = lonInputStream.readUnsigned8();
        this.key = lonInputStream.readByteArray(6);
    }

    public String toString() {
        return " subnet = " + this.subnet + " node = " + this.node + " domain length = " + this.len + " domain = " + LonByteArrayUtil.toString(this.id, this.len) + " key = " + LonByteArrayUtil.toString(this.key) + '\n';
    }

    private final /* synthetic */ void this() {
        this.id = new byte[6];
        this.key = new byte[6];
    }

    public QueryDomainResponse() {
        this.this();
    }

    public QueryDomainResponse(LonInputStream lonInputStream) throws LonException {
        this.this();
        this.code = 42;
        this.fromInputStream(lonInputStream);
    }
}

