/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryDomainResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class QueryDomainRequest
extends LonMessage
implements NetMessages {
    private int domainIndex;

    public int getDomainIndex() {
        return this.domainIndex;
    }

    public void setDomainIndex(int n) {
        this.domainIndex = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.write(this.domainIndex);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 106) {
            throw new InvalidResponseException(n);
        }
        this.domainIndex = lonInputStream.read();
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 10) {
            throw new FailedResponseException();
        }
        if (n != 42) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new QueryDomainResponse(lonInputStream);
    }

    public QueryDomainRequest(int n) {
        this.code = 106;
        this.domainIndex = n;
    }
}

