/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.lonworks.netmessages;

import com.tridium.lonworks.netmessages.NetMessages;
import com.tridium.lonworks.netmessages.QueryAddrResponse;
import javax.baja.lonworks.FailedResponseException;
import javax.baja.lonworks.InvalidResponseException;
import javax.baja.lonworks.LonException;
import javax.baja.lonworks.LonMessage;
import javax.baja.lonworks.io.LonInputStream;
import javax.baja.lonworks.io.LonOutputStream;

public class QueryAddrRequest
extends LonMessage
implements NetMessages {
    private int addrIndex;

    public int getAddrIndex() {
        return this.addrIndex;
    }

    public void setAddrIndex(int n) {
        this.addrIndex = n;
    }

    public void toOutputStream(LonOutputStream lonOutputStream) {
        lonOutputStream.writeUnsigned8(this.code);
        lonOutputStream.writeUnsigned8(this.addrIndex);
    }

    public void fromInputStream(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n != 103) {
            throw new InvalidResponseException(n);
        }
        this.addrIndex = lonInputStream.readUnsigned8();
    }

    public LonMessage toResponse(LonInputStream lonInputStream) throws LonException {
        int n = lonInputStream.readUnsigned8();
        if (n == 7) {
            throw new FailedResponseException();
        }
        if (n != 39) {
            throw new InvalidResponseException(n);
        }
        lonInputStream.reset();
        return new QueryAddrResponse(lonInputStream);
    }

    public QueryAddrRequest(int n) {
        this.code = 103;
        this.addrIndex = n;
    }
}

